/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.propelling.design;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.pe.animate.AnimatedEditor;
import com.kingdee.bos.ctrl.ext.pe.beans.editor.ColorPropertyEditor;
import com.kingdee.bos.ctrl.ext.pe.beans.editor.StylePropertyEditor;
import com.kingdee.bos.ctrl.ext.pe.beans.editor.formula.FormulaComposer;
import com.kingdee.bos.ctrl.ext.pe.beans.value.ColorVFPair;
import com.kingdee.bos.ctrl.ext.pe.beans.value.StringVFPair;
import com.kingdee.bos.ctrl.ext.pe.beans.value.VFPair;
import com.kingdee.bos.ctrl.ext.ui.wizards.propelling.model.IndexDefine;
import com.kingdee.bos.ctrl.ext.ui.wizards.propelling.model.PropellingModel;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDComboColor;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.eas.rpts.ctrlreport.propelling.design.AbstractMessageType;
import com.kingdee.eas.rpts.ctrlreport.propelling.design.ColorSchemeModel;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class TypeMetro
extends AbstractMessageType {
    private Book book;
    private KDPanel selectedDemoPanel;
    private KDPanel previewColorPanel;
    private KDLabel selecedIndexLabel;
    private KDPanel demoCat2Panel;
    private KDPanel demoTypePanel;
    private KDPanel colorPanel;
    private KDRadioButton defalutRadio;
    private KDRadioButton radio1;
    private KDRadioButton radio2;
    private KDRadioButton radio3;
    private KDRadioButton radio4;
    private KDRadioButton radio5;
    private KDRadioButton radio6;
    private KDRadioButton userDefineRadio;
    protected FormulaComposer nameComposer;
    protected FormulaComposer valueComposer;
    protected PropellingModel.MetroLayoutType metroLayoutType;
    protected ColorPropertyEditor bgColorEditor;
    protected ColorPropertyEditor foreNameColorEditor;
    protected ColorPropertyEditor foreValueColorEditor;
    protected AnimatedEditor bgEditor;
    protected AnimatedEditor foreNameEditor;
    protected AnimatedEditor foreValueEditor;
    protected AnimatedEditor styleEditor;
    protected KDLabelContainer backgroundC;
    protected KDLabelContainer foregroundNameC;
    protected KDLabelContainer foregroundValueC;
    protected KDLabelContainer formatC;
    protected StylePropertyEditor stylePropertyEditor;
    protected IndexDefine[] indexArr = new IndexDefine[4];
    private TypePanelClickListener listener;
    private Color[] defaultBlockColor = new Color[4];
    private String defaultForeNameColor = String.valueOf(PropellingModel.DEFAULT_NAME_FORECOLOR.getRGB());
    private String defaultForeValueColor = String.valueOf(PropellingModel.DEFAULT_VALUE_FORECOLOR.getRGB());
    private StringVFPair defaultDataFormat = new StringVFPair("G/\u901a\u7528\u683c\u5f0f", null);
    private boolean isColorSchemesChanged = false;
    private ColorSchemeModel.ColorSchemes selectedColorSchemes = null;

    protected TypeMetro(Book book, IndexDefine[] indexArr) {
        this.book = book;
        this.initSelectedColorSchemes();
        this.initColorScheme();
        if (indexArr != null) {
            this.indexArr = indexArr;
        } else {
            this.syncFromModel(true);
        }
    }

    @Override
    protected KDPanel createPreviewPanel() {
        KDPanel demoPanel = new KDPanel();
        demoPanel.setBackground(Color.WHITE);
        demoPanel.setLayout((LayoutManager)new KDLayout());
        demoPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(300, 20, 200, 123));
        KDLabel labelTitle = new KDLabel("\u73af\u7403\u96c6\u56e2\u8d39\u7528\u8d85\u51fa\u9884\u7b97");
        labelTitle.setFont(new Font("\u5b8b\u4f53", 1, 14));
        labelTitle.setBorder(previewBorder);
        labelTitle.setAutoToolTipText(false);
        String dataString = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()).toString();
        KDLabel labelMetro1 = new KDLabel();
        labelMetro1.setBackground(this.defaultBlockColor[0]);
        labelMetro1.setOpaque(true);
        KDLabel labelMetro2 = new KDLabel();
        labelMetro2.setBackground(this.defaultBlockColor[1]);
        labelMetro2.setOpaque(true);
        KDLabel labelDate = new KDLabel(dataString);
        labelDate.setFont(new Font("\u5b8b\u4f53", 0, 12));
        labelDate.setAutoToolTipText(false);
        KDTextArea labelArea = new KDTextArea("\u7ba1\u7406\u8d39\u7528\uff1a\u8d39\u7528\u9884\u7b978\u4e07\u5143\uff0c\u5b9e\u9645\u8d39\u752810\u4e07\u5143\uff0c\u5b8c\u6210\u7387125%");
        labelArea.setEnabled(false);
        labelArea.setDisabledTextColor(Color.BLACK);
        labelArea.setBorder(previewBorder);
        labelArea.setAutoToolTipText(false);
        labelArea.setEditable(false);
        labelArea.setOpaque(false);
        demoPanel.add((Component)labelTitle, (Object)new KDLayout.Constraints(5, 5, 200, 20, 0));
        demoPanel.add((Component)labelDate, (Object)new KDLayout.Constraints(5, 25, 200, 12, 0));
        demoPanel.add((Component)labelArea, (Object)new KDLayout.Constraints(5, 81, 200, 40, 0));
        KDLabel labelMetro = new KDLabel();
        labelMetro.setBorder(previewBorder);
        labelMetro.setLayout(null);
        labelMetro1.setBounds(2, 2, 96, 34);
        labelMetro2.setBounds(102, 2, 96, 34);
        KDLabel labelName1 = new KDLabel("\u6210\u4ea4\u91d1\u989d");
        KDLabel labelValue1 = new KDLabel("198,124");
        KDLabel labelName2 = new KDLabel("\u5229\u6da6");
        KDLabel labelValue2 = new KDLabel("2,001");
        labelMetro1.setLayout(null);
        labelName1.setForeground(Color.WHITE);
        labelName1.setFont(new Font("\u5b8b\u4f53", 0, 11));
        labelName1.setBounds(5, 0, 94, 15);
        labelValue1.setBounds(22, 16, 94, 15);
        labelValue1.setForeground(Color.WHITE);
        labelValue1.setFont(new Font("Times New Roman", 1, 14));
        labelMetro2.setLayout(null);
        labelName2.setForeground(Color.WHITE);
        labelName2.setFont(new Font("\u5b8b\u4f53", 0, 11));
        labelName2.setBounds(5, 0, 94, 15);
        labelValue2.setBounds(32, 16, 94, 15);
        labelValue2.setForeground(Color.WHITE);
        labelValue2.setFont(new Font("Times New Roman", 1, 14));
        labelMetro1.add((Component)labelName1);
        labelMetro1.add((Component)labelValue1);
        labelMetro2.add((Component)labelName2);
        labelMetro2.add((Component)labelValue2);
        labelMetro.add((Component)labelMetro1);
        labelMetro.add((Component)labelMetro2);
        demoPanel.add((Component)labelMetro, (Object)new KDLayout.Constraints(5, 40, 200, 38, 0));
        KDLabel tipTitle = new KDLabel(TIPS_TITLE);
        tipTitle.setForeground(TIPS_COLOR);
        KDLabel tipImage = new KDLabel("\u2014\u2014>\u5185\u5bb9\uff1a\u8272\u5757\u3001\u6307\u6807\u3001\u6307\u6807\u503c");
        tipImage.setForeground(TIPS_COLOR);
        KDLabel tipContent = new KDLabel(TIPS_CONTENT);
        tipContent.setForeground(TIPS_COLOR);
        KDPanel previewPanel = new KDPanel();
        previewPanel.setLayout((LayoutManager)new KDLayout());
        previewPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(300, 20, 420, 123));
        previewPanel.add((Component)tipTitle, (Object)new KDLayout.Constraints(210, 5, 180, 20, 0));
        previewPanel.add((Component)tipImage, (Object)new KDLayout.Constraints(210, 40, 220, 38, 0));
        previewPanel.add((Component)tipContent, (Object)new KDLayout.Constraints(210, 81, 180, 40, 0));
        previewPanel.add((Component)demoPanel, (Object)new KDLayout.Constraints(0, 0, 215, 123, 0));
        return previewPanel;
    }

    @Override
    protected KDPanel createTypePanel() {
        this.colorPanel = new KDPanel();
        this.colorPanel.setBorder((Border)new TitledBorder("\u8272\u5757\u4e0e\u6307\u6807"));
        this.colorPanel.setLayout((LayoutManager)new KDLayout());
        this.colorPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(10, 45, 750, 185));
        KDLabel label1 = new KDLabel("\u9009\u62e9\u914d\u8272\u65b9\u6848\uff1a");
        KDButtonGroup radioGroup = new KDButtonGroup();
        KDSeparator rSeparator = new KDSeparator();
        this.defalutRadio = new KDRadioButton("\u9ed8\u8ba4");
        this.radio1 = new KDRadioButton("\u5546\u52a1");
        this.radio2 = new KDRadioButton("\u65f6\u5c1a");
        this.radio3 = new KDRadioButton("\u6e05\u723d");
        this.radio4 = new KDRadioButton("\u6e29\u6696");
        this.radio5 = new KDRadioButton("\u751f\u673a");
        this.radio6 = new KDRadioButton("\u6de1\u96c5");
        this.userDefineRadio = new KDRadioButton("\u81ea\u5b9a\u4e49");
        this.defalutRadio.setUserObject((Object)ColorSchemeModel.ColorSchemes.DEFAULT);
        this.radio1.setUserObject((Object)ColorSchemeModel.ColorSchemes.STYLE1);
        this.radio2.setUserObject((Object)ColorSchemeModel.ColorSchemes.STYLE2);
        this.radio3.setUserObject((Object)ColorSchemeModel.ColorSchemes.STYLE3);
        this.radio4.setUserObject((Object)ColorSchemeModel.ColorSchemes.STYLE4);
        this.radio5.setUserObject((Object)ColorSchemeModel.ColorSchemes.STYLE5);
        this.radio6.setUserObject((Object)ColorSchemeModel.ColorSchemes.STYLE6);
        this.userDefineRadio.setUserObject((Object)ColorSchemeModel.ColorSchemes.USERDEFINE);
        radioGroup.add((AbstractButton)this.defalutRadio);
        radioGroup.add((AbstractButton)this.radio1);
        radioGroup.add((AbstractButton)this.radio2);
        radioGroup.add((AbstractButton)this.radio3);
        radioGroup.add((AbstractButton)this.radio4);
        radioGroup.add((AbstractButton)this.radio5);
        radioGroup.add((AbstractButton)this.radio6);
        radioGroup.add((AbstractButton)this.userDefineRadio);
        ColorSchemesRadioHandler radioHandler = new ColorSchemesRadioHandler();
        this.defalutRadio.addActionListener((ActionListener)radioHandler);
        this.radio1.addActionListener((ActionListener)radioHandler);
        this.radio2.addActionListener((ActionListener)radioHandler);
        this.radio3.addActionListener((ActionListener)radioHandler);
        this.radio4.addActionListener((ActionListener)radioHandler);
        this.radio5.addActionListener((ActionListener)radioHandler);
        this.radio6.addActionListener((ActionListener)radioHandler);
        this.userDefineRadio.addActionListener((ActionListener)radioHandler);
        KDLabel label = new KDLabel("\u9009\u62e9\u8272\u5757\u6837\u5f0f\uff1a");
        this.demoTypePanel = this.createDemoTypePanel();
        KDSeparator hSeparator = new KDSeparator();
        this.previewColorPanel = new KDPanel();
        this.previewColorPanel.setLayout(null);
        KDSeparator vSeparator = new KDSeparator();
        vSeparator.setOrientation(1);
        KDPanel indexPanel = this.createIndexPanel();
        this.colorPanel.add((Component)label1, (Object)new KDLayout.Constraints(10, 20, 100, 20, 0));
        this.colorPanel.add((Component)this.defalutRadio, (Object)new KDLayout.Constraints(153, 20, 50, 20, 0));
        this.colorPanel.add((Component)this.radio1, (Object)new KDLayout.Constraints(223, 20, 50, 20, 0));
        this.colorPanel.add((Component)this.radio2, (Object)new KDLayout.Constraints(293, 20, 50, 20, 0));
        this.colorPanel.add((Component)this.radio3, (Object)new KDLayout.Constraints(363, 20, 50, 20, 0));
        this.colorPanel.add((Component)this.radio4, (Object)new KDLayout.Constraints(433, 20, 50, 20, 0));
        this.colorPanel.add((Component)this.radio5, (Object)new KDLayout.Constraints(503, 20, 50, 20, 0));
        this.colorPanel.add((Component)this.radio6, (Object)new KDLayout.Constraints(573, 20, 50, 20, 0));
        this.colorPanel.add((Component)this.userDefineRadio, (Object)new KDLayout.Constraints(643, 20, 80, 20, 0));
        this.colorPanel.add((Component)rSeparator, (Object)new KDLayout.Constraints(7, 45, 735, 3, anchor_left_right));
        this.colorPanel.add((Component)label, (Object)new KDLayout.Constraints(10, 55, 100, 20, 0));
        this.colorPanel.add((Component)this.demoTypePanel, (Object)new KDLayout.Constraints(143, 55, 570, 50, 0));
        this.colorPanel.add((Component)hSeparator, (Object)new KDLayout.Constraints(7, 110, 735, 3, anchor_left_right));
        this.colorPanel.add((Component)this.previewColorPanel, (Object)new KDLayout.Constraints(10, 120, 185, 100, 0));
        this.colorPanel.add((Component)vSeparator, (Object)new KDLayout.Constraints(200, 114, 3, 65, anchor_top_bottom));
        this.colorPanel.add((Component)indexPanel, (Object)new KDLayout.Constraints(200, 115, 515, 120, 0));
        this.initSelectedColorSchemesRadio();
        this.dispatchLayoutTypeEvent((Component)this.demoCat2Panel);
        return this.colorPanel;
    }

    @Override
    protected void createDescPanel(KDPanel msgContentPanel) {
        super.createDescPanel(msgContentPanel);
        this.descComposer.setRequired(false);
        msgContentPanel.add((Component)this.labelContent, (Object)new KDLayout.Constraints(10, 300, 80, 19, 0));
        msgContentPanel.add((Component)this.descComposer, (Object)new KDLayout.Constraints(100, 300, 660, 50, AbstractMessageType.anchor_all));
    }

    @Override
    protected KDPanel createContentPanel() {
        KDPanel msgContentPanel = new KDPanel();
        msgContentPanel.setLayout((LayoutManager)new KDLayout());
        msgContentPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 770, 360));
        msgContentPanel.setBorder((Border)new TitledBorder("\u6d88\u606f\u5185\u5bb9"));
        this.createTitlePanel(msgContentPanel);
        KDPanel typePanel = this.createTypePanel();
        if (typePanel != null) {
            msgContentPanel.add((Component)typePanel, (Object)new KDLayout.Constraints(10, 50, 750, 240, AbstractMessageType.anchor_left_right));
        }
        this.createDescPanel(msgContentPanel);
        return msgContentPanel;
    }

    private KDPanel createIndexPanel() {
        KDPanel indexPanel = new KDPanel();
        indexPanel.setLayout((LayoutManager)new KDLayout());
        indexPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(295, 80, 418, 100));
        KDLabelContainer indexNameC = new KDLabelContainer();
        indexNameC.setBoundLabelLength(60);
        indexNameC.setBoundLabel((JLabel)new KDLabel("\u6307\u6807\u540d\u79f0\uff1a"));
        this.nameComposer = new FormulaComposer();
        this.nameComposer.setRequired(true);
        indexNameC.setBoundEditor((JComponent)this.nameComposer);
        KDLabelContainer indexValueC = new KDLabelContainer();
        indexValueC.setBoundLabel((JLabel)new KDLabel("\u6307\u6807\u503c\uff1a"));
        indexValueC.setBoundLabelLength(60);
        this.valueComposer = new FormulaComposer();
        this.valueComposer.setRequired(true);
        indexValueC.setBoundEditor((JComponent)this.valueComposer);
        this.backgroundC = new KDLabelContainer();
        this.backgroundC.setBoundLabel((JLabel)new KDLabel("\u80cc\u666f\u8272\uff1a"));
        this.backgroundC.setBoundLabelLength(60);
        this.foregroundNameC = new KDLabelContainer();
        this.foregroundNameC.setBoundLabel((JLabel)new KDLabel("\u524d\u666f\u8272\uff1a"));
        this.foregroundNameC.setBoundLabelLength(60);
        this.foregroundValueC = new KDLabelContainer();
        this.foregroundValueC.setBoundLabel((JLabel)new KDLabel("\u524d\u666f\u8272\uff1a"));
        this.foregroundValueC.setBoundLabelLength(60);
        this.formatC = new KDLabelContainer();
        this.formatC.setBoundLabel((JLabel)new KDLabel("\u6570\u5b57\u683c\u5f0f\uff1a"));
        this.formatC.setBoundLabelLength(60);
        this.setBoundEditor();
        indexPanel.add((Component)indexNameC, (Object)new KDLayout.Constraints(10, 10, 280, 20, 0));
        indexPanel.add((Component)indexValueC, (Object)new KDLayout.Constraints(10, 38, 280, 20, 0));
        indexPanel.add((Component)this.backgroundC, (Object)new KDLayout.Constraints(10, 90, 280, 20, 0));
        indexPanel.add((Component)this.foregroundNameC, (Object)new KDLayout.Constraints(295, 10, 220, 20, 0));
        indexPanel.add((Component)this.foregroundValueC, (Object)new KDLayout.Constraints(295, 38, 220, 20, 0));
        indexPanel.add((Component)this.formatC, (Object)new KDLayout.Constraints(295, 62, 220, 20, 0));
        return indexPanel;
    }

    private void setBoundEditor() {
        this.bgColorEditor = new ColorPropertyEditor();
        this.bgEditor = (AnimatedEditor)this.bgColorEditor.getCustomEditor();
        this.backgroundC.setBoundEditor((JComponent)this.bgEditor);
        this.foreNameColorEditor = new ColorPropertyEditor();
        this.foreNameEditor = (AnimatedEditor)this.foreNameColorEditor.getCustomEditor();
        this.foregroundNameC.setBoundEditor((JComponent)this.foreNameEditor);
        this.foreValueColorEditor = new ColorPropertyEditor();
        this.foreValueEditor = (AnimatedEditor)this.foreValueColorEditor.getCustomEditor();
        this.foregroundValueC.setBoundEditor((JComponent)this.foreValueEditor);
        this.stylePropertyEditor = new StylePropertyEditor();
        this.styleEditor = (AnimatedEditor)this.stylePropertyEditor.getCustomEditor();
        this.formatC.setBoundEditor((JComponent)this.styleEditor);
        ((KDComboColor)this.bgEditor.getCurrentSlide()).addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                TypeMetro.this.selecedIndexLabel.setBackground((Color)eventObj.getNewValue());
            }
        });
        ((KDComboColor)this.foreNameEditor.getCurrentSlide()).addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                TypeMetro.this.selecedIndexLabel.getComponent(0).setForeground((Color)eventObj.getNewValue());
            }
        });
        ((KDComboColor)this.foreValueEditor.getCurrentSlide()).addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                TypeMetro.this.selecedIndexLabel.getComponent(1).setForeground((Color)eventObj.getNewValue());
            }
        });
    }

    private KDPanel createDemoTypePanel() {
        KDPanel panel = new KDPanel();
        FlowLayout layout = new FlowLayout(3, 10, 0);
        panel.setLayout((LayoutManager)layout);
        panel.add((Component)this.createDemoPanel(PropellingModel.MetroLayoutType.ANN));
        panel.add((Component)this.createDemoPanel(PropellingModel.MetroLayoutType.BOB0));
        panel.add((Component)this.createDemoPanel(PropellingModel.MetroLayoutType.BOB1));
        panel.add((Component)this.createDemoPanel(PropellingModel.MetroLayoutType.CAT0));
        panel.add((Component)this.createDemoPanel(PropellingModel.MetroLayoutType.CAT1));
        this.demoCat2Panel = this.createDemoPanel(PropellingModel.MetroLayoutType.DOG0);
        panel.add((Component)this.demoCat2Panel);
        return panel;
    }

    private KDPanel createDemoPanel(PropellingModel.MetroLayoutType type) {
        KDPanel panel = new KDPanel();
        panel.setLayout(null);
        panel.setPreferredSize(new Dimension(85, 43));
        panel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        if (this.listener == null) {
            this.listener = new TypePanelClickListener();
        }
        panel.addMouseListener((MouseListener)this.listener);
        int height = 15;
        int widthOne = 75;
        int widthTwo = (widthOne - 3) / 2;
        switch (type) {
            case ANN: {
                Rectangle rect = new Rectangle(5, 5, widthOne, height);
                panel.add((Component)this.createColorLabel(this.listener, this.defaultBlockColor[0], rect, 0));
                panel.setName(PropellingModel.MetroLayoutType.ANN.name());
                return panel;
            }
            case BOB0: {
                Rectangle rect = new Rectangle(5, 5, widthTwo, height);
                panel.add((Component)this.createColorLabel(this.listener, this.defaultBlockColor[0], rect, 0));
                rect = new Rectangle(44, 5, widthTwo, height);
                panel.add((Component)this.createColorLabel(this.listener, this.defaultBlockColor[1], rect, 1));
                panel.setName(PropellingModel.MetroLayoutType.BOB0.name());
                return panel;
            }
            case BOB1: {
                Rectangle rect = new Rectangle(5, 5, widthOne, height);
                panel.add((Component)this.createColorLabel(this.listener, this.defaultBlockColor[0], rect, 0));
                rect = new Rectangle(5, 23, widthOne, height);
                panel.add((Component)this.createColorLabel(this.listener, this.defaultBlockColor[1], rect, 1));
                panel.setName(PropellingModel.MetroLayoutType.BOB1.name());
                return panel;
            }
            case CAT0: {
                Rectangle rect = new Rectangle(5, 5, widthOne, height);
                panel.add((Component)this.createColorLabel(this.listener, this.defaultBlockColor[0], rect, 0));
                rect = new Rectangle(5, 23, widthTwo, height);
                panel.add((Component)this.createColorLabel(this.listener, this.defaultBlockColor[1], rect, 1));
                rect = new Rectangle(44, 23, widthTwo, height);
                panel.add((Component)this.createColorLabel(this.listener, this.defaultBlockColor[2], rect, 2));
                panel.setName(PropellingModel.MetroLayoutType.CAT0.name());
                return panel;
            }
            case CAT1: {
                Rectangle rect = new Rectangle(5, 5, widthTwo, height);
                panel.add((Component)this.createColorLabel(this.listener, this.defaultBlockColor[0], rect, 0));
                rect = new Rectangle(44, 5, widthTwo, height);
                panel.add((Component)this.createColorLabel(this.listener, this.defaultBlockColor[1], rect, 1));
                rect = new Rectangle(5, 23, widthOne, height);
                panel.add((Component)this.createColorLabel(this.listener, this.defaultBlockColor[2], rect, 2));
                panel.setName(PropellingModel.MetroLayoutType.CAT1.name());
                return panel;
            }
            case DOG0: {
                Rectangle rect = new Rectangle(5, 5, widthTwo, height);
                panel.add((Component)this.createColorLabel(this.listener, this.defaultBlockColor[0], rect, 0));
                rect = new Rectangle(44, 5, widthTwo, height);
                panel.add((Component)this.createColorLabel(this.listener, this.defaultBlockColor[1], rect, 1));
                rect = new Rectangle(5, 23, widthTwo, height);
                panel.add((Component)this.createColorLabel(this.listener, this.defaultBlockColor[2], rect, 2));
                rect = new Rectangle(44, 23, widthTwo, height);
                panel.add((Component)this.createColorLabel(this.listener, this.defaultBlockColor[3], rect, 3));
                panel.setName(PropellingModel.MetroLayoutType.DOG0.name());
                return panel;
            }
        }
        return panel;
    }

    private KDLabel createColorLabel(MouseAdapter listener, Color color, Rectangle rect, int position) {
        KDLabel label = new KDLabel();
        label.addMouseListener((MouseListener)listener);
        label.setOpaque(true);
        label.setBackground(color);
        label.setBounds(rect);
        label.setForeground(Color.red);
        label.setName(String.valueOf(position));
        if (listener instanceof ColorLabelClickListener) {
            this.updateIndexLabel(listener, label);
            if (this.indexArr[position] != null) {
                color = (Color)this.getVFPair(this.indexArr[position].getBackgroundFormula()).getValue();
                if (color != null) {
                    label.setBackground(color);
                }
                if ((color = (Color)this.getVFPair(this.indexArr[position].getForegroundNameFormula()).getValue()) != null) {
                    label.getComponent(0).setForeground(color);
                }
                if ((color = (Color)this.getVFPair(this.indexArr[position].getForegroundValueFormula()).getValue()) != null) {
                    label.getComponent(1).setForeground(color);
                }
            }
        }
        return label;
    }

    private void updateIndexLabel(MouseAdapter listener, KDLabel indexLabel) {
        KDLabel nameLabel = new KDLabel("\u6307\u6807\u540d\u79f0");
        nameLabel.setBounds(3, 0, 70, 19);
        nameLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 9));
        nameLabel.setForeground(Color.WHITE);
        nameLabel.addMouseListener((MouseListener)listener);
        KDLabel valueLabel = new KDLabel("\u6307\u6807\u503c");
        valueLabel.setBounds((indexLabel.getWidth() - 38) / 2, (indexLabel.getHeight() - 18) * 4 / 5, 38, 18);
        valueLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 11));
        valueLabel.setForeground(Color.WHITE);
        valueLabel.addMouseListener((MouseListener)listener);
        indexLabel.add((Component)nameLabel);
        indexLabel.add((Component)valueLabel);
    }

    protected void syncFromModel(boolean isInit) {
        PropellingModel model = this.book.getPropellingModel();
        if (StringUtil.isEmptyString((String)model.getPreFormula())) {
            this.setDefaultIndexArr();
            return;
        }
        for (int j = 0; j < model.metroSize(); ++j) {
            IndexDefine define = model.getIndexDefine(j);
            IndexDefine indexArrJ = new IndexDefine(j, null, this.book);
            this.switchIndexDefine(define, indexArrJ);
            this.indexArr[j] = indexArrJ;
        }
        this.setDefaultIndexArr();
        if (!isInit) {
            this.setColorLabelProperties();
        }
    }

    private void setDefaultIndexArr() {
        for (int i = 0; i < 4; ++i) {
            if (this.indexArr[i] != null) continue;
            IndexDefine indexDefine = new IndexDefine(i, null, this.book);
            indexDefine.setForegroundNameFormula(this.defaultForeNameColor);
            indexDefine.setForegroundValueFormula(this.defaultForeValueColor);
            indexDefine.setBackgroundFormula(String.valueOf(this.defaultBlockColor[i].getRGB()));
            indexDefine.setDataFormat(this.defaultDataFormat);
            this.indexArr[i] = indexDefine;
        }
    }

    protected void switchIndexDefine(IndexDefine defineFrom, IndexDefine defineTo) {
        defineTo.setNameFormula(defineFrom.getNameFormula());
        defineTo.setDataFormula(defineFrom.getDataFormula());
        defineTo.setForegroundNameFormula(defineFrom.getForegroundNameFormula());
        defineTo.setForegroundValueFormula(defineFrom.getForegroundValueFormula());
        defineTo.setBackgroundFormula(defineFrom.getBackgroundFormula());
        defineTo.setDataFormat(defineFrom.getDataFormat());
    }

    private void setColorLabelProperties() {
        this.setBoundEditor();
        int pos = Integer.valueOf(this.selecedIndexLabel.getName());
        this.nameComposer.setFormula(this.indexArr[pos].getNameFormula());
        this.valueComposer.setFormula(this.indexArr[pos].getDataFormula());
        this.bgColorEditor.setValue((Object)this.getVFPair(this.indexArr[pos].getBackgroundFormula()));
        this.foreNameColorEditor.setValue((Object)this.getVFPair(this.indexArr[pos].getForegroundNameFormula()));
        this.foreValueColorEditor.setValue((Object)this.getVFPair(this.indexArr[pos].getForegroundValueFormula()));
        this.stylePropertyEditor.setValue((Object)this.indexArr[pos].getDataFormat());
        this.colorPanel.repaint();
    }

    private VFPair getVFPair(String formula) {
        ColorVFPair vfPair;
        int rgb = 0;
        try {
            rgb = Integer.valueOf(formula);
            vfPair = new ColorVFPair(new Color(rgb), null);
        }
        catch (NumberFormatException e) {
            String format = formula;
            vfPair = new ColorVFPair(null, format);
        }
        return vfPair;
    }

    protected IndexDefine[] cacheIndexDefine() {
        int pos;
        if (this.indexArr == null) {
            this.indexArr = new IndexDefine[4];
        }
        IndexDefine indexDefine = this.indexArr[pos = Integer.valueOf(this.selecedIndexLabel.getName()).intValue()] == null ? new IndexDefine(pos, null, this.book) : this.indexArr[pos];
        indexDefine.setNameFormula(this.nameComposer.getFormula());
        indexDefine.setDataFormula(this.valueComposer.getFormula());
        String colorFormula = this.getColorValue(this.bgColorEditor);
        if (StringUtil.isEmptyString((String)colorFormula)) {
            colorFormula = String.valueOf(this.selecedIndexLabel.getBackground().getRGB());
        }
        indexDefine.setBackgroundFormula(colorFormula);
        colorFormula = this.getColorValue(this.foreNameColorEditor);
        if (StringUtil.isEmptyString((String)colorFormula)) {
            colorFormula = String.valueOf(this.selecedIndexLabel.getComponent(0).getForeground().getRGB());
        }
        indexDefine.setForegroundNameFormula(colorFormula);
        colorFormula = this.getColorValue(this.foreValueColorEditor);
        if (StringUtil.isEmptyString((String)colorFormula)) {
            colorFormula = String.valueOf(this.selecedIndexLabel.getComponent(1).getForeground().getRGB());
        }
        indexDefine.setForegroundValueFormula(colorFormula);
        StringVFPair dataFormat = (StringVFPair)this.stylePropertyEditor.getValue();
        if (StringUtil.isEmptyString((String)dataFormat.getStringValue()) && StringUtil.isEmptyString((String)dataFormat.getFormula())) {
            dataFormat = this.defaultDataFormat;
        }
        indexDefine.setDataFormat(dataFormat);
        this.indexArr[pos] = indexDefine;
        return this.indexArr;
    }

    private String getColorValue(ColorPropertyEditor editor) {
        ColorVFPair vfPair = (ColorVFPair)editor.getValue();
        String formula = vfPair.getFormula();
        if (!StringUtil.isEmptyString((String)formula)) {
            return formula;
        }
        if (vfPair.getColorValue() != null) {
            return String.valueOf(vfPair.getColorValue().getRGB());
        }
        return null;
    }

    @Override
    protected PropellingModel.MessageType getMessageType() {
        return PropellingModel.MessageType.METRO;
    }

    protected void setMetroTypeLayout(PropellingModel.MetroLayoutType layoutType) {
        this.metroLayoutType = layoutType;
        Component[] childs = this.demoTypePanel.getComponents();
        for (int i = childs.length - 1; i >= 0; --i) {
            if (!childs[i].getName().equals(layoutType.name())) continue;
            this.dispatchLayoutTypeEvent(childs[i]);
            break;
        }
    }

    private void dispatchLayoutTypeEvent(Component layoutPanel) {
        MouseEvent me = new MouseEvent(layoutPanel, 500, System.currentTimeMillis(), 16, layoutPanel.getX(), layoutPanel.getY(), 1, false, 1);
        layoutPanel.dispatchEvent(me);
    }

    @Override
    protected String getEmptyName() {
        String name = super.getEmptyName();
        if (StringUtil.isEmptyString((String)name)) {
            int size = 0;
            this.metroLayoutType = PropellingModel.MetroLayoutType.valueOf((String)this.selectedDemoPanel.getName());
            switch (this.metroLayoutType) {
                case ANN: {
                    size = 1;
                    break;
                }
                case BOB0: 
                case BOB1: {
                    size = 2;
                    break;
                }
                case CAT0: 
                case CAT1: 
                case CAT2: {
                    size = 3;
                    break;
                }
                case DOG0: {
                    size = 4;
                }
            }
            for (int i = size - 1; i >= 0; --i) {
                name = "\u7b2c" + (i + 1) + "\u8272\u5757\uff0c";
                if (this.indexArr[i] == null || StringUtil.isEmptyString((String)this.indexArr[i].getNameFormula())) {
                    name = name + "\u6307\u6807\u540d\u79f0";
                    break;
                }
                if (StringUtil.isEmptyString((String)this.indexArr[i].getDataFormula())) {
                    name = name + "\u6307\u6807\u503c";
                    break;
                }
                name = null;
            }
        }
        return name;
    }

    protected IndexDefine[] cacheIndex() {
        int pos;
        if (this.indexArr == null) {
            this.indexArr = new IndexDefine[4];
        }
        IndexDefine indexDefine = this.indexArr[pos = Integer.valueOf(this.selecedIndexLabel.getName()).intValue()] == null ? new IndexDefine(pos, null, this.book) : this.indexArr[pos];
        indexDefine.setNameFormula(this.nameComposer.getFormula());
        indexDefine.setDataFormula(this.valueComposer.getFormula());
        StringVFPair dataFormat = (StringVFPair)this.stylePropertyEditor.getValue();
        if (StringUtil.isEmptyString((String)dataFormat.getStringValue()) && StringUtil.isEmptyString((String)dataFormat.getFormula())) {
            dataFormat = this.defaultDataFormat;
        }
        indexDefine.setDataFormat(dataFormat);
        this.indexArr[pos] = indexDefine;
        return this.indexArr;
    }

    private void syncIndexArr(Color[] foreNameColor, Color[] foreValueColor) {
        for (int j = 0; j < 4; ++j) {
            if (this.indexArr[j] == null) {
                return;
            }
            this.indexArr[j].setForegroundNameFormula(String.valueOf(foreNameColor[j].getRGB()));
            this.indexArr[j].setForegroundValueFormula(String.valueOf(foreValueColor[j].getRGB()));
            this.indexArr[j].setBackgroundFormula(String.valueOf(this.defaultBlockColor[j].getRGB()));
        }
    }

    private void syncDefaultBlockColor(Color[] colors) {
        for (int i = 0; i < colors.length; ++i) {
            this.defaultBlockColor[i] = colors[i];
        }
    }

    private Color[] initUserDefineColorScheme() {
        PropellingModel model = this.book.getPropellingModel();
        Color[] backgroundColors = ColorSchemeModel.ColorSchemes.USERDEFINE.getBackgroundColors();
        Color[] foregroundNameColors = ColorSchemeModel.ColorSchemes.USERDEFINE.getForeNameColor();
        Color[] foregroundValueColors = ColorSchemeModel.ColorSchemes.USERDEFINE.getForeValueColor();
        for (int j = 0; j < 4; ++j) {
            if (j < model.metroSize()) {
                IndexDefine define1 = model.getIndexDefine(j);
                Color backGroundColor = (Color)this.getVFPair(define1.getBackgroundFormula()).getValue();
                Color nameColors = (Color)this.getVFPair(define1.getForegroundNameFormula()).getValue();
                Color valueColors = (Color)this.getVFPair(define1.getForegroundValueFormula()).getValue();
                backgroundColors[j] = backGroundColor != null ? backGroundColor : ColorSchemeModel.USERDEFINE_BG_COLOR[j];
                this.selectedColorSchemes.getForeNameColor()[j] = nameColors != null ? nameColors : PropellingModel.DEFAULT_NAME_FORECOLOR;
                if (valueColors != null) {
                    this.selectedColorSchemes.getForeValueColor()[j] = valueColors;
                    continue;
                }
                this.selectedColorSchemes.getForeValueColor()[j] = PropellingModel.DEFAULT_VALUE_FORECOLOR;
                continue;
            }
            backgroundColors[j] = ColorSchemeModel.USERDEFINE_BG_COLOR[j];
            foregroundNameColors[j] = PropellingModel.DEFAULT_NAME_FORECOLOR;
            foregroundValueColors[j] = PropellingModel.DEFAULT_VALUE_FORECOLOR;
        }
        return backgroundColors;
    }

    public void initColorScheme() {
        Color[] colors = this.selectedColorSchemes == ColorSchemeModel.ColorSchemes.USERDEFINE ? this.initUserDefineColorScheme() : this.selectedColorSchemes.getBackgroundColors();
        this.syncDefaultBlockColor(colors);
        this.syncIndexArr(this.selectedColorSchemes.getForeNameColor(), this.selectedColorSchemes.getForeValueColor());
        this.refreshDemoTypePanel();
        this.initSelectedColorSchemesRadio();
    }

    public void initSelectedColorSchemes() {
        PropellingModel model = this.book.getPropellingModel();
        if (model.metroSize() < 1) {
            this.selectedColorSchemes = ColorSchemeModel.ColorSchemes.DEFAULT;
            return;
        }
        Color[] backGroundColor = new Color[model.metroSize()];
        Color[] foregroundNameColor = new Color[model.metroSize()];
        Color[] foregroundValueColor = new Color[model.metroSize()];
        for (int i = 0; i < model.metroSize(); ++i) {
            IndexDefine define = model.getIndexDefine(i);
            if (define == null) {
                this.selectedColorSchemes = ColorSchemeModel.ColorSchemes.DEFAULT;
                return;
            }
            Color backgroundFormula = (Color)this.getVFPair(define.getBackgroundFormula()).getValue();
            Color foregroundNameFormula = (Color)this.getVFPair(define.getForegroundNameFormula()).getValue();
            Color foregroundValueFormula = (Color)this.getVFPair(define.getForegroundValueFormula()).getValue();
            if (backgroundFormula == null || foregroundNameFormula == null || foregroundValueFormula == null) {
                this.selectedColorSchemes = ColorSchemeModel.ColorSchemes.USERDEFINE;
                return;
            }
            backGroundColor[i] = backgroundFormula;
            foregroundNameColor[i] = foregroundNameFormula;
            foregroundValueColor[i] = foregroundValueFormula;
        }
        ColorSchemeModel.ColorSchemes[] colorSchemes = ColorSchemeModel.ColorSchemes.values();
        int count = 0;
        for (int i = 0; i < colorSchemes.length; ++i) {
            if (this.verifyColor(colorSchemes[i].getBackgroundColors(), backGroundColor) && this.verifyColor(colorSchemes[i].getForeNameColor(), foregroundNameColor) && this.verifyColor(colorSchemes[i].getForeValueColor(), foregroundValueColor)) {
                this.selectedColorSchemes = colorSchemes[i];
                return;
            }
            ++count;
        }
        if (count == colorSchemes.length) {
            this.selectedColorSchemes = ColorSchemeModel.ColorSchemes.USERDEFINE;
        }
    }

    private boolean verifyColor(Color[] oldColors, Color[] newColors) {
        if (newColors.length == 0) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < newColors.length; ++i) {
            if (!newColors[i].equals(oldColors[i])) continue;
            ++count;
        }
        return count == newColors.length;
    }

    private void refreshDemoTypePanel() {
        if (this.demoTypePanel == null) {
            return;
        }
        this.demoTypePanel.removeAll();
        this.demoTypePanel.add((Component)this.createDemoPanel(PropellingModel.MetroLayoutType.ANN));
        this.demoTypePanel.add((Component)this.createDemoPanel(PropellingModel.MetroLayoutType.BOB0));
        this.demoTypePanel.add((Component)this.createDemoPanel(PropellingModel.MetroLayoutType.BOB1));
        this.demoTypePanel.add((Component)this.createDemoPanel(PropellingModel.MetroLayoutType.CAT0));
        this.demoTypePanel.add((Component)this.createDemoPanel(PropellingModel.MetroLayoutType.CAT1));
        this.demoCat2Panel = this.createDemoPanel(PropellingModel.MetroLayoutType.DOG0);
        this.demoTypePanel.add((Component)this.demoCat2Panel);
        this.demoTypePanel.validate();
    }

    private void initSelectedColorSchemesRadio() {
        if (this.userDefineRadio == null) {
            return;
        }
        this.userDefineRadio.setVisible(false);
        switch (this.selectedColorSchemes) {
            case DEFAULT: {
                this.defalutRadio.setSelected(true);
                break;
            }
            case STYLE1: {
                this.radio1.setSelected(true);
                break;
            }
            case STYLE2: {
                this.radio2.setSelected(true);
                break;
            }
            case STYLE3: {
                this.radio3.setSelected(true);
                break;
            }
            case STYLE4: {
                this.radio4.setSelected(true);
                break;
            }
            case STYLE5: {
                this.radio5.setSelected(true);
                break;
            }
            case STYLE6: {
                this.radio6.setSelected(true);
                break;
            }
            case USERDEFINE: {
                this.userDefineRadio.setSelected(true);
                this.userDefineRadio.setVisible(true);
                break;
            }
            default: {
                this.defalutRadio.setSelected(true);
            }
        }
    }

    private class ColorSchemesRadioHandler
    implements ActionListener {
        private ColorSchemesRadioHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TypeMetro.this.cacheIndex();
            TypeMetro.this.isColorSchemesChanged = true;
            KDRadioButton radio = (KDRadioButton)e.getSource();
            ColorSchemeModel.ColorSchemes colorScheme = null;
            if (!radio.isSelected()) {
                return;
            }
            colorScheme = (ColorSchemeModel.ColorSchemes)((Object)radio.getUserObject());
            TypeMetro.this.syncDefaultBlockColor(colorScheme.getBackgroundColors());
            Color[] foreNameColor = colorScheme.getForeNameColor();
            Color[] foreValueColor = colorScheme.getForeValueColor();
            TypeMetro.this.syncIndexArr(foreNameColor, foreValueColor);
            if (colorScheme.name() == ColorSchemeModel.ColorSchemes.USERDEFINE.name()) {
                PropellingModel model = TypeMetro.this.book.getPropellingModel();
                for (int j = 0; j < model.metroSize(); ++j) {
                    IndexDefine define1 = model.getIndexDefine(j);
                    String foregroundNameFormula = TypeMetro.this.getVFPair(define1.getForegroundNameFormula()).getFormula();
                    String foregroundValueFormula = TypeMetro.this.getVFPair(define1.getForegroundValueFormula()).getFormula();
                    String backgroundFormula = TypeMetro.this.getVFPair(define1.getBackgroundFormula()).getFormula();
                    if (foregroundNameFormula != null) {
                        TypeMetro.this.indexArr[j].setForegroundNameFormula(foregroundNameFormula);
                    }
                    if (foregroundValueFormula != null) {
                        TypeMetro.this.indexArr[j].setForegroundValueFormula(foregroundValueFormula);
                    }
                    if (backgroundFormula == null) continue;
                    TypeMetro.this.indexArr[j].setBackgroundFormula(backgroundFormula);
                }
            }
            TypeMetro.this.refreshDemoTypePanel();
            TypeMetro.this.selectedDemoPanel = (KDPanel)TypeMetro.this.demoTypePanel.getComponent(5);
            TypeMetro.this.selectedDemoPanel.setBorder(BorderFactory.createLineBorder(Color.ORANGE, 3));
            TypeMetro.this.dispatchLayoutTypeEvent((Component)TypeMetro.this.selectedDemoPanel);
            TypeMetro.this.setColorLabelProperties();
        }
    }

    class ColorLabelClickListener
    extends MouseAdapter {
        ColorLabelClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            KDLabel indexLabel = (KDLabel)e.getSource();
            if (!(indexLabel.getParent() instanceof KDPanel)) {
                indexLabel = (KDLabel)indexLabel.getParent();
            }
            if (TypeMetro.this.selecedIndexLabel == indexLabel) {
                return;
            }
            int space = 3;
            if (TypeMetro.this.selecedIndexLabel != null) {
                TypeMetro.this.selecedIndexLabel.setBorder(null);
                TypeMetro.this.selecedIndexLabel.setBounds(TypeMetro.this.selecedIndexLabel.getX() + space, TypeMetro.this.selecedIndexLabel.getY() + space, TypeMetro.this.selecedIndexLabel.getWidth() - 2 * space, TypeMetro.this.selecedIndexLabel.getHeight() - 2 * space);
                TypeMetro.this.cacheIndexDefine();
            }
            TypeMetro.this.selecedIndexLabel = indexLabel;
            TypeMetro.this.selecedIndexLabel.setBounds(TypeMetro.this.selecedIndexLabel.getX() - space, TypeMetro.this.selecedIndexLabel.getY() - space, TypeMetro.this.selecedIndexLabel.getWidth() + 2 * space, TypeMetro.this.selecedIndexLabel.getHeight() + 2 * space);
            TypeMetro.this.selecedIndexLabel.setBorder(BorderFactory.createLineBorder(Color.ORANGE, space));
            TypeMetro.this.setColorLabelProperties();
        }
    }

    class TypePanelClickListener
    extends MouseAdapter {
        TypePanelClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Component source = (Component)e.getSource();
            KDPanel panel = !(source instanceof KDPanel) ? (KDPanel)source.getParent() : (KDPanel)source;
            if (TypeMetro.this.selectedDemoPanel == panel && !TypeMetro.this.isColorSchemesChanged) {
                return;
            }
            if (TypeMetro.this.selectedDemoPanel != null) {
                TypeMetro.this.selectedDemoPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
            }
            TypeMetro.this.selectedDemoPanel = panel;
            if (TypeMetro.this.selecedIndexLabel != null) {
                TypeMetro.this.cacheIndex();
            }
            panel.setBorder(BorderFactory.createLineBorder(Color.ORANGE, 3));
            TypeMetro.this.metroLayoutType = PropellingModel.MetroLayoutType.valueOf((String)panel.getName());
            int height = 43;
            int widthOne = 175;
            int widthTwo = (widthOne - 5) / 2;
            ColorLabelClickListener listener = new ColorLabelClickListener();
            TypeMetro.this.previewColorPanel.removeAll();
            TypeMetro.this.selecedIndexLabel = null;
            switch (TypeMetro.this.metroLayoutType) {
                case ANN: {
                    Rectangle rect = new Rectangle(5, 5, widthOne, height);
                    KDLabel indexLabel = TypeMetro.this.createColorLabel(listener, TypeMetro.this.defaultBlockColor[0], rect, 0);
                    TypeMetro.this.previewColorPanel.add((Component)indexLabel);
                    this.dispatchFirstEvent(indexLabel);
                    break;
                }
                case BOB0: {
                    Rectangle rect = new Rectangle(5, 5, widthTwo, height);
                    KDLabel indexLabel = TypeMetro.this.createColorLabel(listener, TypeMetro.this.defaultBlockColor[0], rect, 0);
                    TypeMetro.this.previewColorPanel.add((Component)indexLabel);
                    this.dispatchFirstEvent(indexLabel);
                    rect = new Rectangle(93, 5, widthTwo, height);
                    TypeMetro.this.previewColorPanel.add((Component)TypeMetro.this.createColorLabel(listener, TypeMetro.this.defaultBlockColor[1], rect, 1));
                    break;
                }
                case BOB1: {
                    Rectangle rect = new Rectangle(5, 5, widthOne, height);
                    KDLabel indexLabel = TypeMetro.this.createColorLabel(listener, TypeMetro.this.defaultBlockColor[0], rect, 0);
                    TypeMetro.this.previewColorPanel.add((Component)indexLabel);
                    this.dispatchFirstEvent(indexLabel);
                    rect = new Rectangle(5, 51, widthOne, height);
                    TypeMetro.this.previewColorPanel.add((Component)TypeMetro.this.createColorLabel(listener, TypeMetro.this.defaultBlockColor[1], rect, 1));
                    break;
                }
                case CAT0: {
                    Rectangle rect = new Rectangle(5, 5, widthOne, height);
                    KDLabel indexLabel = TypeMetro.this.createColorLabel(listener, TypeMetro.this.defaultBlockColor[0], rect, 0);
                    TypeMetro.this.previewColorPanel.add((Component)indexLabel);
                    this.dispatchFirstEvent(indexLabel);
                    rect = new Rectangle(5, 51, widthTwo, height);
                    TypeMetro.this.previewColorPanel.add((Component)TypeMetro.this.createColorLabel(listener, TypeMetro.this.defaultBlockColor[1], rect, 1));
                    rect = new Rectangle(93, 51, widthTwo, height);
                    TypeMetro.this.previewColorPanel.add((Component)TypeMetro.this.createColorLabel(listener, TypeMetro.this.defaultBlockColor[2], rect, 2));
                    break;
                }
                case CAT1: {
                    Rectangle rect = new Rectangle(5, 5, widthTwo, height);
                    KDLabel indexLabel = TypeMetro.this.createColorLabel(listener, TypeMetro.this.defaultBlockColor[0], rect, 0);
                    TypeMetro.this.previewColorPanel.add((Component)indexLabel);
                    this.dispatchFirstEvent(indexLabel);
                    rect = new Rectangle(93, 5, widthTwo, height);
                    TypeMetro.this.previewColorPanel.add((Component)TypeMetro.this.createColorLabel(listener, TypeMetro.this.defaultBlockColor[1], rect, 1));
                    rect = new Rectangle(5, 51, widthOne, height);
                    TypeMetro.this.previewColorPanel.add((Component)TypeMetro.this.createColorLabel(listener, TypeMetro.this.defaultBlockColor[2], rect, 2));
                    break;
                }
                case DOG0: {
                    Rectangle rect = new Rectangle(5, 5, widthTwo, height);
                    KDLabel indexLabel = TypeMetro.this.createColorLabel(listener, TypeMetro.this.defaultBlockColor[0], rect, 0);
                    TypeMetro.this.previewColorPanel.add((Component)indexLabel);
                    this.dispatchFirstEvent(indexLabel);
                    rect = new Rectangle(93, 5, widthTwo, height);
                    indexLabel = TypeMetro.this.createColorLabel(listener, TypeMetro.this.defaultBlockColor[1], rect, 1);
                    TypeMetro.this.previewColorPanel.add((Component)indexLabel);
                    rect = new Rectangle(5, 51, widthTwo, height);
                    indexLabel = TypeMetro.this.createColorLabel(listener, TypeMetro.this.defaultBlockColor[2], rect, 2);
                    TypeMetro.this.previewColorPanel.add((Component)indexLabel);
                    rect = new Rectangle(93, 51, widthTwo, height);
                    indexLabel = TypeMetro.this.createColorLabel(listener, TypeMetro.this.defaultBlockColor[3], rect, 3);
                    TypeMetro.this.previewColorPanel.add((Component)indexLabel);
                }
            }
            TypeMetro.this.previewColorPanel.repaint();
            TypeMetro.this.isColorSchemesChanged = false;
        }

        private void dispatchFirstEvent(KDLabel indexLabel) {
            MouseEvent me = new MouseEvent((Component)indexLabel, 500, System.currentTimeMillis(), 16, indexLabel.getX(), indexLabel.getY(), 1, false, 1);
            indexLabel.dispatchEvent((AWTEvent)me);
        }
    }
}

