/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.ThemeReportTreeNode;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.Set;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class PortalReportMenuUtil {
    private static Logger logger = CommonLogger.getLogger(PortalReportMenuUtil.class);

    public static boolean addPortalMenuDir(Context ctx, String displayName) throws BOSException {
        return PortalReportMenuUtil.addPortalMenuDir(ctx, "", displayName);
    }

    public static boolean addPortalMenuDir(Context ctx, String parentNodePath, String displayName) throws BOSException {
        RptParams params = new RptParams();
        params.setString("MethodName", "saveBIMenu");
        params.setString("parentNodePath", parentNodePath);
        params.setString("displayName", displayName);
        params = ctx != null ? ReportFacadeFactory.getLocalInstance(ctx).commonExecuteNever(params) : ReportFacadeFactory.getRemoteInstance().commonExecuteNever(params);
        return params.getString("exist") == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getReportMenuArray(Context ctx) {
        TreeModel treeRoot = null;
        try (Repository rep = null;){
            rep = BISystem.getRepository((Context)ctx);
            treeRoot = rep.getBITree(7);
        }
        ThemeReportTreeNode obj = (ThemeReportTreeNode)treeRoot.getRoot();
        JSONArray jsonArray = new JSONArray();
        PortalReportMenuUtil.genArray(jsonArray, obj, ctx);
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        HashMap<Object, JSONObject> mapAll = new HashMap<Object, JSONObject>();
        JSONArray needDel = new JSONArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jo = (JSONObject)jsonArray.get(i);
            if ("true".equals(jo.get((Object)"isFolder").toString())) {
                map.put(jo.get((Object)"repositoryPath"), 0);
            } else if (map.containsKey(jo.get((Object)"parent"))) {
                int val;
                String pKey = jo.get((Object)"parent").toString();
                while (null != pKey && mapAll.containsKey(pKey) && (val = ((Integer)map.get(pKey)).intValue()) <= 0) {
                    map.put(pKey, ++val);
                    JSONObject jb = (JSONObject)mapAll.get(pKey);
                    pKey = jb.get((Object)"parent").toString();
                }
            } else {
                map.put(jo.get((Object)"parent"), 0);
            }
            mapAll.put(jo.get((Object)"repositoryPath"), jo);
        }
        Set set = map.keySet();
        for (String key : set) {
            if ((Integer)map.get(key) != 0) continue;
            jsonArray.remove(mapAll.get(key));
        }
        return jsonArray;
    }

    private static JSONArray genArray(JSONArray jsonArray, ThemeReportTreeNode obj, Context ctx) {
        if (obj == null) {
            return jsonArray;
        }
        for (int i = 0; i < obj.getChildCount(); ++i) {
            ThemeReportTreeNode node = (ThemeReportTreeNode)obj.getChildAt(i);
            if (!node.isExtReport() && !node.isFolder()) continue;
            boolean isPermission = true;
            if (node.getReportPath() != null && !"".equals(node.getReportPath())) {
                try {
                    String reportID = node.getReportPath();
                    boolean isCloudRpt = (Boolean)Class.forName("com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO").getMethod("isCloudReport", Context.class, String.class).invoke(null, ctx, reportID);
                    String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                    String orgID = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
                    isPermission = (Boolean)Class.forName("com.kingdee.eas.rpts.ctrlreport.bo.PermissionBO").getMethod("hasDataPermissionByReportId", Context.class, String.class, String.class, String.class, Class.forName("com.kingdee.eas.rpts.ctrlreport.data.PermissionKind")).invoke(null, ctx, userID, orgID, reportID, Class.forName("com.kingdee.eas.rpts.ctrlreport.data.PermissionKind").getField("VIEW").get(null));
                    if (!isPermission && isCloudRpt) {
                        isPermission = (Boolean)Class.forName("com.kingdee.eas.rpts.ctrlreport.bo.CloudReportAuthBO").getMethod("hasDemoAuthByRptId", Context.class, String.class, String.class).invoke(null, ctx, reportID, userID);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                if (!isPermission) continue;
            }
            if (node.isFolder() && node.getChildCount() != 0) {
                PortalReportMenuUtil.addNode(jsonArray, node);
            }
            if (node.getReportPath() != null) {
                PortalReportMenuUtil.addNode(jsonArray, node);
            }
            PortalReportMenuUtil.genArray(jsonArray, node, ctx);
        }
        return null;
    }

    private static void addNode(JSONArray jsonArray, ThemeReportTreeNode node) {
        JSONObject treeNode = new JSONObject();
        treeNode.put("caption", (Object)node.getName());
        treeNode.put("repositoryPath", (Object)node.getRepositoryPath());
        treeNode.put("reportPath", (Object)(null == node.getReportPath() ? "0" : node.getReportPath()));
        if (node.getReportPath() == null) {
            treeNode.put("icon", (Object)"/plt_bi/res/file/folder_Open.gif");
        }
        treeNode.put("isFolder", (Object)node.isFolder());
        treeNode.put("isLeaf", (Object)node.isLeaf());
        treeNode.put("reportType", node.isExtReport() ? Boolean.valueOf(true) : "FOLDER");
        ThemeReportTreeNode parent = (ThemeReportTreeNode)node.getParent();
        treeNode.put("parent", (Object)(null == parent.getRepositoryPath() ? "0" : parent.getRepositoryPath()));
        jsonArray.add((Object)treeNode);
    }
}

