/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.common.web.util.DataCenterManager;
import com.kingdee.eas.cp.eip.sso.SSOHandleFacadeFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.module.perm.entity.User;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.net.URLEncoder;
import java.util.Locale;

public class PortalUtil {
    public static String getGUItoPortalUrl(String url) {
        String result = null;
        String serverURL = System.getProperty("EASPORTAL_ROOT");
        if (StringUtils.isEmpty((String)serverURL)) {
            serverURL = "http://localhost:6888/portal";
        } else if (serverURL.contains("easportal")) {
            serverURL = serverURL.replace("easportal", "portal");
        }
        try {
            result = SSOHandleFacadeFactory.getRemoteInstance().getGUItoPortalUrl(URLEncoder.encode(url, "utf-8"), true, SysContext.getSysContext().getLocale().toString(), SysContext.getSysContext().getDCNumber());
            result = serverURL + "/" + result;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static PortalContext getPortalContext(Context context) {
        PortalContext portalContext = new PortalContext();
        portalContext.setIp(context.getClientHostIP());
        portalContext.setLocale(PortalUtil.populateStandardLocal(context.getLocale()));
        portalContext.setSessionId(Uuid.create().toString());
        portalContext.getMetaInfo().put("eas_context", context);
        portalContext.getMetaInfo().put("eas_context_id", context.getContextID());
        portalContext.getMetaInfo().put("current_data_center", context.getAIS());
        User loginUser = new User();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)context);
        loginUser.setId(user.getId().toString());
        loginUser.setName(user.getName());
        loginUser.setCode(user.getNumber());
        portalContext.setLoginUser(loginUser);
        loginUser.setPortalContext(portalContext);
        DataCenterManager dataCenterManager = new DataCenterManager(context);
        portalContext.getMetaInfo().put("current_data_center_name", dataCenterManager.getDatacenterName(context));
        return portalContext;
    }

    private static Locale populateStandardLocal(Locale easLocale) {
        if ("l1".equals(easLocale.getLanguage())) {
            return Locale.ENGLISH;
        }
        if ("l2".equals(easLocale.getLanguage())) {
            return Locale.CHINA;
        }
        if ("l3".equals(easLocale.getLanguage())) {
            return Locale.TAIWAN;
        }
        return Locale.CHINA;
    }
}

