/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.util.fi;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.eas.rpts.ctrlreport.util.fi.FIParam;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class FIParamIO {
    public static void serialize(List<FIParam> params, Book template) {
        Element root = new Element("FIParams");
        for (FIParam p : params) {
            Element ep = new Element("FIParam");
            ep.setAttribute("name", p.getName());
            ep.setAttribute("value", p.getValue());
            ep.setAttribute("dataType", String.valueOf(p.getDataType()));
            ep.setAttribute("sheetName", p.getSheetName());
            ep.setText(p.getDesc());
            root.addContent((Content)ep);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLOutputter xml = new XMLOutputter();
        try {
            xml.output(root, (OutputStream)out);
            template.setUserObject("rpts_report_fiParams", (Object)new String(out.toByteArray(), "UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<FIParam> load(Book template) {
        Element root;
        String serialString = (String)template.getUserObjectValue("rpts_report_fiParams");
        if (StringUtil.isEmptyString((String)serialString)) {
            return FIParamIO.loadDefault();
        }
        SAXBuilder sb = new SAXBuilder();
        try {
            root = sb.build((InputStream)new ByteArrayInputStream(serialString.getBytes("UTF-8"))).getRootElement();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return FIParamIO.loadDefault();
        }
        ArrayList<FIParam> params = new ArrayList<FIParam>();
        List children = root.getChildren("FIParam");
        for (Object o : children) {
            if (!(o instanceof Element)) continue;
            Element child = (Element)o;
            params.add(new FIParam().setDataType(Integer.parseInt(child.getAttributeValue("dataType"))).setDesc(child.getText()).setName(child.getAttributeValue("name")).setSheetName(child.getAttributeValue("sheetName")).setValue(child.getAttributeValue("value")));
        }
        return params;
    }

    private static List<FIParam> loadDefault() {
        ArrayList<FIParam> params = new ArrayList<FIParam>();
        FIParam param = new FIParam();
        param.setName("IncludePosted").setValue("N").setSheetName("sheet1").setDesc("\u5305\u542b\u672a\u8fc7\u8d26\u51ed\u8bc1").setDataType(1);
        params.add(param);
        param = new FIParam();
        param.setName("IncludeSub").setValue("N").setSheetName("sheet1").setDesc("\u5305\u542b\u6240\u6709\u76f4\u63a5\u4e0b\u7ea7\u79d1\u76ee\u53ca\u8f85\u52a9\u8d26\u501f/\u8d37\u65b9\u4f59\u989d").setDataType(1);
        params.add(param);
        param = new FIParam();
        param.setName("IncludeSubAccount").setValue("N").setSheetName("sheet1").setDesc("\u5305\u542b\u6240\u6709\u76f4\u63a5\u4e0b\u7ea7\u79d1\u76ee\u501f/\u8d37\u65b9\u4f59\u989d").setDataType(1);
        params.add(param);
        param = new FIParam();
        param.setName("IncludeLeaf").setValue("N").setSheetName("sheet1").setDesc("\u5305\u542b\u6240\u6709\u6700\u660e\u7ec6\u7ea7\u79d1\u76ee\u53ca\u8f85\u52a9\u8d26\u7684\u501f\u65b9/\u8d37\u65b9\u4f59\u989d").setDataType(1);
        params.add(param);
        param = new FIParam();
        param.setName("IncludeLeafAccount").setValue("N").setSheetName("sheet1").setDesc("\u5305\u542b\u6240\u6709\u6700\u660e\u7ec6\u7ea7\u79d1\u76ee\u501f\u65b9/\u8d37\u65b9\u4f59\u989d").setDataType(1);
        params.add(param);
        param = new FIParam();
        param.setName("IncludeAllAssistItems").setValue("N").setSheetName("sheet1").setDesc("\u5305\u542b\u6240\u6709\u660e\u7ec6\u79d1\u76ee\u7684\u6838\u7b97\u9879\u76ee").setDataType(1);
        params.add(param);
        param = new FIParam();
        param.setName("Currency").setSheetName("sheet1").setDesc("\u5e01\u522b").setDataType(0);
        params.add(param);
        param = new FIParam();
        param.setName("StartYear").setValue("0").setSheetName("sheet1").setDesc("\u5f00\u59cb\u5e74").setDataType(3);
        params.add(param);
        param = new FIParam();
        param.setName("EndYear").setValue("0").setSheetName("sheet1").setDesc("\u7ed3\u675f\u5e74").setDataType(3);
        params.add(param);
        param = new FIParam();
        param.setName("StartPeriod").setValue("0").setSheetName("sheet1").setDesc("\u5f00\u59cb\u671f\u95f4").setDataType(3);
        params.add(param);
        param = new FIParam();
        param.setName("EndPeriod").setValue("0").setSheetName("sheet1").setDesc("\u7ed3\u675f\u671f\u95f4").setDataType(3);
        params.add(param);
        return params;
    }
}

