/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.model;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgRangeManage {
    private static Logger log = LogUtil.getPackageLogger(OrgRangeManage.class);
    public static final String ID = "id";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String PARENTID = "parentId";

    public static final DefObj[] getOrgRangeFieldList() {
        DefObj defItem1 = OrgRangeManage.getDefObj(ID, "ID");
        DefObj defItem2 = OrgRangeManage.getDefObj(NUMBER, "\u7f16\u7801");
        DefObj defItem3 = OrgRangeManage.getDefObj(NAME, "\u540d\u79f0");
        DefObj[] defObjs = new DefObj[]{defItem1, defItem2, defItem3};
        return defObjs;
    }

    public static final DefObj getDefObj(String name, String alias) {
        DefObj defItem = new DefObj(){

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append(this.getName()).append("  [").append(this.getAlias()).append("]");
                return sb.toString();
            }
        };
        defItem.setName(name);
        defItem.setAlias(alias);
        return defItem;
    }

    public static final ArrayList<HashMap<String, String>> getOrgRangeDataList(Context ctx, String userPK) {
        return OrgRangeManage.getOrgRangeList1(ctx, userPK, 10);
    }

    public static final ArrayList<HashMap<String, String>> getAdminOrgRangeList(Context ctx, String userPK) {
        return OrgRangeManage.getOrgRangeList1(ctx, userPK, 20);
    }

    private static final ArrayList<HashMap<String, String>> getOrgRangeList1(Context ctx, String userPK, int orgRangeType) {
        String table = "T_ORG_BaseUnit";
        String sealup = "";
        if (orgRangeType == 20) {
            table = "t_org_admin";
            sealup = " Fissealup = 0 and ";
        }
        String sql = new StringBuffer("SELECT FID,FNUMBER,FNAME_L2,FParentID FROM ").append(table).append(" WHERE ").append(sealup).append("FID IN(SELECT FORGID FROM T_PM_ORGRANGE WHERE FUSERID='").append(userPK).append("' AND FTYPE=").append(orgRangeType).append(") AND FISUNION = 0").toString();
        return OrgRangeManage.getOrgRangeList2(ctx, sql);
    }

    private static final ArrayList<HashMap<String, String>> getOrgRangeList2(Context ctx, String sql) {
        ArrayList<Object> dataList = new ArrayList<HashMap<String, String>>();
        try {
            IRowSet rowset = ExtDBUtil.executeQuery(ctx, sql, null);
            HashMap<String, String> map = null;
            while (rowset.next()) {
                map = new HashMap<String, String>();
                map.put(ID, CtrlReportUtil.getObjectString(rowset.getString("FID")));
                map.put(NUMBER, CtrlReportUtil.getObjectString(rowset.getString("FNUMBER")));
                map.put(NAME, CtrlReportUtil.getObjectString(rowset.getString("FNAME_L2")));
                map.put(PARENTID, CtrlReportUtil.getObjectString(rowset.getString("FParentID")));
                dataList.add(map);
            }
            if (map == null) {
                return dataList;
            }
            Comparator mapCp = new Comparator(){

                public int compare(Object oObj, Object tObj) {
                    Map oneM = (Map)oObj;
                    Map twoM = (Map)tObj;
                    String oneNum = (String)oneM.get(OrgRangeManage.NUMBER);
                    oneNum = StringUtil.isEmptyString((String)oneNum) ? "" : oneNum;
                    return oneNum.compareTo((String)twoM.get(OrgRangeManage.NUMBER));
                }
            };
            Object[] orgs = dataList.toArray();
            Arrays.sort(orgs, mapCp);
            dataList = new ArrayList<Object>(Arrays.asList(orgs));
        }
        catch (Exception e) {
            log.error((Object)"\u83b7\u53d6\u7528\u6237\u7ec4\u7ec7\u8303\u56f4\u9519\u8bef", (Throwable)e);
        }
        return dataList;
    }

    public static final ArrayList<HashMap<String, String>> getPermissionOrgRangeList(Context ctx, String userPK, String reportId) {
        ArrayList<HashMap<String, String>> dataList = new ArrayList<HashMap<String, String>>();
        StringBuffer sqlBuf = new StringBuffer();
        try {
            sqlBuf = sqlBuf.append("select fpermissiontype, fuserid, forgid, froleid from t_ext_permission where ").append("freportid='").append(reportId).append("'");
            IRowSet rowset = ExtDBUtil.executeQuery(ctx, sqlBuf.toString(), null);
            ArrayList<String> orgIdList = new ArrayList<String>();
            ArrayList<String> roleIdList = new ArrayList<String>();
            boolean onlyUser = false;
            while (!onlyUser && rowset.next()) {
                int fpermissiontype = rowset.getInt("fpermissiontype");
                String fuserid = rowset.getString("fuserid");
                switch (fpermissiontype) {
                    case 2: {
                        if (StringUtil.isEmptyString((String)fuserid) || !fuserid.endsWith(userPK)) break;
                        onlyUser = true;
                        break;
                    }
                    case 0: {
                        String forgid = rowset.getString("forgid");
                        if (StringUtil.isEmptyString((String)forgid) || StringUtil.isEmptyString((String)fuserid) || !fuserid.endsWith(userPK)) break;
                        orgIdList.add(forgid);
                        break;
                    }
                    case 1: {
                        String froleid = rowset.getString("froleid");
                        if (StringUtil.isEmptyString((String)froleid)) break;
                        roleIdList.add(froleid);
                    }
                }
            }
            if (onlyUser) {
                return OrgRangeManage.getOrgRangeDataList(ctx, userPK);
            }
            if (!roleIdList.isEmpty()) {
                sqlBuf.delete(0, sqlBuf.length()).append("select forgid from t_pm_userroleorg where fuserid='").append(userPK).append("' and froleid in (");
                Iterator roleIdIter = roleIdList.iterator();
                while (roleIdIter.hasNext()) {
                    sqlBuf.append("'").append((String)roleIdIter.next()).append("',");
                }
                sqlBuf.replace(sqlBuf.length() - 1, sqlBuf.length(), ")");
                rowset = ExtDBUtil.executeQuery(ctx, sqlBuf.toString(), null);
                while (rowset != null && rowset.next()) {
                    orgIdList.add(rowset.getString("forgid"));
                }
            }
            if (!orgIdList.isEmpty()) {
                sqlBuf.delete(0, sqlBuf.length()).append("SELECT FID,FNUMBER,FNAME_L2,FParentID FROM T_ORG_BaseUnit WHERE fid in (");
                Iterator orgIdIter = orgIdList.iterator();
                while (orgIdIter.hasNext()) {
                    sqlBuf.append("'").append((String)orgIdIter.next()).append("',");
                }
                sqlBuf.replace(sqlBuf.length() - 1, sqlBuf.length(), ")");
                return OrgRangeManage.getOrgRangeList2(ctx, sqlBuf.toString());
            }
        }
        catch (Exception e) {
            log.error((Object)"\u83b7\u53d6\u5f53\u524d\u7528\u6237\u62a5\u8868\u6388\u6743\u7ec4\u7ec7\u8303\u56f4\u7684\u6570\u636e\u9519\u8bef\uff01", (Throwable)e);
        }
        return dataList;
    }

    public static final ArrayList<HashMap<String, String>> getOrgRangeList(Context ctx, String userPK, int sysVarType) {
        return OrgRangeManage.getOrgRangeList(ctx, userPK, sysVarType, null);
    }

    public static final ArrayList<HashMap<String, String>> getOrgRangeList(Context ctx, String userPK, int sysVarType, String reportId) {
        switch (sysVarType) {
            case 0: {
                return OrgRangeManage.getOrgRangeDataList(ctx, userPK);
            }
            case 1: {
                return OrgRangeManage.getAdminOrgRangeList(ctx, userPK);
            }
            case 2: {
                return OrgRangeManage.getPermissionOrgRangeList(ctx, userPK, reportId);
            }
            case 3: {
                return OrgRangeManage.getFIOrgRangeDataList(ctx, userPK);
            }
        }
        log.error((Object)("\u4e0d\u5b58\u5728\u7684\u7cfb\u7edf\u9884\u8bbe\u53d8\u91cf\u7c7b\u578b: " + sysVarType));
        return new ArrayList<HashMap<String, String>>();
    }

    private static ArrayList<HashMap<String, String>> getFIOrgRangeDataList(Context ctx, String userPK) {
        String table = "t_Org_company";
        String sql = new StringBuffer("SELECT FID,FNUMBER,FNAME_L2,FParentID FROM ").append(table).append(" WHERE  FIsSealUp = 0  and fid IN (SELECT DISTINCT forgid FROM t_pm_orgrange WHERE fuserid = '").append(userPK).append("' AND FTYPE=10) AND FISUNION = 0 ").toString();
        return OrgRangeManage.getOrgRangeList2(ctx, sql);
    }
}

