/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.model;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.ExtStringUtil;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SqlParamParser {
    private static final Logger logger = CommonLogger.getLogger(SqlParamParser.class);
    public static final String reg_paramname_end = "[,|%|\\(|\\)|\\s|'|\"|@]";
    private static final String addEndString = " and 1=1";
    public static final String reg_paramname = "([A-Z|a-z|0-9|_])";

    public static final boolean isErrorParamName(String source) {
        boolean flag = false;
        try {
            Pattern pattern = Pattern.compile(reg_paramname, 2);
            for (int i = 0; i < source.length(); ++i) {
                String str = source.substring(i, i + 1);
                Matcher matcher = pattern.matcher(str);
                if (matcher.find()) continue;
                flag = true;
                break;
            }
        }
        catch (Exception e) {
            flag = true;
            logger.error((Object)"SqlParamParser.isOKParamName", (Throwable)e);
        }
        return flag;
    }

    public static final String getValueByReg(String source, String strRegex) {
        String strRet = "";
        try {
            Pattern pattern = Pattern.compile(strRegex, 2);
            Matcher matcher = pattern.matcher(source);
            if (matcher.find()) {
                strRet = matcher.group(1);
            }
        }
        catch (Exception e) {
            logger.debug((Object)"SqlParamParser.getValueByReg", (Throwable)e);
        }
        return strRet;
    }

    public static final String replaceRNT2Empty(String source) {
        return source.replaceAll("\\r|\\n|\\t", " ");
    }

    public static final String customSQLReg(String source, HashMap mapParam, HashMap paramTypeMap, String paramName, Object[] paramValues) {
        String curentName;
        source = SqlParamParser.replaceRNT2Empty(source);
        source = source.trim();
        StringBuffer sbSQL = new StringBuffer();
        StringBuffer newWhere = new StringBuffer();
        String reg = null;
        reg = source.endsWith("@" + paramName) ? "@(" + paramName + ")" : "@(" + paramName + ")" + reg_paramname_end;
        Pattern pattern = Pattern.compile(reg, 2);
        Matcher matcher = pattern.matcher(source);
        if (matcher.find() && paramName.equalsIgnoreCase(curentName = matcher.group(1))) {
            String newParamName = paramName + String.valueOf(CtrlReportUtil.getSystemTime());
            Pattern pattern2 = null;
            Matcher matcher2 = null;
            boolean isAddEndFlag = false;
            while (true) {
                String tmp = "@" + paramName + reg_paramname_end;
                String reg2 = "(.+)\\s(where|or|and)(.+)(" + tmp + ")(.*)(or|and)\\s(.+)";
                pattern2 = Pattern.compile(reg2, 2);
                matcher2 = pattern2.matcher(source);
                if (matcher2.find()) break;
                if (isAddEndFlag) {
                    return source;
                }
                source = source + addEndString;
                isAddEndFlag = true;
            }
            String sqlStart = matcher2.group(1);
            String whereOrAnd = matcher2.group(2);
            String expOperator = matcher2.group(3);
            String param = matcher2.group(4);
            String exp = matcher2.group(5);
            String whereOrAnd2 = matcher2.group(6);
            String sqlEnd = matcher2.group(7);
            String reg3 = "(.+)\\s+(=|>|<|>=|<=|in|like)\\s+(.*)";
            Pattern pattern3 = Pattern.compile(reg3, 2);
            Matcher matcher3 = pattern3.matcher(expOperator);
            if (matcher3.find()) {
                String expStart = matcher3.group(1);
                String operator = matcher3.group(2);
                String expEnd = matcher3.group(3);
                StringBuffer newValue = new StringBuffer();
                newValue.append(expEnd).append(param).append(exp);
                if (operator.equalsIgnoreCase("IN")) {
                    newWhere.append(expStart).append(" ").append(operator).append(" (");
                    int length = paramValues.length;
                    for (int n = 0; n < length; ++n) {
                        String currentNewParamName = newParamName + "_" + n;
                        String newParamNameTemp = ExtStringUtil.replace(newValue.toString(), "@" + paramName, "@" + currentNewParamName);
                        newWhere.append(newParamNameTemp);
                        if (n < length - 1) {
                            newWhere.append(", ");
                        }
                        String paramValue = CtrlReportUtil.getObjectString(paramValues[n]);
                        mapParam.put(currentNewParamName, paramValue);
                        paramTypeMap.put(currentNewParamName, paramTypeMap.get(paramName));
                    }
                    newWhere.append(")");
                } else {
                    newWhere.append("(");
                    int length = paramValues.length;
                    for (int n = 0; n < length; ++n) {
                        String currentNewParamName = newParamName + "_" + n;
                        String newParamNameTemp = ExtStringUtil.replace(newValue.toString(), "@" + paramName, "@" + currentNewParamName);
                        newWhere.append(expStart).append(" ").append(operator).append(" ").append(newParamNameTemp);
                        if (n < length - 1) {
                            newWhere.append(" OR ");
                        }
                        String paramValue = CtrlReportUtil.getObjectString(paramValues[n]);
                        mapParam.put(currentNewParamName, paramValue);
                        paramTypeMap.put(currentNewParamName, paramTypeMap.get(paramName));
                    }
                    newWhere.append(")");
                }
                if (isAddEndFlag) {
                    whereOrAnd2 = "";
                    sqlEnd = "";
                }
                sbSQL.append(sqlStart).append(" ").append(whereOrAnd).append(" ").append(newWhere).append(" ").append(whereOrAnd2).append(" ").append(sqlEnd);
            } else {
                return null;
            }
        }
        return CtrlReportUtil.trimStr(sbSQL.toString());
    }

    public static void main(String[] str) {
        String paraname = "name";
        String source = "() table where name = @name";
        Object[] obj = new String[]{"11", "22", "33"};
        String sql = SqlParamParser.customSQLReg(source, new HashMap(), new HashMap(), paraname, obj);
        System.out.println(sql);
        if (!source.endsWith("@" + paraname)) {
            try {
                String reg = "@" + paraname + "[,|\\(|\\)|\\s|'|\"]";
                String strRet = null;
                Pattern pattern = Pattern.compile(reg);
                Matcher matcher = pattern.matcher(source);
                Object strNum = null;
                if (matcher.find()) {
                    strRet = matcher.group(0);
                    reg = "(.+)\\s(where|or|and)(.+)(" + reg + ")(.*)(or|and)\\s(.+)";
                    Pattern pattern2 = Pattern.compile(reg);
                    Matcher matcher2 = pattern2.matcher(source);
                    Object strNum2 = null;
                    if (matcher2.find()) {
                        strRet = matcher2.group(3);
                        System.out.println(matcher2.groupCount());
                        String sqlStart = matcher2.group(1);
                        String whereOrAnd = matcher2.group(2);
                        String expOperator = matcher2.group(3);
                        String param = matcher2.group(4);
                        String exp = matcher2.group(5);
                        String whereOrAnd2 = matcher2.group(6);
                        String sqlEnd = matcher2.group(7);
                        for (int i = 0; i < matcher2.groupCount(); ++i) {
                            System.out.println(matcher2.group(i));
                        }
                        reg = "(.+)\\s+(=|>|<|>=|<=|in|like)\\s+(.*)";
                        Pattern pattern3 = Pattern.compile(reg);
                        Matcher matcher3 = pattern3.matcher(strRet);
                        if (matcher3.find()) {
                            System.out.println("*************");
                            for (int i = 0; i < matcher3.groupCount(); ++i) {
                                System.out.println(matcher3.group(i));
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

