/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.explorer.model.base.ConstructURL;
import com.kingdee.bos.ctrl.ext.immit.IRptRuntimeCallback;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAXException;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.kds.exec.ExtExecutor;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.bos.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.UserObject;
import com.kingdee.bos.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.bos.ctrl.kds.model.util.ExtURL;
import com.kingdee.bos.ctrl.kds.model.util.IConstructURL;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.base.license.EXTLicenseException;
import com.kingdee.eas.rpts.base.license.EXTLicenseService;
import com.kingdee.eas.rpts.base.license.ILicenseChecker;
import com.kingdee.eas.rpts.base.license.LicenseCheckerFactory;
import com.kingdee.eas.rpts.base.license.ReportCenterLicenseSrvChecker;
import com.kingdee.eas.rpts.cloud.service.CloudRptCenterControllerFacade;
import com.kingdee.eas.rpts.cloud.service.ICloudRptCenterController;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.audittool.ReportAuditUtil;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.bo.PermissionBO;
import com.kingdee.eas.rpts.ctrlreport.data.PermissionKind;
import com.kingdee.eas.rpts.ctrlreport.data.PublishType;
import com.kingdee.eas.rpts.ctrlreport.datasetfactory.DataSetBaseFactory;
import com.kingdee.eas.rpts.ctrlreport.datasetfactory.ExtDataSetEnumFactory;
import com.kingdee.eas.rpts.ctrlreport.datasetfactory.ExtDataSetKSQLFactory;
import com.kingdee.eas.rpts.ctrlreport.datasetfactory.ExtDataSetTextFactory;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroDesignException;
import com.kingdee.eas.rpts.ctrlreport.macro.exec.ExtRptMacroExecuteFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.mobile.util.LayoutParameterUtil;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.model.RptRuntimeCallbackImpl;
import com.kingdee.eas.rpts.ctrlreport.subrpt.SubReportException;
import com.kingdee.eas.rpts.ctrlreport.subrpt.SubReportWebExecutor;
import com.kingdee.eas.rpts.ctrlsqldesign.data.CacheObject;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputState;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.SystemVarType;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtContextUtils;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.OrgRangeManage;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.SqlDSModelDrill;
import com.kingdee.eas.rpts.ctrlsqldesign.model.exception.InvalidCouponException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.exception.NonExistRptException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.exception.NonModuleLisenceException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.exception.RptBinaryUnpackFailureException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.exception.RptLisenceCheckException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.exception.RptPermissionDeniedException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.exception.UnDeployedRptVisitException;
import com.kingdee.eas.rpts.tobi.domain.WebReportDomain;
import com.kingdee.eas.rpts.tobi.util.BosContextUtil;
import com.kingdee.eas.rpts.web.filter.ReportParamDescription;
import com.kingdee.eas.rpts.web.vo.Entry;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class WebParamAdapter {
    private static final Logger logger = CommonLogger.getLogger(WebParamAdapter.class);
    public static final String T_FilterComponent = "FilterComponent";
    public static final String T_FilterItem = "FilterItem";
    public static final String T_ListItem = "ListItem";
    public static final String A_type = "type";
    public static final String A_name = "name";
    public static final String A_dataType = "dataType";
    public static final String A_caption = "caption";
    public static final String A_required = "required";
    public static final String A_defaultValue = "defaultValue";
    public static final String A_defalutAlias = "defaultAlais";
    public static final String A_isAllowEdit = "isAllowEdit";
    public static final String A_isReadOnly = "isReadOnly";
    public static final String A_isAllowMultipleSelected = "isAllowMultipleSelected";
    public static final String A_value = "value";
    public static final String A_valueColumn = "valueColumn";
    public static final String A_displayColumn = "displayColumn";
    public static final String A_fullname = "fullname";
    public static final String A_errMsg = "errMsg";
    public static final String BIContext = "BIContext";
    public static final String CurrentReportDBModel = "CurrentReportDBModel";
    public static final String isLimitRecord = "isLimitRecord";
    public static final String isLimitComplete = "isLimitComplete";
    public static final String datasetParent = "datasetParent";
    public static final String CacheObject = "CacheObject";
    public static final String EXTOUTPARAM = "extOutParam";
    public static final String IS_DSH_EXTREPORT = "isDshExtReport";
    public static final String DSH_EXTREPORT_SELECTTYPE = "selectType";
    public static final String ORG_FULL_NAME = "orgFullName";
    public static final String SELECTTYPE_MOUDL = "modul";
    private String reportID;
    private String reportName;
    private String systemID;
    private String orgID;
    private String sourceReportOrgID;
    private Context ctx;
    Book book;
    private DefineReportInfo info;
    ArrayList reportDBModel = new ArrayList();
    ArrayList allUnionParam = new ArrayList();
    private Map mapOutParam;
    boolean isSchedule = false;
    protected ILicenseChecker _licenseChecker;
    private boolean _isChecked;
    private boolean _isTree;
    private Map _sqlDbMap;
    private boolean _initSqlDbMap;
    private boolean isHyperlink;
    private boolean isDshExtReport = false;
    private String orgFullName;
    private String dshExtReportSelectType;
    private static ThreadLocal<WebParamAdapter> local = new ThreadLocal();

    public WebParamAdapter(Context ctx, String reportID) {
        this.ctx = ctx;
        this.reportID = reportID;
        ExtContextUtils.setContext(ctx);
    }

    public WebParamAdapter(Context ctx, String reportID, boolean isCheckLisence) {
        this.ctx = ctx;
        this.reportID = reportID;
        this._isChecked = !isCheckLisence;
        ExtContextUtils.setContext(ctx);
    }

    public WebParamAdapter(Context ctx, String reportName, String systemID, String orgID) {
        this.ctx = ctx;
        this.reportName = reportName;
        this.systemID = systemID;
        this.orgID = orgID;
        ExtContextUtils.setContext(ctx);
    }

    public WebParamAdapter(Context ctx, String reportName, String systemID, String orgID, String reportId) {
        this.ctx = ctx;
        this.reportName = reportName;
        this.systemID = systemID;
        this.orgID = orgID;
        this.reportID = reportId;
        ExtContextUtils.setContext(ctx);
    }

    public void setSchedule(boolean isSchedule) {
        this.isSchedule = isSchedule;
    }

    public void cacheDbSourceModel(boolean checkRptPermission) throws Exception {
        this.book = this.refreshBook(checkRptPermission);
        try {
            this.cacheDbSourceModel();
        }
        catch (Exception e) {
            logger.error((Object)"getReportParamXmlString.cacheDbSourceModel", (Throwable)e);
            throw e;
        }
    }

    public String getReportParamXmlString(boolean checkRptPermission, Map mapOutParam) throws Exception {
        this.cacheDbSourceModel(checkRptPermission);
        this.handleOutParam(mapOutParam);
        Element rootElement = new Element(T_FilterComponent);
        Iterator itr = this.allUnionParam.iterator();
        while (itr.hasNext()) {
            Element itemElement = this.makeFilterItem((DesignParameter)((Object)itr.next()));
            if (null == itemElement) continue;
            rootElement.addContent((Content)itemElement);
        }
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        format.setEncoding("UTF-8");
        XMLOutputter outter = new XMLOutputter(format);
        String xmlstr = outter.outputString(rootElement);
        return xmlstr;
    }

    public Map parseOutParam(String extOutParam) throws BIReportException {
        HashMap<String, String> mapOutParam = null;
        if (!StringUtil.isEmptyString((String)extOutParam)) {
            try {
                mapOutParam = new HashMap<String, String>();
                JSONObject oParam = new JSONObject(extOutParam);
                Iterator iter = oParam.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    Object value = oParam.get(key);
                    if (value == null) continue;
                    String strValue = "";
                    if (value instanceof JSONArray) {
                        JSONArray arrValue = (JSONArray)value;
                        for (int i = 0; i < arrValue.length(); ++i) {
                            strValue = strValue + arrValue.get(i) + "0xx1xx";
                        }
                        strValue = strValue.substring(0, strValue.length() - "0xx1xx".length());
                    } else {
                        strValue = String.valueOf(value);
                    }
                    mapOutParam.put(key, strValue);
                }
            }
            catch (JSONException je) {
                String msg = "\u89e3\u6790\u5916\u90e8\u96c6\u6210URL\u53c2\u6570(extOutParam)\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u683c\u5f0f\u662f\u5426\u6b63\u786e!";
                logger.error((Object)msg, (Throwable)je);
                throw new BIReportException(msg, (Throwable)je);
            }
        }
        this.mapOutParam = mapOutParam;
        return mapOutParam;
    }

    public Map getOutParamMap() {
        return this.mapOutParam;
    }

    public void handleOutParam(Map mapOutParam) {
        String value;
        if (mapOutParam == null || mapOutParam.isEmpty()) {
            return;
        }
        for (DesignParameter dp : this.allUnionParam) {
            String name = dp.getName();
            if (!mapOutParam.containsKey(name)) continue;
            value = (String)mapOutParam.get(name);
            dp.setCurentValue(value);
            dp.setCurentValueAlias(value);
            dp.setDefaultValue(value);
            dp.setDefaultAlias(value);
            mapOutParam.remove(name);
        }
        for (String name : mapOutParam.keySet()) {
            DesignParameter dp;
            dp = new DesignParameter();
            dp.setAllowNull(true);
            dp.setInputType(InputType.INPUT);
            dp.setInputState(InputState.HIDDEN);
            dp.setDesignDataType(DesignDataType.TXT);
            dp.setName(name);
            dp.setAlias(name);
            value = (String)mapOutParam.get(name);
            dp.setCurentValue(value);
            dp.setCurentValueAlias(value);
            dp.setDefaultValue(value);
            dp.setDefaultAlias(value);
            this.allUnionParam.add(dp);
        }
    }

    public String getReportParamXmlString(boolean checkRptPermission) throws Exception {
        return this.getReportParamXmlString(checkRptPermission, null);
    }

    public static WebParamAdapter getCurrentInst() {
        return local.get();
    }

    public void cacheUnionParam(Book book, Context ctx) throws Exception {
        String orgId;
        this.book = book;
        ExtDataSetManager dm = book.getDataSetManager();
        int dsSize = dm.size();
        ExtDataSet[] datasets = new ExtDataSet[dsSize];
        if (!this._initSqlDbMap) {
            this._sqlDbMap = new HashMap(10);
        }
        for (int i = 0; i < dsSize; ++i) {
            Map map;
            datasets[i] = dm.getAt(i);
            if (this._initSqlDbMap || StringUtil.isEmptyString((String)datasets[i].getMeta()) || (map = (Map)SqlDSModelDrill.split(datasets[i].getMeta())[1]) == null || map.isEmpty()) continue;
            this._sqlDbMap.putAll(map);
        }
        this._initSqlDbMap = true;
        this.sourceReportOrgID = orgId = BosContextUtil.getClientCurrentOrgId();
        try {
            local.set(this);
            RunReportParam.cacheDbSourceModel(ctx, datasets, this.reportDBModel, this.allUnionParam, null, this.sourceReportOrgID, orgId);
        }
        catch (Exception e) {
            logger.error((Object)"getReportParamXmlString.cacheDbSourceModel", (Throwable)e);
            throw e;
        }
    }

    public String getReportParamXmlString() throws Exception {
        return this.getReportParamXmlString(true);
    }

    public static HashMap prepareParam(Context ctx, Map mapBIParam, Map mapBIAlias, ArrayList allUnionParam, boolean isSchedule) throws JDOMException, IOException {
        ArrayList paramList = new ArrayList();
        for (DesignParameter dp : allUnionParam) {
            String paramName = dp.getName();
            String value = "";
            DesignDataType ddt = dp.getDesignDataType();
            String dataType = String.valueOf(ddt.intValue());
            String alias = "";
            if (mapBIParam.containsKey(paramName)) {
                value = CtrlReportUtil.getObjectString(mapBIParam.get(paramName));
                alias = CtrlReportUtil.getObjectString(mapBIAlias.get(paramName));
                if (dataType.equals(String.valueOf(2)) && !isSchedule && !value.equals("")) {
                    try {
                        Date curr = CtrlReportUtil.sdf_yyyy_MM_dd.parse(value);
                        value = CtrlReportUtil.formatDate(curr);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(A_name, paramName);
            map.put(A_value, value);
            map.put("valueAlias", alias);
            map.put(A_dataType, dataType);
            paramList.add(map);
            HashMap<String, String> mapValueAlias = new HashMap<String, String>();
            mapValueAlias.put(A_name, paramName + "_text");
            mapValueAlias.put("valueAlias", alias);
            mapValueAlias.put(A_dataType, String.valueOf(0));
            if (null != alias && alias.length() > 0) {
                mapValueAlias.put(A_value, alias);
            } else {
                mapValueAlias.put(A_value, null);
            }
            paramList.add(mapValueAlias);
        }
        String parameterXmlString = CtrlDesignUtil.toFilterSolutionXml(paramList);
        HashMap mapDesignParam = RunReportParam.setExecuteParam(allUnionParam, parameterXmlString);
        RunReportParam.putServerDefalutListParamsMap(ctx, mapDesignParam);
        return mapDesignParam;
    }

    public void execute(Map mapBIParam, Map mapBIAlias) throws IOException, KDFException, KDFSAXException, Exception {
        long runStart = System.currentTimeMillis();
        this.book = this.refreshBook();
        this.cacheDbSourceModel();
        HashMap mapDesignParam = WebParamAdapter.prepareParam(this.ctx, mapBIParam, mapBIAlias, this.allUnionParam, this.isSchedule);
        this.runExt(mapDesignParam);
        if (ReportAuditUtil.isDeployReport(this.info)) {
            int loadPathType = 2;
            if (mapBIParam.containsKey("loadPathType")) {
                loadPathType = (Integer)mapBIParam.get("loadPathType");
                mapBIParam.remove("loadPathType");
            }
            long end = System.currentTimeMillis() - runStart;
            ReportAuditUtil.updateAuditTable(this.ctx, this.info, end, loadPathType);
        }
        Sheet sheet = this.book.getActiveSheet();
        UserObject colTreePos = sheet.getUserObject("COLUMN_INLINED_TREE_POSITION");
        UserObject rowTreePos = sheet.getUserObject("ROW_INLINED_TREE_POSITION");
        if (!this._isTree) {
            this._isTree = colTreePos != null ^ rowTreePos != null;
        }
    }

    public static Map buildParam(Context ctx, ArrayList allUnionParam, Map mapBIParam, Map mapBIAlias) throws JDOMException, IOException {
        ArrayList paramList = new ArrayList();
        for (DesignParameter dp : allUnionParam) {
            String paramName = dp.getName();
            String value = "";
            DesignDataType ddt = dp.getDesignDataType();
            String dataType = String.valueOf(ddt.intValue());
            String alias = "";
            if (mapBIParam.containsKey(paramName)) {
                value = CtrlReportUtil.getObjectString(mapBIParam.get(paramName));
                alias = CtrlReportUtil.getObjectString(mapBIAlias.get(paramName));
                if (dataType.equals(String.valueOf(2)) && !value.equals("")) {
                    try {
                        Date curr = CtrlReportUtil.sdf_yyyy_MM_dd.parse(value);
                        value = CtrlReportUtil.formatDate(curr);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(A_name, paramName);
            map.put(A_value, value);
            map.put("valueAlias", alias);
            map.put(A_dataType, dataType);
            paramList.add(map);
            HashMap<String, String> mapValueAlias = new HashMap<String, String>();
            mapValueAlias.put(A_name, paramName + "_text");
            mapValueAlias.put("valueAlias", alias);
            mapValueAlias.put(A_dataType, String.valueOf(0));
            if (null != alias && alias.length() > 0) {
                mapValueAlias.put(A_value, alias);
            } else {
                mapValueAlias.put(A_value, null);
            }
            paramList.add(mapValueAlias);
        }
        String parameterXmlString = CtrlDesignUtil.toFilterSolutionXml(paramList);
        HashMap mapDesignParam = RunReportParam.setExecuteParam(allUnionParam, parameterXmlString);
        RunReportParam.putServerDefalutListParamsMap(ctx, mapDesignParam);
        return mapDesignParam;
    }

    public void execute3G(String xmlString) throws Exception {
        this.book = this.refreshBook();
        this.cacheDbSourceModel();
        HashMap mapDesignParam = RunReportParam.setExecuteParam(this.allUnionParam, xmlString);
        RunReportParam.putServerDefalutListParamsMap(this.ctx, mapDesignParam);
        this.runExt(mapDesignParam);
    }

    public void execute(Map map) throws Exception {
        this.book = this.refreshBook();
        this.cacheDbSourceModel();
        HashMap sysPs = new HashMap();
        RunReportParam.putServerDefalutListParamsMap(this.ctx, sysPs);
        for (String name : sysPs.keySet()) {
            DesignParameter dp = (DesignParameter)((Object)sysPs.get(name));
            String value = dp.getCurentValue();
            int dataType = dp.getDesignDataType().intValue();
            ParameterImpl p = new ParameterImpl();
            p.setName(name);
            p.setAlias(dp.getAlias());
            p.setValue(RunReportParam.getVariant(value, dataType));
            p.setDataType(dataType);
            map.put(name, p);
        }
        ExecutionContext extCtx = this.book.getDataSetManager().getExecutionContext();
        if (extCtx != null) {
            extCtx.setRptRuntimeCallback((IRptRuntimeCallback)new RptRuntimeCallbackImpl(this.ctx, this.reportID));
            extCtx.registerDataSetCacheObject((Object)BIContext, (Object)this.ctx);
            extCtx.registerDataSetCacheObject((Object)CurrentReportDBModel, (Object)this.reportDBModel);
            CacheObject co = new CacheObject();
            co.setSourceReportOrgID(this.sourceReportOrgID);
            extCtx.registerDataSetCacheObject((Object)CacheObject, (Object)CacheObject);
        }
        ExtURL.setConstructURL((IConstructURL)new ConstructURL(this.ctx));
        this.book.getDeps().setCalcDescription(this.ctx.getClientHostIP(), this.ctx.getUserName(), this.reportName);
        extCtx.attachDataSetParameters(ExtRptMacroExecuteFacade.fetchMacroParameters(this.ctx, this.book));
        boolean shouldUseDemoData = !this.isAuthorizedReport() && this.book.getCloudRptUuid() != null && this.book.getUserObject("CLOUD_REPORT_DEMO_BOOK_DATA") != null;
        extCtx.setUseDemoData(shouldUseDemoData);
        ExtExecutor.exec((Book)this.book, (Map)this.getDataSetFactories(), (Map)map, null);
        Sheet sheet = this.book.getActiveSheet();
        UserObject colTreePos = sheet.getUserObject("COLUMN_INLINED_TREE_POSITION");
        UserObject rowTreePos = sheet.getUserObject("ROW_INLINED_TREE_POSITION");
        if (!this._isTree) {
            this._isTree = colTreePos != null ^ rowTreePos != null;
        }
    }

    private boolean isAuthorizedReport() {
        if (this.info == null) {
            return false;
        }
        return PermissionBO.hasDataPermissionByReportId(this.ctx, ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString(), ContextUtil.getCurrentOrgUnit((Context)this.ctx).getId().toString(), this.info.getId().toString(), PermissionKind.VIEW);
    }

    public void executeSchedule(HashMap mapDesignParam) throws IOException, KDFException, KDFSAXException, Exception {
        this.book = this.refreshBook();
        this.cacheDbSourceModel();
        this.runExt(mapDesignParam);
    }

    public void executeCard(HashMap mapDesignParam) throws IOException, KDFException, KDFSAXException, Exception {
        this.book = this.beforeExecuteBook();
        this.cacheDbSourceModel();
        this.executeCard(this.book, mapDesignParam);
    }

    private void executeCard(Book book, HashMap mapDesignParam) throws SubReportException {
        ExecutionContext extCtx = book.getDataSetManager().getExecutionContext();
        extCtx.attachDataSetParameters(ExtRptMacroExecuteFacade.fetchMacroParameters(this.ctx, book, mapDesignParam));
        IExtRptMacroController controller = RunReportParam.getMacroControllerFacade(this.ctx);
        HashMap mapParameterImpl = new HashMap();
        for (String name : mapDesignParam.keySet()) {
            Variant var;
            String sv;
            Object ov;
            Object oParam = mapDesignParam.get(name);
            if (oParam instanceof ParameterImpl) {
                mapParameterImpl.put(name, oParam);
                continue;
            }
            DesignParameter dp = (DesignParameter)((Object)oParam);
            String value = dp.getCurentValue();
            String dataType = String.valueOf(dp.getDesignDataType().intValue());
            DesignDataType ddt = dp.getDesignDataType();
            if (DesignDataType.DATE.equals(ddt)) {
                value = RunReportParam.getDateValue(this.ctx, ddt, value);
            }
            if ((value = CtrlReportUtil.getObjectString(value)).startsWith("@ExtRpt")) {
                value = ((DesignParameter)((Object)mapDesignParam.get(value.substring(1)))).getCurentValue();
            }
            boolean hasMacro = false;
            ParameterImpl p = new ParameterImpl();
            if ("#@$firstData$@#".equals(value)) {
                Variant[] v = this.parseFirstDataValue(dp, value, dataType);
                p.setValue(v[0]);
                hasMacro = true;
                ov = v[0].getValue();
                sv = ov != null ? ov.toString() : null;
                dp.setCurentValue(sv);
                Object oParamText = mapDesignParam.get(name + "_text");
                if (oParamText != null && oParamText instanceof DesignParameter) {
                    ov = v[1].getValue();
                    sv = ov != null ? ov.toString() : null;
                    dp.setCurentValueAlias(sv);
                    ((DesignParameter)((Object)oParamText)).setCurentValue(sv);
                    ((DesignParameter)((Object)oParamText)).setCurentValueAlias(sv);
                }
            } else if ((value.startsWith(String.valueOf('$')) || value.indexOf("0xx1xx") > 0) && (var = this.parseMacro(controller, value, dataType)) != null) {
                hasMacro = true;
                p.setValue(var);
                if (var.isArray()) {
                    String curValue = "";
                    Variant[] arrV = (Variant[])var.getValue();
                    int len = arrV.length;
                    for (int i = 0; i < len; ++i) {
                        curValue = curValue + arrV[i].getValue() + "0xx1xx";
                    }
                    dp.setCurentValue(curValue);
                    dp.setCurentValueAlias(curValue);
                } else {
                    ov = var.getValue();
                    sv = ov != null ? ov.toString() : null;
                    dp.setCurentValue(sv);
                    dp.setCurentValueAlias(sv);
                }
            }
            if (!hasMacro) {
                p.setValue(RunReportParam.getVariant(value, Integer.parseInt(dataType)));
            }
            p.setName(name);
            p.setDataType(Integer.parseInt(dataType));
            p.setIgnoreNull(dp.isIgnoreNull());
            mapParameterImpl.put(name, p);
        }
        if (extCtx != null) {
            extCtx.setRptRuntimeCallback((IRptRuntimeCallback)new RptRuntimeCallbackImpl(this.ctx, this.reportID));
            extCtx.registerDataSetCacheObject((Object)BIContext, (Object)this.ctx);
            extCtx.registerDataSetCacheObject((Object)CurrentReportDBModel, (Object)this.reportDBModel);
            CacheObject co = new CacheObject();
            co.setSourceReportOrgID(this.sourceReportOrgID);
            extCtx.registerDataSetCacheObject((Object)CacheObject, (Object)co);
        }
        ExtURL.setConstructURL((IConstructURL)new ConstructURL(this.ctx));
        book.getDeps().setCalcDescription(this.ctx.getClientHostIP(), this.ctx.getUserName(), this.reportName);
        boolean shouldUseDemoData = !this.isAuthorizedReport() && book.getCloudRptUuid() != null && book.getUserObject("CLOUD_REPORT_DEMO_BOOK_DATA") != null;
        extCtx.setUseDemoData(shouldUseDemoData);
        ExtExecutor.execCard((Book)book, (Map)this.getDataSetFactories(), mapParameterImpl, null);
    }

    public void executeBook(HashMap mapDesignParam) throws IOException, KDFException, KDFSAXException, Exception {
        long runStart = System.currentTimeMillis();
        this.book = this.beforeExecuteBook();
        this.cacheDbSourceModel();
        this.runExt(mapDesignParam);
        long end = System.currentTimeMillis() - runStart;
        if (PublishType.isPublished(this.info)) {
            int pathType = (Integer)this.ctx.get((Object)"deployType", (Object)7);
            this.ctx.remove((Object)"deployType");
            ReportAuditUtil.updateAuditTable(this.ctx, this.info, end, pathType);
        }
    }

    private void runExt(HashMap mapDesignParam) throws Exception {
        this.execute(this.book, mapDesignParam);
        try {
            SubReportWebExecutor executor = new SubReportWebExecutor(this.book, this.ctx);
            executor.exec();
        }
        catch (Exception e) {
            logger.error((Object)"\u5b50\u62a5\u8868\u6267\u884c\u51fa\u9519\uff01", (Throwable)e);
            throw new SubReportException("\u5b50\u62a5\u8868\u6267\u884c\u51fa\u9519\uff01", e);
        }
    }

    public Map transParam(Book book, HashMap mapDesignParam) {
        ExecutionContext extCtx = book.getDataSetManager().getExecutionContext();
        extCtx.attachDataSetParameters(ExtRptMacroExecuteFacade.fetchMacroParameters(this.ctx, book, mapDesignParam));
        IExtRptMacroController controller = RunReportParam.getMacroControllerFacade(this.ctx);
        HashMap mapParameterImpl = new HashMap();
        for (String name : mapDesignParam.keySet()) {
            Variant var;
            String sv;
            Object ov;
            Object oParam = mapDesignParam.get(name);
            if (oParam instanceof ParameterImpl) {
                mapParameterImpl.put(name, oParam);
                continue;
            }
            DesignParameter dp = (DesignParameter)((Object)oParam);
            String value = dp.getCurentValue();
            String dataType = String.valueOf(dp.getDesignDataType().intValue());
            DesignDataType ddt = dp.getDesignDataType();
            if (DesignDataType.DATE.equals(ddt)) {
                value = RunReportParam.getDateValue(this.ctx, ddt, value);
            }
            if ((value = CtrlReportUtil.getObjectString(value)).startsWith("@ExtRpt")) {
                value = ((DesignParameter)((Object)mapDesignParam.get(value.substring(1)))).getCurentValue();
            }
            boolean hasMacro = false;
            ParameterImpl p = new ParameterImpl();
            if ("#@$firstData$@#".equals(value)) {
                Variant[] v = this.parseFirstDataValue(dp, value, dataType);
                p.setValue(v[0]);
                hasMacro = true;
                ov = v[0].getValue();
                sv = ov != null ? ov.toString() : null;
                dp.setCurentValue(sv);
                Object oParamText = mapDesignParam.get(name + "_text");
                if (oParamText != null && oParamText instanceof DesignParameter) {
                    ov = v[1].getValue();
                    sv = ov != null ? ov.toString() : null;
                    dp.setCurentValueAlias(sv);
                    ((DesignParameter)((Object)oParamText)).setCurentValue(sv);
                    ((DesignParameter)((Object)oParamText)).setCurentValueAlias(sv);
                }
            } else if ((value.startsWith(String.valueOf('$')) || value.indexOf("0xx1xx") > 0) && (var = this.parseMacro(controller, value, dataType)) != null) {
                hasMacro = true;
                p.setValue(var);
                if (var.isArray()) {
                    String curValue = "";
                    Variant[] arrV = (Variant[])var.getValue();
                    int len = arrV.length;
                    for (int i = 0; i < len; ++i) {
                        curValue = curValue + arrV[i].getValue() + "0xx1xx";
                    }
                    dp.setCurentValue(curValue);
                    dp.setCurentValueAlias(curValue);
                } else {
                    ov = var.getValue();
                    sv = ov != null ? ov.toString() : null;
                    dp.setCurentValue(sv);
                    dp.setCurentValueAlias(sv);
                }
            }
            if (!hasMacro) {
                p.setValue(RunReportParam.getVariant(value, Integer.parseInt(dataType)));
            }
            p.setName(name);
            p.setDataType(Integer.parseInt(dataType));
            p.setIgnoreNull(dp.isIgnoreNull());
            mapParameterImpl.put(name, p);
        }
        return mapParameterImpl;
    }

    private void execute(Book book, HashMap mapDesignParam) throws SubReportException {
        ExecutionContext extCtx = book.getDataSetManager().getExecutionContext();
        Map mapParameterImpl = this.transParam(book, mapDesignParam);
        if (extCtx != null) {
            extCtx.setRptRuntimeCallback((IRptRuntimeCallback)new RptRuntimeCallbackImpl(this.ctx, this.reportID));
            extCtx.registerDataSetCacheObject((Object)BIContext, (Object)this.ctx);
            extCtx.registerDataSetCacheObject((Object)CurrentReportDBModel, (Object)this.reportDBModel);
            CacheObject co = new CacheObject();
            co.setSourceReportOrgID(this.sourceReportOrgID);
            extCtx.registerDataSetCacheObject((Object)CacheObject, (Object)co);
        }
        ExtURL.setConstructURL((IConstructURL)new ConstructURL(this.ctx));
        book.getDeps().setCalcDescription(this.ctx.getClientHostIP(), this.ctx.getUserName(), this.reportName);
        boolean shouldUseDemoData = !this.isAuthorizedReport() && book.getCloudRptUuid() != null && book.getUserObject("CLOUD_REPORT_DEMO_BOOK_DATA") != null;
        extCtx.setUseDemoData(shouldUseDemoData);
        ExtExecutor.exec((Book)book, (Map)this.getDataSetFactories(), (Map)mapParameterImpl, null);
    }

    private Variant[] parseFirstDataValue(DesignParameter dp, String value, String dataType) {
        for (Object o : this.allUnionParam) {
            DesignParameter up = (DesignParameter)((Object)o);
            if (!up.getName().equalsIgnoreCase(dp.getName())) continue;
            dp.setInputCtrl(up.getInputCtrl());
            break;
        }
        String text = null;
        if (dp.getInputCtrl() != null) {
            Entry<?, ?> item = RunReportParam.parseFirstDataValue(this.ctx, dp, this);
            value = String.valueOf(item.getValue());
            text = String.valueOf(item.getText());
        }
        return new Variant[]{RunReportParam.getVariant(value, Integer.parseInt(dataType)), RunReportParam.getVariant(text, Integer.parseInt(dataType))};
    }

    private Variant parseMacro(IExtRptMacroController controller, String value, String dataType) {
        boolean hasMacro = false;
        ArrayList<Variant> arrVar = new ArrayList<Variant>();
        String[] arrValue = value.split("0xx1xx");
        for (int i = 0; i < arrValue.length; ++i) {
            if (arrValue[i].startsWith(String.valueOf('$'))) {
                hasMacro = true;
                boolean isMacro = false;
                try {
                    isMacro = controller != null && controller.e(arrValue[i].substring(1), null);
                }
                catch (MacroDesignException e) {
                    logger.error((Object)e);
                }
                if (!isMacro) {
                    arrVar.add(RunReportParam.getVariant(arrValue[i], Integer.parseInt(dataType)));
                    continue;
                }
                Variant vs = this.book.getNamedObject(arrValue[i]).getValue();
                if (!vs.isArray()) {
                    arrVar.add(vs);
                    continue;
                }
                Variant[] va = (Variant[])vs.getValue();
                for (int v = 0; v < va.length; ++v) {
                    arrVar.add(va[v]);
                }
                continue;
            }
            arrVar.add(RunReportParam.getVariant(arrValue[i], Integer.parseInt(dataType)));
        }
        if (hasMacro) {
            int size = arrVar.size();
            if (size == 1) {
                return (Variant)arrVar.get(0);
            }
            if (size > 1) {
                Variant[] vts = new Variant[size];
                for (int n = 0; n < size; ++n) {
                    vts[n] = (Variant)arrVar.get(n);
                }
                return new Variant((Object)vts, 512);
            }
        }
        return null;
    }

    private Book beforeExecuteBook() throws IOException, KDFException, KDFSAXException, Exception {
        this.info = this.systemID == null ? DefineReportBO.getReportInfo(this.ctx, this.reportID) : DefineReportBO.getReportInfo(this.ctx, this.systemID, this.reportName, this.orgID, this.reportID);
        if (null == this.info) {
            throw new Exception("\u62a5\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7ec4\u7ec7\u9694\u79bb\u6216\u8005\u5b50\u7cfb\u7edf\u8def\u5f84\u3001\u540d\u79f0\u662f\u5426\u6539\u53d8");
        }
        this.reportID = this.info.getId().toString();
        this.systemID = this.info.getSystemID();
        this.reportName = this.info.getName();
        this.orgID = this.info.getOrgID().toString();
        byte[] bContent = this.info.getContent();
        int stdProduct = this.info.getIsStdProduct();
        if (stdProduct == 1) {
            boolean isStdProduct = BookIOUtil.hasValidCoupon((byte[])bContent, (boolean)true);
            if (!isStdProduct) {
                throw new Exception("\u5f53\u524d\u6807\u8bc6\u4e3a\u6807\u51c6\u4ea7\u54c1\u7684\u62a5\u8868\uff0c\u52a0\u5bc6\u4fe1\u606f\u5df2\u7ecf\u7834\u574f,\u8bf7\u91cd\u65b0\u5bfc\u5165\u6807\u51c6\u62a5\u8868");
            }
            if (!this._isChecked) {
                String className = this.info.getMenuUi();
                if (!StringUtil.isEmptyString((String)className)) {
                    ReportCenterLicenseSrvChecker licenseChecker = new ReportCenterLicenseSrvChecker(className, this.ctx);
                    licenseChecker.checkLicense();
                }
                this._isChecked = true;
            }
        } else if (!this._isChecked) {
            ILicenseChecker licChecker = this.getLicenseChecker(this.info);
            if (licChecker instanceof ReportCenterLicenseSrvChecker) {
                EXTLicenseService licSrsv = new EXTLicenseService(this.ctx);
                try {
                    if ((licSrsv.sysLicenseModuleType() & 2) == 0) {
                        throw new Exception("\u6ca1\u6709EAS\u3010\u62a5\u8868\u8fd0\u884c\u5e73\u53f0\u3011\u6a21\u5757\u7684License;\u8bf7\u5148\u8d2d\u4e70\u3010\u62a5\u8868\u8fd0\u884c\u5e73\u53f0\u3011\u6a21\u5757\u3002");
                    }
                }
                catch (EXTLicenseException e) {
                    logger.info((Object)"\u62a5\u8868\u8fd0\u884c\u5e73\u53f0\u68c0\u67e5License\u5931\u8d25", (Throwable)e);
                    throw new Exception("\u68c0\u67e5License\u5931\u8d25");
                }
            }
            licChecker.checkLicense();
            this._isChecked = true;
        }
        this.sourceReportOrgID = this.info.getOrgID().toString();
        Book book = BookIOUtil.unpack((byte[])this.info.getContent());
        if (null == book) {
            throw new Exception("unpack\u6a21\u677f\u4e3a\u7a7a");
        }
        return book;
    }

    private Book refreshBook() throws Exception {
        return this.refreshBook(true);
    }

    public Book refreshBook(boolean checkRptPermission) throws Exception {
        String orgId;
        String userId;
        if (!StringUtil.isEmptyString((String)this.reportID)) {
            this.info = DefineReportBO.getReportInfo(this.ctx, this.reportID);
        }
        if (null == this.info && !StringUtil.isEmptyString((String)this.systemID)) {
            if (this.isDshExtReport && !StringUtil.isEmptyString((String)this.orgFullName)) {
                this.orgID = this.getOrgIdByFullName(this.orgFullName);
            }
            if (!StringUtil.isEmptyString((String)this.orgID)) {
                this.info = DefineReportBO.getReportInfo(this.ctx, this.systemID, this.reportName, this.orgID);
            }
        }
        if (this.isDshExtReport && null == this.info) {
            NonExistRptException e = new NonExistRptException("\u62a5\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            logger.error((Object)("systemID:" + this.systemID + "--orgFullName:" + this.orgFullName + "--reportName:" + this.reportName), (Throwable)((Object)e));
            throw e;
        }
        if (null == this.info) {
            NonExistRptException e = new NonExistRptException("\u62a5\u8868\u4e0d\u5b58\u5728:\r\n1. \u8bf7\u68c0\u67e5\u662f\u5426\u7ec4\u7ec7\u9694\u79bb;\r\n2. \u68c0\u67e5\u5b50\u7cfb\u7edf\u8def\u5f84\u3001\u540d\u79f0\u662f\u5426\u6539\u53d8;\r\n3. \u82e5\u662f\u8054\u67e5\u6267\u884c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u8054\u67e5.");
            logger.error((Object)("systemID:" + this.systemID + "--reportID:" + this.reportID + "--reportName:" + this.reportName), (Throwable)((Object)e));
            throw e;
        }
        ExtURL.setConstructURL((IConstructURL)new ConstructURL(this.ctx));
        Book book = BookIOUtil.unpack((byte[])this.info.getContent());
        this.reportID = this.info.getId().toString();
        this.systemID = this.info.getSystemID();
        this.reportName = this.info.getName();
        this.orgID = this.info.getOrgID().toString();
        if (this.ctx != null) {
            userId = this.ctx.getCaller().toString();
            orgId = ContextUtil.getCurrentOrgUnit((Context)this.ctx).getId().toString();
        } else {
            userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        }
        if (checkRptPermission) {
            boolean isRawCloudRpt;
            boolean hasDemoAuth = false;
            boolean isPermission = PermissionBO.hasDataPermissionByReportId(this.ctx, userId, orgId, this.reportID, PermissionKind.VIEW);
            boolean bl = isRawCloudRpt = book.getCloudRptUuid() != null && book.getUserObject("CLOUD_REPORT_DEMO_BOOK_DATA") != null;
            if (isRawCloudRpt) {
                ICloudRptCenterController controller = CloudRptCenterControllerFacade.getLocalInst(this.ctx);
                hasDemoAuth = controller.hasDemoAuth(userId, book.getCloudRptUuid());
            }
            if (!(hasDemoAuth || this.isHyperlink || isPermission)) {
                throw new RptPermissionDeniedException("\u6ca1\u6709\u67e5\u770b\u62a5\u8868\u7684\u6743\u9650");
            }
        }
        if (!this.isDshExtReport && !this.isHyperlink && checkRptPermission && !PublishType.isPublished(this.info)) {
            throw new UnDeployedRptVisitException("\u62a5\u8868\u5df2\u7ecf\u64a4\u9500\u53d1\u5e03");
        }
        byte[] bContent = this.info.getContent();
        int stdProduct = this.info.getIsStdProduct();
        if (stdProduct == 1) {
            boolean isStdProduct = BookIOUtil.hasValidCoupon((byte[])bContent, (boolean)true);
            if (!isStdProduct) {
                throw new InvalidCouponException("\u5f53\u524d\u6807\u8bc6\u4e3a\u6807\u51c6\u4ea7\u54c1\u7684\u62a5\u8868\uff0c\u52a0\u5bc6\u4fe1\u606f\u5df2\u7ecf\u7834\u574f,\u8bf7\u91cd\u65b0\u5bfc\u5165\u6807\u51c6\u62a5\u8868");
            }
            if (!this._isChecked) {
                String className = this.info.getMenuUi();
                if (!StringUtil.isEmptyString((String)className)) {
                    ReportCenterLicenseSrvChecker licenseChecker = new ReportCenterLicenseSrvChecker(className, this.ctx);
                    licenseChecker.checkLicense();
                }
                this._isChecked = true;
            }
        } else if (!this._isChecked) {
            ILicenseChecker licChecker = this.getLicenseChecker(this.info);
            if (licChecker instanceof ReportCenterLicenseSrvChecker) {
                EXTLicenseService licSrsv = new EXTLicenseService(this.ctx);
                try {
                    if ((licSrsv.sysLicenseModuleType() & 2) == 0) {
                        throw new NonModuleLisenceException("\u6ca1\u6709EAS\u3010\u62a5\u8868\u8fd0\u884c\u5e73\u53f0\u3011\u6a21\u5757\u7684License\uff1b\u8bf7\u5148\u8d2d\u4e70\n\u3010\u62a5\u8868\u8fd0\u884c\u5e73\u53f0\u3011\u6a21\u5757\u3002");
                    }
                }
                catch (EXTLicenseException e) {
                    logger.info((Object)"\u62a5\u8868\u8fd0\u884c\u5e73\u53f0\u68c0\u67e5License\u5931\u8d25", (Throwable)e);
                    throw new RptLisenceCheckException("\u68c0\u67e5License\u5931\u8d25");
                }
            }
            licChecker.checkLicense();
            this._isChecked = true;
        }
        this.sourceReportOrgID = this.info.getOrgID().toString();
        if (null == book) {
            throw new RptBinaryUnpackFailureException("unpack\u6a21\u677f\u4e3a\u7a7a");
        }
        return book;
    }

    public String getOrgIdByFullName(String orgFullName) {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String sql = "select fid from t_org_baseunit where fdisplayname_" + strLocal + "=?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(orgFullName);
        ArrayList resultList = null;
        String orgId = null;
        try {
            resultList = ExtDBUtil.getResultListBySql(this.ctx, sql, queryValue);
            if (resultList != null && resultList.size() > 0) {
                orgId = ((Map)resultList.get(0)).get("fid").toString();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u67e5\u8be2\u7ec4\u7ec7id\u5931\u8d25!", (Throwable)e);
        }
        return orgId;
    }

    private ILicenseChecker getLicenseChecker(DefineReportInfo entity) {
        if (this._licenseChecker == null) {
            this._licenseChecker = LicenseCheckerFactory.getLicenseChecker(entity, this.ctx);
        }
        return this._licenseChecker;
    }

    private Element makeFilterItem(DesignParameter p) throws CtrlReportException, Exception {
        String defaultAlias;
        String defaultValue;
        String defalutValue;
        InputType inputType = p.getInputType();
        if (inputType.equals(InputType.Separator) || inputType.equals(InputType.EMPTY)) {
            return null;
        }
        Element filterItemElement = new Element(T_FilterItem);
        IInputCtrl inputCtrl = p.getInputCtrl();
        filterItemElement.setAttribute(A_isReadOnly, Boolean.toString(p.getInputState() != InputState.READONLY));
        if (inputType.equals(InputType.INPUT) || inputType.equals(InputType.DATE) || inputType.equals(InputType.Spinner) || inputType.equals(InputType.LABEL)) {
            DesignDataType ddt = p.getDesignDataType();
            defalutValue = p.getCurentValue() != null ? p.getCurentValue() : p.getDefaultValue();
            String msg = "";
            filterItemElement.setAttribute(A_type, "input");
            if (inputType.equals(InputType.DATE)) {
                filterItemElement.setAttribute(A_dataType, "date");
                if (ddt.equals(DesignDataType.DATE)) {
                    defalutValue = RunReportParam.getDateValue(this.ctx, ddt, defalutValue);
                } else if (ddt.equals(DesignDataType.DATETIME)) {
                    msg = "\u4e0d\u652f\u6301\u65e5\u671f\u65f6\u95f4\u7c7b\u578b)";
                    defalutValue = "";
                } else if (ddt.equals(DesignDataType.TIME)) {
                    msg = "\u4e0d\u652f\u6301\u65f6\u95f4\u7c7b\u578b)";
                    defalutValue = "";
                }
            } else {
                filterItemElement.setAttribute(A_dataType, "string");
            }
            if (!msg.equals("")) {
                msg = "(" + msg;
            }
            filterItemElement.setAttribute(A_name, p.getName());
            filterItemElement.setAttribute(A_caption, CtrlReportUtil.getObjectString(p.getAlias(Locale.CHINA)) + msg);
            filterItemElement.setAttribute(A_required, Boolean.toString(!p.isAllowNull()));
            filterItemElement.setAttribute(A_defaultValue, defalutValue == null ? "" : defalutValue);
            filterItemElement.setAttribute(A_defalutAlias, defalutValue == null ? "" : defalutValue);
        }
        if (inputType.equals(InputType.ALONE_CHECKBOX)) {
            filterItemElement.setAttribute(A_type, "list");
            filterItemElement.setAttribute(A_name, p.getName());
            filterItemElement.setAttribute(A_caption, CtrlReportUtil.getObjectString(p.getAlias(Locale.CHINA)));
            filterItemElement.setAttribute(A_required, Boolean.toString(!p.isAllowNull()));
            defaultValue = CtrlReportUtil.getObjectString(p.getDefaultValue());
            defaultAlias = CtrlReportUtil.getObjectString(p.getDefaultAlias());
            filterItemElement.setAttribute(A_defaultValue, defaultValue);
            filterItemElement.setAttribute(A_defalutAlias, defaultAlias);
            inputCtrl = p.getInputCtrl();
            if (null != inputCtrl) {
                filterItemElement.setAttribute(A_isAllowMultipleSelected, "false");
                DefObj defSelected = inputCtrl.getDefValue();
                WebParamAdapter.makeParameterListItem(filterItemElement, defSelected);
                if (defaultValue.equals(String.valueOf(1))) {
                    filterItemElement.setAttribute(A_defaultValue, defSelected.getName());
                    filterItemElement.setAttribute(A_defalutAlias, defSelected.getAlias());
                }
                DefObj defNoSelected = inputCtrl.getDefDisplay();
                WebParamAdapter.makeParameterListItem(filterItemElement, defNoSelected);
                if (defaultValue.equals(String.valueOf(2))) {
                    filterItemElement.setAttribute(A_defaultValue, defNoSelected.getName());
                    filterItemElement.setAttribute(A_defalutAlias, defNoSelected.getAlias());
                }
            }
        }
        if (inputType.equals(InputType.LIST) || inputType.equals(InputType.CHECKBOX)) {
            filterItemElement.setAttribute(A_type, "list");
            filterItemElement.setAttribute(A_name, p.getName());
            filterItemElement.setAttribute(A_caption, CtrlReportUtil.getObjectString(p.getAlias(Locale.CHINA)));
            filterItemElement.setAttribute(A_required, Boolean.toString(!p.isAllowNull()));
            if (p.getCurentValue() != null) {
                defaultValue = p.getCurentValue();
                defaultAlias = p.getCurentValueAlias() != null ? p.getCurentValueAlias() : defaultValue;
            } else {
                defaultValue = p.getDefaultValue();
                defaultAlias = p.getDefaultAlias();
            }
            defaultValue = CtrlReportUtil.getObjectString(defaultValue);
            String[] defaultValues = defaultValue.split("0xx1xx");
            StringBuffer defaultValueBuf = new StringBuffer();
            StringBuffer defaultAliasBuf = new StringBuffer();
            inputCtrl = p.getInputCtrl();
            if (null != inputCtrl) {
                if (inputType.equals(InputType.LIST)) {
                    filterItemElement.setAttribute(A_isAllowMultipleSelected, "false");
                } else {
                    filterItemElement.setAttribute(A_isAllowMultipleSelected, "true");
                }
                int bind = inputCtrl.getDataBind();
                if (bind == 0) {
                    boolean isKSQL;
                    String displayKey = "alias";
                    String valueKey = A_value;
                    String tableFlag = inputCtrl.getDataSetType();
                    boolean bl = isKSQL = !tableFlag.equals("6");
                    if (isKSQL) {
                        displayKey = inputCtrl.getDefDisplay().getName();
                        valueKey = inputCtrl.getDefValue().getName();
                    }
                    DefObj def = inputCtrl.getDefDbsource();
                    String fid = def.getName();
                    if (isKSQL) {
                        String dbsourcename = def.getAlias();
                        String systemid = CtrlReportUtil.getObjectString(def.getProperty("systemID"));
                        if (!systemid.equals("")) {
                            fid = fid + "\\" + systemid + "\\" + dbsourcename;
                        }
                    }
                    ArrayList lst = this.getBizDataList(isKSQL, fid);
                    for (HashMap mapitem : lst) {
                        DefObj defItem = new DefObj();
                        defItem.setName(CtrlReportUtil.getObjectString(mapitem.get(valueKey.toLowerCase())));
                        defItem.setAlias(CtrlReportUtil.getObjectString(mapitem.get(displayKey.toLowerCase())));
                        WebParamAdapter.makeParameterListItem(filterItemElement, defItem);
                        this.getDefaultValue(defaultValues, defItem, defaultValueBuf, defaultAliasBuf);
                    }
                } else if (bind == 1) {
                    ArrayList selfList = inputCtrl.getSelfList();
                    for (DefObj defItem : selfList) {
                        WebParamAdapter.makeParameterListItem(filterItemElement, defItem);
                    }
                    defaultValueBuf.append(defaultValue);
                    defaultAliasBuf.append(defaultAlias);
                } else if (bind == 6) {
                    String systemVarType = inputCtrl.getDefDbsource().getName();
                    String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
                    ArrayList<HashMap<String, String>> lst = OrgRangeManage.getOrgRangeList(this.ctx, userId, Integer.valueOf(systemVarType), this.reportID);
                    String displayKey = inputCtrl.getDefDisplay().getName();
                    String valueKey = inputCtrl.getDefValue().getName();
                    for (int i = 0; i < lst.size(); ++i) {
                        HashMap<String, String> map = lst.get(i);
                        DefObj defItem = new DefObj();
                        defItem.setName(map.get(valueKey).toString());
                        defItem.setAlias(map.get(displayKey).toString());
                        WebParamAdapter.makeParameterListItem(filterItemElement, defItem);
                        this.getDefaultValue(defaultValues, defItem, defaultValueBuf, defaultAliasBuf);
                    }
                } else if (bind == 3) {
                    DefObj def = inputCtrl.getDefDbsource();
                    String fullName = def.getName();
                    IRowSet rs = null;
                    MetaDataPK queryPK = new MetaDataPK(fullName);
                    IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)queryPK);
                    rs = queryExecutor.executeQuery(0, Integer.MAX_VALUE);
                    ArrayList lst = ExtDBUtil.setDataToList((ResultSet)rs);
                    String displayKey = inputCtrl.getDefDisplay().getName();
                    String valueKey = inputCtrl.getDefValue().getName();
                    for (HashMap mapitem : lst) {
                        DefObj defItem = new DefObj();
                        defItem.setName(CtrlReportUtil.getObjectString(mapitem.get(valueKey)));
                        defItem.setAlias(CtrlReportUtil.getObjectString(mapitem.get(displayKey)));
                        WebParamAdapter.makeParameterListItem(filterItemElement, defItem);
                        this.getDefaultValue(defaultValues, defItem, defaultValueBuf, defaultAliasBuf);
                        System.out.println(">>>>>>\u4ee3\u7801\u8f93\u51fa\u6ca1\u8d70jar\u5305<<<<<<<");
                    }
                }
                this.setDefaultValue(bind, filterItemElement, defaultValueBuf.toString(), defaultAliasBuf.toString());
            }
        }
        if (inputType.equals(InputType.F7LIST)) {
            int bind = 0;
            inputCtrl = p.getInputCtrl();
            if (inputCtrl == null) {
                filterItemElement.setAttribute(A_errMsg, p.getAlias(Locale.CHINA) + " \u8bf7\u8bbe\u7f6e\u6570\u636e\u6765\u6e90\uff01");
            } else {
                bind = inputCtrl.getDataBind();
                if (bind == 5) {
                    filterItemElement.setAttribute(A_errMsg, p.getAlias(Locale.CHINA) + " \u662f\u4ee3\u7801\u5b9a\u5236\u7684F7\u63a7\u4ef6\uff0c\u4e0d\u80fd\u8f6c\u6362\uff01");
                }
            }
            defalutValue = p.getCurentValue() != null ? p.getCurentValue() : p.getDefaultValue();
            String defaultAlias2 = p.getCurentValueAlias() != null ? p.getCurentValueAlias() : p.getDefaultAlias();
            filterItemElement.setAttribute(A_type, "sql");
            filterItemElement.setAttribute(A_name, p.getName());
            filterItemElement.setAttribute(A_caption, CtrlReportUtil.getObjectString(p.getAlias(Locale.CHINA)));
            filterItemElement.setAttribute(A_required, Boolean.toString(!p.isAllowNull()));
            filterItemElement.setAttribute(A_defaultValue, CtrlReportUtil.getObjectString(defalutValue));
            filterItemElement.setAttribute(A_defalutAlias, CtrlReportUtil.getObjectString(defaultAlias2));
            if (null != inputCtrl) {
                filterItemElement.setAttribute(A_isAllowMultipleSelected, Boolean.toString(inputCtrl.isAllowMultipleSelected()));
                filterItemElement.setAttribute(A_valueColumn, RunReportParam.getRealFieldName(inputCtrl.getDefValue()));
                filterItemElement.setAttribute(A_displayColumn, RunReportParam.getRealFieldName(inputCtrl.getDefDisplay()));
                if (inputCtrl.isAllowMultipleSelected()) {
                    filterItemElement.setAttribute("rowLimit", inputCtrl.getRowLimit());
                }
                DefObj def = inputCtrl.getDefDbsource();
                String fid = def.getName();
                if (bind == 4) {
                    String dbsourcename = def.getAlias();
                    String systemid = CtrlReportUtil.getObjectString(def.getProperty("systemID"));
                    if (!systemid.equals("")) {
                        fid = fid + "\\" + systemid + "\\" + dbsourcename;
                    }
                }
                filterItemElement.setAttribute(A_fullname, fid);
            }
        }
        return filterItemElement;
    }

    private void getDefaultValue(String[] defaultValues, DefObj defItem, StringBuffer defaultValueBuf, StringBuffer defaultAliasBuf) {
        int length = defaultValues.length;
        for (int i = 0; i < length; ++i) {
            if (!defItem.getName().equals(defaultValues[i])) continue;
            defaultValueBuf.append(defItem.getName()).append("0xx1xx");
            defaultAliasBuf.append(defItem.getAlias()).append("0xx1xx");
            return;
        }
    }

    private void setDefaultValue(int bind, Element filterItemElement, String defaultValue, String defaultAlias) {
        if (bind != 1) {
            int index = defaultValue.lastIndexOf("0xx1xx");
            defaultValue = defaultValue.substring(0, index < 0 ? 0 : index);
            index = defaultAlias.lastIndexOf("0xx1xx");
            defaultAlias = defaultAlias.substring(0, index < 0 ? 0 : index);
        }
        filterItemElement.setAttribute(A_defaultValue, defaultValue);
        filterItemElement.setAttribute(A_defalutAlias, defaultAlias);
    }

    private static final void makeParameterListItem(Element fatherEle, DefObj def) {
        Element element = new Element(T_ListItem);
        element.setAttribute(A_caption, CtrlReportUtil.getObjectString(def.getAlias()));
        element.setAttribute(A_value, def.getName());
        fatherEle.addContent((Content)element);
    }

    public String getF7Data(String fullName, String displayColumn, String valueColumn) throws Exception {
        Element listItemElement = new Element(T_ListItem);
        String value = valueColumn;
        String display = displayColumn;
        ArrayList lst = null;
        if (SystemVarType.isSystemVarType(fullName)) {
            lst = OrgRangeManage.getOrgRangeList(this.ctx, this.ctx.getCaller().toString(), Integer.valueOf(fullName), this.reportID);
        } else if (fullName.indexOf(".") == -1 || fullName.indexOf("\\") > -1) {
            lst = this.getBizDataList(true, fullName);
        } else if (!CtrlReportUtil.getObjectString(valueColumn).equals("")) {
            IRowSet rs = null;
            MetaDataPK queryPK = new MetaDataPK(fullName);
            IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)queryPK);
            rs = queryExecutor.executeQuery(0, Integer.MAX_VALUE);
            lst = ExtDBUtil.setDataToList((ResultSet)rs);
        } else {
            lst = this.getBizDataList(false, fullName);
            value = A_value;
            display = "alias";
        }
        value = value.toLowerCase();
        display = display.toLowerCase();
        for (HashMap<String, String> mapitem : lst) {
            DefObj defItem = new DefObj();
            defItem.setName(CtrlReportUtil.getObjectString(mapitem.get(value)));
            defItem.setAlias(CtrlReportUtil.getObjectString(mapitem.get(display)));
            WebParamAdapter.makeParameterListItem(listItemElement, defItem);
        }
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        format.setEncoding("UTF-8");
        XMLOutputter outter = new XMLOutputter(format);
        String xmlstr = outter.outputString(listItemElement);
        return xmlstr;
    }

    private ArrayList getBizDataList(boolean isKSQL, String dbsourceid) throws Exception {
        String orgID = this.orgID;
        if (StringUtil.isEmptyString((String)orgID)) {
            DefineReportInfo info = null;
            info = this.systemID == null ? DefineReportBO.getReportInfo(this.ctx, this.reportID) : DefineReportBO.getReportInfo(this.ctx, this.systemID, this.reportName, orgID);
            if (null == info) {
                throw new Exception("\u62a5\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7ec4\u7ec7\u9694\u79bb\u6216\u8005\u5b50\u7cfb\u7edf\u8def\u5f84\u3001\u540d\u79f0\u662f\u5426\u6539\u53d8");
            }
            orgID = info.getOrgID().toString();
        }
        String orgName = ContextUtil.getCurrentOrgUnit((Context)this.ctx).getName();
        return RunReportParam.getBizDataList(this.ctx, isKSQL, dbsourceid, orgID, orgName, this._sqlDbMap, null);
    }

    private boolean cacheDbSourceModel() throws Exception {
        ExtDataSetManager dm = this.book.getDataSetManager();
        int dsSize = dm.size();
        ExtDataSet[] datasets = new ExtDataSet[dsSize];
        if (!this._initSqlDbMap) {
            this._sqlDbMap = new HashMap(10);
        }
        for (int i = 0; i < dsSize; ++i) {
            Map map;
            datasets[i] = dm.getAt(i);
            if (this._initSqlDbMap || StringUtil.isEmptyString((String)datasets[i].getMeta()) || (map = (Map)SqlDSModelDrill.split(datasets[i].getMeta())[1]) == null || map.isEmpty()) continue;
            this._sqlDbMap.putAll(map);
        }
        this._initSqlDbMap = true;
        local.set(this);
        String orgId = this.ctx != null ? ContextUtil.getCurrentOrgUnit((Context)this.ctx).getId().toString() : SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        return RunReportParam.cacheDbSourceModel(this.ctx, datasets, this.reportDBModel, this.allUnionParam, null, this.sourceReportOrgID, orgId);
    }

    public Book getBook() {
        return this.book;
    }

    public HashMap getSqlDbMap() {
        return (HashMap)this._sqlDbMap;
    }

    public Sheet getPartSheet(int row1, int row2) {
        Sheet sheet = this.book.getActiveSheet();
        if (this._isTree) {
            return sheet;
        }
        Sheet.ICellsIterator itor = sheet.getCellsIterator(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), false, false);
        while (itor.hasNext()) {
            Cell cll = itor.next();
            cll.getText();
        }
        boolean isSecurity = SheetBaseMath.isSecuritySheet((Sheet)sheet);
        if (isSecurity) {
            AlgorithmUtil.delHideRowsAndCols((int[])sheet.getSecHidedRows(), (int[])sheet.getSecHidedCols(), (Sheet)sheet);
            sheet.clearHiddenRowsNCols();
        }
        return sheet;
    }

    public String getReportID() {
        return this.reportID;
    }

    public boolean isTree() {
        return this._isTree;
    }

    public void setTree(boolean istree) {
        this._isTree = istree;
    }

    public ArrayList getAllUnionParam() {
        return this.allUnionParam;
    }

    public void setAllUnionParam(ArrayList allUnionParam) {
        this.allUnionParam = allUnionParam;
    }

    public void setHyperlink(boolean isHyperlink) {
        this.isHyperlink = isHyperlink;
    }

    public boolean isHyperlink() {
        return this.isHyperlink;
    }

    public boolean isDshExtReport() {
        return this.isDshExtReport;
    }

    public void setDshExtReport(boolean isDshExtReport) {
        this.isDshExtReport = isDshExtReport;
    }

    public String getOrgFullName() {
        return this.orgFullName;
    }

    public void setOrgFullName(String orgFullName) {
        this.orgFullName = orgFullName;
    }

    public String getDshExtReportSelectType() {
        return this.dshExtReportSelectType;
    }

    public void setDshExtReportSelectType(String dshExtReportSelectType) {
        this.dshExtReportSelectType = dshExtReportSelectType;
    }

    public void mobileExecute(HashMap mapDesignParam) throws Exception {
        long runStart = System.currentTimeMillis();
        if (this.book == null) {
            this.book = this.beforeExecuteBook();
        }
        this.runExt(mapDesignParam);
        long end = System.currentTimeMillis() - runStart;
        if (PublishType.isPublished(this.info)) {
            int pathType = (Integer)this.ctx.get((Object)"deployType", (Object)9);
            this.ctx.remove((Object)"deployType");
            ReportAuditUtil.updateAuditTable(this.ctx, this.info, end, pathType);
        }
    }

    public ArrayList mobileFetchParams() throws Exception {
        if (this.allUnionParam.isEmpty()) {
            if (this.book == null) {
                this.book = this.beforeExecuteBook();
            }
            if (this.ctx == null) {
                this.cacheUnionParam(this.book, this.ctx);
            } else {
                this.cacheDbSourceModel();
            }
        }
        this.handleOutParam(this.mapOutParam);
        return this.getAllUnionParam();
    }

    public boolean isUseLastSaveParam() {
        String isLastSaveParam = this.book.getUserObjectValue("mobileparam_isLastSaveParam") == null ? "1" : this.book.getUserObjectValue("mobileparam_isLastSaveParam").toString();
        return Integer.parseInt(isLastSaveParam) == 1;
    }

    public ArrayList mobileFetchSortedParams() throws Exception {
        if (this.allUnionParam.isEmpty()) {
            if (this.book == null) {
                this.book = this.beforeExecuteBook();
            }
            if (this.ctx == null) {
                this.cacheUnionParam(this.book, this.ctx);
            } else {
                this.cacheDbSourceModel();
            }
        }
        String allParamLayoutInfo = (String)this.book.getUserObjectValue("mobileparam_allparams_layoutinfo");
        HashMap<String, Integer> allParamLayout = LayoutParameterUtil.allParamFromXml(allParamLayoutInfo);
        LayoutParameterUtil.sortAllParams(this.allUnionParam, allParamLayout);
        return this.allUnionParam;
    }

    public boolean isAllCommonParam(ArrayList commonParams) throws Exception {
        ArrayList allParams = this.mobileFetchSortedParams();
        if (allParams == null) {
            return true;
        }
        if (commonParams == null) {
            return false;
        }
        return allParams.size() == commonParams.size();
    }

    public Double getFirstPlaceHolder() {
        String commonParamLayoutInfo = (String)this.book.getUserObjectValue("mobileparam_commonparam_layoutinfo");
        HashMap<String, Double> commonParamLayout = LayoutParameterUtil.commonParamFromXml(commonParamLayoutInfo);
        return commonParamLayout == null || !commonParamLayout.containsKey("first_place_holder") ? Double.valueOf(0.0) : commonParamLayout.get("first_place_holder");
    }

    public Double getLastPlaceHolder() {
        String commonParamLayoutInfo = (String)this.book.getUserObjectValue("mobileparam_commonparam_layoutinfo");
        HashMap<String, Double> commonParamLayout = LayoutParameterUtil.commonParamFromXml(commonParamLayoutInfo);
        return commonParamLayout == null || !commonParamLayout.containsKey("end_place_holder") ? Double.valueOf(0.0) : commonParamLayout.get("end_place_holder");
    }

    public ArrayList mobileCommParams(Context easCtx, WebParamAdapter paramAdapter, String reportId) throws Exception {
        CommonParams commParam;
        int index;
        String commonParamLayoutInfo = (String)this.book.getUserObjectValue("mobileparam_commonparam_layoutinfo");
        HashMap<String, Double> commonParamLayout = LayoutParameterUtil.commonParamFromXml(commonParamLayoutInfo);
        if (commonParamLayout == null) {
            return null;
        }
        ArrayList allParams = this.mobileFetchSortedParams();
        if (allParams == null) {
            return null;
        }
        ArrayList<Object> commonParams = new ArrayList<Object>();
        for (int i = 0; i < allParams.size(); ++i) {
            Object parameter = (DesignParameter)((Object)allParams.get(i));
            if (commonParamLayout.get(parameter.getName()) == null) continue;
            commonParams.add(parameter);
        }
        new WebReportDomain();
        List<ReportParamDescription> translateParams = WebReportDomain.translateParams(easCtx, commonParams, paramAdapter, reportId);
        commonParams.clear();
        for (ReportParamDescription rpDesc : translateParams) {
            CommonParams commParam2 = new CommonParams(rpDesc, commonParamLayout.get(rpDesc.getName()));
            commonParams.add(commParam2);
        }
        double percentage = 0.0;
        percentage += this.getFirstPlaceHolder().doubleValue();
        for (index = 0; index < commonParams.size(); ++index) {
            commParam = (CommonParams)commonParams.get(index);
            if (commParam.getPercentage() < 0.1) {
                commParam.setPercentage(0.1);
            }
            percentage += commParam.getPercentage().doubleValue();
        }
        if ((percentage += this.getLastPlaceHolder().doubleValue()) > 1.0) {
            for (index = commonParams.size() - 1; index >= 0; --index) {
                commParam = (CommonParams)commonParams.get(index);
                double p = commParam.getPercentage();
                if (!(p > 0.1)) continue;
                if (p - 0.1 >= percentage - 1.0) {
                    p = p - percentage + 1.0;
                    percentage = 1.0;
                    commParam.setPercentage(p);
                    break;
                }
                percentage -= p - 0.1;
                p = 0.1;
                commParam.setPercentage(p);
            }
        }
        return commonParams;
    }

    public boolean mobileEmptyFilter() throws Exception {
        this.mobileFetchParams();
        boolean isAllHide = true;
        for (Object obj : this.allUnionParam) {
            DesignParameter dp = (DesignParameter)((Object)obj);
            if (dp.getInputState().intValue() == 2) continue;
            isAllHide = false;
            break;
        }
        return isAllHide;
    }

    public String getSourceRptId() {
        return this.sourceReportOrgID;
    }

    public String getReportName() {
        return this.reportName;
    }

    private Map getDataSetFactories() {
        HashMap<ExtDataSetType, DataSetBaseFactory> mapFactories = new HashMap<ExtDataSetType, DataSetBaseFactory>();
        mapFactories.put(ExtDataSetType.TXT, new ExtDataSetTextFactory());
        mapFactories.put(ExtDataSetType.SQL_KSQL, ExtDataSetKSQLFactory.getInstance());
        mapFactories.put(ExtDataSetType.SQL_ENUM, ExtDataSetEnumFactory.getInstance());
        return mapFactories;
    }

    public void setLicenseChecked(boolean isChecked) {
        this._isChecked = isChecked;
    }

    public byte[] executeSubReport(HashMap mapDesignParam) throws Exception {
        if (this.book == null) {
            try {
                this.book = this.beforeExecuteBook();
            }
            catch (Exception e) {
                logger.error((Object)"\u5b50\u62a5\u8868\u6267\u884c\u51fa\u9519\uff01", (Throwable)e);
                return null;
            }
        }
        this.execute(this.book, mapDesignParam);
        return this.info.getContent();
    }

    public Book executeSubReport(HashMap mapDesignParam, byte[] bookData) throws Exception {
        Book subBook;
        block3: {
            subBook = null;
            try {
                subBook = MiscUtil.unpack((byte[])bookData);
            }
            catch (Exception e) {
                MiscUtil.handleFileCheckingException((Exception)e, null);
                if (!MiscUtil.shouldLog()) break block3;
                MiscUtil.log((Throwable)e);
            }
        }
        if (subBook == null) {
            return null;
        }
        this.sourceReportOrgID = this.orgID;
        this.execute(subBook, mapDesignParam);
        return subBook;
    }

    public boolean isHideMenubarInReport() throws Exception {
        UserObject hideMenubar;
        if (this.book == null) {
            this.book = this.refreshBook();
        }
        if ((hideMenubar = this.book.getUserObject("PortalIsHideMenubarInReport")) == null) {
            return false;
        }
        return "true".equalsIgnoreCase(hideMenubar.getValue().toString());
    }

    public boolean isFullScreen() throws Exception {
        UserObject fullScreen;
        if (this.book == null) {
            this.book = this.refreshBook();
        }
        if ((fullScreen = this.book.getUserObject("PortalFullScreen")) == null) {
            return false;
        }
        return "true".equals(fullScreen.getValue().toString());
    }

    public boolean isPopFilter() throws Exception {
        UserObject popFilter;
        if (this.book == null) {
            this.book = this.refreshBook();
        }
        if ((popFilter = this.book.getUserObject("PortalPopFilter")) == null) {
            return true;
        }
        return "true".equals(popFilter.getValue().toString());
    }

    class CommonParams {
        Object param;
        Double percentage;

        public CommonParams() {
        }

        public CommonParams(Object param, Double percentage) {
            this.param = param;
            this.percentage = percentage;
        }

        public Object getParam() {
            return this.param;
        }

        public void setParam(Object param) {
            this.param = param;
        }

        public Double getPercentage() {
            return this.percentage;
        }

        public void setPercentage(Double percentage) {
            this.percentage = percentage;
        }
    }
}

