/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.param;

import com.kingdee.bos.ctrl.common.util.NumberUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.data.AloneBoxData;
import com.kingdee.eas.rpts.ctrlsqldesign.param.DefaultArgInput;
import com.kingdee.eas.rpts.ctrlsqldesign.param.IParamRelation;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SpinnerNumberModel;

public abstract class AbstractParamRelation
implements IParamRelation {
    private static final String ValueF7Field = "valueF7Field";
    private static final String AliasF7Field = "aliasF7Field";
    protected HashMap objectComponents;
    protected HashMap stopParamMap;
    protected HashMap valueNameF7Map;
    ArrayList layObjList = new ArrayList();
    DefaultArgInput filterUI = null;

    public AbstractParamRelation() {
        this.objectComponents = new HashMap();
        this.stopParamMap = new HashMap();
        this.valueNameF7Map = new HashMap();
    }

    @Override
    public void initComponent(String paramName, Object components, String valueF7Field, String aliasF7Field) {
        this.objectComponents.put(paramName, components);
        if (valueF7Field != null && aliasF7Field != null) {
            HashMap<String, String> fieldF7map = new HashMap<String, String>();
            fieldF7map.put(ValueF7Field, valueF7Field);
            fieldF7map.put(AliasF7Field, aliasF7Field);
            this.valueNameF7Map.put(paramName, fieldF7map);
        }
    }

    @Override
    public void stopListener(String paramName) {
        this.stopParamMap.put(paramName, null);
    }

    @Override
    public Map getStopListener() {
        return this.stopParamMap;
    }

    @Override
    public void setLayObjList(ArrayList layObjList) {
        this.layObjList = layObjList;
    }

    @Override
    public void setFilterUI(DefaultArgInput filter) {
        this.filterUI = filter;
    }

    @Override
    public void dataChange(String paramName) throws Exception {
    }

    @Override
    public void willShow(SelectorEvent e, String paramName) throws Exception {
    }

    @Override
    public boolean confirmFilterBefore() throws Exception {
        return true;
    }

    @Override
    public void loadSolutionAfter() throws Exception {
    }

    public String[] getComponentValue(String paramName, String valueField) {
        Iterator it = this.objectComponents.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (!key.equals(paramName)) continue;
            Object currentObj = this.objectComponents.get(key);
            if (currentObj instanceof KDTextField) {
                KDTextField textField = (KDTextField)currentObj;
                String valueString = textField.getText().trim();
                String[] returnValues = new String[]{valueString};
                return returnValues;
            }
            if (currentObj instanceof KDSpinner) {
                KDSpinner kDSpinner = (KDSpinner)currentObj;
                String valueString = CtrlReportUtil.getObjectString(kDSpinner.getDoubleVlaue());
                if (!valueString.equals("")) {
                    valueString = NumberUtil.cutZero((String)valueString);
                }
                String[] returnValues = new String[]{valueString};
                return returnValues;
            }
            if (currentObj instanceof KDDatePicker) {
                KDDatePicker datePicker = (KDDatePicker)currentObj;
                String valueString = datePicker.getText();
                String[] returnValues = new String[]{valueString};
                return returnValues;
            }
            if (currentObj instanceof KDTimePicker) {
                KDTimePicker datePicker = (KDTimePicker)currentObj;
                String valueString = datePicker.getText();
                String[] returnValues = new String[]{valueString};
                return returnValues;
            }
            if (currentObj instanceof KDComboBox) {
                KDComboBox obj = (KDComboBox)currentObj;
                Object valueObj = obj.getSelectedItem();
                String valueString = null;
                if (valueObj instanceof DefObj) {
                    DefObj def = (DefObj)obj.getSelectedItem();
                    if (null != def) {
                        valueString = def.getName();
                    }
                } else if (valueObj instanceof String) {
                    valueString = (String)valueObj;
                }
                String[] returnValues = new String[]{valueString};
                return returnValues;
            }
            if (currentObj instanceof KDCheckBox) {
                KDCheckBox cb = (KDCheckBox)currentObj;
                AloneBoxData abd = (AloneBoxData)cb.getUserObject();
                String valueString = "";
                valueString = cb.isSelected() ? abd.getSelectedValue() : abd.getNoSelectedValue();
                String[] returnValues = new String[]{valueString};
                return returnValues;
            }
            if (currentObj instanceof KDCheckBox[]) {
                KDCheckBox[] cbs = (KDCheckBox[])currentObj;
                ArrayList<String> returnList = new ArrayList<String>();
                for (KDCheckBox cb : cbs) {
                    if (!cb.isSelected()) continue;
                    DefObj def = (DefObj)cb.getUserObject();
                    returnList.add(def.getName());
                }
                returnList.trimToSize();
                String[] returnValues = new String[returnList.size()];
                returnList.toArray(returnValues);
                return returnValues;
            }
            if (!(currentObj instanceof KDBizPromptBox)) continue;
            KDBizPromptBox obj = (KDBizPromptBox)currentObj;
            Object f7Data = obj.getData();
            if (null == f7Data) {
                return null;
            }
            boolean isNullValueField = false;
            if (null == valueField) {
                valueField = this.getF7ValueAliasField(paramName, "value").toLowerCase();
                isNullValueField = true;
            }
            if (f7Data instanceof Object[]) {
                Object[] arrData = (Object[])f7Data;
                int size = arrData.length;
                String[] returnValues = new String[size];
                for (int i = 0; i < size; ++i) {
                    String valueString;
                    Object everyF7Object = arrData[i];
                    if (everyF7Object instanceof IObjectValue) {
                        returnValues[i] = valueString = CtrlReportUtil.getObjectString(((IObjectValue)everyF7Object).get(valueField));
                        continue;
                    }
                    if (everyF7Object instanceof DefObj) {
                        valueString = CtrlReportUtil.getObjectString(((DefObj)everyF7Object).getProperty(valueField.toLowerCase()));
                        if (isNullValueField) {
                            valueString = CtrlReportUtil.getObjectString(((DefObj)everyF7Object).getName());
                        }
                        returnValues[i] = valueString;
                        continue;
                    }
                    returnValues[i] = everyF7Object instanceof String ? CtrlReportUtil.getObjectString(everyF7Object) : (everyF7Object == null ? null : CtrlReportUtil.getObjectString(everyF7Object.toString()));
                }
                return returnValues;
            }
            if (f7Data instanceof IObjectValue) {
                String valueString = CtrlReportUtil.getObjectString(((IObjectValue)f7Data).get(valueField));
                String[] returnValues = new String[]{valueString};
                return returnValues;
            }
            if (f7Data instanceof DefObj) {
                String[] returnValues = new String[1];
                String valueString = CtrlReportUtil.getObjectString(((DefObj)f7Data).getProperty(valueField.toLowerCase()));
                if (isNullValueField) {
                    valueString = CtrlReportUtil.getObjectString(((DefObj)f7Data).getName());
                }
                returnValues[0] = valueString;
                return returnValues;
            }
            if (f7Data instanceof String) {
                String valueString = CtrlReportUtil.getObjectString(f7Data);
                String[] returnValues = new String[]{valueString};
                return returnValues;
            }
            String valueString = CtrlReportUtil.getObjectString(f7Data.toString());
            String[] returnValues = new String[]{valueString};
            return returnValues;
        }
        return null;
    }

    public String getComponentValue(String paramName) {
        String[] str = this.getComponentValue(paramName, null);
        if (null != str) {
            return str[0];
        }
        return null;
    }

    public String[] getCheckBoxGroupValue(String paramName) {
        return this.getComponentValue(paramName, null);
    }

    public String[] getF7Value(String paramName) {
        return this.getComponentValue(paramName, null);
    }

    public String[] getF7Value(String paramName, String valueField) {
        return this.getComponentValue(paramName, valueField);
    }

    public String[] getComponentText(String paramName) {
        Iterator it = this.objectComponents.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (!key.equals(paramName)) continue;
            Object currentObj = this.objectComponents.get(key);
            if (currentObj instanceof KDComboBox) {
                KDComboBox obj = (KDComboBox)currentObj;
                Object valueObj = obj.getSelectedItem();
                String valueString = null;
                if (valueObj instanceof DefObj) {
                    DefObj def = (DefObj)obj.getSelectedItem();
                    if (null != def) {
                        valueString = def.getAlias();
                    }
                } else if (valueObj instanceof String) {
                    valueString = (String)valueObj;
                }
                String[] returnValues = new String[]{valueString};
                return returnValues;
            }
            if (currentObj instanceof KDCheckBox) {
                KDCheckBox cb = (KDCheckBox)currentObj;
                AloneBoxData abd = (AloneBoxData)cb.getUserObject();
                String valueString = "";
                valueString = cb.isSelected() ? abd.getSelectedAlias() : abd.getNoSelectedAlias();
                String[] returnValues = new String[]{valueString};
                return returnValues;
            }
            if (currentObj instanceof KDCheckBox[]) {
                KDCheckBox[] cbs = (KDCheckBox[])currentObj;
                ArrayList<String> returnList = new ArrayList<String>();
                for (KDCheckBox cb : cbs) {
                    if (!cb.isSelected()) continue;
                    DefObj def = (DefObj)cb.getUserObject();
                    returnList.add(def.getAlias());
                }
                returnList.trimToSize();
                String[] returnValues = new String[returnList.size()];
                returnList.toArray(returnValues);
                return returnValues;
            }
            if (!(currentObj instanceof KDBizPromptBox)) continue;
            KDBizPromptBox obj = (KDBizPromptBox)currentObj;
            Object f7Data = obj.getData();
            if (null == f7Data) {
                return null;
            }
            String aliasField = this.getF7ValueAliasField(paramName, "alias").toLowerCase();
            if (f7Data instanceof Object[]) {
                Object[] arrData = (Object[])f7Data;
                int size = arrData.length;
                String[] returnValues = new String[size];
                for (int i = 0; i < size; ++i) {
                    String valueString;
                    Object everyF7Object = arrData[i];
                    returnValues[i] = everyF7Object instanceof IObjectValue ? (valueString = CtrlReportUtil.getObjectString(((IObjectValue)everyF7Object).get(aliasField))) : (everyF7Object instanceof DefObj ? (valueString = CtrlReportUtil.getObjectString(((DefObj)everyF7Object).getAlias())) : (everyF7Object instanceof String ? CtrlReportUtil.getObjectString(everyF7Object) : (everyF7Object == null ? null : CtrlReportUtil.getObjectString(everyF7Object.toString()))));
                }
                return returnValues;
            }
            if (f7Data instanceof IObjectValue) {
                String valueString = CtrlReportUtil.getObjectString(((IObjectValue)f7Data).get(aliasField));
                String[] returnValues = new String[]{valueString};
                return returnValues;
            }
            if (f7Data instanceof DefObj) {
                String valueString = CtrlReportUtil.getObjectString(((DefObj)f7Data).getAlias());
                String[] returnValues = new String[]{valueString};
                return returnValues;
            }
            if (f7Data instanceof String) {
                String valueString = CtrlReportUtil.getObjectString(f7Data);
                String[] returnValues = new String[]{valueString};
                return returnValues;
            }
            String valueString = CtrlReportUtil.getObjectString(f7Data.toString());
            String[] returnValues = new String[]{valueString};
            return returnValues;
        }
        return null;
    }

    public void setComponentValue(String paramName, String[] values, String[] labelTxts, boolean isStopListener) throws Exception {
        if (isStopListener) {
            this.stopListener(paramName);
        }
        Iterator it = this.objectComponents.keySet().iterator();
        block4: while (it.hasNext()) {
            String key = it.next().toString();
            if (!key.equals(paramName)) continue;
            Object currentObj = this.objectComponents.get(key);
            if (currentObj instanceof KDTextField) {
                String value = values[0];
                KDTextField textField = (KDTextField)currentObj;
                textField.setText(value);
                break;
            }
            if (currentObj instanceof KDSpinner) {
                String value = values[0];
                KDSpinner kDSpinner = (KDSpinner)currentObj;
                SpinnerNumberModel sum = (SpinnerNumberModel)kDSpinner.getModel();
                String maxValue = CtrlReportUtil.getObjectString(sum.getMaximum());
                String minValue = CtrlReportUtil.getObjectString(sum.getMinimum());
                BigDecimal bgValue = new BigDecimal(value);
                BigDecimal bgMaxValue = new BigDecimal(maxValue);
                BigDecimal bgMinValue = new BigDecimal(minValue);
                if (bgValue.compareTo(bgMinValue) < 0) {
                    value = minValue;
                } else if (bgValue.compareTo(bgMaxValue) > 0) {
                    value = maxValue;
                }
                kDSpinner.setValue((Object)new Double(value));
                break;
            }
            if (currentObj instanceof KDDatePicker) {
                String value = values[0];
                KDDatePicker datePicker = (KDDatePicker)currentObj;
                Date date = null;
                try {
                    String pattern = datePicker.getDatePattern();
                    if (!value.equals("") && value.matches("(\\d){4}-(\\d){2}-(\\d){2}")) {
                        value = CtrlReportUtil.formatDate("yyyy-MM-dd", pattern, value);
                    } else if (!value.equals("") && value.matches("(\\d){4}-(\\d){2}-(\\d){2}(\\s(\\d){2}:(\\d){2}:(\\d){2}(.)*)?")) {
                        value = CtrlReportUtil.formatDate("yyyy-MM-dd HH:mm:ss", pattern, value);
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                    date = sdf.parse(value);
                }
                catch (ParseException e) {
                    date = null;
                }
                datePicker.setValue(date);
                break;
            }
            if (currentObj instanceof KDTimePicker) {
                String value = values[0];
                KDTimePicker kDTimePicker = (KDTimePicker)currentObj;
                Date date = null;
                try {
                    String pattern = kDTimePicker.getTimePattern();
                    if (!value.equals("") && value.matches("(\\d){2}:(\\d){2}:(\\d){2}")) {
                        value = CtrlReportUtil.formatDate("HH:mm:ss", pattern, value);
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                    date = sdf.parse(value);
                }
                catch (ParseException e) {
                    date = null;
                }
                kDTimePicker.setValue(date);
                break;
            }
            if (currentObj instanceof KDComboBox) {
                String value = values[0];
                KDComboBox obj = (KDComboBox)currentObj;
                int count = obj.getItemCount();
                for (int i = 0; i < count; ++i) {
                    DefObj def = (DefObj)obj.getItemAt(i);
                    String valueTemp = def.getName();
                    if (!valueTemp.equals(value)) continue;
                    obj.setSelectedIndex(i);
                    break block4;
                }
                break;
            }
            if (currentObj instanceof KDCheckBox) {
                KDCheckBox cb = (KDCheckBox)currentObj;
                AloneBoxData abd = (AloneBoxData)cb.getUserObject();
                String value = values[0];
                String selectedValue = abd.getSelectedValue();
                if (selectedValue.equals(value)) {
                    cb.setSelected(true);
                    break;
                }
                cb.setSelected(false);
                break;
            }
            if (currentObj instanceof KDCheckBox[]) {
                for (KDCheckBox cb : (KDCheckBox[])currentObj) {
                    DefObj def = (DefObj)cb.getUserObject();
                    String valueTemp = def.getName();
                    boolean isSelected = false;
                    for (int n = 0; n < values.length; ++n) {
                        if (!valueTemp.equals(values[n])) continue;
                        cb.setSelected(true);
                        isSelected = true;
                        break;
                    }
                    if (isSelected) continue;
                    cb.setSelected(false);
                }
                break;
            }
            if (!(currentObj instanceof KDBizPromptBox)) continue;
            KDBizPromptBox obj = (KDBizPromptBox)currentObj;
            DefObj[] defs = new DefObj[values.length];
            String valueField = this.getF7ValueAliasField(paramName, "value").toLowerCase();
            String aliasField = this.getF7ValueAliasField(paramName, "alias").toLowerCase();
            for (int i = 0; i < values.length; ++i) {
                if (labelTxts == null) {
                    labelTxts = values;
                }
                DefObj def = new DefObj();
                def.setName(values[i]);
                def.setAlias(labelTxts[i]);
                def.setProperty(valueField, (Object)values[i]);
                def.setProperty(aliasField, (Object)labelTxts[i]);
                defs[i] = def;
            }
            obj.setData((Object)defs);
            break;
        }
    }

    private String getF7ValueAliasField(String paramName, String valueOrAlias) {
        HashMap map = (HashMap)this.valueNameF7Map.get(paramName);
        if (valueOrAlias.equals("value")) {
            return CtrlReportUtil.getObjectString(map.get(ValueF7Field));
        }
        return CtrlReportUtil.getObjectString(map.get(AliasF7Field));
    }

    public void setComponentValue(String paramName, String value, boolean isStopListener) throws Exception {
        this.setComponentValue(paramName, new String[]{value}, null, isStopListener);
    }

    public void setCheckBoxGroupValue(String paramName, String[] values, boolean isStopListener) throws Exception {
        this.setComponentValue(paramName, values, null, isStopListener);
    }

    public void setF7Value(String paramName, String[] values, String[] labelTxts, boolean isStopListener) throws Exception {
        this.setComponentValue(paramName, values, labelTxts, isStopListener);
    }

    public void setComponentEnable(String paramName, String[] checkBoxValues, boolean enable) {
        Iterator it = this.objectComponents.keySet().iterator();
        while (it.hasNext()) {
            KDCheckBox cb;
            KDDatePicker datePicker;
            String key = it.next().toString();
            if (!key.equals(paramName)) continue;
            Object currentObj = this.objectComponents.get(key);
            if (currentObj instanceof KDCheckBox[]) {
                block1: for (KDCheckBox cb2 : (KDCheckBox[])currentObj) {
                    DefObj def = (DefObj)cb2.getUserObject();
                    for (int n = 0; n < checkBoxValues.length; ++n) {
                        if (!def.getName().equals(checkBoxValues[n])) continue;
                        cb2.setEnabled(enable);
                        continue block1;
                    }
                }
                continue;
            }
            if (currentObj instanceof KDDatePicker) {
                datePicker = (KDDatePicker)currentObj;
                datePicker.setEnabled(enable);
                continue;
            }
            if (currentObj instanceof KDTimePicker) {
                datePicker = (KDTimePicker)currentObj;
                datePicker.setEnabled(enable);
                continue;
            }
            if (currentObj instanceof KDCheckBox) {
                cb = (KDCheckBox)currentObj;
                cb.setEnabled(enable);
                continue;
            }
            if (currentObj instanceof KDComboBox) {
                cb = (KDComboBox)currentObj;
                cb.setEnabled(enable);
                continue;
            }
            IKDTextComponent comp = (IKDTextComponent)currentObj;
            comp.setEditable(enable);
        }
    }

    public void setComponentEnable(String paramName, boolean enable) {
        this.setComponentEnable(paramName, null, enable);
    }

    public void setCheckBoxGroupEnable(String paramName, String[] checkBoxValues, boolean enable) {
        this.setComponentEnable(paramName, checkBoxValues, enable);
    }

    public void setComponentVisible(String paramName, String[] checkBoxValues, boolean visible, boolean isIncludeLabel) {
        Iterator it = this.objectComponents.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (!key.equals(paramName)) continue;
            Object currentObj = this.objectComponents.get(key);
            if (currentObj instanceof KDCheckBox[]) {
                if (isIncludeLabel) {
                    KDPanel kDPanel = (KDPanel)this.objectComponents.get(paramName + "_panel");
                    kDPanel.setVisible(visible);
                    break;
                }
                KDCheckBox[] cbs = (KDCheckBox[])currentObj;
                int length = cbs.length;
                block1: for (int n = 0; n < checkBoxValues.length; ++n) {
                    for (int i = 0; i < length; ++i) {
                        KDCheckBox cb = cbs[i];
                        DefObj def = (DefObj)cb.getUserObject();
                        if (!def.getName().equals(checkBoxValues[n])) continue;
                        cb.setVisible(visible);
                        continue block1;
                    }
                }
            } else {
                KDComboBox obj;
                KDDatePicker datePicker;
                if (currentObj instanceof KDDatePicker) {
                    datePicker = (KDDatePicker)currentObj;
                    datePicker.setVisible(visible);
                } else if (currentObj instanceof KDTimePicker) {
                    datePicker = (KDTimePicker)currentObj;
                    datePicker.setVisible(visible);
                } else if (currentObj instanceof KDCheckBox) {
                    KDCheckBox cb = (KDCheckBox)currentObj;
                    cb.setVisible(visible);
                } else if (currentObj instanceof KDTextField) {
                    KDTextField textField = (KDTextField)currentObj;
                    textField.setVisible(visible);
                } else if (currentObj instanceof KDSpinner) {
                    KDSpinner kDSpinner = (KDSpinner)currentObj;
                    kDSpinner.setVisible(visible);
                } else if (currentObj instanceof KDComboBox) {
                    obj = (KDComboBox)currentObj;
                    obj.setVisible(visible);
                } else if (currentObj instanceof KDBizPromptBox) {
                    obj = (KDBizPromptBox)currentObj;
                    obj.setVisible(visible);
                }
                if (isIncludeLabel) {
                    KDLabelContainer kDLabelContainer1 = (KDLabelContainer)this.objectComponents.get(paramName + "_label");
                    kDLabelContainer1.setVisible(visible);
                }
                for (HashMap mapLay : this.layObjList) {
                    JComponent jCObj;
                    String objName;
                    Object obj2 = mapLay.get("object");
                    if (!(obj2 instanceof JComponent) || !(objName = (jCObj = (JComponent)obj2).getName()).equals(paramName) && (!isIncludeLabel || !objName.equals(paramName + "_label"))) continue;
                    boolean isVisible = jCObj.isVisible();
                    mapLay.put("isVisible", new Boolean(isVisible));
                }
            }
            break;
        }
    }

    public void restoreInitUI() {
        this.filterUI.restoreInitUI();
    }

    public void moveComponent(String paramNameFrom, String paramNameTo, boolean isIncludeLabel) {
        boolean b1 = this.objectComponents.containsKey(paramNameFrom);
        boolean b2 = this.objectComponents.containsKey(paramNameTo);
        boolean b3 = true;
        boolean b4 = true;
        if (isIncludeLabel) {
            b3 = this.objectComponents.containsKey(paramNameFrom + "_label");
            b4 = this.objectComponents.containsKey(paramNameTo + "_label");
        }
        boolean styleChange = false;
        if (this.filterUI.isOneStyle) {
            this.filterUI.isOneStyle = true;
            this.filterUI.createParametersUILayout();
            styleChange = true;
        }
        if (b1 && b2 && b3 & b4) {
            JComponent compFrom = (JComponent)this.objectComponents.get(paramNameFrom);
            JComponent compTo = (JComponent)this.objectComponents.get(paramNameTo);
            Rectangle rtFrom = compFrom.getBounds();
            Rectangle rtTo = compTo.getBounds();
            compFrom.setBounds(rtTo);
            compTo.setBounds(rtFrom);
            if (isIncludeLabel) {
                JComponent compFromLabel = (JComponent)this.objectComponents.get(paramNameFrom + "_label");
                JComponent compToLabel = (JComponent)this.objectComponents.get(paramNameTo + "_label");
                Rectangle rtLabelFrom = compFromLabel.getBounds();
                Rectangle rtLabelTo = compToLabel.getBounds();
                compFromLabel.setBounds(rtLabelTo);
                compToLabel.setBounds(rtLabelFrom);
            }
            HashMap<String, HashMap> map = new HashMap<String, HashMap>();
            for (HashMap mapLay : this.layObjList) {
                boolean isVisible;
                Object obj = mapLay.get("object");
                if (!(obj instanceof JComponent)) continue;
                JComponent jCObj = (JComponent)obj;
                String objName = jCObj.getName();
                if (objName.equals(paramNameFrom) || objName.equals(paramNameTo)) {
                    isVisible = jCObj.isVisible();
                    mapLay.put("two", ((JComponent)obj).getBounds());
                    mapLay.put("isVisible", new Boolean(isVisible));
                } else if (isIncludeLabel && (objName.equals(paramNameFrom + "_label") || objName.equals(paramNameTo + "_label"))) {
                    isVisible = jCObj.isVisible();
                    mapLay.put("two", ((JComponent)obj).getBounds());
                    mapLay.put("isVisible", new Boolean(isVisible));
                }
                map.put(objName, mapLay);
            }
            ArrayList listTmp = new ArrayList();
            int size = this.layObjList.size();
            for (int i = 0; i < size; ++i) {
                HashMap mapLay = (HashMap)this.layObjList.get(i);
                Object obj = mapLay.get("object");
                JComponent jCObj = (JComponent)obj;
                String objName = jCObj.getName();
                if (objName.equals(paramNameFrom)) {
                    listTmp.add(map.get(paramNameTo));
                    continue;
                }
                if (objName.equals(paramNameTo)) {
                    listTmp.add(map.get(paramNameFrom));
                    continue;
                }
                if (isIncludeLabel) {
                    if (objName.equals(paramNameFrom + "_label")) {
                        listTmp.add(map.get(paramNameTo + "_label"));
                        continue;
                    }
                    if (objName.equals(paramNameTo + "_label")) {
                        listTmp.add(map.get(paramNameFrom + "_label"));
                        continue;
                    }
                }
                listTmp.add(map.get(objName));
            }
            this.layObjList.clear();
            this.layObjList.addAll(listTmp);
        }
        if (styleChange) {
            this.filterUI.isOneStyle = false;
            this.filterUI.createParametersUILayout();
        }
    }

    public void moveComponent(String paramName, Rectangle newRectangle, boolean isLabel) {
        this.filterUI.btnSwitch.setEnabled(false);
        Object currentObj = this.objectComponents.get(paramName);
        if (null == currentObj) {
            return;
        }
        if (currentObj instanceof KDCheckBox[] && isLabel) {
            KDPanel kDPanel = (KDPanel)this.objectComponents.get(paramName + "_panel");
            kDPanel.setBounds(newRectangle);
            return;
        }
        if (isLabel) {
            JComponent comp = (JComponent)this.objectComponents.get(paramName + "_label");
            comp.setBounds(newRectangle);
        } else {
            JComponent comp = (JComponent)this.objectComponents.get(paramName);
            comp.setBounds(newRectangle);
        }
        this.filterUI.revalidate();
    }

    public void setComponentFocus(String paramName) {
        Object currentObj = this.objectComponents.get(paramName);
        if (null != currentObj) {
            if (currentObj instanceof KDDatePicker) {
                KDDatePicker datePicker = (KDDatePicker)currentObj;
                datePicker.requestFocus();
            } else if (currentObj instanceof KDTimePicker) {
                KDTimePicker datePicker = (KDTimePicker)currentObj;
                datePicker.requestFocus();
            } else if (currentObj instanceof KDCheckBox) {
                KDCheckBox cb = (KDCheckBox)currentObj;
                cb.requestFocus();
            } else if (currentObj instanceof KDComboBox) {
                KDComboBox cb = (KDComboBox)currentObj;
                cb.requestFocus();
            } else if (currentObj instanceof KDBizPromptBox) {
                KDBizPromptBox cb = (KDBizPromptBox)currentObj;
                cb.requestFocus();
            } else if (currentObj instanceof KDSpinner) {
                KDSpinner cb = (KDSpinner)currentObj;
                cb.requestFocus();
            } else if (currentObj instanceof KDTextField) {
                KDTextField cb = (KDTextField)currentObj;
                cb.requestFocus();
            }
        }
    }

    public Object checkNull(String paramName, String msg, boolean isNullToFocus) {
        Object returnObject = null;
        Object currentObj = this.objectComponents.get(paramName);
        if (null == currentObj) {
            return returnObject;
        }
        if (currentObj instanceof KDCheckBox[] || currentObj instanceof KDBizPromptBox) {
            returnObject = this.getF7Value(paramName);
            if (returnObject instanceof String[]) {
                Object value;
                Object values = returnObject;
                if (((Object)values).length == 1 && ((value = values[0]) == null || ((String)value).equals(""))) {
                    returnObject = null;
                }
            } else {
                returnObject = null;
            }
        } else {
            returnObject = this.getComponentValue(paramName);
            if (returnObject == null || returnObject.equals("")) {
                returnObject = null;
            }
        }
        if (returnObject == null) {
            MessageUtil.showInfo(msg, false);
            if (isNullToFocus) {
                this.setComponentFocus(paramName);
            }
        }
        return returnObject;
    }

    protected boolean defaultLayoutSingle() {
        return false;
    }
}

