/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.param;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.bo.ReportSnapBO;
import com.kingdee.eas.rpts.ctrlreport.data.ReportSnapType;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.DateUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.param.AbstractParamRelation;
import java.util.Date;
import java.util.HashMap;

public class SnapRelation
extends AbstractParamRelation {
    int iSnapType = -1;
    String today = CtrlReportUtil.formatDate(new Date());

    @Override
    public void loadSolutionAfter() throws Exception {
        this.setComponentValue("where", "1976-01-01", true);
        this.setComponentValue("reportDate", this.today, true);
        this.setFilterCtrl();
    }

    private void setFilterCtrl() throws Exception {
        this.restoreInitUI();
        String[] reportIDs = this.getF7Value("reportID");
        if (reportIDs != null) {
            String reportID = reportIDs[0];
            HashMap mapReportInfo = DefineReportBO.getReportInfoByID(null, reportID);
            String snapType = CtrlReportUtil.getObjectString(mapReportInfo.get("fsnaptype"));
            if (snapType.equals("")) {
                snapType = "-1";
            }
            this.iSnapType = Integer.parseInt(snapType);
            String snapTypeName = ReportSnapType.getDataType(this.iSnapType).getName();
            this.setComponentValue("reportType", snapTypeName, true);
        } else {
            this.iSnapType = -1;
        }
        String[] currentDataArr = DateUtil.getDateTimeArr(this.today);
        String currentYear = currentDataArr[0];
        String currentMonth = currentDataArr[1];
        String currentDay = currentDataArr[2];
        switch (this.iSnapType) {
            case 1: {
                this.setFilterCtrlVisible(false, true, false, false, false, false);
                this.moveComponent("year", "reportDate", true);
                this.setDefaultYear(currentYear);
                break;
            }
            case 2: {
                this.setFilterCtrlVisible(false, true, true, false, false, false);
                this.moveComponent("halfYear", "year", true);
                this.moveComponent("year", "reportDate", true);
                this.setDefaultYear(currentYear);
                this.setDefaultHalfYear(currentMonth);
                break;
            }
            case 3: {
                this.setFilterCtrlVisible(false, true, false, true, false, false);
                this.moveComponent("quarter", "year", true);
                this.moveComponent("year", "reportDate", true);
                this.setDefaultYear(currentYear);
                this.setDefaultQuarter(this.today, currentYear);
                break;
            }
            case 4: {
                this.setFilterCtrlVisible(false, true, false, false, true, false);
                this.moveComponent("month", "year", true);
                this.moveComponent("year", "reportDate", true);
                this.setDefaultYear(currentYear);
                this.setDefaultMonth(currentMonth);
                break;
            }
            case 5: {
                this.setFilterCtrlVisible(false, true, false, false, true, true);
                this.moveComponent("halfMonth", "halfYear", true);
                this.moveComponent("month", "year", true);
                this.moveComponent("year", "reportDate", true);
                this.setDefaultYear(currentYear);
                this.setDefaultMonth(currentMonth);
                this.setDefaultHalfMonth(currentDay);
                break;
            }
            case -1: 
            case 0: 
            case 6: 
            case 7: {
                this.setFilterCtrlVisible(true, false, false, false, false, false);
                break;
            }
        }
    }

    private void setFilterCtrlVisible(boolean d_reportDate, boolean sp_year, boolean cb_halfYear, boolean cb_quarter, boolean sp_month, boolean cb_halfMonth) {
        this.setComponentVisible("reportDate", null, d_reportDate, true);
        this.setComponentVisible("year", null, sp_year, true);
        this.setComponentVisible("halfYear", null, cb_halfYear, true);
        this.setComponentVisible("quarter", null, cb_quarter, true);
        this.setComponentVisible("month", null, sp_month, true);
        this.setComponentVisible("halfMonth", null, cb_halfMonth, true);
    }

    private void setDefaultYear(String currentYear) throws Exception {
        String thisYear = this.getComponentValue("year");
        if (thisYear.equals("") || thisYear.equals("1976")) {
            this.setComponentValue("year", currentYear, true);
        }
    }

    private void setDefaultHalfYear(String currentMonth) throws Exception {
        String thisHalfYear = this.getComponentValue("halfYear");
        if (thisHalfYear.equals("")) {
            int monthTemp = Integer.parseInt(currentMonth);
            if (monthTemp <= 6) {
                this.setComponentValue("halfYear", "0", true);
            } else {
                this.setComponentValue("halfYear", "1", true);
            }
        }
    }

    private void setDefaultQuarter(String currentSnapDate, String currentYear) throws Exception {
        String thisQuarter = this.getComponentValue("quarter");
        if (thisQuarter.equals("")) {
            String quarBegin = DateUtil.getDateOfQuarter(currentSnapDate, true);
            if (quarBegin.equals(currentYear + "-01-01")) {
                this.setComponentValue("quarter", "1", true);
            } else if (quarBegin.equals(currentYear + "-04-01")) {
                this.setComponentValue("quarter", "2", true);
            } else if (quarBegin.equals(currentYear + "-07-01")) {
                this.setComponentValue("quarter", "3", true);
            } else {
                this.setComponentValue("quarter", "4", true);
            }
        }
    }

    private void setDefaultMonth(String currentMonth) throws Exception {
        String thisMonth = this.getComponentValue("month");
        if (thisMonth.equals("")) {
            this.setComponentValue("month", currentMonth, true);
        }
    }

    private void setDefaultHalfMonth(String currentDay) throws Exception {
        String thisHalfMonth = this.getComponentValue("halfMonth");
        if (thisHalfMonth.equals("")) {
            int dayTemp = Integer.parseInt(currentDay);
            if (dayTemp <= 15) {
                this.setComponentValue("halfMonth", "0", true);
            } else {
                this.setComponentValue("halfMonth", "1", true);
            }
        }
    }

    @Override
    public void dataChange(String paramName) throws Exception {
        if (paramName.equals("reportID")) {
            this.setFilterCtrl();
        }
    }

    @Override
    public boolean confirmFilterBefore() throws Exception {
        String reportDate = "";
        switch (this.iSnapType) {
            case 1: {
                Object year = this.checkNull("year", "\u8bf7\u9009\u62e9\u5e74\u5ea6\uff01", true);
                if (null == year) {
                    return false;
                }
                reportDate = year + "-01-01";
                break;
            }
            case 2: {
                Object year = this.checkNull("year", "\u8bf7\u9009\u62e9\u5e74\u5ea6\uff01", true);
                if (null == year) {
                    return false;
                }
                Object halfYear = this.checkNull("halfYear", "\u8bf7\u9009\u62e9\u4e0a\u4e0b\u534a\u5e74\uff01", true);
                if (null == halfYear) {
                    return false;
                }
                if (halfYear.equals("0")) {
                    reportDate = year + "-01-01";
                    break;
                }
                reportDate = year + "-07-01";
                break;
            }
            case 3: {
                Object year = this.checkNull("year", "\u8bf7\u9009\u62e9\u5e74\u5ea6\uff01", true);
                if (null == year) {
                    return false;
                }
                Object quarter = this.checkNull("quarter", "\u8bf7\u9009\u62e9\u5b63\u5ea6\uff01", true);
                if (null == quarter) {
                    return false;
                }
                if (quarter.equals("1")) {
                    reportDate = year + "-01-01";
                    break;
                }
                if (quarter.equals("2")) {
                    reportDate = year + "-04-01";
                    break;
                }
                if (quarter.equals("3")) {
                    reportDate = year + "-07-01";
                    break;
                }
                if (!quarter.equals("4")) break;
                reportDate = year + "-10-01";
                break;
            }
            case 4: {
                Object year = this.checkNull("year", "\u8bf7\u9009\u62e9\u5e74\u5ea6\uff01", true);
                if (null == year) {
                    return false;
                }
                Object month = this.checkNull("month", "\u8bf7\u9009\u62e9\u6708\u4efd\uff01", true);
                if (null == month) {
                    return false;
                }
                String monthString = (String)month;
                if (monthString.length() < 2) {
                    monthString = "0" + monthString;
                }
                reportDate = year + "-" + monthString + "-01";
                break;
            }
            case 5: {
                Object year = this.checkNull("year", "\u8bf7\u9009\u62e9\u5e74\u5ea6\uff01", true);
                if (null == year) {
                    return false;
                }
                Object month = this.checkNull("month", "\u8bf7\u9009\u62e9\u6708\u4efd\uff01", true);
                if (null == month) {
                    return false;
                }
                Object halfMonth = this.checkNull("halfMonth", "\u8bf7\u9009\u62e9\u4e0a\u4e0b\u534a\u6708\uff01", true);
                if (null == halfMonth) {
                    return false;
                }
                String monthString = (String)month;
                if (monthString.length() < 2) {
                    monthString = "0" + monthString;
                }
                if (halfMonth.equals("0")) {
                    reportDate = year + "-" + monthString + "-01";
                    break;
                }
                reportDate = year + "-" + monthString + "-16";
                break;
            }
            case -1: 
            case 0: 
            case 6: 
            case 7: {
                Object reportDateObject = this.checkNull("reportDate", "\u8bf7\u9009\u62e9\u4e0a\u62a5\u671f\u95f4\uff01", true);
                if (null == reportDate) {
                    return false;
                }
                reportDate = (String)reportDateObject;
                break;
            }
        }
        String snapFlag = ReportSnapBO.getSnapFlagByType(this.iSnapType, reportDate);
        this.setComponentValue("where", snapFlag, true);
        String sql = null;
        KDBizPromptBox bpOrg = (KDBizPromptBox)this.objectComponents.get("orgID");
        if (!bpOrg.isRequired()) {
            String[] orgID = this.getF7Value("orgID");
            if (null != orgID) {
                String reportName = this.getComponentText("reportID")[0];
                StringBuffer sb = new StringBuffer();
                sb.append("SELECT snap.FID, snap.snapName, ");
                sb.append("'").append(reportName).append("' reportName, ");
                sb.append(this.iSnapType).append(" snapType, ");
                sb.append("org.FName_L2 orgName, ");
                sb.append("(select FName_l2 from T_PM_User u where snap.FCreatorID = u.FID) userName, ");
                sb.append("snap.reprotTime, snap.memo ");
                sb.append("FROM T_ORG_BaseUnit org ");
                sb.append("left OUTER JOIN (");
                sb.append("SELECT FID, FName_l2 snapName, FReportTime reprotTime, FMemo_l2 memo, forgid, fcreatorid FROM t_EXT_ReportSnap WHERE FReportID = '@reportID' AND fsnapflag = '@where'");
                sb.append(") snap ON snap.FOrgID =  org.FID ");
                sb.append("WHERE org.fid in ('@orgID')");
                sql = sb.toString();
            } else {
                sql = "SELECT snap.FID, snap.FName_l2 AS snapName, report.FName_l2 AS reportName, report.FSnapType AS snapType, org.FName_l2 AS orgName, u.FName_l2 AS userName, snap.FReportTime as reprotTime, snap.FMemo_l2 AS memo FROM T_BAS_DefineReport report INNER JOIN T_EXT_ReportSnap snap ON report.FID = snap.FReportID INNER JOIN t_pm_user u on snap.FCreatorID=u.fid INNER JOIN T_ORG_BaseUnit org on snap.FOrgID=org.fid where report.fid = '@reportID' and snap.fsnapflag = '@where' and snap.forgid in ('@orgID')";
            }
        } else {
            sql = "SELECT snap.FID, snap.FName_l2 AS fname, snap.FReportTime, snap.FMemo_l2 AS fmemo, cont.FContent FROM T_BAS_DefineReport report INNER JOIN T_EXT_ReportSnap snap ON report.FID = snap.FReportID INNER JOIN T_EXT_ByteContent cont ON snap.FID = cont.FID where report.fid = '@reportID' and snap.fsnapflag = '@where' and snap.forgid in ('@orgID')";
        }
        this.setComponentValue("sql", sql, true);
        return true;
    }
}

