/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.mobileService.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.mobileService.common.IResourceMethodHandler;
import com.kingdee.eas.rpts.mobileService.license.ExtLightRptLisenceScavenger;
import com.kingdee.eas.rpts.mobileService.model.MobileResult;
import com.kingdee.eas.rpts.mobileService.runtime.Env;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ExtLightReportsHanlder
implements IResourceMethodHandler {
    private static Logger logger = CommonLogger.getLogger(ExtLightReportsHanlder.class);

    @Override
    public MobileResult handle(Context easCtx, String ... args) throws ExtRptBizException {
        ExtLightRptLisenceScavenger.checkModuleLisence(easCtx);
        String pubAcctId = (String)Env.get(Env.Key.pubAcctId);
        return ExtLightReportsHanlder.listRpts(easCtx, pubAcctId);
    }

    private static MobileResult listRpts(Context easCtx, String pubAcctId) throws ExtRptBizException {
        Iterator iter;
        logger.info((Object)"------------------ExtLightReportsHanlder.listRpts method invoke start------------------");
        logger.info((Object)easCtx);
        try {
            iter = DefineReportBO.getMobileReportList(easCtx, pubAcctId).iterator();
        }
        catch (BOSException e1) {
            throw ExtRptBizException.newRptListSQLExecuteException(e1);
        }
        ArrayList ret = new ArrayList();
        while (iter.hasNext()) {
            Map map = (Map)iter.next();
            TreeMap reportItem = new TreeMap();
            reportItem.put("name", map.get("fmobilename"));
            reportItem.put("id", map.get("fid"));
            reportItem.put("type", map.get("fmobiletype"));
            ret.add(reportItem);
        }
        logger.info((Object)"------------------ExtLightReportsHanlder.listRpts method invoke finished------------------");
        return new MobileResult(ret);
    }

    @Override
    public String[] loadArgs(Map<String, String> params) {
        return null;
    }
}

