/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.dispatch.server.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.propelling.kpi.ExtKPIModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.propelling.kpi.KPIDefine;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlreport.propelling.ExtMessageService;
import com.kingdee.eas.rpts.ctrlreport.propelling.runtime.exception.MessageServiceException;
import com.kingdee.eas.rpts.ctrlreport.propelling.runtime.handler.XuntMessageHandler;
import com.kingdee.eas.rpts.snapshot.dispatch.server.app.KeyValue;
import com.kingdee.eas.rpts.snapshot.dispatch.server.app.Table;
import com.kingdee.eas.rpts.snapshot.dispatch.util.DispatchCommonUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class MobileSnapshotDAO {
    private static Logger logger = CommonLogger.getLogger(MobileSnapshotDAO.class);
    private static final int MAX = 10;

    public static List<Map<String, Object>> listRptSnaps(Context easCtx, String rptId) throws ExtRptBizException {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)easCtx, (String)Table.FETCH_SNAP_LIST_SQL, (Object[])new Object[]{rptId});
            while (rs.next()) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("snapshotTag", DispatchCommonUtil.clob2String(rs.getObject(1)));
                item.put("timestamp", rs.getDate(2).getTime());
                ret.add(item);
            }
            return ret;
        }
        catch (Throwable cause) {
            throw ExtRptBizException.newRptSnapshotListVisitException(cause);
        }
    }

    public static List<Map<String, Object>> listUserMessages(Context easCtx, String userId, String pubAcctId, String edgeSnapshotTag, String direction) throws ExtRptBizException {
        ArrayList<Map<String, Object>> returnValue;
        block9: {
            Map<String, Object> map;
            Map<String, Object> map2;
            String idS;
            List<Map<String, Object>> ret;
            boolean isAfter;
            block10: {
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(userId);
                params.add(pubAcctId);
                boolean isEmptyEdge = StringUtil.isEmptyString((String)edgeSnapshotTag);
                StringBuilder sb = new StringBuilder("SELECT");
                isAfter = isEmptyEdge ? false : "after".equals(direction);
                sb.append(" M.FPICTURE,M.FTITLE,M.FCONTENT,M.FCREATETIME,M.FSENDTIME,M.FSNAPID,M.FREPORTID");
                sb.append(" FROM T_EXT_EXTSENDMESSAGE M");
                sb.append(" WHERE M.FUSERID=?");
                sb.append(" AND M.FPUBACCTID=?");
                sb.append(" AND M.FISSEND=1");
                sb.append(" ORDER BY M.FCREATETIME ,M.FSNAPID DESC");
                ret = MobileSnapshotDAO.reverse(MobileSnapshotDAO.visitMessageRowset(easCtx, sb.toString(), params));
                returnValue = new ArrayList<Map<String, Object>>();
                if (!isEmptyEdge) break block10;
                int count = 0;
                for (Map<String, Object> map3 : ret) {
                    if (count < 10) {
                        returnValue.add(map3);
                        ++count;
                        continue;
                    }
                    break block9;
                }
                break block9;
            }
            int index = 0;
            Iterator<Map<String, Object>> iterator = ret.iterator();
            while (iterator.hasNext() && !(idS = (map2 = iterator.next()).get("id").toString()).equals(edgeSnapshotTag)) {
                ++index;
            }
            if (index >= ret.size() - 1 || index == 0) break block9;
            if (!isAfter) {
                int count = 0;
                for (int i = index + 1; i < ret.size() - 1; ++i) {
                    map = ret.get(i);
                    if (count < 10) {
                        returnValue.add(map);
                        ++count;
                        continue;
                    }
                    break;
                }
            } else {
                int count = 0;
                for (int i = index - 1; i >= 0; --i) {
                    map = ret.get(i);
                    if (count < 10) {
                        returnValue.add(map);
                        ++count;
                        continue;
                    }
                    break;
                }
            }
        }
        return MobileSnapshotDAO.reverse(returnValue);
    }

    private static List<Map<String, Object>> findSameTags(Context easCtx, String userId, String pubAcctId, String edgeSnapshotTag) throws ExtRptBizException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(userId);
        if (pubAcctId != null) {
            params.add(pubAcctId);
        }
        params.add(edgeSnapshotTag);
        params.add(edgeSnapshotTag);
        StringBuilder sb = new StringBuilder("SELECT");
        sb.append(" M.FPICTURE,M.FTITLE,M.FCONTENT,M.FCREATETIME,M.FSENDTIME,M.FSNAPID,M.FREPORTID");
        sb.append(" FROM T_EXT_EXTSENDMESSAGE M");
        sb.append(" WHERE M.FUSERID=?");
        if (pubAcctId != null) {
            sb.append(" AND M.FPUBACCTID=?");
        }
        sb.append(" AND M.FSNAPID<?");
        sb.append(" AND M.FCREATETIME=(SELECT TOP 1 FCREATETIME FROM T_EXT_EXTSENDMESSAGE WHERE FSNAPID=?)");
        sb.append(" AND M.FISSEND=1 ORDER BY M.FSNAPID");
        return MobileSnapshotDAO.visitMessageRowset(easCtx, sb.toString(), params);
    }

    public static int unreadMessages(Context easCtx, String userId, String pubAcctId, Timestamp ts) throws ExtRptBizException {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)easCtx, (String)"SELECT COUNT(*) FROM T_EXT_EXTSENDMESSAGE WHERE FPUBACCTID=? AND FUSERID=? AND FSENDTIME>? AND FISSEND=1", (Object[])new Object[]{pubAcctId, userId, ts});
            rs.next();
            return rs.getInt(1);
        }
        catch (Throwable cause) {
            throw ExtRptBizException.newRptMessagesVisitException(cause);
        }
    }

    public static Map<String, Object> lastUnreadMessage(Context easCtx, String userId, String pubAcctId, Timestamp ts) throws ExtRptBizException {
        try {
            IRowSet rs = ts != null ? DbUtil.executeQuery((Context)easCtx, (String)"SELECT TOP 1 M.FTITLE,M.FSENDTIME FROM T_EXT_EXTSENDMESSAGE M WHERE FISSEND=1 AND FPUBACCTID=? AND FUSERID=? AND FSENDTIME>? ORDER BY FSENDTIME DESC", (Object[])new Object[]{pubAcctId, userId, ts}) : DbUtil.executeQuery((Context)easCtx, (String)"SELECT TOP 1 M.FTITLE,M.FSENDTIME FROM T_EXT_EXTSENDMESSAGE M WHERE FISSEND=1 AND FPUBACCTID=? AND FUSERID=? ORDER BY FSENDTIME DESC", (Object[])new Object[]{pubAcctId, userId});
            if (!rs.next()) {
                return null;
            }
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("text", rs.getString(1));
            ret.put("date", rs.getDate(2).getTime());
            return ret;
        }
        catch (Throwable cause) {
            throw ExtRptBizException.newRptMessagesVisitException(cause);
        }
    }

    public static List<Map<String, Object>> listRptMessages(Context easCtx, String userId, String rptId, Timestamp[][] dateFilter, String edgeMessageId) throws ExtRptBizException {
        ArrayList<Map<String, Object>> sameTimeTags;
        boolean isEmptyEdge = StringUtil.isEmptyString((String)edgeMessageId);
        List<Map<String, Object>> list = sameTimeTags = isEmptyEdge ? new ArrayList<Map<String, Object>>() : MobileSnapshotDAO.findSameTags(easCtx, userId, null, edgeMessageId);
        if (sameTimeTags.size() >= 10) {
            return sameTimeTags;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(rptId);
        params.add(userId);
        if (!isEmptyEdge) {
            params.add(edgeMessageId);
        }
        StringBuilder sb = new StringBuilder("SELECT TOP ");
        sb.append(10 - sameTimeTags.size());
        sb.append(" FPICTURE,FTITLE,FCONTENT,FCREATETIME,FSENDTIME,FSNAPID,FREPORTID");
        sb.append(" FROM T_EXT_EXTSENDMESSAGE WHERE FREPORTID=? AND FUSERID=?");
        if (!isEmptyEdge) {
            sb.append(" AND FCREATETIME < (SELECT TOP 1 FCREATETIME FROM T_EXT_EXTSENDMESSAGE WHERE FSNAPID=?)");
        }
        MobileSnapshotDAO.addDateFilter("FCREATETIME", dateFilter, sb, params);
        sb.append(" ORDER BY FSENDTIME DESC");
        sameTimeTags.addAll(MobileSnapshotDAO.reverse(MobileSnapshotDAO.visitMessageRowset(easCtx, sb.toString(), params)));
        return sameTimeTags;
    }

    private static <T> List<T> reverse(List<T> target) {
        ArrayList<T> messages = new ArrayList<T>();
        for (int i = target.size() - 1; i >= 0; --i) {
            messages.add(target.get(i));
        }
        return messages;
    }

    private static void addDateFilter(String timeFieldName, Timestamp[][] dateFilter, StringBuilder sb, ArrayList<Object> params) {
        if (dateFilter != null && dateFilter.length > 0) {
            params.add(dateFilter[0][0]);
            params.add(dateFilter[0][1]);
            sb.append(" AND((");
            sb.append(timeFieldName);
            sb.append(" >= ? AND ");
            sb.append(timeFieldName);
            sb.append(" < ?)");
            for (int i = 1; i < dateFilter.length; ++i) {
                params.add(dateFilter[i][0]);
                params.add(dateFilter[i][1]);
                sb.append(" OR (");
                sb.append(timeFieldName);
                sb.append(" >= ? AND ");
                sb.append(timeFieldName);
                sb.append(" < ?)");
            }
            sb.append(")");
        }
    }

    private static List<Map<String, Object>> visitMessageRowset(Context easCtx, String sql, ArrayList<Object> params) throws ExtRptBizException {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)easCtx, (String)sql, (Object[])params.toArray());
            ArrayList<Map<String, Object>> messages = new ArrayList<Map<String, Object>>();
            while (rs.next()) {
                String rptId;
                DefineReportInfo info;
                String snapshotUuid = DispatchCommonUtil.clob2String(rs.getObject(6));
                HashMap<String, Object> message = new HashMap<String, Object>();
                messages.add(message);
                message.put("title", DispatchCommonUtil.clob2String(rs.getObject(2)));
                Timestamp createDate = rs.getTimestamp(4);
                message.put("date", ((Date)createDate).getTime());
                message.put("text", DispatchCommonUtil.clob2String(rs.getObject(3)));
                String url = new ExtMessageService(easCtx).pubVisitUrl();
                if (rs.getObject(1) != null) {
                    message.put("imgUrl", "/mobile/lightapp/extRpt/resources?remoteMethod=extLightHistoryMessagePicData&snapshotTag=" + snapshotUuid);
                }
                message.put("snapshotUrl", XuntMessageHandler.buildSnapshotVisitURL(url, (info = DefineReportBO.getReportInfo(easCtx, rptId = DispatchCommonUtil.clob2String(rs.getString(7)))) != null ? info.getName() : "(\u62a5\u8868\u5df2\u88ab\u5220\u9664)", rptId, snapshotUuid, createDate).toString());
                message.put("id", snapshotUuid);
            }
            return messages;
        }
        catch (Throwable cause) {
            throw ExtRptBizException.newRptMessagesVisitException(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] fetchMessagePic(Context easCtx, String snapId) throws ExtRptBizException {
        byte[] byArray;
        IRowSet rs = DbUtil.executeQuery((Context)easCtx, (String)"SELECT FPICTURE FROM T_EXT_EXTSENDMESSAGE WHERE FSNAPID=?", (Object[])new Object[]{snapId});
        if (!rs.next()) throw ExtRptBizException.newRptPicVisitException(new NullPointerException("no pic data for message"));
        InputStream in = null;
        try {
            Blob blob = rs.getBlob(1);
            in = blob.getBinaryStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = in.read(buffer);
            while (len > 0) {
                out.write(buffer, 0, len);
                len = in.read(buffer);
            }
            byArray = out.toByteArray();
        }
        catch (SQLException e) {
            byte[] byArray2;
            try {
                byArray2 = rs.getBytes(1);
            }
            catch (Throwable throwable) {
                try {
                    CloseUtil.close((Closeable[])new Closeable[]{in});
                    throw throwable;
                }
                catch (Throwable cause) {
                    throw ExtRptBizException.newRptPicVisitException(cause);
                }
            }
            CloseUtil.close((Closeable[])new Closeable[]{in});
            return byArray2;
        }
        CloseUtil.close((Closeable[])new Closeable[]{in});
        return byArray;
    }

    public static Map<String, Object> listRptKPIs(Context easCtx, String pubAcctId, String rptId, String orgId, String userId, Timestamp[][] dateFilter) throws ExtRptBizException {
        IRowSet rs;
        try {
            MobileSnapshotDAO.initKPIDatas(easCtx);
        }
        catch (Throwable e) {
            throw ExtRptBizException.newRptKPIsVisitException(e);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(pubAcctId);
        try {
            rs = DbUtil.executeQuery((Context)easCtx, (String)"SELECT FID FROM T_EXT_XUNT_PUBACCT WHERE FPUBACCTID=?", (Object[])params.toArray());
            while (rs.next()) {
                pubAcctId = rs.getString("FID");
            }
        }
        catch (Throwable cause) {
            throw ExtRptBizException.newRptKPIsVisitException(cause);
        }
        params.clear();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        TreeSet<Long> times = new TreeSet<Long>();
        TreeSet<Object> kpiNames = new TreeSet<Object>();
        params.add(orgId);
        params.add(rptId);
        params.add(userId);
        params.add(pubAcctId);
        StringBuilder sb = new StringBuilder("SELECT FKPINAME,FKPIVALUE,FKPIFORMAT,FCDATE FROM T_EXT_STAT_USERRPTKPI").append(" WHERE FORGID=? AND FREPORTID=? AND FUSERID=? AND FPUBACCTID=?");
        MobileSnapshotDAO.addDateFilter("FCDATE", dateFilter, sb, params);
        sb.append(" ORDER BY FCDATE ASC");
        HashMap<Long, ArrayList<KeyValue>> kpis = new HashMap<Long, ArrayList<KeyValue>>();
        HashMap kpisT = new HashMap();
        try {
            rs = DbUtil.executeQuery((Context)easCtx, (String)sb.toString(), (Object[])params.toArray());
            while (rs.next()) {
                String kpiName = rs.getString("FKPINAME");
                String string = rs.getString("FKPIFORMAT");
                Double kpiValue = rs.getBigDecimal("FKPIVALUE").doubleValue();
                if (!kpisT.containsKey(kpiName)) {
                    HashMap<String, Object> kpi = new HashMap<String, Object>();
                    kpi.put("name", kpiName);
                    kpi.put("format", string);
                    kpi.put("values", new ArrayList());
                    kpisT.put(kpiName, kpi);
                }
                if (StringUtil.isEmptyString((String)kpiName)) continue;
                long time = rs.getTime("FCDATE").getTime();
                ArrayList<KeyValue> container = (ArrayList<KeyValue>)kpis.get(time);
                if (container == null) {
                    container = new ArrayList<KeyValue>();
                    kpis.put(time, container);
                }
                container.add(new KeyValue(kpiName, kpiValue));
                times.add(time);
                kpiNames.add(kpiName);
            }
            for (String string : kpiNames) {
                Map kpi = (Map)kpisT.get(string);
                for (Long time : times) {
                    List vsc = (List)kpi.get("values");
                    boolean isValueAdded = false;
                    for (KeyValue kv : (List)kpis.get(time)) {
                        if (!kv.name.equals(string)) continue;
                        vsc.add(kv.value);
                        isValueAdded = true;
                        break;
                    }
                    if (isValueAdded) continue;
                    vsc.add(null);
                }
            }
            ret.put("summaries", kpisT.values());
            ret.put("date", times);
            return ret;
        }
        catch (Throwable cause) {
            throw ExtRptBizException.newRptKPIsVisitException(cause);
        }
    }

    public static Collection<Map<String, Object>> listUserRptKPIs(Context easCtx, String userId, String pubAcctId) throws Throwable {
        MobileSnapshotDAO.initKPIDatas(easCtx);
        System.out.println("-------------\u83b7\u53d6\u7528\u6237\u3010" + userId + "\u3011\u5728\u516c\u4f17\u53f7\u3010" + pubAcctId + "\u3011\u6307\u6807----------------");
        ArrayList<String> params = new ArrayList<String>();
        params.add(pubAcctId);
        IRowSet rs = DbUtil.executeQuery((Context)easCtx, (String)"SELECT FID FROM T_EXT_XUNT_PUBACCT WHERE FPUBACCTID=?", (Object[])params.toArray());
        while (rs.next()) {
            pubAcctId = rs.getString("FID");
        }
        System.out.println("-----------------\u8f6c\u6362\u540e\u7684EAS\u4e3b\u9898ID\u3010" + pubAcctId + "\u3011--------------------");
        params.clear();
        HashMap buffer = new HashMap();
        StringBuilder sqlBuffer = new StringBuilder("SELECT DISTINCT FREPORTID FROM T_EXT_STAT_USERRPTKPI WHERE FUSERID=? AND FPUBACCTID=?");
        params.add(userId);
        params.add(pubAcctId);
        rs = DbUtil.executeQuery((Context)easCtx, (String)sqlBuffer.toString(), (Object[])params.toArray());
        sqlBuffer = new StringBuilder("SELECT FKPINAME FROM T_EXT_STAT_USERRPTKPI WHERE FUSERID=? AND FPUBACCTID=? AND FREPORTID=?");
        while (rs.next()) {
            DefineReportInfo rpt = DefineReportBO.getReportInfo(easCtx, rs.getString("FREPORTID"));
            if (rpt == null) continue;
            HashMap<String, Object> rptVO = new HashMap<String, Object>();
            String string = rpt.getId().toString();
            rptVO.put("reportId", string);
            rptVO.put("reportName", rpt.getMobileName());
            TreeSet<String> summaryNames = new TreeSet<String>();
            rptVO.put("summaryNames", summaryNames);
            params.clear();
            params.add(userId);
            params.add(pubAcctId);
            params.add(rpt.getId().toString());
            IRowSet rs2 = DbUtil.executeQuery((Context)easCtx, (String)sqlBuffer.toString(), (Object[])params.toArray());
            while (rs2.next()) {
                String FKPINAME = DispatchCommonUtil.clob2String(rs2.getObject("FKPINAME"));
                if (StringUtil.isEmptyString((String)FKPINAME)) continue;
                summaryNames.add(FKPINAME);
            }
            if (summaryNames.isEmpty()) continue;
            buffer.put(string, rptVO);
        }
        Collection<Map<String, Object>> values = buffer.values();
        sqlBuffer = new StringBuilder("SELECT DISTINCT KPI.FORGID ORGID,ORG.FNAME_L2 ORGNAME FROM T_EXT_STAT_USERRPTKPI KPI").append(" LEFT JOIN T_ORG_ADMIN ORG ON KPI.FORGID=ORG.FID").append(" WHERE KPI.FREPORTID=? AND FUSERID=? AND FPUBACCTID=?");
        for (Map map : values) {
            params.clear();
            params.add((String)map.get("reportId"));
            params.add(userId);
            params.add(pubAcctId);
            rs = DbUtil.executeQuery((Context)easCtx, (String)sqlBuffer.toString(), (Object[])params.toArray());
            ArrayList orgs = new ArrayList();
            while (rs.next()) {
                HashMap<String, String> org = new HashMap<String, String>();
                org.put("id", rs.getString("ORGID"));
                org.put("name", rs.getString("ORGNAME"));
                orgs.add(org);
            }
            map.put("orgs", orgs);
        }
        return values;
    }

    public static String fetchSnapFilterValues(Context easCtx, String snapId) throws ExtRptBizException {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)easCtx, (String)Table.FETCH_FILTER_SQL, (Object[])new Object[]{snapId});
            String partFilter = "";
            while (rs.next()) {
                partFilter = partFilter + DispatchCommonUtil.clob2String(rs.getObject(1));
            }
            if (!StringUtil.isEmptyString((String)partFilter)) {
                return partFilter;
            }
            throw ExtRptBizException.newSnapshotFilterVisitException(new NullPointerException("no filter content,snapid is:" + snapId));
        }
        catch (Exception e) {
            throw ExtRptBizException.newSnapshotFilterVisitException(e);
        }
    }

    public static void saveSnapAppendix(Context easCtx, String snapId, String rptId, String filter, String kpis) throws BOSException {
        try {
            DbUtil.execute((Context)easCtx, (String)Table.INSERT_SQL, (Object[])new Object[]{snapId, rptId, filter, kpis, new Timestamp(new Date().getTime()), 0});
        }
        catch (BOSException e) {
            logger.error((Object)"execute insert error, will be splitFilter", (Throwable)e);
            List paramsList = MobileSnapshotDAO.splitFilter(snapId, rptId, filter, kpis);
            DbUtil.executeBatch((Context)easCtx, (String)Table.INSERT_SQL, (List)paramsList);
        }
    }

    private static List splitFilter(String snapId, String rptId, String filter, String kpis) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Timestamp timestamp = new Timestamp(new Date().getTime());
        if (!StringUtil.isEmptyString((String)filter)) {
            int maxLen = 2000;
            int fLen = filter.length();
            if (fLen > maxLen) {
                String partFilter = "";
                int count = fLen / maxLen;
                int beginIndex = 0;
                int endIndex = maxLen;
                for (int i = 0; i < count; ++i) {
                    partFilter = filter.substring(beginIndex, endIndex);
                    paramsList.add(new Object[]{snapId, rptId, partFilter, kpis, timestamp, i});
                    beginIndex = endIndex;
                    if (i >= count - 1) continue;
                    endIndex += maxLen;
                }
                if (beginIndex < fLen) {
                    partFilter = filter.substring(beginIndex, fLen);
                    paramsList.add(new Object[]{snapId, rptId, partFilter, kpis, timestamp, count});
                }
                return paramsList;
            }
        }
        paramsList.add(new Object[]{snapId, rptId, filter, kpis, timestamp, 0});
        return paramsList;
    }

    public static List<String> tranlasteUserID4Xunt(Context easCtx, List<String> users) throws MessageServiceException {
        StringBuilder sb = new StringBuilder(Table.USERID_TRANSLATE_SQL);
        if (users != null && !users.isEmpty()) {
            sb.append(" AND FID IN (");
            Iterator<String> iter = users.iterator();
            while (true) {
                String user = iter.next();
                sb.append("'");
                sb.append(user);
                sb.append("'");
                if (!iter.hasNext()) break;
                sb.append(",");
            }
            sb.append(")");
            HashSet<String> logSet = new HashSet<String>(users);
            users.clear();
            try {
                IRowSet rs = DbUtil.executeQuery((Context)easCtx, (String)sb.toString());
                while (rs.next()) {
                    String personId = rs.getString(1);
                    if (personId == null || "null".equals(personId.trim().toLowerCase(Locale.ENGLISH))) continue;
                    users.add(personId);
                    logSet.remove(rs.getString(3));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MessageServiceException(e, 1800, "failed to translate user's fid to tagetID");
            }
            if (!logSet.isEmpty()) {
                for (String user : logSet) {
                    logger.warn((Object)("--------ID:" + user + " PersonId " + "is illegal,will be ignored--------"));
                }
            }
        }
        return users;
    }

    public static void initKPIDatas(Context easCtx) throws Throwable {
        StringBuilder sql = new StringBuilder("SELECT distinct STAT.FSNAPID SNAPID,STAT.FKPIMODEL KPIMODEL,STAT.FRPTUUID REPORTID,STAT.FCDATE CREATEDATE,").append("MESSAGE.FUSERID USERID,MESSAGE.FPUBACCTID PUBACCTID,").append("SNAP.FORGID ORGID").append(" FROM T_EXT_M_SNAP_STATICS STAT").append(" LEFT JOIN T_EXT_EXTSENDMESSAGE MESSAGE").append(" ON STAT.FSNAPID=MESSAGE.FSNAPID").append(" LEFT JOIN T_EXT_SSSNAPSHOT SNAP").append(" ON STAT.FSNAPID=SNAP.FID").append(" WHERE STAT.FISTRANSFERED<>1").append(" AND MESSAGE.FISSEND=1").append(" AND MESSAGE.FPUBACCTID IS NOT NULL").append(" AND STAT.FKPIMODEL <> '<root />'");
        IRowSet rs = DbUtil.executeQuery((Context)easCtx, (String)sql.toString());
        sql = new StringBuilder("INSERT INTO T_EXT_STAT_USERRPTKPI(").append("FID,FREPORTID,FSNAPID,FORGID,FUSERID,FPUBACCTID,FCDATE,FKPINAME,FKPIVALUE,FKPIFORMAT").append(")").append(" VALUES(?,?,?,?,?,?,?,?,?,?)");
        HashSet<String> snapIdList = new HashSet<String>();
        ExtKPIModel model = new ExtKPIModel();
        while (rs.next()) {
            KPIDefine[] defines = model.fromXml(DispatchCommonUtil.clob2String(rs.getObject("KPIMODEL"))).defines();
            String snapId = DispatchCommonUtil.clob2String(rs.getObject("SNAPID"));
            snapIdList.add(snapId);
            for (KPIDefine define : defines) {
                BigDecimal value = null;
                try {
                    value = new BigDecimal(define.kpiValue());
                }
                catch (Throwable e) {
                    logger.warn((Object)("kpi ignored cause kpi value is not a number\u3010" + define.kpiValue() + "\u3011"));
                }
                if (value == null) continue;
                DbUtil.execute((Context)easCtx, (String)sql.toString(), (Object[])new Object[]{BOSUuid.create((String)"4001D360").toString(), rs.getObject("REPORTID"), snapId, rs.getObject("ORGID"), rs.getObject("USERID"), rs.getObject("PUBACCTID"), rs.getObject("CREATEDATE"), define.kpiName(), value, define.numberFormat()});
            }
        }
        if (!snapIdList.isEmpty()) {
            sql = new StringBuilder("UPDATE T_EXT_M_SNAP_STATICS SET FISTRANSFERED='1' WHERE FSNAPID IN(?");
            for (int i = 1; i < snapIdList.size(); ++i) {
                sql.append(",?");
            }
            sql.append(")");
            DbUtil.execute((Context)easCtx, (String)sql.toString(), (Object[])snapIdList.toArray());
        }
    }
}

