/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.dispatch.server.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.fulfil.ExportUtil;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kds.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.eas.rpts.ctrlreport.bo.SendMailBO;
import com.kingdee.eas.rpts.ctrlreport.email.Attachment;
import com.kingdee.eas.rpts.ctrlreport.email.MailInfo;
import com.kingdee.eas.rpts.ctrlreport.email.SendMailInfo;
import com.kingdee.eas.rpts.ctrlreport.email.SmtpSender;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.rpts.snapshot.dispatch.server.ISendEmailDAO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;

public class SendEmailDAOImpl
extends ORMObject
implements ISendEmailDAO {
    Logger logger = CommonLogger.getLogger(SendEmailDAOImpl.class);

    public SendEmailDAOImpl() {
        this.registerInterface(ISendEmailDAO.class, this);
    }

    @Override
    public void sendMail(Context ctx, Book book, Map dispatchMap, boolean isSuccess, String errorMsg, String snapName) {
        String femail = CtrlReportUtil.getObjectString(dispatchMap.get("femail"));
        if (femail.equals("")) {
            return;
        }
        int fmsgsendtype = ((Number)dispatchMap.get("fmsgsendtype")).intValue();
        if (fmsgsendtype == 1 && !isSuccess) {
            return;
        }
        if (fmsgsendtype == 2 && isSuccess) {
            return;
        }
        String fsendmail = (String)dispatchMap.get("fsendmail");
        if (fsendmail.equals("")) {
            return;
        }
        String strResult = "\u6210\u529f";
        if (!isSuccess) {
            strResult = "\u5931\u8d25";
        }
        femail = ExtStringUtil.replace(femail, "\r", "");
        femail = ExtStringUtil.replace(femail, "\n", "");
        femail = ExtStringUtil.replace(femail, "\uff0c", ";");
        femail = ExtStringUtil.replace(femail, ",", ";");
        femail = ExtStringUtil.replace(femail, "\uff1b", ";");
        String fjobprocessdefid = CtrlReportUtil.getObjectString(dispatchMap.get("fjobprocessdefid"));
        try {
            byte[] data;
            SendMailInfo sendMailInfo = SendMailBO.getSendMailListById(ctx, fsendmail);
            if (sendMailInfo == null) {
                return;
            }
            String mailHost = sendMailInfo.getMailHost().trim();
            String mailUser = sendMailInfo.getMailUser().trim();
            String mailAddress = sendMailInfo.getMailAddress();
            String[] toAddress = femail.split(";");
            String mailPassword = new String(new BASE64Decoder().decodeBuffer(sendMailInfo.getMailPassword()));
            MailInfo mailInfo = new MailInfo();
            mailInfo.setSmtpServer(mailHost);
            mailInfo.setSmtpPort(25);
            mailInfo.setMailUserName(mailUser);
            mailInfo.setMailPassword(mailPassword);
            mailInfo.setMailTo(toAddress);
            mailInfo.setMailFrom(mailAddress);
            mailInfo.setMailShowTo(femail);
            mailInfo.setMailShowFrom(mailAddress);
            String mailTitle = (String)dispatchMap.get("mailtitle");
            mailInfo.setMailSubject(this.decodeSysVar(mailTitle, dispatchMap, snapName));
            String mailContent = (String)dispatchMap.get("mailcontent");
            StringBuffer content = new StringBuffer(this.decodeSysVar(mailContent, dispatchMap, snapName));
            if (!StringUtil.isEmptyString((String)errorMsg)) {
                content.append("\r\n");
                content.append("\u203b\u203b\r\n");
                if (!isSuccess) {
                    content.append("\u4ee5\u4e0b\u662f\u751f\u6210\u8c03\u5ea6\u5931\u8d25\u7684\u6982\u8981\u4fe1\u606f\uff0c\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01\r\n");
                } else {
                    content.append("\u8c03\u5ea6\u6267\u884c\u867d\u7136\u6267\u884c\u6210\u529f\uff0c\u4f46\u6267\u884c\u8fc7\u7a0b\u4e2d\u5b58\u5728\u95ee\u9898\u3002\u4ee5\u4e0b\u662f\u95ee\u9898\u7684\u6982\u8981\u4fe1\u606f\uff0c \u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01\r\n");
                }
                content.append("  ").append(errorMsg);
            }
            mailInfo.setMailBody(content.toString());
            int isTakeAttach = ((Number)dispatchMap.get("fistakeattachment")).intValue();
            if (1 == isTakeAttach && isSuccess && (data = this.exportToXsl(ctx, book, fjobprocessdefid)) != null) {
                Attachment attach1 = new Attachment(snapName + ".xls", "application/vnd.ms-excel", data);
                mailInfo.setAttachments(new Attachment[]{attach1});
            }
            SmtpSender.sendMail(mailInfo, 0);
            this.logger.error((Object)"send mail finish");
        }
        catch (Exception ex) {
            this.logger.error((Object)"ex");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] exportToXsl(Context ctx, Book book, String fjobprocessdefid) {
        if (book == null) {
            return null;
        }
        ByteArrayOutputStream os = null;
        byte[] data = null;
        try {
            KDSBook kdsbook = BookToKDSBook.traslate((Book)book, null);
            ExportUtil.removeHideSheet((Book)book, (KDSBook)kdsbook);
            ExportManager em = new ExportManager();
            em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"TRUE");
            em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"FALSE");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
            os = new ByteArrayOutputStream(102400);
            em.exportToExcelStream(kdsbook, (OutputStream)os);
            data = os.toByteArray();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        return data;
    }

    private String decodeSysVar(String str, Map dispatchMap, String snapName) {
        dispatchMap.get("dispatchupdatetime");
        String reportname = CtrlReportUtil.getObjectString(dispatchMap.get("reportname"));
        String dispatchName = (String)dispatchMap.get("dispatchname");
        String userName = (String)dispatchMap.get("username");
        String orgName = (String)dispatchMap.get("orgname");
        String ftitle = CtrlReportUtil.getObjectString(dispatchMap.get("ftitle"));
        String fcreatetime = CtrlReportUtil.getObjectString(dispatchMap.get("fcreatetime"));
        if (fcreatetime != null && fcreatetime.split("\\.").length > 1) {
            fcreatetime = fcreatetime.split("\\.")[0];
        }
        String s = str.replaceAll("<%\u8c03\u5ea6\u540d\u79f0%>", dispatchName).replaceAll("<%\u6a21\u677f\u540d\u79f0%>", reportname).replaceAll("<%\u5feb\u7167\u540d\u79f0%>", snapName).replaceAll("<%\u521b\u5efa\u4eba%>", userName).replaceAll("<%\u521b\u5efa\u7ec4\u7ec7%>", orgName).replaceAll("<%\u540e\u53f0\u4e8b\u7269\u540d\u79f0%>", ftitle).replaceAll("<%\u8c03\u5ea6\u521b\u5efa\u65f6\u95f4%>", fcreatetime);
        return s;
    }
}

