/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.statistics;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.rpts.statistics.EASExtStatisticsInfoStub;
import com.kingdee.eas.rpts.statistics.IEASExtStatisticsInfoStub;
import com.kingdee.eas.rpts.statistics.exception.SalmonBizException;
import com.kingdee.eas.rpts.statistics.info.EnterpriseInfo;
import com.kingdee.eas.rpts.statistics.util.ServiceUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EASExtStatisticsInfoService {
    private static final long serialVersionUID = 1L;
    private static EnterpriseInfo info;
    private static EASExtStatisticsInfoService inst;

    public static void uploadFinished(Context easCtx, long start, int size) throws SalmonBizException {
        ServiceUtil.DBUtil.executeMaintainRecord(easCtx, "UPDATE T_EXT_UPLOADCLIENT SET FLASTUPLOAD=?", start + (long)size);
    }

    private Map<String, Object> fetchAllStatisticsInfoPacket(Context easCtx) throws SalmonBizException {
        return new EASExtStatisticsInfoStub(easCtx).fetchAllStatisticsInfoPacket();
    }

    public static EnterpriseInfo fetchEnterpriseInfo(Context easCtx) throws SalmonBizException {
        info = new EnterpriseInfo();
        try {
            LicenseBaseInfo license;
            if (easCtx == null) {
                license = LicenseSrvAgentFactory.getRemoteInstance().getLicenseBaseInfo();
                easCtx = ((IEASExtStatisticsInfoStub)BOSObjectFactory.createRemoteBOSObject((String)"com.kingdee.eas.rpts.statistics.EASExtStatisticsInfoStub", IEASExtStatisticsInfoStub.class)).getContext();
            } else {
                license = LicenseSrvAgentFactory.getLocalInstance((Context)easCtx).getLicenseBaseInfo();
            }
            info.setName(new String(Base64.decode((String)license.getLicenseTo()), "gbk"));
            info.setUuid(license.getSerialNum());
            info.setDbCode(easCtx.getAIS());
            info.setDbType((String)easCtx.get((Object)"dbType"));
            info.setVersion(license.getVersion());
        }
        catch (LicenseException e) {
            throw new SalmonBizException("[LicenseException]failed to collect enterprise info.", e);
        }
        catch (BOSException e) {
            throw new SalmonBizException("[BOSException]failed to collect enterprise info.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SalmonBizException("[UnsupportedEncodingException]failed to collect enterprise info.", e);
        }
        return info;
    }

    private static String heartBeat(Context easCtx, String clientUuid) throws SalmonBizException {
        return new EASExtStatisticsInfoStub(easCtx).heartbeat(clientUuid);
    }

    private void finished(Context easCtx) throws SalmonBizException {
        new EASExtStatisticsInfoStub(easCtx).finished();
    }

    private void clean(Context easCtx) throws SalmonBizException {
        new EASExtStatisticsInfoStub(easCtx).clean();
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Context easCtx = WebContextUtil.getEasContext((HttpServletRequest)req);
        String method = req.getParameter("remoteMethod");
        HashMap<String, Object> data = new HashMap<String, Object>();
        JSONObject json = new JSONObject();
        try {
            Object retValue = null;
            switch (MethodEnum.valueOf(method)) {
                case fetchStatisticsInfo: {
                    retValue = EnterpriseInfo.wrapEnterpriseInfo(EASExtStatisticsInfoService.fetchEnterpriseInfo(easCtx));
                    break;
                }
                case fetchAllStatisticsInfoPacket: {
                    retValue = this.fetchAllStatisticsInfoPacket(easCtx);
                    break;
                }
                case heartbeat: {
                    retValue = EASExtStatisticsInfoService.heartBeat(easCtx, req.getParameter("clientUuid"));
                    break;
                }
                case finished: {
                    this.finished(easCtx);
                    break;
                }
                case uploadFinished: {
                    EASExtStatisticsInfoService.uploadFinished(easCtx, Long.parseLong(req.getParameter("start")), Integer.parseInt(req.getParameter("byteSize")));
                    break;
                }
                case startCreateZipFile: {
                    new EASExtStatisticsInfoStub(easCtx).startCreateZipFile();
                    break;
                }
                case clean: {
                    this.clean(easCtx);
                    break;
                }
                default: {
                    throw new RuntimeException("UNKOWN METHOD");
                }
            }
            if (retValue != null) {
                data.put("retValue", retValue);
            }
            data.put("success", true);
        }
        catch (SalmonBizException e) {
            e.printStackTrace();
            data.put("success", false);
            data.put("exception", e.getMessage());
        }
        resp.setContentType("application/json; charset=utf-8");
        ServletOutputStream out = resp.getOutputStream();
        try {
            json.put("data", data);
        }
        catch (JSONException e) {
            e.printStackTrace();
            try {
                json.put("data", (Object)"failed to put json data");
            }
            catch (JSONException e1) {
                e.printStackTrace();
            }
        }
        out.write(json.toString().getBytes("utf-8"));
        out.flush();
    }

    public static EASExtStatisticsInfoService INST() {
        return inst;
    }

    static {
        inst = new EASExtStatisticsInfoService();
    }

    private static enum MethodEnum {
        fetchStatisticsInfo,
        fetchAllStatisticsInfoPacket,
        heartbeat,
        finished,
        startCreateZipFile,
        uploadFinished,
        clean;

    }
}

