/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.statistics;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.rpts.statistics.EASExtStatisticsInfoService;
import com.kingdee.eas.rpts.statistics.IEASExtStatisticsInfoStub;
import com.kingdee.eas.rpts.statistics.ZipFileCreator;
import com.kingdee.eas.rpts.statistics.dynamic.DefaultExtStatisticsRunner;
import com.kingdee.eas.rpts.statistics.dynamic.IExtStatisticsRunner;
import com.kingdee.eas.rpts.statistics.exception.SalmonBizException;
import com.kingdee.eas.rpts.statistics.util.ServiceUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.Uuid;
import java.io.File;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class EASExtStatisticsInfoStub
implements IEASExtStatisticsInfoStub {
    private static final long serialVersionUID = 5835105056925936549L;
    private Context easCtx;
    private IExtStatisticsRunner statisticsRunner = new DefaultExtStatisticsRunner();

    public EASExtStatisticsInfoStub(Context easCtx) {
        this.easCtx = easCtx;
    }

    public EASExtStatisticsInfoStub() {
        this.easCtx = ContextUtils.getContextFromSession();
    }

    @Override
    public void clean() throws SalmonBizException {
        ServiceUtil.DBUtil.executeMaintainRecord(this.easCtx, "DELETE T_EXT_EXPORTEDRPT WHERE FRECORDTIME IS NULL", new Object[0]);
    }

    @Override
    public Map<String, Object> fetchAllStatisticsInfoPacket() throws SalmonBizException {
        IRowSet rs = ServiceUtil.DBUtil.executeQuery(this.easCtx, "SELECT FFILELENGTH,FLASTUPLOAD,FFILEPATH,FCLUSTERNODENAME,FSTATUS FROM T_EXT_UPLOADCLIENT", null);
        try {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            if (rs.next()) {
                String status = rs.getString("FSTATUS");
                if ("CREATING".equals(status)) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("status", "CREATING");
                    return map;
                }
                String filePath = rs.getString("FFILEPATH");
                long start = rs.getLong("FLASTUPLOAD");
                File file = new File(filePath);
                byte[] data = ServiceUtil.ClusterUtil.loadClusterFile(this.easCtx, rs.getString("FCLUSTERNODENAME"), filePath, (int)start);
                ret.put("fileName", file.getName());
                ret.put("start", start);
                ret.put("isEnd", (long)data.length < 0xA00000L);
                ret.put("byteSize", data.length);
                ret.put("data", Base64Encoder.byteArrayToBase64((byte[])data));
            }
            return ret;
        }
        catch (SQLException e) {
            throw new SalmonBizException("[SQLException]failed to query rpt stats package status.", e);
        }
    }

    @Override
    public void finished() throws SalmonBizException {
        ServiceUtil.DBUtil.executeMaintainRecord(this.easCtx, "UPDATE T_EXT_UPLOADCLIENT SET FSTATUS='FINISHED',FFINISHTIME=?", new Timestamp(new java.util.Date().getTime()));
        ServiceUtil.DBUtil.executeMaintainRecord(this.easCtx, "UPDATE T_EXT_EXPORTEDRPT SET FRECORDTIME=?", new Timestamp(new java.util.Date().getTime()));
        EASExtStatisticsInfoStub.cleanFile(this.easCtx);
    }

    @Override
    public String heartbeat(String clientUuid) throws SalmonBizException {
        if (StringUtil.isEmptyString((String)clientUuid)) {
            clientUuid = Uuid.randomUUID().toString();
        }
        try {
            IRowSet rowset = ServiceUtil.DBUtil.executeQuery(this.easCtx, "SELECT * FROM T_EXT_UPLOADCLIENT", null);
            String insertSQL = "INSERT INTO T_EXT_UPLOADCLIENT(FCLIENTUUID,FACCESSTIME) VALUES(?,?)";
            if (rowset.next()) {
                boolean reChoose;
                boolean is30D;
                boolean isNotFinished;
                String oldClientUuid = rowset.getString("FCLIENTUUID");
                Date aTime = rowset.getDate("FACCESSTIME");
                Date fTime = rowset.getDate("FFINISHTIME");
                String status = rowset.getString("FSTATUS");
                if (StringUtil.equals((String)status, (String)"CREATING")) {
                    return null;
                }
                boolean bl = isNotFinished = !StringUtil.equals((String)status, (String)"FINISHED");
                boolean bl2 = fTime == null ? true : (is30D = System.currentTimeMillis() - fTime.getTime() > 2592000000L);
                boolean bl3 = aTime == null ? true : (reChoose = System.currentTimeMillis() - aTime.getTime() > 900000L);
                if (isNotFinished || is30D) {
                    if (StringUtil.equals((String)oldClientUuid, (String)clientUuid)) {
                        ServiceUtil.DBUtil.executeMaintainRecord(this.easCtx, "UPDATE T_EXT_UPLOADCLIENT SET FACCESSTIME=?", new Timestamp(new java.util.Date().getTime()));
                        return clientUuid;
                    }
                    if (reChoose) {
                        ServiceUtil.DBUtil.executeMaintainRecord(this.easCtx, "DELETE T_EXT_EXPORTEDRPT WHERE FRECORDTIME IS NULL", new Object[0]);
                        ServiceUtil.DBUtil.executeMaintainRecord(this.easCtx, "UPDATE T_EXT_UPLOADCLIENT SET FCLIENTUUID=?,FACCESSTIME=?", clientUuid, new Timestamp(new java.util.Date().getTime()));
                        return clientUuid;
                    }
                    return null;
                }
                if (!isNotFinished) {
                    EASExtStatisticsInfoStub.cleanFile(this.easCtx);
                    return null;
                }
                return null;
            }
            ServiceUtil.DBUtil.executeMaintainRecord(this.easCtx, insertSQL, clientUuid, new Timestamp(new java.util.Date().getTime()));
            return clientUuid;
        }
        catch (SQLException e) {
            throw new SalmonBizException("[SQLException]failed to maintain heartbeat.", e);
        }
    }

    @Override
    public void startCreateZipFile() throws SalmonBizException {
        new ZipFileCreator(this.easCtx, this.statisticsRunner, EASExtStatisticsInfoService.fetchEnterpriseInfo(this.easCtx)).createFile();
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return this;
    }

    public static void cleanFile(Context easCtx) throws SalmonBizException {
        IRowSet rs = ServiceUtil.DBUtil.executeQuery(easCtx, "SELECT FFILEPATH,FSTATUS,FCLUSTERNODENAME FROM T_EXT_UPLOADCLIENT", null);
        try {
            if (rs.next() && StringUtil.equals((String)"FINISHED", (String)rs.getString("FSTATUS"))) {
                ServiceUtil.ClusterUtil.deleteClusterFile(easCtx, rs.getString("FCLUSTERNODENAME"), rs.getString("FFILEPATH"));
            }
        }
        catch (SQLException e) {
            throw new SalmonBizException("[SQLException]failed to query file status.", e);
        }
        catch (RPCConnectException e) {
            ServiceUtil.DBUtil.executeMaintainRecord(easCtx, "DELETE T_EXT_UPLOADCLIENT", new Object[0]);
        }
    }

    public Context getContext() {
        return this.easCtx;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public BOSObjectType getType() {
        return new BOSObjectType("336A337E");
    }
}

