/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.statistics.info;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.rpts.statistics.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class StatisticsInfoPacket {
    private String rptUuid;
    private boolean isRawCloudRpt;
    private String rptName;
    private String systemId;
    private String templateType;
    private String templateVersion;
    private String cloudRptUuid;
    private byte[] templateData;
    private Element rptUsageStatus;

    public String getRptUuid() {
        return this.rptUuid;
    }

    public StatisticsInfoPacket setRptUuid(String rptUuid) {
        this.rptUuid = rptUuid;
        return this;
    }

    public String getRptName() {
        return this.rptName;
    }

    public StatisticsInfoPacket setRptName(String rptName) {
        this.rptName = rptName;
        return this;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public StatisticsInfoPacket setSystemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public StatisticsInfoPacket setTemplateType(String templateType) {
        this.templateType = templateType;
        return this;
    }

    public byte[] getTemplateData() {
        return this.templateData == null ? new byte[]{} : this.templateData;
    }

    public StatisticsInfoPacket setTemplateData(byte[] templateData) {
        this.templateData = templateData;
        return this;
    }

    public String getTemplateVersion() {
        return this.templateVersion;
    }

    public void setTemplateVersion(String templateVersion) {
        this.templateVersion = templateVersion;
    }

    public Element getRptUsageStatus() {
        return this.rptUsageStatus;
    }

    public void setRptUsageStatus(Element rptUsageStatus) {
        this.rptUsageStatus = rptUsageStatus;
    }

    public String getCloudRptUuid() {
        return this.cloudRptUuid;
    }

    public void setCloudRptUuid(String cloudRptUuid) {
        this.cloudRptUuid = cloudRptUuid;
    }

    public boolean isRawCloudRpt() {
        return this.isRawCloudRpt;
    }

    public void setRawCloudRpt(boolean isRawCloudRpt) {
        this.isRawCloudRpt = isRawCloudRpt;
    }

    public boolean equals(Object another) {
        if (!(another instanceof StatisticsInfoPacket)) {
            return false;
        }
        StatisticsInfoPacket packet = (StatisticsInfoPacket)another;
        if (!StringUtil.equals((String)packet.rptName, (String)this.rptName)) {
            return false;
        }
        if (!StringUtil.equals((String)packet.rptUuid, (String)this.rptUuid)) {
            return false;
        }
        if (!StringUtil.equals((String)packet.systemId, (String)this.systemId)) {
            return false;
        }
        if (!StringUtil.equals((String)packet.templateType, (String)this.templateType)) {
            return false;
        }
        if (!StringUtil.equals((String)packet.templateVersion, (String)this.templateVersion)) {
            return false;
        }
        if (this.templateData == null) {
            return packet.templateData == null;
        }
        if (packet.templateData == null) {
            return false;
        }
        if (this.templateData.length != packet.templateData.length) {
            return false;
        }
        for (int i = 0; i < this.templateData.length; ++i) {
            if (this.templateData[i] == packet.templateData[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "{rptUuid:" + this.rptUuid + ",rptName:" + this.rptName + ",systemId:" + this.systemId + "}";
    }

    public void wrap(int folderIndex, ZipOutputStream zipOut) {
        try {
            String folderName = String.valueOf(folderIndex) + "/";
            ZipEntry zipEntry = new ZipEntry(folderName);
            zipOut.putNextEntry(zipEntry);
            Element root = new Element("rpt");
            root.setAttribute("name", this.getRptName());
            root.setAttribute("uuid", this.getRptUuid());
            root.setAttribute("systemId", this.getSystemId());
            root.setAttribute("templateType", this.getTemplateType());
            root.setAttribute("lastUpdTime", this.getTemplateVersion());
            if (this.getCloudRptUuid() != null) {
                root.setAttribute("cloudRptUuid", this.getCloudRptUuid());
            }
            root.setAttribute("isRawCloudRpt", String.valueOf(this.isRawCloudRpt()));
            if (this.rptUsageStatus != null) {
                root.addContent((Content)this.rptUsageStatus);
            }
            zipOut.putNextEntry(new ZipEntry(folderName + "desc.xml"));
            XMLUtil.output(root, zipOut);
            this.addEntry(zipOut, folderName + "templateData", this.getTemplateData());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addEntry(ZipOutputStream zipOut, String entryName, byte[] data) throws IOException {
        ZipEntry zipEntry = new ZipEntry(entryName);
        zipOut.putNextEntry(zipEntry);
        zipOut.write(data);
    }

    public void unWrap(ZipInputStream zipIn) throws IOException {
        this.fill(zipIn.getNextEntry().getName().split("/")[1], zipIn);
        this.fill(zipIn.getNextEntry().getName().split("/")[1], zipIn);
        zipIn.closeEntry();
    }

    private void fill(String entryName, ZipInputStream zipIn) throws IOException {
        if ("desc.xml".equals(entryName)) {
            try {
                List children;
                Element root = new SAXBuilder().build((InputStream)new ByteArrayInputStream(this.loadData(zipIn))).getRootElement();
                this.setRptName(root.getAttributeValue("name"));
                this.setRptUuid(root.getAttributeValue("uuid"));
                this.setSystemId(root.getAttributeValue("systemId"));
                this.setTemplateType(root.getAttributeValue("templateType"));
                this.setTemplateVersion(root.getAttributeValue("lastUpdTime"));
                this.setCloudRptUuid(root.getAttributeValue("cloudRptUuid"));
                String v = root.getAttributeValue("isRawCloudRpt");
                if (v != null) {
                    this.setRawCloudRpt(Boolean.valueOf(v));
                }
                if ((children = root.getChildren()) != null && !children.isEmpty()) {
                    this.setRptUsageStatus((Element)children.get(0));
                }
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
        } else if ("templateData".equals(entryName)) {
            this.setTemplateData(this.loadData(zipIn));
        }
    }

    private byte[] loadData(ZipInputStream zipIn) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int bufferLen = 1024;
        byte[] data = new byte[bufferLen];
        int len = zipIn.read(data, 0, bufferLen);
        while (len != -1) {
            out.write(data, 0, len);
            len = zipIn.read(data, 0, bufferLen);
        }
        return out.toByteArray();
    }
}

