/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.debug.server.impl;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.eas.rpts.sumreport.data.SnapDataBean;
import com.kingdee.eas.rpts.sumreport.data.TaskDetailInfo;
import com.kingdee.eas.rpts.sumreport.data.TaskDistributeInfo;
import com.kingdee.eas.rpts.sumreport.debug.server.IDebugTaskBOFacade;
import com.kingdee.eas.rpts.sumreport.exceptions.SumTaskException;
import com.kingdee.eas.rpts.sumreport.util.MixUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DebugTaskBOFacade
extends ORMObject
implements IDebugTaskBOFacade {
    public DebugTaskBOFacade() {
        this.registerInterface(IDebugTaskBOFacade.class, this);
    }

    @Override
    public void deleteTask(TaskDistributeInfo[] taskInfos) throws SumTaskException {
        StringBuffer sqlDelTaskBuf = new StringBuffer("DELETE T_EXT_DEBUGTASKDISTRIBUTE WHERE FID IN(");
        StringBuffer sqlDelActivityBuf = new StringBuffer("DELETE T_EXT_DEBUGTASKDETAIL WHERE FTASKDISTRIBUTEID IN(");
        String[] ids = new String[taskInfos.length];
        for (int i = 0; i < taskInfos.length; ++i) {
            ids[i] = taskInfos[i].getId();
            sqlDelTaskBuf.append('\'').append(ids[i]).append("',");
            sqlDelActivityBuf.append('\'').append(ids[i]).append("',");
        }
        sqlDelTaskBuf.setCharAt(sqlDelTaskBuf.length() - 1, ')');
        sqlDelActivityBuf.setCharAt(sqlDelActivityBuf.length() - 1, ')');
        try {
            DbUtil.executeBatchUpdate(new String[]{sqlDelTaskBuf.toString(), sqlDelActivityBuf.toString(), this.getDelSnapshotSQL(ids)});
        }
        catch (SQLException e) {
            throw SumTaskException.wrap(e);
        }
    }

    @Override
    public Collection getTaskDetailsInfoByTask(String taskID) throws SumTaskException {
        ArrayList<TaskDetailInfo> arrayList;
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("SELECT dtd.FID AS Id,dtd.FReportId as ReportId,dtd.FManageOrgID as ManageOrgId,dtd.FSnapState as SnapState, ");
        sqlBuf.append("dtd.FActivityName AS ActivityName,dtd.FParentID as ParentId,dtd.FLeaf as Leaf,TD.FBEGINDATE,TD.FENDDATE");
        sqlBuf.append(" from T_EXT_DebugTaskDetail dtd LEFT OUTER JOIN T_EXT_DebugTaskDistribute TD ON dtd.FTaskDistributeID = TD.FID ");
        sqlBuf.append("where dtd.FTaskDistributeID = ? ORDER BY FLEVEL ASC,FTREEORDER ASC ");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(sqlBuf.toString(), new Object[]{taskID});
            ArrayList<TaskDetailInfo> rsLst = new ArrayList<TaskDetailInfo>(rs.size());
            while (rs.next()) {
                TaskDetailInfo item = new TaskDetailInfo();
                item.setId(rs.getString("Id"));
                item.setReportID(rs.getString("ReportId"));
                item.setManageOrg(rs.getString("ManageOrgId"));
                item.setName(rs.getString("ActivityName"));
                item.setParentID(rs.getString("ParentId"));
                item.setLeaf(rs.getInt("Leaf") == 1);
                item.setHavedSnapshot(rs.getInt("SnapState") == 1);
                item.setBeginDate(rs.getTimestamp("FBeginDate"));
                item.setEndDate(rs.getTimestamp("FEndDate"));
                rsLst.add(item);
            }
            arrayList = rsLst;
        }
        catch (SQLException e) {
            try {
                throw SumTaskException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    @Override
    public List getTaskListByOrgID(String orgID, String local) throws SumTaskException {
        ArrayList<TaskDistributeInfo> arrayList;
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("Select td.fid,td.fnumber, td.FSumRangeID, td.FUpLoadReportID, td.FSumReportID,");
        sqlBuf.append("td.FReportPeriod, td.FOrgID, td.FCreatorID, td.FCreateTime,td.FLastUpdateTime,");
        sqlBuf.append("FWeekBegin,td.FBeginDate,td.FendDate,");
        sqlBuf.append("td.Fname_").append(local).append(" as TaskName, ");
        sqlBuf.append("td.FDes_").append(local).append(" as TaskDes, ");
        sqlBuf.append("sr.Fname_").append(local).append(" as RangeName, ");
        sqlBuf.append("ur.Fname_").append(local).append(" as UploadReportName, ");
        sqlBuf.append("sdr.Fname_").append(local).append(" as SumReportName, ");
        sqlBuf.append("u.Fname_").append(local).append(" as CreatorName, ");
        sqlBuf.append("up.Fname_").append(local).append(" as UpdatorName ");
        sqlBuf.append("from T_EXT_DebugTaskDistribute td ");
        sqlBuf.append("LEFT OUTER JOIN T_EXT_DebugSumRange sr on td.FSumRangeID = sr.fid ");
        sqlBuf.append("LEFT OUTER JOIN T_BAS_DefineReport ur on td.FUpLoadReportID = ur.fid ");
        sqlBuf.append("LEFT OUTER JOIN T_BAS_DefineReport sdr on td.FSumReportID = sdr.fid ");
        sqlBuf.append("LEFT OUTER JOIN t_pm_user u on td.FCreatorID = u.fid ");
        sqlBuf.append("LEFT OUTER JOIN t_pm_user up on td.FUpdatePerson = up.fid ");
        sqlBuf.append("where td.FOrgID = ? ");
        sqlBuf.append("order by td.FCreateTime desc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(sqlBuf.toString(), new Object[]{orgID});
            ArrayList<TaskDistributeInfo> rsLst = new ArrayList<TaskDistributeInfo>(rs.size());
            while (rs.next()) {
                TaskDistributeInfo item = new TaskDistributeInfo();
                item.setId(rs.getString("Fid"));
                item.setNumber(rs.getString("FNumber"));
                item.setSumRangeID(rs.getString("FSumRangeId"));
                item.setUpLoadReportID(rs.getString("FUploadReportId"));
                item.setSumReportID(rs.getString("FSumReportId"));
                item.setReportPeriod(rs.getInt("FReportPeriod"));
                item.setCreateTime(rs.getTimestamp("FCreateTime"));
                item.setLastUpdateTime(rs.getTimestamp("FLastUpdateTime"));
                item.setWeekBegin(rs.getInt("FWeekBegin"));
                item.setBeginTime(rs.getTimestamp("FBeginDate"));
                item.setEndTime(rs.getTimestamp("FEndDate"));
                item.setName(rs.getString("TaskName"), local);
                item.setDes(rs.getString("TaskDes"), local);
                item.setSumRangeName(rs.getString("RangeName"));
                item.setUpLoadReportName(rs.getString("UploadReportName"));
                item.setSumReportName(rs.getString("SumReportName"));
                item.setCreator(rs.getString("CreatorName"));
                item.setUpdatePerson(rs.getString("UpdatorName"));
                rsLst.add(item);
            }
            arrayList = rsLst;
        }
        catch (SQLException e) {
            try {
                throw SumTaskException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    private static String getInsertTaskSQL(TaskDistributeInfo taskInfo) {
        String createTime = MixUtil.getDateFromTimestamp(new Timestamp(new Date().getTime()));
        String periodBeginTime = MixUtil.getDateFromTimestamp(taskInfo.getBeginTime());
        String periodEndTime = MixUtil.getDateFromTimestamp(taskInfo.getEndTime());
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("insert into T_EXT_DebugTaskDistribute(FID,FSumRangeID,FName_l2,FName_l3,FDes_l2,");
        sqlBuf.append("FDes_l3,FUpLoadReportID,FSumReportID,FReportPeriod,FOrgID,FCreatorID,FCreateTime,");
        sqlBuf.append("FBeginDate,FendDate,fnumber) values (");
        sqlBuf.append("'").append(taskInfo.getId()).append("', ");
        sqlBuf.append("'").append(taskInfo.getSumRangeID()).append("', ");
        sqlBuf.append("'").append(taskInfo.getName("l2").replaceAll("'", "''")).append("', ");
        sqlBuf.append("'").append(taskInfo.getName("l2").replaceAll("'", "''")).append("', ");
        sqlBuf.append("'").append(taskInfo.getDes("l2").replaceAll("'", "''")).append("', ");
        sqlBuf.append("'").append(taskInfo.getDes("l3").replaceAll("'", "''")).append("', ");
        sqlBuf.append("'").append(taskInfo.getUpLoadReportID()).append("', ");
        sqlBuf.append("'").append(taskInfo.getSumReportID()).append("', ");
        sqlBuf.append("").append(taskInfo.getReportPeriod()).append(", ");
        sqlBuf.append("'").append(taskInfo.getOrgID()).append("', ");
        sqlBuf.append("'").append(taskInfo.getCreator()).append("', ");
        sqlBuf.append("{ts'").append(createTime).append("'},");
        sqlBuf.append("{ts'").append(periodBeginTime).append("'},");
        sqlBuf.append("{ts'").append(periodEndTime).append("'},'");
        sqlBuf.append(taskInfo.getNumber().replaceAll("'", "''")).append("'");
        sqlBuf.append(")");
        return sqlBuf.toString();
    }

    private static String getInsertActivitySQL(TaskDetailInfo detailInfo) {
        Timestamp now = new Timestamp(new Date().getTime());
        detailInfo.setDistributeTime(now);
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("insert into T_EXT_DebugTaskDetail(FID,FTaskDistributeID,FManageOrgID,");
        sqlBuf.append("FLeaf,FDistributorID,FDistributeTime,FReportID,FActivityName,FTreeOrder,FLevel,FParentID)");
        sqlBuf.append("values('");
        sqlBuf.append(detailInfo.getId()).append("','").append(detailInfo.getTaskDistributeID()).append("','").append(detailInfo.getManageOrg()).append("',").append(detailInfo.isLeaf() ? 1 : 0).append(",'").append(detailInfo.getDistributorID()).append("',{ts'").append(MixUtil.getDateFromTimestamp(detailInfo.getDistributeTime())).append("'},'").append(detailInfo.getReportID()).append("','");
        sqlBuf.append(detailInfo.getName().replaceAll("'", "''")).append("',");
        sqlBuf.append(detailInfo.getTreeOrder()).append(',');
        sqlBuf.append(detailInfo.getLevel());
        sqlBuf.append(",'").append(detailInfo.getParentID()).append('\'');
        sqlBuf.append(")");
        return sqlBuf.toString();
    }

    private static String[] getInsertTaskActivitysSQL(TaskDistributeInfo taskInfo) {
        List activities = taskInfo.getDetailList();
        String sql = DebugTaskBOFacade.getInsertTaskSQL(taskInfo);
        String[] sqls = new String[]{sql};
        if (activities != null && activities.size() > 0) {
            sqls = new String[activities.size() + 1];
            sqls[0] = sql;
            Iterator itor = activities.iterator();
            int i = 1;
            while (itor.hasNext()) {
                sqls[i++] = DebugTaskBOFacade.getInsertActivitySQL((TaskDetailInfo)itor.next());
            }
        }
        return sqls;
    }

    @Override
    public void insertTask(TaskDistributeInfo taskInfo) throws SumTaskException {
        try {
            String[] sqls = DebugTaskBOFacade.getInsertTaskActivitysSQL(taskInfo);
            DbUtil.executeBatchUpdate(sqls);
        }
        catch (SQLException e) {
            throw SumTaskException.wrap(e);
        }
    }

    @Override
    public boolean isExistTaskName(String id, String name, String local) throws SumTaskException {
        Object[] paramObjs;
        StringBuffer sqlBuf = new StringBuffer("SELECT top 1 FID FROM T_EXT_DebugTaskDistribute where ");
        if (StringUtil.isEmptyString((String)id)) {
            sqlBuf.append("fname_").append(local).append(" = ? ");
            paramObjs = new Object[]{name};
        } else {
            sqlBuf.append("fid <> ? and fname_").append(local).append(" = ? ");
            paramObjs = new Object[]{id, name};
        }
        try {
            IRowSet rs = DbUtil.executeQuery(sqlBuf.toString(), paramObjs);
            return rs.next();
        }
        catch (SQLException e) {
            throw SumTaskException.wrap(e);
        }
    }

    private static final String getUpdateTaskDistributeSQL(TaskDistributeInfo taskInfo) {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("UPDATE T_EXT_DEBUGTaskDistribute set ");
        sbSQL.append("fnumber = '").append(taskInfo.getNumber().replaceAll("'", "''")).append("', ");
        sbSQL.append("FName_l2 = '").append(taskInfo.getName("l2").replaceAll("'", "''")).append("', ");
        sbSQL.append("FName_l3 = '").append(taskInfo.getName("l3").replaceAll("'", "''")).append("', ");
        sbSQL.append("FDES_L2 = '").append(taskInfo.getDes("l2").replaceAll("'", "''")).append("', ");
        sbSQL.append("FDES_L3 = '").append(taskInfo.getDes("l3").replaceAll("'", "''")).append("', ");
        sbSQL.append("fbegindate = {ts'").append(MixUtil.getDateFromTimestamp(taskInfo.getBeginTime())).append("'}, ");
        sbSQL.append("fenddate = {ts'").append(MixUtil.getDateFromTimestamp(taskInfo.getEndTime())).append("'}, ");
        sbSQL.append("FLASTUPDATETIME ={ts' ").append(MixUtil.getToDay()).append("'}, ");
        sbSQL.append("FUPDATEPERSON = '").append(taskInfo.getUpdatePerson()).append("', ");
        sbSQL.append("FUpLoadReportID = '").append(taskInfo.getUpLoadReportID()).append("', ");
        sbSQL.append("FSumReportID = '").append(taskInfo.getSumReportID()).append("', ");
        sbSQL.append("FReportPeriod = ").append(taskInfo.getReportPeriod()).append(",");
        sbSQL.append("FWeekBegin = ").append(taskInfo.getWeekBegin()).append("");
        sbSQL.append("WHERE FID = '").append(taskInfo.getId()).append("'");
        return sbSQL.toString();
    }

    @Override
    public boolean updateTask(TaskDistributeInfo oldVO, TaskDistributeInfo newVO) throws SumTaskException {
        StringBuffer sqlDelActivitys = new StringBuffer("DELETE T_EXT_DebugTaskDetail WHERE FTASKDISTRIBUTEID = '");
        sqlDelActivitys.append(oldVO.getId()).append('\'');
        List activities = newVO.getDetailList();
        boolean updateSnapshot = activities != null && activities.size() > 0;
        String[] sqls = new String[newVO.getDetailList().size() + 2 + (updateSnapshot ? 1 : 0)];
        sqls[0] = sqlDelActivitys.toString();
        sqls[1] = DebugTaskBOFacade.getUpdateTaskDistributeSQL(newVO);
        if (updateSnapshot) {
            String[] ids = new String[activities.size()];
            int size = activities.size();
            for (int i = 0; i < size; ++i) {
                TaskDetailInfo activity = (TaskDetailInfo)activities.get(i);
                ids[i] = activity.getId();
            }
            sqls[2] = this.getDelSnapshotSQL(ids);
        }
        String[] sqlInsActivities = DebugTaskBOFacade.getInsertTaskActivitysSQL(newVO);
        System.arraycopy(sqlInsActivities, 1, sqls, 2 + (updateSnapshot ? 1 : 0), sqlInsActivities.length - 1);
        try {
            DbUtil.executeBatchUpdate(sqls);
            return true;
        }
        catch (SQLException e) {
            throw SumTaskException.wrap(e);
        }
    }

    public static String getUpdateActivityStateSQL(int state) {
        return "UPDATE T_EXT_DEBUGTASKDETAIL SET FSNAPSTATE = " + state;
    }

    @Override
    public boolean updateTask(TaskDistributeInfo newVO, Set updateSet, List delList, boolean updateUploadTemplate, boolean updateSumTemplate) throws SumTaskException {
        String[] sqls;
        block17: {
            block16: {
                boolean del;
                boolean update = updateSet.size() > 0;
                int size = 1 + (update && !updateUploadTemplate ? 1 : 0) + ((del = delList.size() > 0) ? 1 : 0) + (updateUploadTemplate ? 1 : (updateSumTemplate ? 1 : 0));
                if (size > 1) {
                    ++size;
                }
                sqls = new String[size];
                sqls[0] = DebugTaskBOFacade.getUpdateTaskDistributeSQL(newVO);
                Iterator itor = delList.iterator();
                StringBuffer updateActivitySQL = null;
                int i = 1;
                if (del) {
                    updateActivitySQL = new StringBuffer("DELETE T_EXT_DebugTaskDetail WHERE FID IN (");
                    while (itor.hasNext()) {
                        updateActivitySQL.append('\'').append(itor.next()).append("',");
                    }
                    updateActivitySQL.setCharAt(updateActivitySQL.length() - 1, ')');
                    sqls[i++] = updateActivitySQL.toString();
                }
                updateActivitySQL = null;
                if (updateUploadTemplate) {
                    updateActivitySQL = new StringBuffer(DebugTaskBOFacade.getUpdateActivityStateSQL(0));
                    updateActivitySQL.append(" WHERE FTASKDISTRIBUTEID = '").append(newVO.getId()).append('\'');
                    sqls[i++] = updateActivitySQL.toString();
                } else {
                    if (update) {
                        updateActivitySQL = new StringBuffer(DebugTaskBOFacade.getUpdateActivityStateSQL(0));
                        updateActivitySQL.append(" WHERE FID IN(");
                        itor = updateSet.iterator();
                        while (itor.hasNext()) {
                            updateActivitySQL.append('\'').append(itor.next()).append("',");
                        }
                        updateActivitySQL.setCharAt(updateActivitySQL.length() - 1, ')');
                        sqls[i++] = updateActivitySQL.toString();
                    }
                    if (updateSumTemplate) {
                        updateActivitySQL = new StringBuffer(DebugTaskBOFacade.getUpdateActivityStateSQL(0));
                        updateActivitySQL.append(" WHERE FTASKDISTRIBUTEID = '").append(newVO.getId()).append("' AND FLeaf = 0");
                        sqls[i++] = updateActivitySQL.toString();
                    }
                }
                IRowSet rs = null;
                if (!updateUploadTemplate) break block16;
                try {
                    rs = DbUtil.executeQuery("SELECT FID AS ID FROM T_EXT_DEBUGTASKDETAIL WHERE FTASKDISTRIBUTEID = ?", new Object[]{newVO.getId()});
                    String[] delSnapshotSqls = new String[rs.size()];
                    int r = 0;
                    while (rs.next()) {
                        delSnapshotSqls[r++] = rs.getString("ID");
                    }
                    sqls[i++] = this.getDelSnapshotSQL(delSnapshotSqls);
                }
                catch (SQLException e) {
                    try {
                        throw SumTaskException.wrap(e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs);
                break block17;
            }
            updateSet.addAll(delList);
            if (updateSet.size() > 0) {
                sqls[i++] = this.getDelSnapshotSQL(updateSet.toArray(new String[updateSet.size()]));
            }
        }
        try {
            DbUtil.executeBatchUpdate(sqls);
            return true;
        }
        catch (SQLException e) {
            throw SumTaskException.wrap(e);
        }
    }

    private String getDelSnapshotSQL(String[] activityIDs) {
        StringBuffer delSqlBuf = new StringBuffer("DELETE T_EXT_DebugSnapContent WHERE FID IN (");
        int len = activityIDs.length;
        for (int i = 0; i < len; ++i) {
            delSqlBuf.append('\'').append(activityIDs[i]).append("',");
        }
        delSqlBuf.setCharAt(delSqlBuf.length() - 1, ')');
        return delSqlBuf.toString();
    }

    @Override
    public void delSnaphost(String[] activityIDs) throws SumTaskException {
        if (activityIDs == null || activityIDs.length == 0) {
            return;
        }
        String delSql = this.getDelSnapshotSQL(activityIDs);
        String[] sqls = new String[2];
        try {
            sqls[0] = delSql;
            StringBuffer delSqlBuf = new StringBuffer("UPDATE T_EXT_DebugTaskDetail SET FSnapState = 0 WHERE FID IN (");
            for (int i = 0; i < activityIDs.length; ++i) {
                delSqlBuf.append('\'').append(activityIDs[i]).append("',");
            }
            delSqlBuf.setCharAt(delSqlBuf.length() - 1, ')');
            sqls[1] = delSqlBuf.toString();
            DbUtil.executeBatchUpdate(sqls);
        }
        catch (SQLException e) {
            throw SumTaskException.wrap(e);
        }
    }

    @Override
    public void insertSnapshot(String activityID, SnapDataBean[] entitys) throws SumTaskException {
        try {
            ArrayList<Object> params = new ArrayList<Object>(entitys.length * 4);
            int len = entitys.length;
            for (int i = 0; i < len; ++i) {
                params.add(activityID);
                params.add(new Integer(i));
                params.add(entitys[i].getBlock());
                params.add(new Integer(entitys[i].getSize()));
            }
            String sql = "insert into T_EXT_DebugSnapContent(fid,FBlockIndex,FContent,FLength) values(?,?,?,?)";
            DbUtil.executeBatchUpdate(sql, params, 4, DebugTaskBOFacade.getUpdateActivityStateSQL(1) + " WHERE FID = '" + activityID + "'");
        }
        catch (SQLException e) {
            throw SumTaskException.wrap("\u4fdd\u5b58\u5feb\u7167\u6570\u636e\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public Map queryChildsId2DataMap(String activityID) throws SumTaskException {
        HashMap<String, byte[]> hashMap;
        StringBuffer sqlBuf = new StringBuffer("SELECT SC.FID AS ID, SC.FBLOCKINDEX AS BINDEX,SC.FCONTENT AS DATA,SC.FLENGTH AS LENGTH FROM ");
        sqlBuf.append(" T_EXT_DEBUGSNAPCONTENT SC LEFT OUTER JOIN T_EXT_DEBUGTASKDETAIL TD ON SC.FID = TD.FID WHERE TD.FPARENTID = ?");
        sqlBuf.append(" ORDER BY SC.FID ASC, SC.FBLOCKINDEX DESC");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(sqlBuf.toString(), new Object[]{activityID});
            HashMap<String, byte[]> rsMap = new HashMap<String, byte[]>(rs.size());
            if (rs.next()) {
                boolean breakAll = false;
                do {
                    String id = rs.getString("ID");
                    int size = rs.getInt("BINDEX") + 1;
                    SnapDataBean[] beans = new SnapDataBean[size];
                    int index = 0;
                    for (int i = size - 1; i >= 0; --i) {
                        int length = rs.getInt("LENGTH");
                        byte[] block = new byte[length];
                        try {
                            InputStream in = rs.getBlob("DATA").getBinaryStream();
                            try {
                                in.read(block);
                            }
                            catch (IOException e) {
                                throw SumTaskException.wrap(e);
                            }
                        }
                        catch (SQLException e) {
                            block = rs.getBytes("DATA");
                        }
                        beans[index++] = new SnapDataBean(block, length);
                        if (rs.next()) continue;
                        breakAll = true;
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    for (int i = beans.length - 1; i >= 0; --i) {
                        out.write(beans[i].getBlock(), 0, beans[i].getSize());
                        beans[i].GCBlock();
                    }
                    rsMap.put(id, out.toByteArray());
                } while (!breakAll);
            }
            hashMap = rsMap;
        }
        catch (SQLException e) {
            try {
                throw SumTaskException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return hashMap;
    }

    @Override
    public Map queryChildsId2NameMap(String activityID) throws SumTaskException {
        HashMap<String, String> hashMap;
        StringBuffer sqlBuf = new StringBuffer("SELECT FID AS ID ,FACTIVITYNAME AS NAME FROM T_EXT_DebugTaskDetail WHERE FPARENTID = '");
        sqlBuf.append(activityID).append('\'');
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(sqlBuf.toString(), null);
            HashMap<String, String> id2Name = new HashMap<String, String>(rs.size());
            while (rs.next()) {
                id2Name.put(rs.getString("ID"), rs.getString("NAME"));
            }
            hashMap = id2Name;
        }
        catch (SQLException e) {
            try {
                throw SumTaskException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return hashMap;
    }

    @Override
    public void updateSnapshot(String activityID, SnapDataBean[] entitys) throws SumTaskException {
        try {
            ArrayList<Object> params = new ArrayList<Object>(entitys.length * 4);
            int len = entitys.length;
            for (int i = 0; i < len; ++i) {
                params.add(activityID);
                params.add(new Integer(i));
                params.add(entitys[i].getBlock());
                params.add(new Integer(entitys[i].getSize()));
            }
            String sql = "insert into T_EXT_DebugSnapContent(fid,FBlockIndex,FContent,FLength) values(?,?,?,?)";
            StringBuffer delSql = new StringBuffer("delete from T_EXT_DebugSnapContent where fid ='");
            delSql.append(activityID).append('\'');
            DbUtil.executeBatchUpdate(sql, params, 4, delSql.toString());
        }
        catch (SQLException e) {
            throw SumTaskException.wrap("\u4fdd\u5b58\u5feb\u7167\u6570\u636e\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public byte[] querySnapshotByID(String activityID) throws SumTaskException {
        StringBuffer sqlBuf = new StringBuffer("SELECT FID AS ID,FCONTENT AS DATA,FLENGTH AS LENGTH FROM");
        sqlBuf.append(" T_EXT_DEBUGSNAPCONTENT WHERE FID =? ORDER BY FID,FBLOCKINDEX");
        try {
            IRowSet rs = DbUtil.executeQuery(sqlBuf.toString(), new Object[]{activityID});
            SnapDataBean[] beans = new SnapDataBean[rs.size()];
            int index = 0;
            while (rs.next()) {
                int length = rs.getInt("LENGTH");
                byte[] block = new byte[length];
                try {
                    InputStream in = rs.getBlob("DATA").getBinaryStream();
                    try {
                        in.read(block);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (SQLException e) {
                    block = rs.getBytes("DATA");
                }
                beans[index++] = new SnapDataBean(block, length);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (int i = 0; i < beans.length; ++i) {
                out.write(beans[i].getBlock(), 0, beans[i].getSize());
                beans[i].GCBlock();
            }
            return out.toByteArray();
        }
        catch (SQLException e) {
            throw SumTaskException.wrap("\u67e5\u8be2\u5feb\u7167\u6570\u636e\u5931\u8d25\uff01", e);
        }
    }
}

