/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.debug.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.eas.rpts.sumreport.data.SumRangeInfo;
import com.kingdee.eas.rpts.sumreport.data.SumUnitInfo;
import com.kingdee.eas.rpts.sumreport.data.SumUnitOrgInfo;
import com.kingdee.eas.rpts.sumreport.debug.server.IDebugSumRangeBOFacade;
import com.kingdee.eas.rpts.sumreport.debug.server.impl.DebugSumRangeBOFacade;
import com.kingdee.eas.rpts.sumreport.exceptions.SumRangeException;
import com.kingdee.eas.rpts.sumreport.model.InfoException;
import com.kingdee.eas.rpts.sumreport.service.inf.ISumRangeService;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class DebugSumRangeService
implements ISumRangeService {
    private IDebugSumRangeBOFacade _facade;

    private IDebugSumRangeBOFacade getFacade() throws SumRangeException {
        if (this._facade == null) {
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            try {
                this._facade = (IDebugSumRangeBOFacade)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)DebugSumRangeBOFacade.class.getName(), IDebugSumRangeBOFacade.class);
            }
            catch (BOSException e) {
                throw SumRangeException.wrap("Initial summary task facade error.", (Exception)((Object)e));
            }
        }
        return this._facade;
    }

    @Override
    public void newSumRange(SumRangeInfo vo) throws SumRangeException, InfoException {
        this.varifyUnSame(vo);
        this.getFacade().insertSumRange(vo);
    }

    public void varifyUnSame(SumRangeInfo vo) throws InfoException, SumRangeException {
        if (this.getFacade().isExistRangeNumber(vo.getId(), vo.getNumber())) {
            throw new InfoException("\u5df2\u5b58\u5728\u8be5\u7f16\u7801\u7684\u6c47\u603b\u8303\u56f4\uff0c\u8bf7\u66f4\u6539\u7f16\u7801", 2);
        }
        if (this.getFacade().isExistRangeName(vo.getId(), vo.getName(), EASUtil.gelLoginLocal())) {
            throw new InfoException("\u5df2\u5b58\u5728\u8be5\u540d\u79f0\u7684\u6c47\u603b\u8303\u56f4\uff0c\u8bf7\u66f4\u6539\u540d\u79f0", 3);
        }
    }

    @Override
    public void newVersion(SumRangeInfo info, String srcRangeID) throws InfoException, SumRangeException {
        SumRangeInfo vo = (SumRangeInfo)info.clone();
        vo.setId(null);
        this.varifyUnSame(vo);
        String nRangeID = UID.create((int)44);
        vo.setId(nRangeID);
        Timestamp createTime = new Timestamp(new Date().getTime());
        vo.setCreateTime(createTime);
        vo.setUsingFlag(0);
        String local = EASUtil.gelLoginLocal();
        List rsUnitLst = this.getFacade().getCurrentOrgUnitListByRangeID(srcRangeID, local);
        if (rsUnitLst != null) {
            HashMap<String, String> idMap = new HashMap<String, String>(rsUnitLst.size());
            if (rsUnitLst.size() >= 1) {
                ArrayList<SumUnitInfo> unitLst = new ArrayList<SumUnitInfo>(rsUnitLst.size());
                int size = rsUnitLst.size();
                for (int i = 0; i < size; ++i) {
                    SumUnitInfo uItem = (SumUnitInfo)rsUnitLst.get(i);
                    String oldID = uItem.getId();
                    String pID = uItem.getParentID();
                    String newID = UID.create((int)44);
                    if (idMap.containsKey(pID)) {
                        String nPID = (String)idMap.get(pID);
                        uItem.setParentID(nPID);
                    }
                    idMap.put(oldID, newID);
                    uItem.setId(newID);
                    uItem.setSumRangeID(nRangeID);
                    uItem.setCreateTime(createTime);
                    unitLst.add(uItem);
                }
                vo.setUnitList(unitLst);
            }
            List rsOrgsLst = this.getFacade().getOrgListByRangeID(srcRangeID, local);
            ArrayList<SumUnitOrgInfo> orgLst = new ArrayList<SumUnitOrgInfo>(rsOrgsLst.size());
            if (null != rsOrgsLst && rsOrgsLst.size() >= 1) {
                int size = rsOrgsLst.size();
                for (int i = 0; i < size; ++i) {
                    SumUnitOrgInfo oItem = (SumUnitOrgInfo)rsOrgsLst.get(i);
                    oItem.setSumUnitID((String)idMap.get(oItem.getSumUnitID()));
                    oItem.setSumRangeID(nRangeID);
                    oItem.setCreateTime(createTime);
                    orgLst.add(oItem);
                }
            }
            vo.setOrgList(orgLst);
        }
        this.getFacade().addNewVersion(vo, srcRangeID, local);
    }

    @Override
    public void updateSumRange(SumRangeInfo vo) throws SumRangeException, InfoException {
        vo.setLastUpdateTime(new Timestamp(new Date().getTime()));
        if (this.getFacade().isExistRangeNumber(vo.getId(), vo.getNumber())) {
            throw new InfoException("\u5df2\u5b58\u5728\u8be5\u7f16\u7801\u7684\u6c47\u603b\u8303\u56f4\uff0c\u8bf7\u66f4\u6539\u7f16\u7801", 2);
        }
        if (this.getFacade().isExistRangeName(vo.getId(), vo.getName(), "l2")) {
            throw new InfoException("\u5df2\u5b58\u5728\u8be5\u540d\u79f0\u7684\u6c47\u603b\u8303\u56f4\uff0c\u8bf7\u66f4\u6539\u540d\u79f0", 3);
        }
        this.getFacade().updateSumRange(vo);
    }

    @Override
    public void deleteSumRange(ArrayList ranges) throws SumRangeException {
        this.getFacade().deleteSumRange(ranges);
    }

    @Override
    public List queryAllSumRange(String localString) throws SumRangeException {
        return this.getFacade().getRangList(localString);
    }

    @Override
    public List getLaunchedRanges(String localString) throws SumRangeException {
        return this.getFacade().getRangeList4F7(localString);
    }

    @Override
    public List getSumRangeUnitList(List sumRangeInfoList) throws BOSException {
        if (sumRangeInfoList == null || sumRangeInfoList.size() == 0) {
            return null;
        }
        return this.getFacade().getSumRangeUnitList(sumRangeInfoList);
    }

    @Override
    public List getSumUnitOrgListByRangeID(String rangeID, String localString) throws BOSException {
        List sumUnitOrgList = null;
        if (rangeID != null && !"".equals(rangeID)) {
            sumUnitOrgList = this.getFacade().getOrgListByRangeID2(rangeID, localString);
        }
        return sumUnitOrgList;
    }

    @Override
    public boolean getExistSumRangeMsg(List sumRangeInfoList, StringBuffer errorMsg, int whichSubClass, KDFrame parentUI) throws BOSException {
        return false;
    }
}

