/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.sumreport.client.sumrange.importexport.ImportSumRangeEditUI;
import com.kingdee.eas.rpts.sumreport.data.F7VO;
import com.kingdee.eas.rpts.sumreport.data.SumRangeInfo;
import com.kingdee.eas.rpts.sumreport.data.SumUnitInfo;
import com.kingdee.eas.rpts.sumreport.data.SumUnitOrgInfo;
import com.kingdee.eas.rpts.sumreport.debug.server.IDebugSumRangeBOFacade;
import com.kingdee.eas.rpts.sumreport.debug.server.impl.DebugSumRangeBOFacade;
import com.kingdee.eas.rpts.sumreport.exceptions.SumRangeException;
import com.kingdee.eas.rpts.sumreport.model.InfoException;
import com.kingdee.eas.rpts.sumreport.server.ISumRangeBOFacade;
import com.kingdee.eas.rpts.sumreport.server.impl.SumRangeBOFacade;
import com.kingdee.eas.rpts.sumreport.service.inf.ISumRangeService;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import com.kingdee.eas.rpts.sumreport.util.MixUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class SumRangeService
implements ISumRangeService {
    private ISumRangeBOFacade _facade;
    private IDebugSumRangeBOFacade _debugFacade;

    public ISumRangeBOFacade getFacade() throws SumRangeException {
        if (this._facade == null) {
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            try {
                this._facade = (ISumRangeBOFacade)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)SumRangeBOFacade.class.getName(), ISumRangeBOFacade.class);
            }
            catch (BOSException e) {
                throw SumRangeException.wrap("Initial summary task facade error.", (Exception)((Object)e));
            }
        }
        return this._facade;
    }

    private IDebugSumRangeBOFacade getDebugFacade() throws SumRangeException {
        if (this._facade == null) {
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            try {
                this._debugFacade = (IDebugSumRangeBOFacade)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)DebugSumRangeBOFacade.class.getName(), IDebugSumRangeBOFacade.class);
            }
            catch (BOSException e) {
                throw SumRangeException.wrap("Initial summary task facade error.", (Exception)((Object)e));
            }
        }
        return this._debugFacade;
    }

    @Override
    public void newSumRange(SumRangeInfo vo) throws BOSException, InfoException {
        this.varifyUnSame(vo);
        this.getFacade().insertSumRange(vo);
    }

    @Override
    public void updateSumRange(SumRangeInfo vo) throws BOSException, InfoException {
        vo.setLastUpdateTime(new Timestamp(new Date().getTime()));
        if (this.getFacade().isExistRangeNumber(vo.getId(), vo.getNumber())) {
            throw new InfoException("\u5df2\u5b58\u5728\u8be5\u7f16\u7801\u7684\u6c47\u603b\u8303\u56f4\uff0c\u8bf7\u66f4\u6539\u7f16\u7801", 2);
        }
        if (this.getFacade().isExistRangeName(vo.getId(), vo.getName(), "l2")) {
            throw new InfoException("\u5df2\u5b58\u5728\u8be5\u540d\u79f0\u7684\u6c47\u603b\u8303\u56f4\uff0c\u8bf7\u66f4\u6539\u540d\u79f0", 3);
        }
        this.getFacade().updateSumRange(vo);
    }

    public void startSumRange(ArrayList ranges) throws BOSException {
        ArrayList<String> canStart = new ArrayList<String>();
        int size = ranges.size();
        for (int i = 0; i < size; ++i) {
            SumRangeInfo item = (SumRangeInfo)ranges.get(i);
            if (item.getUsingFlag() == 1) continue;
            canStart.add(item.getId());
        }
        this.getFacade().setSumRangeUsing(canStart, 1);
    }

    public List stopSumRange(ArrayList ranges) throws BOSException {
        ArrayList<String> canStop = new ArrayList<String>();
        ArrayList<SumRangeInfo> cannotStop = new ArrayList<SumRangeInfo>();
        int size = ranges.size();
        for (int i = 0; i < size; ++i) {
            SumRangeInfo item = (SumRangeInfo)ranges.get(i);
            if (item.getUsingFlag() != 0 && this.getFacade().isCanStopRange(item.getId())) {
                canStop.add(item.getId());
                continue;
            }
            cannotStop.add(item);
        }
        this.getFacade().setSumRangeUsing(canStop, 2);
        return cannotStop;
    }

    @Override
    public void deleteSumRange(ArrayList ranges) throws BOSException {
        ArrayList<String> unRef = new ArrayList<String>();
        int size = ranges.size();
        for (int i = 0; i < size; ++i) {
            SumRangeInfo item = (SumRangeInfo)ranges.get(i);
            if (item.getUsingFlag() != 0 || this.getFacade().isRangeReference(item.getId())) continue;
            unRef.add(item.getId());
        }
        this.getFacade().deleteSumRange(unRef);
    }

    public void varifyUnSame(SumRangeInfo vo) throws InfoException, BOSException {
        if (this.getFacade().isExistRangeNumber(vo.getId(), vo.getNumber())) {
            throw new InfoException("\u5df2\u5b58\u5728\u8be5\u7f16\u7801\u7684\u6c47\u603b\u8303\u56f4\uff0c\u8bf7\u66f4\u6539\u7f16\u7801", 2);
        }
        if (this.getFacade().isExistRangeName(vo.getId(), vo.getName(), EASUtil.gelLoginLocal())) {
            throw new InfoException("\u5df2\u5b58\u5728\u8be5\u540d\u79f0\u7684\u6c47\u603b\u8303\u56f4\uff0c\u8bf7\u66f4\u6539\u540d\u79f0", 3);
        }
    }

    @Override
    public List queryAllSumRange(String localString) throws BOSException {
        return this.getFacade().getRangList(localString);
    }

    @Override
    public List getSumRangeUnitList(List sumRangeInfoList) throws BOSException {
        if (sumRangeInfoList == null || sumRangeInfoList.size() == 0) {
            return null;
        }
        return this.getFacade().getSumRangeUnitList(sumRangeInfoList);
    }

    @Override
    public boolean getExistSumRangeMsg(List sumRangeInfoList, StringBuffer errorMsg, int whichSubClass, KDFrame parentUI) throws BOSException {
        List dupSumRangeInfoList = this.getDupSumRangeInfoList(sumRangeInfoList, whichSubClass);
        return this.doCheck(sumRangeInfoList, dupSumRangeInfoList, errorMsg, whichSubClass, parentUI);
    }

    private List getDupSumRangeInfoList(List sumRangeInfoList, int whichSubClass) throws SumRangeException, BOSException {
        List dupSumRangeInfoList = null;
        switch (whichSubClass) {
            case 0: {
                dupSumRangeInfoList = this.getFacade().getSumRangeListByNumber(sumRangeInfoList);
                break;
            }
            case 1: {
                dupSumRangeInfoList = this.getDebugFacade().getSumRangeListByNumber(sumRangeInfoList);
            }
        }
        return dupSumRangeInfoList;
    }

    private boolean doCheck(List sumRangeInfoList, List dupSumRangeInfoList, StringBuffer errorMsg, int whichSubClass, KDFrame parentUI) throws BOSException {
        Map unDupNumSumRange = this.getUnDupSumRangInfoAndCreateErrMsg(sumRangeInfoList, dupSumRangeInfoList, errorMsg);
        unDupNumSumRange = this.popupSaveEditUI(sumRangeInfoList, unDupNumSumRange, errorMsg, whichSubClass, parentUI);
        ArrayList manageOrgList = new ArrayList();
        for (SumRangeInfo sumRangeInfo : unDupNumSumRange.values()) {
            List unitList = sumRangeInfo.getUnitList();
            this.checkImportSumUnitDup(sumRangeInfo, unitList, errorMsg, manageOrgList);
            this.addSumUnitOrgIntoManageList(manageOrgList, sumRangeInfo.getOrgList());
        }
        boolean isAllSuccess = true;
        if (unDupNumSumRange != null && unDupNumSumRange.size() > 0) {
            List existManageOrgList = null;
            switch (whichSubClass) {
                case 0: {
                    existManageOrgList = this.getFacade().getOrgUnitListBaseNumber(manageOrgList);
                    break;
                }
                case 1: {
                    existManageOrgList = this.getDebugFacade().getOrgUnitListBaseNumber(manageOrgList);
                }
            }
            Map existOrgNumMap = this.getExistOrgNumMap(existManageOrgList);
            StringBuffer orgNotExistErrorMsg = new StringBuffer();
            this.filterSumUnitList(unDupNumSumRange, existOrgNumMap, orgNotExistErrorMsg);
            if (orgNotExistErrorMsg.length() > 0) {
                errorMsg.append(orgNotExistErrorMsg);
            }
            isAllSuccess = this.insertData(unDupNumSumRange, errorMsg, whichSubClass);
        }
        return isAllSuccess;
    }

    private Map popupSaveEditUI(List sumRangeInfoList, Map unDupNumSumRange, StringBuffer errorMsg, int whichSubClass, final KDFrame parentUI) throws SumRangeException, BOSException {
        if (unDupNumSumRange == null || unDupNumSumRange.size() == 0) {
            String msg = errorMsg.toString().replaceFirst("\u4ee5\u4e0b\u6c47\u603b\u8303\u56f4\u5bfc\u5165\u5931\u8d25\\\uff1a", "\u4ee5\u4e0b\u4fe1\u606f\u4e0e\u7cfb\u7edf\u4e2d\u5df2\u6709\u7684\u6c47\u603b\u8303\u56f4\u91cd\u590d\uff1a");
            final ImportSumRangeEditUI _editUI = new ImportSumRangeEditUI((Frame)parentUI, msg);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        _editUI.setSize(new Dimension(300, 200));
                        _editUI.setModal(true);
                        _editUI.setTitle("\u8bf7\u91cd\u65b0\u8f93\u5165\u6c47\u603b\u8303\u56f4\u7f16\u7801\u548c\u540d\u79f0");
                        _editUI.setDefaultCloseOperation(2);
                        _editUI.setLocationRelativeTo((Component)parentUI);
                        _editUI.setVisible(true);
                    }
                });
            }
            catch (InterruptedException e) {
                throw SumRangeException.wrap(e);
            }
            catch (InvocationTargetException e) {
                throw SumRangeException.wrap(e);
            }
            SumRangeInfo info = _editUI.getInfo();
            if (info != null && !StringUtil.isEmptyString((String)info.getNumber()) && !StringUtil.isEmptyString((String)info.getName()) && sumRangeInfoList != null && sumRangeInfoList.size() > 0) {
                int size = sumRangeInfoList.size();
                for (int i = 0; i < size; ++i) {
                    SumRangeInfo sumRangeInfo = (SumRangeInfo)sumRangeInfoList.get(i);
                    sumRangeInfo.setNumber(this.removeQuotes(info.getNumber()));
                    sumRangeInfo.setName(this.removeQuotes(info.getName("l1")), "l1");
                    sumRangeInfo.setName(this.removeQuotes(info.getName("l2")), "l2");
                    sumRangeInfo.setName(this.removeQuotes(info.getName("l3")), "l3");
                    errorMsg.setLength(0);
                    List dupSumRangeInfoList = this.getDupSumRangeInfoList(sumRangeInfoList, whichSubClass);
                    unDupNumSumRange = this.getUnDupSumRangInfoAndCreateErrMsg(sumRangeInfoList, dupSumRangeInfoList, errorMsg);
                    unDupNumSumRange = this.popupSaveEditUI(sumRangeInfoList, unDupNumSumRange, errorMsg, whichSubClass, parentUI);
                }
            }
        }
        return unDupNumSumRange;
    }

    protected String removeQuotes(String text) {
        String string = text = text == null ? "" : text;
        if (text.indexOf("'") != -1) {
            text = text.replaceAll("'", "''");
        }
        return text;
    }

    private boolean insertData(Map unDupNumSumRange, StringBuffer errorMsg, int whichSubClass) throws BOSException {
        boolean isAllSuccess;
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        Map errorMsgMap = null;
        switch (whichSubClass) {
            case 0: {
                errorMsgMap = this.getFacade().batchInsertSumRange(unDupNumSumRange, userId);
                break;
            }
            case 1: {
                errorMsgMap = this.getDebugFacade().batchInsertSumRange(unDupNumSumRange, userId);
            }
        }
        String successMsg = null;
        String otherError = null;
        if (null != errorMsgMap) {
            successMsg = (String)errorMsgMap.get("successMsg");
            otherError = (String)errorMsgMap.get("errorMsg");
        }
        boolean bl = isAllSuccess = errorMsg.length() <= 0;
        if (null != otherError && otherError.length() > 0) {
            errorMsg.append(otherError);
            isAllSuccess = false;
        }
        if (null != successMsg && successMsg.length() > 0) {
            errorMsg.insert(0, successMsg);
        }
        return isAllSuccess;
    }

    private void filterSumUnitList(Map unDupNumSumRange, Map existOrgNumMap, StringBuffer orgNotExistErrorMsg) {
        for (SumRangeInfo sumRangeInfo : unDupNumSumRange.values()) {
            List unitList = sumRangeInfo.getUnitList();
            List orgList = sumRangeInfo.getOrgList();
            this.addUnitIdIntoListRemoveUnexisUnit(unitList, orgList, existOrgNumMap, sumRangeInfo, orgNotExistErrorMsg);
        }
    }

    private void addUnitIdIntoListRemoveUnexisUnit(List unitList, List orgList, Map existOrgNumMap, SumRangeInfo sumRangeInfo, StringBuffer orgNotExistErrorMsg) {
        if (unitList == null || unitList.size() == 0) {
            return;
        }
        SumUnitInfo sumUnitInfo = null;
        boolean isDeleteSumUnit = false;
        StringBuffer otherError = new StringBuffer();
        for (int i = unitList.size() - 1; i >= 0; --i) {
            isDeleteSumUnit = false;
            sumUnitInfo = (SumUnitInfo)unitList.get(i);
            if (existOrgNumMap.containsKey(sumUnitInfo.getOrgNumber())) {
                sumUnitInfo.setManageOrgID((String)existOrgNumMap.get(sumUnitInfo.getOrgNumber()));
            } else {
                unitList.remove(i);
                if (orgNotExistErrorMsg.length() == 0) {
                    orgNotExistErrorMsg.append("\u4ee5\u4e0b\u6c47\u603b\u8303\u56f4\u4e0b\u6c47\u603b\u5355\u5143\u7684\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u6c47\u603b\u5355\u5143\u4e0d\u80fd\u5bfc\u5165\uff1a\n");
                }
                orgNotExistErrorMsg.append("  \u6c47\u603b\u8303\u56f4\u7f16\u7801\uff1a").append(sumRangeInfo.getNumber()).append("  ");
                orgNotExistErrorMsg.append("\u6c47\u603b\u5355\u5143\u7f16\u7801\uff1a").append(sumUnitInfo.getNumber()).append("  ");
                orgNotExistErrorMsg.append("\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801\uff1a").append(sumUnitInfo.getOrgNumber()).append("\n");
                isDeleteSumUnit = true;
            }
            this.addOrgIdIntoOrgListRemoveUnexisOrg(orgList, sumUnitInfo, existOrgNumMap, sumRangeInfo, isDeleteSumUnit, otherError);
        }
        if (otherError.length() > 0) {
            orgNotExistErrorMsg.append(otherError);
        }
    }

    private void addOrgIdIntoOrgListRemoveUnexisOrg(List orgList, SumUnitInfo sumUnitInfo, Map existOrgNumMap, SumRangeInfo sumRangeInfo, boolean isDeleteSumUnit, StringBuffer orgNotExistErrorMsg) {
        if (orgList == null || orgList.size() == 0) {
            return;
        }
        SumUnitOrgInfo sumUnitOrgInfo = null;
        for (int i = orgList.size() - 1; i >= 0; --i) {
            sumUnitOrgInfo = (SumUnitOrgInfo)orgList.get(i);
            if (isDeleteSumUnit) {
                if (!sumUnitInfo.getId().equals(sumUnitOrgInfo.getSumUnitID())) continue;
                orgList.remove(i);
                continue;
            }
            if (!StringUtil.isEmptyString((String)sumUnitOrgInfo.getSumUnitID()) && !sumUnitInfo.getId().equals(sumUnitOrgInfo.getSumUnitID())) continue;
            if (existOrgNumMap.containsKey(sumUnitOrgInfo.getOrgNumber())) {
                sumUnitOrgInfo.setOrgID((String)existOrgNumMap.get(sumUnitOrgInfo.getOrgNumber()));
                continue;
            }
            this.addErrorMsgRemoveOrg(orgList, sumUnitInfo, sumRangeInfo, orgNotExistErrorMsg, sumUnitOrgInfo, i);
        }
    }

    private void addErrorMsgRemoveOrg(List orgList, SumUnitInfo sumUnitInfo, SumRangeInfo sumRangeInfo, StringBuffer otherError, SumUnitOrgInfo sumUnitOrgInfo, int i) {
        if (!StringUtil.isEmptyString((String)sumUnitOrgInfo.getOrgNumber()) && otherError.length() == 0) {
            otherError.append("\u4ee5\u4e0b\u8981\u5bfc\u5165\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u5bfc\u5165: \n");
        }
        if (!StringUtil.isEmptyString((String)sumUnitOrgInfo.getSumUnitID())) {
            otherError.append("  \u6c47\u603b\u8303\u56f4\u7f16\u7801\uff1a").append(sumRangeInfo.getNumber()).append("  ");
            otherError.append("\u6c47\u603b\u5355\u5143\u7f16\u7801\uff1a").append(sumUnitInfo.getNumber()).append("  ");
            otherError.append("\u5f15\u5165\u7ec4\u7ec7\u7f16\u7801\uff1a").append(sumUnitOrgInfo.getOrgNumber()).append("\n");
        }
        orgList.remove(i);
    }

    private Map getExistOrgNumMap(List existManageOrgList) {
        HashMap<String, String> existOrgNumIdMap = new HashMap<String, String>();
        if (existManageOrgList == null || existManageOrgList.size() == 0) {
            return existOrgNumIdMap;
        }
        int size = existManageOrgList.size();
        for (int i = 0; i < size; ++i) {
            Map orgListMap = null;
            orgListMap = (Map)existManageOrgList.get(i);
            String orgNumber = (String)orgListMap.get("fnumber");
            if (StringUtil.isEmptyString((String)orgNumber) || existOrgNumIdMap.containsKey(orgNumber)) continue;
            existOrgNumIdMap.put(orgNumber, (String)orgListMap.get("fid"));
        }
        return existOrgNumIdMap;
    }

    private void addSumUnitOrgIntoManageList(List manageOrgList, List orgList) {
        if (orgList == null || orgList.size() == 0) {
            return;
        }
        int size = orgList.size();
        for (int i = 0; i < size; ++i) {
            SumUnitOrgInfo sumUnitOrgInfo = (SumUnitOrgInfo)orgList.get(i);
            if (sumUnitOrgInfo == null || StringUtil.isEmptyString((String)sumUnitOrgInfo.getOrgNumber()) || manageOrgList.contains(sumUnitOrgInfo.getOrgNumber())) continue;
            manageOrgList.add(sumUnitOrgInfo.getOrgNumber());
        }
    }

    private void checkImportSumUnitDup(SumRangeInfo sumRangeInfo, List unitList, StringBuffer errorMsg, List manageOrgList) {
        if (unitList == null || unitList.size() == 0) {
            return;
        }
        HashMap<String, SumUnitInfo> numUnit = new HashMap<String, SumUnitInfo>();
        HashMap<String, SumUnitInfo> nameUnit = new HashMap<String, SumUnitInfo>();
        StringBuffer unitErrorMsg = new StringBuffer();
        for (int i = unitList.size() - 1; i >= 0; --i) {
            SumUnitInfo sumUnitInfo = (SumUnitInfo)unitList.get(i);
            if (sumUnitInfo == null) continue;
            if (!StringUtil.isEmptyString((String)sumUnitInfo.getOrgNumber()) && !manageOrgList.contains(sumUnitInfo.getOrgNumber())) {
                manageOrgList.add(sumUnitInfo.getOrgNumber());
            }
            if (!numUnit.containsKey(sumUnitInfo.getNumber())) {
                numUnit.put(sumUnitInfo.getNumber(), sumUnitInfo);
            } else {
                this.removeUnitFromUnitListByNum(sumRangeInfo, unitErrorMsg, sumUnitInfo, unitList, numUnit);
                this.removeDupOrgFromManageOrgList(sumUnitInfo, manageOrgList);
            }
            if (!nameUnit.containsKey(sumUnitInfo.getName("l2"))) {
                nameUnit.put(sumUnitInfo.getName("l2"), sumUnitInfo);
                continue;
            }
            this.removeUnitFromUnitListByName(sumRangeInfo, unitErrorMsg, sumUnitInfo, unitList, nameUnit);
            this.removeDupOrgFromManageOrgList(sumUnitInfo, manageOrgList);
        }
        if (unitErrorMsg.length() > 0) {
            errorMsg.append(unitErrorMsg);
        }
    }

    private void removeUnitFromUnitListByNum(SumRangeInfo sumRangeInfo, StringBuffer unitErrorMsg, SumUnitInfo sumUnitInfo, List unitList, Map numUnit) {
        if (unitList.contains(sumUnitInfo)) {
            unitList.remove(sumUnitInfo);
            this.addSumUnitDupNumNameIntoErrorMsg(sumRangeInfo, unitErrorMsg, sumUnitInfo);
        }
        if (numUnit.containsKey(sumUnitInfo.getNumber()) && unitList.contains(numUnit.get(sumUnitInfo.getNumber()))) {
            unitList.remove(numUnit.get(sumUnitInfo.getNumber()));
            this.addSumUnitDupNumNameIntoErrorMsg(sumRangeInfo, unitErrorMsg, (SumUnitInfo)numUnit.get(sumUnitInfo.getNumber()));
        }
    }

    private void removeUnitFromUnitListByName(SumRangeInfo sumRangeInfo, StringBuffer unitErrorMsg, SumUnitInfo sumUnitInfo, List unitList, Map nameUnit) {
        if (unitList.contains(sumUnitInfo)) {
            unitList.remove(sumUnitInfo);
            this.addSumUnitDupNumNameIntoErrorMsg(sumRangeInfo, unitErrorMsg, sumUnitInfo);
        }
        if (nameUnit.containsKey(sumUnitInfo.getName("l2")) && unitList.contains(nameUnit.get(sumUnitInfo.getName("l2")))) {
            unitList.remove(nameUnit.get(sumUnitInfo.getName("l2")));
            this.addSumUnitDupNumNameIntoErrorMsg(sumRangeInfo, unitErrorMsg, (SumUnitInfo)nameUnit.get(sumUnitInfo.getName("l2")));
        }
    }

    private void removeDupOrgFromManageOrgList(SumUnitInfo sumUnitInfo, List manageOrgList) {
        if (manageOrgList.contains(sumUnitInfo.getOrgNumber())) {
            manageOrgList.remove(sumUnitInfo.getOrgNumber());
        }
    }

    private void addSumUnitDupNumNameIntoErrorMsg(SumRangeInfo sumRangeInfo, StringBuffer unitErrorMsg, SumUnitInfo sumUnitInfo) {
        if (unitErrorMsg.length() == 0) {
            unitErrorMsg.append("\u4ee5\u4e0b\u6c47\u603b\u8303\u56f4\u4e0b\u6c47\u603b\u5355\u5143\u7f16\u7801\u6216\u540d\u79f0\u91cd\u590d\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002\u8bf7\u68c0\u67e5\u4e0b\u5217\u6c47\u603b\u5355\u5143\u7684\u7f16\u7801\u548c\u540d\u79f0\u662f\u5426\u91cd\u590d\uff1a\n");
        }
        unitErrorMsg.append("  \u6c47\u603b\u8303\u56f4\u7f16\u7801");
        unitErrorMsg.append(sumRangeInfo.getNumber()).append("  ");
        unitErrorMsg.append("\u6c47\u603b\u5355\u5143\u7f16\u7801\uff1a").append(sumUnitInfo.getNumber()).append("\n");
    }

    private Map getUnDupSumRangInfoAndCreateErrMsg(List allSumRangeInfoList, List dupSumRangeInfoList, StringBuffer errorMsg) {
        HashMap numSumRange;
        block7: {
            HashMap nameSumRange;
            block6: {
                numSumRange = new HashMap();
                nameSumRange = new HashMap();
                if (dupSumRangeInfoList == null || dupSumRangeInfoList.size() <= 0) break block6;
                errorMsg.append("\u4ee5\u4e0b\u6c47\u603b\u8303\u56f4\u5bfc\u5165\u5931\u8d25\uff1a \n");
                boolean isAddToError = false;
                int rangeSize = allSumRangeInfoList.size();
                block0: for (int i = 0; i < rangeSize; ++i) {
                    isAddToError = false;
                    SumRangeInfo sumRangeInfo = (SumRangeInfo)allSumRangeInfoList.get(i);
                    this.putSumRangeInfoIntoMap(numSumRange, nameSumRange, sumRangeInfo);
                    int dupRangeSize = dupSumRangeInfoList.size();
                    for (int j = 0; j < dupRangeSize; ++j) {
                        Map sumUnitInfoMap = (Map)dupSumRangeInfoList.get(j);
                        String dupRangeNumber = (String)sumUnitInfoMap.get("rangenumber");
                        String dupRangeName = (String)sumUnitInfoMap.get("rangename_l2");
                        if (sumRangeInfo.getNumber().equals(dupRangeNumber)) {
                            numSumRange.remove(dupRangeNumber);
                            isAddToError = true;
                        } else if (sumRangeInfo.getName("l2").equals(dupRangeName)) {
                            nameSumRange.remove(dupRangeName);
                            numSumRange.remove(sumRangeInfo.getNumber());
                            isAddToError = true;
                        }
                        if (!isAddToError) continue;
                        if (errorMsg.indexOf(sumRangeInfo.getNumber()) != -1) continue block0;
                        errorMsg.append("  \u7f16\u7801\uff1a").append(sumRangeInfo.getNumber()).append("  ");
                        errorMsg.append("\u540d\u79f0\uff1a").append(sumRangeInfo.getName("l2")).append(";").append("\n");
                        continue block0;
                    }
                }
                break block7;
            }
            if (dupSumRangeInfoList != null && dupSumRangeInfoList.size() != 0 || allSumRangeInfoList.size() <= 0) break block7;
            int size = allSumRangeInfoList.size();
            for (int i = 0; i < size; ++i) {
                SumRangeInfo sumRangeInfo = (SumRangeInfo)allSumRangeInfoList.get(i);
                this.putSumRangeInfoIntoMap(numSumRange, nameSumRange, sumRangeInfo);
            }
        }
        return numSumRange;
    }

    private void putSumRangeInfoIntoMap(Map numSumRange, Map nameSumRange, SumRangeInfo sumRangeInfo) {
        if (sumRangeInfo != null && !numSumRange.containsKey(sumRangeInfo.getNumber())) {
            if (!nameSumRange.containsKey(sumRangeInfo.getName("l2"))) {
                nameSumRange.put(sumRangeInfo.getName("l2"), sumRangeInfo);
            }
            numSumRange.put(sumRangeInfo.getNumber(), sumRangeInfo);
        }
    }

    @Override
    public List getSumUnitOrgListByRangeID(String rangeID, String localString) throws BOSException {
        List sumUnitOrgList = null;
        if (rangeID != null && !"".equals(rangeID)) {
            sumUnitOrgList = this.getFacade().getOrgListByRangeID(rangeID, localString);
        }
        return sumUnitOrgList;
    }

    @Override
    public List getLaunchedRanges(String localString) throws BOSException {
        List rsL = this.getFacade().getLaunchedRanges(localString);
        Vector<F7VO> f7VOLst = new Vector<F7VO>(rsL.size());
        int size = rsL.size();
        for (int i = 0; i < size; ++i) {
            HashMap iMap = (HashMap)rsL.get(i);
            F7VO vo = new F7VO();
            vo.setId(MixUtil.toString(iMap.get("id")));
            vo.setName(MixUtil.toString(iMap.get("name")));
            vo.setCode(MixUtil.toString(iMap.get("code")));
            f7VOLst.add(vo);
        }
        return f7VOLst;
    }

    public void importSumRange(SumRangeInfo vo) {
    }

    @Override
    public void newVersion(SumRangeInfo info, String srcRangeID) throws BOSException, InfoException {
        SumRangeInfo vo = (SumRangeInfo)info.clone();
        vo.setId(null);
        this.varifyUnSame(vo);
        String nRangeID = UID.create((int)44);
        vo.setId(nRangeID);
        Timestamp createTime = new Timestamp(new Date().getTime());
        vo.setCreateTime(createTime);
        vo.setUsingFlag(0);
        String local = EASUtil.gelLoginLocal();
        List rsUnitLst = this.getFacade().getCurrentOrgUnitListByRangeID(srcRangeID, local);
        if (rsUnitLst != null) {
            HashMap<String, String> idMap = new HashMap<String, String>(rsUnitLst.size());
            if (rsUnitLst.size() >= 1) {
                ArrayList<SumUnitInfo> unitLst = new ArrayList<SumUnitInfo>(rsUnitLst.size());
                int size = rsUnitLst.size();
                for (int i = 0; i < size; ++i) {
                    Map item = (Map)rsUnitLst.get(i);
                    SumUnitInfo uItem = new SumUnitInfo();
                    uItem.setName(MixUtil.toString(item.get("name")), local);
                    String oldID = MixUtil.toString(item.get("id"));
                    uItem.setLongNumber(MixUtil.toString(item.get("longnumber")));
                    uItem.setManageOrgID(MixUtil.toString(item.get("manageorgid")));
                    uItem.setDes(MixUtil.toString(item.get("dec")), local);
                    String pID = MixUtil.toString(item.get("pid"));
                    uItem.setLevel(((Number)item.get("lev")).intValue());
                    uItem.setNumber(MixUtil.toString(item.get("num")));
                    String newID = UID.create((int)44);
                    if (idMap.containsKey(pID)) {
                        String nPID = (String)idMap.get(pID);
                        uItem.setParentID(nPID);
                    }
                    idMap.put(oldID, newID);
                    uItem.setId(newID);
                    uItem.setSumRangeID(nRangeID);
                    uItem.setCreateTime(createTime);
                    unitLst.add(uItem);
                }
                vo.setUnitList(unitLst);
            }
            List rsOrgsLst = this.getFacade().getOrgListByRangeID(srcRangeID, local);
            ArrayList<SumUnitOrgInfo> orgLst = new ArrayList<SumUnitOrgInfo>(rsOrgsLst.size());
            if (null != rsOrgsLst && rsOrgsLst.size() >= 1) {
                int size = rsOrgsLst.size();
                for (int i = 0; i < size; ++i) {
                    Map item = (Map)rsOrgsLst.get(i);
                    SumUnitOrgInfo oItem = new SumUnitOrgInfo();
                    oItem.setLongNumber(MixUtil.toString(item.get("flongnumber")));
                    oItem.setOrgID(MixUtil.toString(item.get("forgid")));
                    oItem.setSumRangeID(nRangeID);
                    String oldUnitID = MixUtil.toString(item.get("fsumunitid"));
                    oItem.setSumUnitID((String)idMap.get(oldUnitID));
                    oItem.setCreateTime(createTime);
                    oItem.setOrgName(MixUtil.toString(item.get("orgname")));
                    orgLst.add(oItem);
                }
            }
            vo.setOrgList(orgLst);
        }
        this.getFacade().addNewVersion(vo, srcRangeID, local);
    }

    public List getAssignToCurOrgSumRanges(String curOrgID, String localString) throws BOSException {
        if (curOrgID == null) {
            return null;
        }
        if (localString == null) {
            localString = "l2";
        }
        return this.getFacade().getAssignToCurOrgSumRanges(curOrgID, localString);
    }
}

