/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.tobi;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.immit.ReportProperties;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.CommonCalculableProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtGroup;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExternalTargets;
import com.kingdee.bos.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.bos.ctrl.kds.io.htm.explorer.AbstractHyperLinkHelper;
import com.kingdee.bos.ctrl.kds.io.htm.serial.Variant2String;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureCollection;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureFactory;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureInfo;
import com.kingdee.bos.webframework.dynamic.IDynamicConfigure;
import com.kingdee.eas.common.client.OprtState;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class HyperLinkHelper
extends AbstractHyperLinkHelper {
    private Logger _logger = CommonLogger.getLogger(((Object)((Object)this)).getClass());
    private ArrayList _targets;
    private ArrayList _targetValues;
    private ArrayList _params;
    private ArrayList _paramValues;
    private Context _ctx;
    private static final String VAL_LINKTYPE_REPORT = "report";
    public static final String VAL_LINKTYPE_EASListUI = "easlistui";
    public static final String VAL_LINKTYPE_EASEditUI = "easeditui";
    public static final String VAL_LINKTYPE_WEBLISTUI = "webListPage";
    public static final String VAL_LINKTYPE_WEBEDITUI = "webEditPage";
    public static final String UI_TYPE = "UI_TYPE";
    public static final String UI_ID_LIST = "ID_LIST";
    public static final String PREFIX = "EAS_UI:";
    private static final String UI_CLASS_NAME = "UI_CLASS_NAME";
    private static final String NOBILL = "nobill.html";
    public static final String DYNAMIC_WEB_UIPK = "com.kingdee.eas.dynamic.web.";

    public HyperLinkHelper(Context ctx) {
        this._ctx = ctx;
    }

    public String params2Json() {
        if (null == this._paramValues) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iter = this._paramValues.iterator();
        int index = 0;
        buffer.append("<SPAN sue = \"param_data\"> {");
        while (iter.hasNext()) {
            buffer.append(index);
            buffer.append(":");
            buffer.append(iter.next().toString());
            if (iter.hasNext()) {
                buffer.append(",");
            }
            ++index;
        }
        buffer.append("}</SPAN>");
        return buffer.toString();
    }

    public String report2Json() {
        if (null == this._targetValues) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iter = this._targetValues.iterator();
        int index = 0;
        buffer.append("<SPAN sue = \"report_data\"> {");
        while (iter.hasNext()) {
            buffer.append(index);
            buffer.append(":");
            buffer.append(iter.next().toString());
            if (iter.hasNext()) {
                buffer.append(",");
            }
            ++index;
        }
        buffer.append("}</SPAN>");
        return buffer.toString();
    }

    public String[] registTarget(HyperlinkCalculableProps prop, Cell cell) {
        List[] results;
        String[] toReturn = new String[2];
        ExtProps ep = cell.getExtProps(false);
        HashMap tars = prop.getTargets();
        ETTargets repTar = (ETTargets)tars.get("EXTRPT");
        ExternalTargets extTar = (ExternalTargets)tars.get("EASBILL");
        int index = 0;
        StringBuffer reportTxt = new StringBuffer(" reports = '[");
        StringBuffer paramTxt = new StringBuffer(" params = '[");
        if (null != repTar) {
            results = this.solveReportHyperL(repTar, ep);
            index = this.generateRegistString(results, reportTxt, paramTxt, index);
        }
        if (null != extTar) {
            results = this.solveExtHyperL(extTar, cell);
            index = this.generateRegistString(results, reportTxt, paramTxt, index);
        }
        reportTxt.append("]'");
        paramTxt.append("]'");
        toReturn[0] = reportTxt.toString();
        toReturn[1] = paramTxt.toString();
        return toReturn;
    }

    private int generateRegistString(List[] results, StringBuffer reportTxt, StringBuffer paramTxt, int offset) {
        Iterator report = results[0].iterator();
        Iterator param = results[1].iterator();
        int index = offset;
        if (index > 0 && report.hasNext()) {
            reportTxt.append(",");
            paramTxt.append(",");
        }
        while (report.hasNext()) {
            int reportIdx = (Integer)report.next();
            String params = (String)param.next();
            reportTxt.append(reportIdx);
            paramTxt.append(params);
            ++index;
            if (!report.hasNext()) break;
            reportTxt.append(",");
            paramTxt.append(",");
        }
        return index;
    }

    private List[] solveExtHyperL(ExternalTargets externals, Cell cell) {
        List[] toReturn = new List[2];
        ArrayList<Integer> idList = new ArrayList<Integer>();
        List targets = externals.getAllAssembledTargets();
        Iterator iter = targets.iterator();
        ArrayList<String> targetsParams = new ArrayList<String>(targets.size());
        toReturn[0] = idList;
        toReturn[1] = targetsParams;
        while (iter.hasNext()) {
            boolean isInArray;
            HashMap attributes = (HashMap)((HashMap)iter.next()).clone();
            String prefix = (String)attributes.get("HYPERLINK_PREFIX");
            if ("JAVA_JUMPER:".equals(prefix) || !PREFIX.equals(prefix)) continue;
            String uiType = attributes.get(UI_TYPE).toString();
            boolean isListUI = uiType.equalsIgnoreCase("listui");
            Object[] results = this.getUrl(attributes, cell);
            String url = (String)results[0];
            String name = (String)attributes.get("DISPLAY_NAME");
            if (url == null) continue;
            int linkIndex = this.getTargets().indexOf(url);
            boolean bl = isInArray = linkIndex >= 0;
            if (!isInArray) {
                linkIndex = this.getTargets().size();
                this.getTargets().add(url);
                String content = "{NAME:\"" + attributes.get("DISPLAY_NAME") + "\", URL:\"" + url + "\", TYPE: \"" + (isListUI ? VAL_LINKTYPE_EASListUI : VAL_LINKTYPE_EASEditUI) + "\"}";
                this._targetValues.add(content);
            }
            idList.add(new Integer(linkIndex));
            List ids = (List)results[1];
            Iterator idIter = ids.iterator();
            StringBuffer paramContent = new StringBuffer();
            paramContent.append("{").append("paramList:");
            paramContent.append("[");
            while (idIter.hasNext()) {
                String vt = idIter.next().toString();
                if (StringUtil.isEmptyString((String)vt)) continue;
                int paramIdx = this.getParams().indexOf(vt);
                if (paramIdx < 0) {
                    paramIdx = this._params.size();
                    this._params.add(vt);
                    this._paramValues.add("\"" + this.encode(vt) + "\"");
                }
                paramContent.append("\"").append(paramIdx).append("\"");
                if (!idIter.hasNext()) continue;
                paramContent.append(",");
            }
            paramContent.append("]}");
            targetsParams.add(paramContent.toString());
        }
        return toReturn;
    }

    private List[] solveReportHyperL(ETTargets repTar, ExtProps ep) {
        List[] result = new List[2];
        ArrayList<Integer> idList = new ArrayList<Integer>();
        List targets = repTar.getTargets();
        Iterator itor = targets.iterator();
        ArrayList<String> targetsParams = new ArrayList<String>(targets.size());
        ExtTransitionTarget target = null;
        result[0] = idList;
        result[1] = targetsParams;
        while (itor.hasNext()) {
            boolean isInArray;
            target = (ExtTransitionTarget)itor.next();
            ReportProperties props = target.getReportProps();
            Object alias = ep.executeCalculableProps(props.getCalculableProps());
            if (alias != null) {
                props.setAlias(alias.toString());
            }
            String id = props.getId();
            int linkIndex = this.getTargets().indexOf(id);
            boolean bl = isInArray = linkIndex >= 0;
            if (!isInArray) {
                linkIndex = this.getTargets().size();
                this.getTargets().add(id);
                String content = "{NAME:\"" + props.getAlias() + "\", ID:\"" + id + "\", TYPE: \"" + VAL_LINKTYPE_REPORT + "\", SYSTEMID: \"" + props.getPath() + "\"}";
                this._targetValues.add(content);
            }
            Integer hyperIndex = new Integer(linkIndex);
            idList.add(hyperIndex);
            Map params = target.getParameters();
            TreeMap<String, String> paramJsonMap = new TreeMap<String, String>();
            if (params != null) {
                ep.executeParams(params);
                Iterator paramIter = params.entrySet().iterator();
                while (paramIter.hasNext()) {
                    ParameterImpl param = (ParameterImpl)paramIter.next().getValue();
                    Variant vt = param.getValue();
                    if (vt != Variant.nullVariant) {
                        int paramIdx = this.getParams().indexOf(vt);
                        if (paramIdx < 0) {
                            paramIdx = this._params.size();
                            this._params.add(vt);
                            this._paramValues.add("\"" + Variant2String.toString((Variant)vt) + "\"");
                        }
                        param.setValue(new Variant((Object)new Integer(paramIdx), 3));
                    }
                    paramJsonMap.put(param.getName(), this.map2String(param.toJsonFormMap()));
                }
            }
            String paramContent = HyperLinkHelper.getJsonString(paramJsonMap);
            targetsParams.add(paramContent);
        }
        return result;
    }

    private String map2String(Map map) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = map.get(key);
            sb.append(key.toString());
            sb.append(":");
            sb.append("\"");
            sb.append(value.toString());
            sb.append("\"");
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private List getTargets() {
        if (null == this._targets) {
            this._targets = new ArrayList();
            this._targetValues = new ArrayList();
        }
        return this._targets;
    }

    private List getParams() {
        if (null == this._params) {
            this._params = new ArrayList();
            this._paramValues = new ArrayList();
        }
        return this._params;
    }

    public Object[] getUrl(Map map, Cell cell) {
        return this.getUrl(map, cell, null);
    }

    public Object[] getUrl(Map map, Cell cell, List idList) {
        String uiType = map.get(UI_TYPE).toString();
        boolean isListUI = uiType.equalsIgnoreCase("listui");
        Object[] toReturn = new Object[2];
        if (idList == null) {
            idList = new ArrayList();
            CommonCalculableProps[] props = (CommonCalculableProps[])map.get(UI_ID_LIST);
            int size = props.length;
            for (int i = 0; i < size; ++i) {
                idList.addAll(this.executeCalculableProps(cell, props[i]));
            }
        }
        String firstItem = idList.get(0).toString();
        String uiClassName = null;
        Object oClassName = map.get(UI_CLASS_NAME);
        if (oClassName != null) {
            uiClassName = oClassName.toString();
        }
        toReturn[0] = isListUI ? this.getListUrl(firstItem, uiClassName) : this.getEditUrl(firstItem, uiClassName);
        toReturn[1] = idList;
        return toReturn;
    }

    public List executeCalculableProps(Cell cell, CommonCalculableProps prop) {
        Sheet sheet = cell.getSheet();
        ExprContext ctx = sheet.getDeps().getExprContext();
        ArrayList<Variant> list = new ArrayList<Variant>();
        Variant variant = prop.calc(ctx, (ICalculable)cell);
        if (variant.isArray()) {
            Variant[] variants = (Variant[])variant.getValue();
            int length = variants.length;
            for (int i = 0; i < length; ++i) {
                Object obj = variants[i].getValue();
                if (obj instanceof CellBlockNode) {
                    list.addAll(this.splitCellBlockToValue(sheet, (CellBlock)((CellBlockNode)obj)));
                    continue;
                }
                list.add(variants[i]);
            }
        } else if (variant.isObject()) {
            Object obj = variant.getValue();
            if (obj instanceof CellBlockNode) {
                list.addAll(this.splitCellBlockToValue(sheet, (CellBlock)((CellBlockNode)obj)));
            } else if (obj instanceof ExtGroup) {
                ExtGroup groups = (ExtGroup)obj;
                Variant[] values = groups.getValues();
                if (values != null) {
                    for (int i = values.length - 1; i >= 0; --i) {
                        list.add(values[i]);
                    }
                }
            } else {
                list.add(variant);
            }
        } else {
            list.add(variant);
        }
        return list;
    }

    private List splitCellBlockToValue(Sheet sheet, CellBlock block) {
        if (block == null) {
            return null;
        }
        ArrayList<Variant> list = new ArrayList<Variant>();
        int row = block.getRow();
        int row2 = block.getRow2();
        int col = block.getCol();
        int col2 = block.getCol2();
        for (int r = row; r <= row2; ++r) {
            for (int c = col; c <= col2; ++c) {
                Cell cell = sheet.getCell(r, c, false);
                if (cell == null) continue;
                list.add(cell.getValue());
            }
        }
        return list;
    }

    private String encode(String org) {
        try {
            return URLEncoder.encode(org, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public void clear() {
        if (null != this._targets) {
            this._targets.clear();
            this._targetValues.clear();
            if (null != this._params) {
                this._params.clear();
                this._paramValues.clear();
            }
        }
    }

    private String getEditUrl(String billId, String uiClassName) {
        Object billObject = this.getEntiry(this._ctx, billId);
        if (billObject == null) {
            return "";
        }
        try {
            String url = "";
            String editUiPk = this.getPropertity(billObject, "webEditUI");
            String web_dynamic = this.getPropertity(billObject, "web_dynamic");
            String isDynamic = this.getPropertity(billObject, "isDynamic");
            if (null != isDynamic && isDynamic.equals("true") && !"1".equalsIgnoreCase(web_dynamic) && !StringUtil.isEmptyString((String)editUiPk)) {
                url = "/winlet/edit/editUIProxy.jsf?uipk=" + editUiPk;
            } else {
                if (!StringUtil.isEmptyString((String)editUiPk)) {
                    url = HyperLinkHelper.webUIName2URL(editUiPk);
                }
                if (StringUtil.isEmptyString((String)url)) {
                    Object o;
                    String editUi = uiClassName;
                    if (StringUtil.isEmptyString((String)editUi)) {
                        editUi = this.getPropertity(billObject, VAL_LINKTYPE_WEBEDITUI);
                    }
                    if (!StringUtil.isEmptyString((String)editUi)) {
                        url = HyperLinkHelper.webPageName2URL(editUi, ".do");
                    }
                    if (StringUtil.isEmptyString((String)url) && !StringUtil.isEmptyString((String)(editUi = this.getPropertity(billObject, "editUI"))) && (o = this.getUrlFromMeta(editUi)) == null) {
                        Object obj = this.getEditPageUrl(billId, OprtState.EDIT);
                        String string = url = obj == null ? "" : obj.toString().trim();
                    }
                }
            }
            if (url.length() > 0) {
                return url;
            }
            return NOBILL;
        }
        catch (Exception e) {
            return NOBILL;
        }
    }

    private Object getEditPageUrl(String id, String pageType) {
        try {
            BOSObjectType bostype = BOSUuid.read((String)id).getType();
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this._ctx);
            EntityObjectInfo entityInfo = loader.getEntity(bostype);
            String entityName = entityInfo.getFullName();
            IDynamicConfigure iApp = DynamicConfigureFactory.getLocalInstance((Context)this._ctx);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("pageType", (Object)OprtState.EDIT.toLowerCase(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("entityObjectName", (Object)entityName, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)1, CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            DynamicConfigureCollection appCollection = iApp.getDynamicConfigureCollection(entityViewInfo);
            DynamicConfigureInfo sInfo = appCollection.get(0);
            if (sInfo == null) {
                return null;
            }
            String uipk = sInfo.getWebUIObjectName();
            return "/dynamicForm.do?event=initialize&method=initalize&uipk=" + uipk;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getListUrl(String billId, String uiClassName) {
        Object billObject = this.getEntiry(this._ctx, billId);
        if (billObject == null) {
            return "";
        }
        try {
            String url = "";
            String listUiPk = this.getPropertity(billObject, "webListUI");
            String web_dynamic = this.getPropertity(billObject, "web_dynamic");
            String isDynamic = this.getPropertity(billObject, "isDynamic");
            if (null != isDynamic && isDynamic.equals("true") && !"1".equalsIgnoreCase(web_dynamic) && !StringUtil.isEmptyString((String)listUiPk)) {
                url = "/winlet/list/listUIProxy.jsf?uipk=" + listUiPk;
            } else {
                if (!StringUtil.isEmptyString((String)listUiPk)) {
                    url = HyperLinkHelper.webUIName2URL(listUiPk);
                }
                if (StringUtil.isEmptyString((String)url)) {
                    String listUi = uiClassName;
                    if (StringUtil.isEmptyString((String)listUi)) {
                        listUi = this.getPropertity(billObject, VAL_LINKTYPE_WEBLISTUI);
                    }
                    if (!StringUtil.isEmptyString((String)listUi)) {
                        url = HyperLinkHelper.webPageName2URL(listUi, ".do");
                    }
                    if (StringUtil.isEmptyString((String)url) && !StringUtil.isEmptyString((String)(listUi = this.getPropertity(billObject, "listUI")))) {
                        Object o = this.getUrlFromMeta(listUi);
                        String string = url = o == null ? "" : o.toString().trim();
                    }
                }
            }
            if (StringUtil.isEmptyString((String)url)) {
                return NOBILL;
            }
            return url;
        }
        catch (Exception e) {
            return NOBILL;
        }
    }

    private Object getEntiry(Context cxt, String billId) {
        Object[] readMthObject = new Object[]{billId};
        Object[] cxtParamArray = new Object[]{cxt};
        Object[] typePrameArray = new Object[1];
        Class[] readMthTypes = new Class[]{String.class};
        Class[] paramLod = new Class[]{Context.class};
        Class[] paramGet = new Class[1];
        try {
            Class<?> BosObjectTypeClazz;
            paramGet[0] = BosObjectTypeClazz = Class.forName("com.kingdee.bos.util.BOSObjectType");
            Class<?> BosUuidClazz = Class.forName("com.kingdee.bos.util.BOSUuid");
            Method readMth = BosUuidClazz.getMethod("read", readMthTypes);
            Method getType = BosUuidClazz.getMethod("getType", new Class[0]);
            Object id = readMth.invoke(null, readMthObject);
            typePrameArray[0] = getType.invoke(id, new Object[0]);
            Class<?> metaDataLoader = Class.forName("com.kingdee.bos.metadata.IMetaDataLoader");
            Class<?> factory = Class.forName("com.kingdee.bos.metadata.MetaDataLoaderFactory");
            Method getLocalMetaDataLoader = factory.getMethod("getLocalMetaDataLoader", paramLod);
            Method load = metaDataLoader.getMethod("getEntity", paramGet);
            Object loader = getLocalMetaDataLoader.invoke(factory, cxtParamArray);
            Object entity = load.invoke(loader, typePrameArray);
            return entity;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getPropertity(Object entiry, String method) {
        Object result = null;
        Class[] paramGet = new Class[]{String.class};
        Object[] args = new Object[]{method};
        try {
            Class<?> entityInfo = Class.forName("com.kingdee.bos.metadata.entity.EntityObjectInfo");
            if (method.equals("isDynamic")) {
                Method getPro = entityInfo.getMethod("isDynamic", null);
                Boolean value = (Boolean)getPro.invoke(entiry, null);
                result = value != false ? "true" : "false";
            } else {
                Method getPro = entityInfo.getMethod("getExtendedProperty", paramGet);
                result = getPro.invoke(entiry, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (String)result;
    }

    private Object getUrlFromMeta(String listUI) {
        Object result = null;
        Class[] metaPkCstP = new Class[]{String.class};
        Object[] metaPkCstV = new Object[]{listUI};
        Class[] uiCstP = new Class[1];
        Object[] uiCstV = new Object[]{this._ctx};
        Class[] uiInfoP = new Class[1];
        Object[] getValueV = new Object[1];
        try {
            uiCstP[0] = Context.class;
            Class<?> metaPk = Class.forName("com.kingdee.bos.metadata.MetaDataPK");
            Class<?> ImetaPk = Class.forName("com.kingdee.bos.metadata.IMetaDataPK");
            Class<?> UIObjCtr = Class.forName("com.kingdee.bos.metadata.ui.UIObjectCtrl");
            Class<?> UIInfo = Class.forName("com.kingdee.bos.metadata.ui.UIObjectInfo");
            uiInfoP[0] = ImetaPk;
            Method uiGetValue = UIObjCtr.getMethod("getValue", uiInfoP);
            Method uiGetExtendPro = UIInfo.getMethod("getExtendedProperties", null);
            Object metaPK = metaPk.getConstructor(metaPkCstP).newInstance(metaPkCstV);
            Object ctrl = UIObjCtr.getConstructor(uiCstP).newInstance(uiCstV);
            getValueV[0] = metaPK;
            Object uiInfo = uiGetValue.invoke(ctrl, getValueV);
            Map extendProperties = (Map)uiGetExtendPro.invoke(uiInfo, null);
            result = extendProperties.get("url");
        }
        catch (Exception e) {
            this._logger.error((Object)"getUrlFromMeta\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    public static String webUIName2URL(String pk) {
        return HyperLinkHelper.webPageName2URL(pk, ".jsf");
    }

    private static String webPageName2URL(String pk, String type) {
        int i;
        if (pk == null || pk.length() == 0) {
            return null;
        }
        String PREFIX = "com.kingdee.eas";
        if (pk.startsWith(PREFIX)) {
            pk = pk.substring(PREFIX.length());
        }
        String url = "";
        String[] ms = pk.split("\\.");
        if (ms.length > 2 && "web".equals(ms[ms.length - 2])) {
            for (i = 0; i < ms.length - 2; ++i) {
                url = url + ms[i] + "/";
            }
        } else {
            for (i = 0; i < ms.length - 1; ++i) {
                url = url + ms[i] + "/";
            }
        }
        String name = ms[ms.length - 1];
        name = name.substring(0, 1).toLowerCase() + name.substring(1) + type;
        url = url + name;
        return url;
    }

    public static String getJsonString(Map map) {
        Class[] parameterTypes = new Class[]{Map.class};
        Object[] initargs = new Object[]{map};
        try {
            Class<?> jsonmapClazz = Class.forName("com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap");
            Constructor<?> constructor = jsonmapClazz.getConstructor(parameterTypes);
            Object jsonmap = constructor.newInstance(initargs);
            return jsonmap.toString();
        }
        catch (Exception e) {
            return "null";
        }
    }
}

