/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.web.bhv;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Row;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.eas.rpts.web.man.ReportImpl;
import com.kingdee.eas.rpts.web.man.SheetImpl;
import com.kingdee.eas.rpts.web.model.AbstractEmbedObject;
import com.kingdee.eas.rpts.web.model.CellModel;
import com.kingdee.eas.rpts.web.model.ColumnModel;
import com.kingdee.eas.rpts.web.model.RowModel;
import com.kingdee.eas.rpts.web.util.BeanFactory;
import com.kingdee.eas.rpts.web.util.EmbedObjectHelper;
import com.kingdee.eas.rpts.web.util.ReportBookHelper;
import com.kingdee.eas.rpts.web.util.StyleToCss;
import com.kingdee.eas.rpts.web.vo.TableInfo;
import java.util.ArrayList;
import java.util.List;

public class OutputTableBhv {
    public TableInfo behaviour(ReportImpl report) {
        Book book = report.getBook();
        SheetImpl sheetModel = report.getCurrentSheet();
        Sheet bookSheet = book.getSheet(sheetModel.getSheetName());
        Context ctx = report.getContext();
        TableInfo fragment = this.outputTableFragment(sheetModel, bookSheet, ctx, report);
        fragment.setBorderStyleMap(BeanFactory.getStyleMap().getBorderStyleMap());
        fragment.setStyleMap(BeanFactory.getStyleMap().getStyleMap());
        BeanFactory.clearStyles();
        return fragment;
    }

    private TableInfo outputTableFragment(SheetImpl sheetModel, Sheet sheet, Context ctx, ReportImpl reportImpl) {
        TableInfo tableModel = new TableInfo();
        if (sheetModel.getStartRow() == 0) {
            List<ColumnModel> colList = this.buildColumn(sheet, sheetModel);
            tableModel.setColList(colList);
        }
        List<RowModel> rowList = sheetModel.isTree() ? this.buildTreeRow(sheet, sheetModel, tableModel, ctx, reportImpl.isbMobile()) : this.buildRow(sheet, sheetModel, tableModel, ctx);
        tableModel.setRowList(rowList);
        tableModel.setCurrentLoadedRowNum(sheetModel.getEndRow());
        tableModel.setCurrentStartRowNum(sheetModel.getStartRow());
        List<AbstractEmbedObject> embedChartList = this.outputEmbedChartList(sheetModel, sheet, ctx, reportImpl);
        tableModel.setEmbedChartList(embedChartList);
        sheetModel.setStartRow(sheetModel.getEndRow() + 1);
        return tableModel;
    }

    private List<RowModel> buildRow(Sheet sheet, SheetImpl sheetModel, TableInfo tableModel, Context ctx) {
        int rowIdx;
        int rowCount = sheetModel.getRowCount();
        int colCount = sheetModel.getColCount();
        int rowSumPerPage = sheetModel.getPerNum();
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        Object o = sheet.getBook().getUserObjectValue("MobileReportTreeDisplayMode");
        ArrayList<RowModel> rowList = new ArrayList<RowModel>();
        int i = 0;
        for (rowIdx = sheetModel.getStartRow(); i < rowSumPerPage && rowIdx <= rowCount - 1; ++rowIdx) {
            RowModel row = new RowModel();
            Row bookRow = sheet.getRow(rowIdx, false);
            if (bookRow != null) {
                List<CellModel> cellList = ReportBookHelper.buildCell(bookRow, colCount, sheetModel, tableModel, ctx, sheet);
                row.setCellList(cellList);
            }
            boolean set = false;
            for (int j = 0; j < rowSpans.size(); ++j) {
                SortedAttributeSpanArray.AttributeSpan span = rowSpans.getAttributeSpan(j);
                if (span.contains(rowIdx)) {
                    row.setHeight(span.getLength() + 1);
                    row.setHided(!span.isVisible());
                    row.setStyle(StyleToCss.getCssStyle(span.getStyle()));
                    row.setBorder(StyleToCss.getCssBorder(span.getStyle()));
                    set = true;
                    break;
                }
                if (span.getEnd() > rowIdx) break;
            }
            if (!set) {
                row.setHeight(sheet.getDefRowHeight() + 1);
            }
            row.setIndex(rowIdx);
            rowList.add(row);
            if (row.isHided()) continue;
            ++i;
        }
        sheetModel.setEndRow(rowIdx - 1);
        return rowList;
    }

    private List<ColumnModel> buildColumn(Sheet sheet, SheetImpl sheetModel) {
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        int colCount = sheetModel.getColCount();
        ArrayList<ColumnModel> colList = new ArrayList<ColumnModel>();
        for (int i = 0; i < colCount; ++i) {
            ColumnModel column = new ColumnModel();
            column.setIndex(i);
            boolean set = false;
            for (int j = 0; j < colSpans.size(); ++j) {
                SortedAttributeSpanArray.AttributeSpan span = colSpans.getAttributeSpan(j);
                if (!span.contains(i)) continue;
                column.setWidth(span.getLength() + 1);
                column.setHided(!span.isVisible());
                column.setStyle(StyleToCss.getCssStyle(span.getStyle()));
                column.setBorder(StyleToCss.getCssBorder(span.getStyle()));
                set = true;
            }
            if (!set) {
                column.setWidth(sheet.getDefColWidth() + 1);
            }
            colList.add(column);
        }
        return colList;
    }

    private List<RowModel> buildTreeRow(Sheet sheet, SheetImpl sheetModel, TableInfo tableModel, Context ctx, boolean isMobile) {
        ArrayList<RowModel> rowList;
        int rowCount = sheetModel.getRowCount();
        int colCount = sheetModel.getColCount();
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        if (rowCount <= 200 || isMobile) {
            rowList = this.buildRow(sheet, sheetModel, tableModel, ctx);
        } else {
            rowList = new ArrayList();
            for (int i = 0; i < rowCount; ++i) {
                int spanIdx;
                int[] type = sheetModel.displayType(i);
                RowModel row = new RowModel();
                Row bookRow = sheet.getRow(i, false);
                if (bookRow != null) {
                    List<CellModel> cellList = ReportBookHelper.buildCell(bookRow, colCount, sheetModel, tableModel, ctx, sheet);
                    row.setCellList(cellList);
                }
                if ((spanIdx = rowSpans.searchSpan(i)) >= 0) {
                    SortedAttributeSpanArray.AttributeSpan span = (SortedAttributeSpanArray.AttributeSpan)rowSpans.getSpan(spanIdx);
                    if (type[0] == 1 && !span.isVisible()) continue;
                    row.setHeight(span.getLength() + 1);
                    row.setHided(!span.isVisible());
                    row.setStyle(StyleToCss.getCssStyle(span.getStyle()));
                    row.setBorder(StyleToCss.getCssBorder(span.getStyle()));
                } else {
                    row.setHeight(sheet.getDefRowHeight() + 1);
                }
                row.setIndex(i);
                rowList.add(row);
            }
            sheetModel.setEndRow(rowCount - 1);
        }
        return rowList;
    }

    private List<AbstractEmbedObject> outputEmbedChartList(SheetImpl sheetModel, Sheet sheet, Context ctx, ReportImpl reportImpl) {
        ArrayList<AbstractEmbedObject> embedChartList = new ArrayList<AbstractEmbedObject>();
        List<AbstractEmbedObject> tableEmbedList = EmbedObjectHelper.transformEmbedObject(sheetModel, sheet, ctx, reportImpl);
        for (AbstractEmbedObject embedChart : tableEmbedList) {
            int pageStartY = SheetBaseMath.getRowY((Sheet)sheet, (int)sheetModel.getStartRow());
            int pageEndY = SheetBaseMath.getRowY((Sheet)sheet, (int)(sheetModel.getEndRow() + 1));
            int top = embedChart.getTop();
            int bottom = top + embedChart.getHeight();
            if (!(top >= pageStartY && top < pageEndY || bottom > pageStartY && bottom <= pageEndY) && (top > pageStartY || bottom < pageEndY)) continue;
            embedChartList.add(embedChart);
        }
        return embedChartList;
    }
}

