/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.web.util;

import com.kingdee.bos.ctrl.ext.ui.wizards.pic.ImageUtils;
import com.kingdee.bos.ctrl.kdf.util.render.CellBackgroundRender;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.ISplitRectInfo;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.SplitRectTextRender;
import com.kingdee.bos.ctrl.kds.io.htm.ImageSave;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.bos.ctrl.kds.model.struct.embed.image.IImageModel;
import com.kingdee.eas.rpts.web.man.SheetImpl;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageGenerator {
    private static final String DIAGONAL_PREFIX = "diagonal_";
    private static final String EMBED_PREFIX = "embed_";

    public static String createAndPersistImage(Sheet sheet, Object o, Cell cell, SheetImpl sheetModel) {
        BufferedImage image = null;
        if (o instanceof ISplitRectInfo) {
            image = ImageGenerator.generateImageForDiagonalHeader(sheet, (ISplitRectInfo)o, cell);
        } else if (o instanceof EmbedObject) {
            EmbedImage ei;
            if (o instanceof EmbedImage && (ei = (EmbedImage)o) != null) {
                try {
                    if (ei.getImage() != null) {
                        return ImageGenerator.createImageForAnyTypeImage((EmbedImage)o, sheetModel);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            image = ImageGenerator.generateImageForEmbedLayer(sheet, (EmbedObject)o);
        } else {
            return "";
        }
        String prefix = "";
        prefix = cell != null ? DIAGONAL_PREFIX : EMBED_PREFIX;
        File imageFile = null;
        try {
            imageFile = File.createTempFile(prefix, ".png", new File(sheetModel.getFileSavePath()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            ImageIO.write((RenderedImage)image, "png", imageFile);
        }
        catch (IOException e) {
            return null;
        }
        catch (IllegalArgumentException ee) {
            return null;
        }
        return sheetModel.getFilePrefixPath() + imageFile.getName();
    }

    private static BufferedImage generateImageForDiagonalHeader(Sheet sheet, ISplitRectInfo o, Cell cell) {
        if (cell == null || o == null) {
            return null;
        }
        int row = cell.getRow();
        int col = cell.getCol();
        int height = 0;
        int width = 0;
        CellBlock mergeBlock = cell.getMerge(true);
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        width = ImageGenerator.getCellWidthOrHeight(sheet, colSpans, true, col, mergeBlock);
        height = ImageGenerator.getCellWidthOrHeight(sheet, rowSpans, false, row, mergeBlock);
        if (height <= 0 || width <= 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        SplitRectTextRender render = new SplitRectTextRender();
        CellBackgroundRender backgroundRender = new CellBackgroundRender();
        Rectangle cellShape = new Rectangle(width, height);
        backgroundRender.draw(image.getGraphics(), (Shape)cellShape, (Object)cell, cell.getStyle());
        render.draw(image.getGraphics(), (Shape)cellShape, (Object)o, cell.getStyle());
        return image;
    }

    private static String createImageForAnyTypeImage(EmbedImage o, SheetImpl sheetModel) {
        String result = "";
        IImageModel model = o.getModel();
        if (model != null) {
            try {
                byte[] data = model.getImageData();
                if (data == null) {
                    return result;
                }
                String suffix = ImageUtils.retrieveImageType((byte[])data);
                ImageSave imagesave = new ImageSave(data, EMBED_PREFIX, suffix, sheetModel.getFileSavePath());
                suffix = sheetModel.getFilePrefixPath() + imagesave.getImageName();
                imagesave.save();
                return suffix;
            }
            catch (IOException e) {
                o.getModel().dispose();
                return result;
            }
        }
        return result;
    }

    private static BufferedImage generateImageForEmbedLayer(Sheet sheet, EmbedObject eo) {
        if (sheet == null || eo == null) {
            return null;
        }
        Rectangle rect = eo.getBounds();
        double width = rect.getWidth();
        double height = rect.getHeight();
        int x = rect.x;
        int y = rect.y;
        BufferedImage image = new BufferedImage((int)width + 1, (int)height + 1, 2);
        Graphics g = image.getGraphics();
        g.translate(-x, -y);
        if (!(eo instanceof FlashChart)) {
            eo.paintData(g);
        } else {
            ((FlashChart)eo).getModel().getXml();
        }
        return image;
    }

    private static int getCellWidthOrHeight(Sheet sheet, SortedAttributeSpanArray spans, boolean gettingWidth, int pos, CellBlock mergedBlock) {
        int length = 0;
        int defaultLength = 0;
        defaultLength = gettingWidth ? sheet.getOriginalDefColWidth() : sheet.getOriginalDefRowHeight();
        if (mergedBlock != null) {
            length = ImageGenerator.getMergedBlockWidthOrHeight(sheet, spans, mergedBlock, gettingWidth);
            return length;
        }
        if (spans == null || spans.size() == 0) {
            length = defaultLength;
        } else {
            int index = spans.searchSpan(pos);
            if (index < 0) {
                length = defaultLength;
            } else {
                SortedAttributeSpanArray.AttributeSpan span = spans.getAttributeSpan(index);
                length = span.getLength();
            }
        }
        return length;
    }

    private static int getMergedBlockWidthOrHeight(Sheet sheet, SortedAttributeSpanArray spans, CellBlock mergedBlock, boolean gettingWidth) {
        if (sheet == null) {
            return -1;
        }
        int row = mergedBlock.getRow();
        int row2 = mergedBlock.getRow2();
        int col = mergedBlock.getCol();
        int col2 = mergedBlock.getCol2();
        int length = 0;
        if (gettingWidth) {
            for (int i = col; i <= col2; ++i) {
                length += ImageGenerator.getCellWidthOrHeight(sheet, spans, gettingWidth, i, null);
            }
        } else {
            for (int r = row; r <= row2; ++r) {
                length += ImageGenerator.getCellWidthOrHeight(sheet, spans, gettingWidth, r, null);
            }
        }
        return length;
    }
}

