/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.service.job.core.IRandomGenerator;
import com.kingdee.bos.service.job.core.IServiceInstanceIdGenerator;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.TriggerIsolationLevel;
import com.kingdee.bos.service.job.ext.DefaultInstanceIdGenerator;
import com.kingdee.bos.service.job.ext.DefaultRandomGenerator;
import com.kingdee.bos.service.job.util.Config;
import com.kingdee.util.ConfigurationItem;

public class Configuration {
    public static final String STANDALONE = "standalone";
    private static int maximalConcurrency;
    private static int minimalConcurrency;
    private static int suspendedTransientJobCacheSize;
    private static int jobDefCacheSize;
    private static int jobLoaderInterval;
    private static boolean isDebug;
    private static long job_loader_delay;
    private static long keepAliveTime;
    private static boolean allowCoreThreadTimeOut;
    private static boolean transientJobOnly;
    private static String localIP;
    private static int persistantJobCheckInterval;
    private static int largeJobLowBound;
    private static int smallJobUpBound;
    private static long jobExecutionTimeout;
    private static IRandomGenerator randomGenerator;
    private static JobIsolationLevel defaultJobIsolationLevel;
    private static final String All_Isolation_Level;
    private static String loadJobIsolationLevel;
    private static TriggerIsolationLevel defaultTriggerIsolationLevel;
    private static int clusterBeatSignalInterval;
    private static int clusterBeatSignalTimeout;
    private static String clusterName;
    private static IServiceInstanceIdGenerator serviceInstanceIdGenerator;
    private static boolean abandonMissedFireTicks;
    private static boolean isEnable;
    private static String cluster;
    private static boolean useNewServerId;
    private static String rpcUrl;

    public static int maximalConcurrency() {
        return maximalConcurrency;
    }

    public static int minimalConcurrency() {
        return minimalConcurrency;
    }

    public static int suspendedTransientJobCacheSize() {
        return suspendedTransientJobCacheSize;
    }

    public static int jobDefCacheSize() {
        return jobDefCacheSize;
    }

    public static boolean isDebug() {
        return isDebug;
    }

    public static long jobLoaderDelay() {
        return job_loader_delay;
    }

    public static boolean transientJobOnly() {
        return transientJobOnly;
    }

    public static String getLocalIP() {
        return localIP;
    }

    public static int persistantJobCheckInterval() {
        return persistantJobCheckInterval;
    }

    public static int largeJobLowBound() {
        return largeJobLowBound;
    }

    public static int smallJobUpBound() {
        return smallJobUpBound;
    }

    public static long jobExecutionTimeout() {
        return jobExecutionTimeout;
    }

    public static IRandomGenerator randomGenerator() {
        return randomGenerator;
    }

    public static JobIsolationLevel defaultJobIsolationLevel() {
        return defaultJobIsolationLevel;
    }

    public static String loadJobIsolationLevel() {
        return loadJobIsolationLevel;
    }

    public static TriggerIsolationLevel defaultTriggerIsolationLevel() {
        return defaultTriggerIsolationLevel;
    }

    public static int clusterBeatSignalInterval() {
        return clusterBeatSignalInterval;
    }

    public static int clusterBeatSignalTimeout() {
        return clusterBeatSignalTimeout;
    }

    public static String clusterName() {
        return clusterName;
    }

    public static IServiceInstanceIdGenerator serviceInstanceIdGenerator() {
        return serviceInstanceIdGenerator;
    }

    public static String instanceId() {
        return serviceInstanceIdGenerator.getInstanceId();
    }

    public static String RPCInstanceId() {
        return serviceInstanceIdGenerator.getRPCInstanceId();
    }

    public static String oldInstanceId() {
        return serviceInstanceIdGenerator.getOldInstanceId();
    }

    public static boolean abandonMissedFireTicks() {
        return abandonMissedFireTicks;
    }

    public static boolean isUseNewServerId() {
        return useNewServerId;
    }

    public static String clusterIsolation() {
        return cluster;
    }

    public static String defaultJobIsolationBoundary() {
        return defaultJobIsolationLevel.getJobIsolationBoundary();
    }

    public static String defaultTriggerIsolationBoundary() {
        return defaultTriggerIsolationLevel.getTriggerIsolationBoundary();
    }

    public static ConfigurationItem getConfiguration() {
        return com.kingdee.util.Configuration.getInstance().getConfigItem("scheduler");
    }

    public static int getServiceCapacity() {
        return 100;
    }

    public static int jobLoaderInterval() {
        return jobLoaderInterval;
    }

    public static boolean isEnable() {
        return isEnable;
    }

    public static String getConfigInfo(String dc) {
        StringBuffer sb = new StringBuffer();
        if (isEnable) {
            sb.append("\u670d\u52a1\u5b9e\u4f8b\u7f51\u5361ID\uff1a").append(Configuration.oldInstanceId()).append("\r\n");
            sb.append("\u670d\u52a1\u5b9e\u4f8bRPCID\uff1a").append(Configuration.RPCInstanceId()).append("\r\n");
            sb.append("\u670d\u52a1\u5b9e\u4f8b\u8bb8\u53efID\uff1a").append(Configuration.instanceId()).append("\r\n");
            if (localIP != null) {
                sb.append("\u6307\u5b9aIP\uff1a").append(localIP).append("\r\n");
            }
            sb.append("\u540e\u53f0\u4e8b\u52a1\u96c6\u7fa4\uff1a").append(Configuration.clusterName()).append("\r\n");
            sb.append("\u6700\u5927\u5e76\u53d1\u5ea6\uff1a").append(maximalConcurrency).append("\r\n");
            sb.append("\u6700\u5c0f\u5e76\u53d1\u5ea6\uff1a").append(minimalConcurrency).append("\r\n");
            sb.append("\r\n");
            sb.append("\u4efb\u52a1\u9694\u79bb\u6807\u8bc6\uff1a").append(Configuration.defaultJobIsolationBoundary()).append("\r\n");
            sb.append("\u4efb\u52a1\u9694\u79bb\u8fb9\u754c\uff1a").append(JobIsolationLevel.sqlWhere(dc)).append("\r\n");
            sb.append("\u89e6\u53d1\u5668\u9694\u79bb\u6807\u8bc6\uff1a").append(Configuration.defaultTriggerIsolationBoundary()).append("\r\n");
            sb.append("\u89e6\u53d1\u5668\u9694\u79bb\u8fb9\u754c\uff1a").append(TriggerIsolationLevel.sqlWhere(dc)).append("\r\n");
        } else {
            String instanceName = System.getProperty("EAS_INSTANCE_NAME");
            if (instanceName != null) {
                sb.append("\u540e\u53f0\u4e8b\u52a1\u670d\u52a1\u672a\u542f\u52a8\uff088.5\u53ca\u4ee5\u4e0a\u7248\u672c\u4e3b\u5b9e\u4f8b\u9ed8\u8ba4\u4e0d\u542f\u52a8\uff09\uff0c\u8bf7\u67e5\u770b\r\n").append("eas/server/profiles/").append(instanceName).append("/config/bosconfig.xml\u6587\u4ef6\u914d\u7f6e\u4fe1\u606f\r\n");
            } else {
                sb.append("\u540e\u53f0\u4e8b\u52a1\u670d\u52a1\u672a\u542f\u52a8\uff0c\u8bf7\u67e5\u770b\r\n").append("{\u89e3\u51b3\u65b9\u6848\u76ee\u5f55}/runtime/server/profiles/server1/config/bosconfig.xml\u6587\u4ef6\u914d\u7f6e\u4fe1\u606f\r\n");
            }
            sb.append("<configitem name=\"scheduler\">\r\n").append("  <attribute key=\"enable\" value=\"false\"/>\r\n").append("</configitem>\r\n").append("\u4fee\u6539enable\u53c2\u6570\u4e3atrue\uff0c\u91cd\u542f\u670d\u52a1\u5668\u5373\u53ef\u542f\u52a8\u540e\u53f0\u4e8b\u52a1\u670d\u52a1\u3002\r\n");
        }
        return sb.toString();
    }

    private static boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }

    public static String getRpcUrl() {
        if (rpcUrl == null) {
            try {
                rpcUrl = ORMRPConfig.getRPCListeningURL((boolean)false);
            }
            catch (Exception e) {
                return null;
            }
        }
        return rpcUrl;
    }

    public static long getKeepAliveTime() {
        return keepAliveTime;
    }

    public static boolean isAllowCoreThreadTimeOut() {
        return allowCoreThreadTimeOut;
    }

    static {
        jobLoaderInterval = 3;
        keepAliveTime = 120L;
        allowCoreThreadTimeOut = true;
        loadJobIsolationLevel = All_Isolation_Level = JobIsolationLevel.allValues();
        clusterName = STANDALONE;
        isEnable = true;
        cluster = null;
        useNewServerId = false;
        String config = "scheduler";
        int tmp = Config.getInt(config, "maximal_concurrency");
        maximalConcurrency = tmp < 1 ? 6 : (tmp < 3 ? 3 : (tmp > 100 ? 100 : tmp));
        tmp = Config.getInt(config, "minimal_concurrency");
        if (tmp < 1) {
            tmp = maximalConcurrency - 2;
        }
        int n = tmp <= 1 ? 1 : (minimalConcurrency = tmp >= 99 ? 99 : tmp);
        if (minimalConcurrency >= maximalConcurrency) {
            minimalConcurrency = maximalConcurrency - 1;
        }
        suspendedTransientJobCacheSize = (tmp = Config.getInt(config, "suspended_transient_job_cache_size")) <= 100 ? 100 : (tmp >= 1000 ? 1000 : tmp);
        tmp = Config.getInt(config, "job_def_cache_size");
        jobDefCacheSize = tmp <= 100 ? 100 : (tmp >= 1000 ? 1000 : tmp);
        tmp = Config.getInt(config, "persistant_job_check_interval");
        if (tmp <= 0) {
            tmp = 1;
        }
        persistantJobCheckInterval = tmp < 1 ? 1 : (tmp > 100 ? 100 : tmp);
        tmp = Config.getInt(config, "large_job_low_bound");
        largeJobLowBound = tmp <= 1 ? 1 : (tmp >= 60 ? 60 : tmp);
        largeJobLowBound *= 1000;
        tmp = Config.getInt(config, "small_job_up_bound");
        smallJobUpBound = tmp <= 1 ? 1 : (tmp >= 60 ? 60 : tmp);
        smallJobUpBound *= 1000;
        tmp = Config.getInt(config, "job_execution_timeout");
        jobExecutionTimeout = tmp < 0 ? 60L : (long)(tmp <= 10 ? 10 : (tmp >= 900 ? 900 : tmp));
        jobExecutionTimeout *= 1000L;
        String s = Config.getString(config, "default_job_isolation_level");
        if (s != null && s.length() > 0) {
            try {
                defaultJobIsolationLevel = JobIsolationLevel.valueOf(s);
            }
            catch (Exception e) {
                defaultJobIsolationLevel = JobIsolationLevel.Server;
            }
        } else {
            defaultJobIsolationLevel = JobIsolationLevel.Server;
        }
        if ((s = Config.getString(config, "load_job_isolation_level")) != null && s.length() > 0) {
            try {
                String[] levels = s.split("\\|");
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < levels.length; ++i) {
                    JobIsolationLevel l = JobIsolationLevel.valueOf(levels[i]);
                    if (l == null) continue;
                    if (sb.length() > 0) {
                        sb.append("|");
                    }
                    sb.append(l.toString());
                }
                loadJobIsolationLevel = sb.length() > 0 ? sb.toString() : All_Isolation_Level;
            }
            catch (Exception e) {
                loadJobIsolationLevel = All_Isolation_Level;
            }
        }
        if ((tmp = Config.getInt(config, "jobLoaderInterval")) > 0 && tmp < 30) {
            jobLoaderInterval = tmp;
        }
        tmp = Config.getInt(config, "job_loader_delay");
        job_loader_delay = Math.max(30, tmp) * 1000;
        s = Config.getString(config, "abandon_missed_fire_ticks");
        if (s != null && s.length() > 0) {
            try {
                abandonMissedFireTicks = new Boolean(s);
            }
            catch (Exception e) {
                abandonMissedFireTicks = true;
            }
        } else {
            abandonMissedFireTicks = true;
        }
        if ((s = Config.getString(config, "default_trigger_isolation_level")) != null && s.length() > 0) {
            try {
                defaultTriggerIsolationLevel = TriggerIsolationLevel.valueOf(s);
            }
            catch (Exception e) {
                defaultTriggerIsolationLevel = TriggerIsolationLevel.Server;
            }
        } else {
            defaultTriggerIsolationLevel = TriggerIsolationLevel.Server;
        }
        if ((tmp = Config.getInt(config, "cluster_beat_signal_interval")) <= 0) {
            tmp = 5;
        }
        clusterBeatSignalInterval = tmp <= 1 ? 1 : (tmp >= 10 ? 10 : tmp);
        clusterBeatSignalInterval *= 60;
        tmp = Config.getInt(config, "cluster_beat_signal_timeout");
        if (tmp <= 0) {
            tmp = 15;
        }
        int n2 = tmp <= 15 ? 15 : (clusterBeatSignalTimeout = tmp >= 60 ? 60 : tmp);
        if ((clusterBeatSignalTimeout *= 60) < clusterBeatSignalInterval * 3) {
            clusterBeatSignalTimeout = clusterBeatSignalInterval * 3;
        }
        clusterBeatSignalTimeout *= 1000;
        s = Config.getString(config, "service_instance_id_generator");
        if (s != null && s.length() > 0) {
            try {
                serviceInstanceIdGenerator = (IServiceInstanceIdGenerator)Class.forName(s).newInstance();
            }
            catch (Throwable e) {
                serviceInstanceIdGenerator = new DefaultInstanceIdGenerator();
            }
        } else {
            serviceInstanceIdGenerator = new DefaultInstanceIdGenerator();
        }
        if ((s = Config.getString(config, "random_generator")) != null && s.length() > 0) {
            try {
                randomGenerator = (IRandomGenerator)Class.forName(s).newInstance();
            }
            catch (Throwable e) {
                randomGenerator = new DefaultRandomGenerator();
            }
        } else {
            randomGenerator = new DefaultRandomGenerator();
        }
        if ((s = Config.getString(config, "debug")) != null && s.length() > 0) {
            try {
                isDebug = new Boolean(s);
            }
            catch (Throwable e) {
                isDebug = true;
            }
        } else {
            isDebug = false;
        }
        if ((s = Config.getString(config, "transient_job_only")) != null && s.length() > 0) {
            try {
                transientJobOnly = new Boolean(s);
            }
            catch (Throwable e) {
                transientJobOnly = false;
            }
        } else {
            transientJobOnly = false;
        }
        String string = localIP = (s = Config.getString(config, "local_ip")) == null ? null : s.trim();
        if (localIP != null && localIP.length() == 0) {
            localIP = null;
        }
        if ((s = Config.getString(config, "clusterName")) != null && s.length() > 0) {
            clusterName = s;
        }
        if ((s = Config.getString(config, "enable")) != null && s.length() > 0) {
            isEnable = "true".equalsIgnoreCase(s);
        }
        if ((s = Config.getString(config, "clusterValue")) != null && s.length() > 0) {
            cluster = s;
        }
        if ((s = Config.getString(config, "useNewServerId")) != null && s.length() > 0) {
            useNewServerId = "true".equalsIgnoreCase(s);
        }
        keepAliveTime = (long)(tmp = Config.getInt(config, "keepAliveTime")) < 120L ? 120L : (long)tmp;
        s = Config.getString(config, "allowCoreThreadTimeOut");
        if (s != null && s.length() > 0) {
            allowCoreThreadTimeOut = "true".equalsIgnoreCase(s);
        }
        rpcUrl = null;
    }
}

