/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.JobEvent;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.util.IListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public final class JobInstanceConfig
implements Serializable {
    public static final int HIGH = 1000000;
    public static final int LOW = -1000000;
    private static final long serialVersionUID = 8963222659092451721L;
    public static final int DEFAULT_PRIORITY = 500;
    HashMap listeners;
    IJobHandler handler;
    int priority;
    boolean isSmallJob;
    String mutex;
    String viewerUI;
    boolean isPersistent;
    String serviceType;
    JobIsolationLevel jobIsolationlevel;
    int threadUBound;
    String threadName;
    int runTimeout;

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public int getRunTimeout() {
        return this.runTimeout;
    }

    public void setRunTimeout(int runTimeout) {
        this.runTimeout = runTimeout;
    }

    public JobInstanceConfig(IJobHandler handler) {
        this(handler, null);
    }

    public JobInstanceConfig(IJobHandler handler, boolean isPersistent) {
        this(handler, isPersistent, true, 500, null, null, null);
    }

    public JobInstanceConfig(IJobHandler handler, String viewerUI) {
        this(handler, true, true, 500, null, viewerUI, null);
    }

    public JobInstanceConfig(IJobHandler handler, boolean isPersistent, boolean isSmall, int priority) {
        this(handler, isPersistent, isSmall, priority, null, null, null);
    }

    public JobInstanceConfig(IJobHandler handler, boolean isPersistent, boolean isSmall, int priority, String mutex, String viewerUI, JobIsolationLevel level) {
        this(handler, isPersistent, isSmall, priority, mutex, viewerUI, level, null, 0);
    }

    public JobInstanceConfig(IJobHandler handler, boolean isPersistent, boolean isSmall, int priority, String mutex, String viewerUI, JobIsolationLevel level, String threadName, int threadUBound) {
        if (priority < -1000000) {
            priority = -1000000;
        } else if (priority > 1000000) {
            priority = 1000000;
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler couldn't be null!");
        }
        if (!(handler instanceof Serializable)) {
            throw new IllegalArgumentException("handler is not serializable!");
        }
        this.priority = priority;
        this.mutex = mutex == null ? null : mutex.trim().toLowerCase();
        this.isPersistent = isPersistent;
        this.isSmallJob = isSmall;
        this.viewerUI = viewerUI;
        this.handler = handler;
        this.jobIsolationlevel = level;
        if (threadName != null && (threadName = threadName.replaceAll("'", "").trim()).length() == 0) {
            threadName = null;
        }
        this.threadName = threadName;
        this.threadUBound = threadUBound;
    }

    public final boolean addEventListener(JobEvent e, IListener h) {
        ArrayList<IListener> list;
        if (this.listeners == null) {
            this.listeners = new HashMap();
        }
        if ((list = (ArrayList<IListener>)this.listeners.get(e)) == null) {
            list = new ArrayList<IListener>();
            this.listeners.put(e, list);
        }
        if (list.contains(h)) {
            return false;
        }
        list.add(h);
        return true;
    }
}

