/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.job.util.Serialization;
import com.kingdee.bos.service.job.wrapper.SqlExecutor;
import com.kingdee.util.Uuid;
import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public final class JobLog
implements Serializable {
    private static final long serialVersionUID = -7063744205536800537L;
    private static Logger log = Logger.getLogger((String)JobLog.class.getName());
    private Timestamp createdTime = new Timestamp(System.currentTimeMillis());
    private Type type;
    private String description;
    private String reason;
    private String advice;
    private Throwable e;

    public JobLog(Type type, String description) {
        this.type = type;
        this.description = description;
    }

    public JobLog(Type type, String description, String reason, String advice, Throwable e) {
        this(type, description);
        this.reason = reason;
        this.advice = advice;
        this.e = e;
    }

    public JobLog(Type type, String description, String reason, String advice, Throwable e, Timestamp createdTime) {
        this(type, description);
        this.reason = reason;
        this.advice = advice;
        this.e = e;
        if (createdTime != null) {
            this.createdTime = createdTime;
        }
    }

    public String toString() {
        return "message type:" + this.type.toString() + "\r\ndescription:" + this.description + "\r\nreason:" + this.reason + "\r\nadvide:" + this.advice + "\r\nstack:" + Serialization.dump(this.e);
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Type getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReason() {
        return this.reason;
    }

    public String getAdvice() {
        return this.advice;
    }

    public Throwable getException() {
        return this.e;
    }

    public void save(String dc, String ownerId) {
        try {
            String sql = "insert into T_JOB_LOG(fid,fownerid, fcreatedtime, fmsgtype,fdescription, freason, fadvice, fexception) values(?,?,?,?,?,?,?,?)";
            int[] types = new int[]{12, 12, 93, 12, 12, 12, 12, 12};
            Object[] values = new Object[]{Uuid.randomUUID().toString() + "JOBMSGLG", ownerId, this.createdTime, this.type.toString(), this.description, this.reason, this.advice, Serialization.dump(this.e)};
            SQL.executeUpdate(dc, sql, types, values);
        }
        catch (Throwable e) {
            log.error((Object)("save job {" + ownerId + "}'s message failed!\r\n" + this), e);
        }
    }

    public void asyncSave(Context ctx, String ownerId) {
        String sql = "insert into T_JOB_LOG(fid,fownerid, fcreatedtime, fmsgtype,fdescription, freason, fadvice, fexception) values(?,?,?,?,?,?,?,?)";
        int[] types = new int[]{12, 12, 93, 12, 12, 12, 12, 12};
        Object[] values = new Object[]{Uuid.randomUUID().toString() + "JOBMSGLG", ownerId, this.createdTime, this.type.toString(), this.description, this.reason, this.advice, Serialization.dump(this.e)};
        SqlExecutor.asynExecute(ctx, sql, types, values);
    }

    public static final class Type
    implements Serializable {
        private static final long serialVersionUID = -2232928252050791791L;
        private String type;
        public static final Type Info = new Type("Info");
        public static final Type Warn = new Type("Warn");
        public static final Type Error = new Type("Error");

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

