/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IDaemonJobHandler;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.IWfJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobEvent;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.RunningJobs;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.service.job.util.Cache;
import org.apache.log4j.Logger;

class JobMonitor
implements IJobHandler,
IDaemonJobHandler {
    private static final Logger log = Logger.getLogger((String)JobMonitor.class.getName());
    private static final long serialVersionUID = 2715316276574368903L;
    private Cache cache = new Cache(128);

    JobMonitor() {
    }

    @Override
    public Object execute(Job job) {
        try {
            this.check();
        }
        catch (Throwable e) {
            log.error((Object)"JobMonitor failed.", e);
        }
        long delay = Math.max(5000L, Configuration.jobExecutionTimeout() / 2L);
        return new Delay(delay);
    }

    private void check() {
        Job[] jobs = RunningJobs.getJobs();
        long now = System.currentTimeMillis();
        long timeout = Configuration.jobExecutionTimeout();
        long timeout_big = timeout * 2L;
        for (Job job : jobs) {
            int count;
            long comp;
            Object tmp;
            Thread t = job.getThread();
            if (t == null) continue;
            long startedTime = job.getStartedTime().getTime();
            int runTimeout = job.getRunTimeout();
            if (runTimeout > 0 && now - startedTime > (long)(runTimeout * 1000) && (tmp = this.cache.getCachedObject(job.getId() + runTimeout)) == null) {
                this.saveTimeoutLog(t, job);
                JobManager.instance().raiseEvent(JobEvent.OnOvertime, job);
                this.cache.pushCachedObject(job.getId() + runTimeout, 1);
            }
            long l = comp = job.getHandler() instanceof IWfJobHandler ? timeout : timeout_big;
            if (now - startedTime < comp) continue;
            Object tmp2 = this.cache.getCachedObject(job.getId());
            int n = count = tmp2 == null ? 0 : (Integer)tmp2;
            if (count >= 5) continue;
            this.saveLog(t, job);
            this.cache.pushCachedObject(job.getId(), count + 1);
        }
    }

    private void saveLog(Thread t, Job job) {
        StackTraceElement[] stack = t.getStackTrace();
        StringBuilder sb = new StringBuilder(1024);
        sb.append("Job execution elapsed too long. The job is {" + job.getTitle() + "\uff0c" + job.getId() + "}, and was started at " + job.getStartedTime() + ".\r\n");
        for (StackTraceElement se : stack) {
            sb.append("\t at ").append(se.getClassName()).append('.').append(se.getMethodName()).append('(').append(se.getFileName()).append(':').append(se.getLineNumber()).append(")\r\n");
        }
        log.warn((Object)sb.toString());
    }

    private void saveTimeoutLog(Thread t, Job job) {
        Throwable throwable = new Throwable("Job executed more than " + job.getRunTimeout() + " seconds. The job is {" + job.getTitle() + "," + job.getId() + "}, and was started at " + job.getStartedTime());
        throwable.setStackTrace(t.getStackTrace());
        JobLog msg = new JobLog(JobLog.Type.Warn, "Job execution over " + job.getRunTimeout() + " seconds.", null, null, throwable);
        msg.save(job.getContext().getAIS(), job.getId());
    }
}

