/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IServiceInstanceIdGenerator;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.service.job.util.SQL;
import java.sql.Connection;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class JobUtils {
    private static Logger log = Logger.getLogger((String)JobUtils.class.getName());
    private static String reScheduleSQL = "update t_job_inst set  fstartedtime=null, fholderid=null, fexpiredtime=null, fscheduledtime=?,fstatechangedtime=?, fstate=? where fjobinstid = ?";

    public static int reSchedule(Context ctx, String jobId, int offset) throws BOSException {
        ClusterStateManager cm = ClusterStateManager.get(ctx);
        Timestamp fscheduledtime = cm.dbNow(offset);
        Timestamp fstatechangedtime = cm.dbNow();
        int r = SQL.executeUpdate(ctx, reScheduleSQL, new int[]{93, 93, 12, 12}, new Object[]{fscheduledtime, fstatechangedtime, JobState.ReScheduled.toString(), jobId});
        return r;
    }

    public static int reSchedule(String dc, String jobId, int offset) throws BOSException {
        Timestamp fscheduledtime = new Timestamp(System.currentTimeMillis());
        Timestamp fstatechangedtime = new Timestamp(System.currentTimeMillis() + (long)offset);
        int r = SQL.executeUpdate(dc, reScheduleSQL, new int[]{93, 93, 12, 12}, new Object[]{fscheduledtime, fstatechangedtime, JobState.ReScheduled.toString(), jobId});
        return r;
    }

    public static void updateIsolationBoundary(String dc) {
        Connection cn = null;
        try {
            cn = DbConnector.getConnection(dc);
            JobUtils.updateTriggerIsolationBoundary(cn);
            JobUtils.updateJobIsolationBoundary(cn);
        }
        catch (Throwable e) {
            log.error((Object)"update IsolationBoundary fail", e);
        }
        finally {
            try {
                if (cn != null) {
                    cn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void updateTriggerIsolationBoundary(Connection cn) throws BOSException {
        Object[] values;
        IServiceInstanceIdGenerator g = Configuration.serviceInstanceIdGenerator();
        String sql = "update T_JOB_TRIGGER set FISOLATIONBOUNDARY = ? where FHOLDERID is null and FISOLATIONBOUNDARY = ?";
        int[] types = new int[]{12, 12};
        if (!g.isSameIp()) {
            values = new Object[]{g.getServerId(), g.getOldServerId()};
            SQL.executeUpdate(cn, sql, types, values);
            values = new Object[]{g.getNewServerId(), g.getOldNewServerId()};
            SQL.executeUpdate(cn, sql, types, values);
        }
        if (!g.isSameIpForRPC()) {
            values = new Object[]{g.getServerId(), g.getRPCServerId()};
            SQL.executeUpdate(cn, sql, types, values);
            values = new Object[]{g.getNewServerId(), g.getRPCNewServerId()};
            SQL.executeUpdate(cn, sql, types, values);
        }
    }

    public static void updateJobIsolationBoundary(Connection cn) throws BOSException {
        Object[] values;
        IServiceInstanceIdGenerator g = Configuration.serviceInstanceIdGenerator();
        String sql = "update T_JOB_INST set FISOLATIONBOUNDARY = ? where FHOLDERID is null and FISOLATIONBOUNDARY = ?";
        int[] types = new int[]{12, 12};
        if (!g.isSameIp()) {
            values = new Object[]{g.getServerId(), g.getOldServerId()};
            SQL.executeUpdate(cn, sql, types, values);
            values = new Object[]{g.getNewServerId(), g.getOldNewServerId()};
            SQL.executeUpdate(cn, sql, types, values);
        }
        if (!g.isSameIpForRPC()) {
            values = new Object[]{g.getServerId(), g.getRPCServerId()};
            SQL.executeUpdate(cn, sql, types, values);
            values = new Object[]{g.getNewServerId(), g.getRPCNewServerId()};
            SQL.executeUpdate(cn, sql, types, values);
        }
        if (!g.isSameIp()) {
            values = new Object[]{g.getInstanceId(), g.getOldInstanceId()};
            SQL.executeUpdate(cn, sql, types, values);
        }
        if (!g.isSameIpForRPC()) {
            values = new Object[]{g.getInstanceId(), g.getRPCInstanceId()};
            SQL.executeUpdate(cn, sql, types, values);
        }
    }
}

