/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.ext;

import com.kingdee.bos.framework.bp.BPJob;
import com.kingdee.bos.framework.bp.IJobServiceProvider;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobManager;
import org.apache.log4j.Logger;

public class DynamicBackgroundServiceProvider
implements IJobServiceProvider {
    private static Logger log = Logger.getLogger((String)DynamicBackgroundServiceProvider.class.getName());
    private static final DynamicBackgroundJobHandler handler = new DynamicBackgroundJobHandler();

    public boolean submit(BPJob bpJob) {
        JobInstanceConfig cfg = new JobInstanceConfig(handler, bpJob.getOption().isPersistent(), true, bpJob.getOption().getPriority());
        Job job = new Job(null, "dynamic background job executing!", cfg, (Object)bpJob);
        try {
            JobManager.instance().add(job);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("accept dynamic background job failed. " + bpJob.toString()), (Throwable)e);
            return false;
        }
    }

    private static class DynamicBackgroundJobHandler
    implements IJobHandler {
        private static final long serialVersionUID = 983302828906069043L;

        private DynamicBackgroundJobHandler() {
        }

        @Override
        public Object execute(Job job) throws Exception {
            BPJob r = (BPJob)job.getParameters();
            r.run();
            return null;
        }
    }
}

