/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.pulse;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IPulse;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.service.job.util.IHeapElement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class TimerPulse
implements IPulse,
IHeapElement {
    private Trigger quartzTrigger;
    private String key;
    private Date nextFireTime;
    private Date lastTriggeredTime;
    private com.kingdee.bos.service.job.core.Trigger trigger;
    private static Logger log = Logger.getLogger((String)TimerPulse.class.getName());

    public TimerPulse(com.kingdee.bos.service.job.core.Trigger trigger) throws Exception {
        this.key = trigger.getKey();
        String plan = TimerPulse.narrow(trigger.getSchedulePlan());
        this.generateQuartzTrigger(trigger, plan);
        this.trigger = trigger;
        this.lastTriggeredTime = trigger.getLastTriggeredTime();
        if (this.lastTriggeredTime == null) {
            this.lastTriggeredTime = trigger.getValidateTime();
        }
        if (this.quartzTrigger != null) {
            this.nextFireTime = this.quartzTrigger.getFireTimeAfter(this.lastTriggeredTime);
            if (Configuration.abandonMissedFireTicks()) {
                ClusterStateManager cm = ClusterStateManager.get(trigger.getDatacenter());
                Timestamp now = cm.dbNow();
                if (this.nextFireTime != null && this.nextFireTime.before(now)) {
                    boolean isLogAbandonMissed = false;
                    if (trigger.isFireLastMissedJob()) {
                        Date fireTimeAfter = this.quartzTrigger.getFireTimeAfter(this.nextFireTime);
                        if (fireTimeAfter != null && fireTimeAfter.before(now)) {
                            isLogAbandonMissed = true;
                        }
                        if (this.quartzTrigger instanceof CronTriggerImpl) {
                            Date nextFireTime;
                            CronTriggerImpl cti = (CronTriggerImpl)this.quartzTrigger;
                            CronTriggerImpl c = (CronTriggerImpl)cti.clone();
                            c.setEndTime(null);
                            Date clone = (Date)now.clone();
                            Date lastFireTime = null;
                            while ((nextFireTime = c.getFireTimeAfter(clone)) != null) {
                                clone = nextFireTime;
                                long interval = nextFireTime.getTime() - ((Date)now).getTime();
                                Date date = new Date(((Date)now).getTime() - interval - 1L);
                                if (date.before(cti.getStartTime())) {
                                    date = cti.getStartTime();
                                }
                                if ((lastFireTime = cti.getFireTimeAfter(date)) == null || !lastFireTime.before(now)) continue;
                                break;
                            }
                            while (lastFireTime != null && lastFireTime.before(now)) {
                                this.nextFireTime = lastFireTime;
                                lastFireTime = cti.getFireTimeAfter(lastFireTime);
                            }
                        }
                        if (this.quartzTrigger instanceof SimpleTriggerImpl) {
                            SimpleTriggerImpl sti = (SimpleTriggerImpl)this.quartzTrigger;
                            this.nextFireTime = sti.getFireTimeBefore((Date)now);
                        }
                    } else {
                        this.nextFireTime = this.quartzTrigger.getFireTimeAfter((Date)now);
                        isLogAbandonMissed = true;
                    }
                    if (isLogAbandonMissed) {
                        String description = "because of {abandon_missed_fire_tick} strategy, some fire ticks of trigger {" + trigger.getKey() + "} were abandoned!";
                        JobLog msg = new JobLog(JobLog.Type.Warn, description, null, null, null);
                        msg.save(trigger.getDatacenter(), trigger.getJobDefID());
                    }
                }
            }
        }
    }

    private void generateQuartzTrigger(com.kingdee.bos.service.job.core.Trigger trigger, String plan) throws ParseException {
        Date startDate = trigger.getValidateTime();
        Date expireDate = new Date(trigger.getExpiredTime().getTime() + 86400000L - 1L);
        if (plan.indexOf(32) >= 0) {
            this.quartzTrigger = TriggerBuilder.newTrigger().withIdentity(this.key, this.key).forJob(this.key, this.key).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)plan)).startAt(startDate).endAt(expireDate).build();
        } else {
            String[] array = plan.split("/");
            long interval = Long.parseLong(array[0]);
            int count = Integer.parseInt(array[1]);
            if (count <= 0) {
                count = Integer.MAX_VALUE;
            }
            this.quartzTrigger = TriggerBuilder.newTrigger().withIdentity(this.key, this.key).forJob(this.key, this.key).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(count).withIntervalInMilliseconds(interval)).startAt(startDate).endAt(expireDate).build();
        }
    }

    @Override
    public String getDataCenter() {
        return this.trigger.getDatacenter();
    }

    static void verify(String plan) throws BOSException {
        plan = TimerPulse.narrow(plan);
        try {
            TriggerBuilder.newTrigger().withIdentity("NULL", "NULL").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)plan)).build();
        }
        catch (Exception e) {
            throw new BOSException("schedule plan {" + plan + "} is invalid.", (Throwable)e);
        }
    }

    static String narrow(String plan) {
        int i = plan.indexOf(":");
        if (i >= 0) {
            plan = plan.substring(i + 1);
        }
        return plan;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public long getPriority() {
        Timestamp d = this.nextFireTime();
        if (d == null) {
            throw new RuntimeException("next fire time is null, couldn't access timer pulse {" + this.key + "}");
        }
        return ((Date)d).getTime();
    }

    @Override
    public Timestamp nextFireTime() {
        ClusterStateManager cm = ClusterStateManager.get(this.trigger.getDatacenter());
        return cm.toLocalTime(this.nextFireTime);
    }

    @Override
    public boolean fire() {
        boolean b;
        if (!this.trigger.triggered(this.nextFireTime)) {
            log.error((Object)("\u89e6\u53d1\u5931\u8d25\uff0c5\u5206\u949f\u540e\u4f1a\u7ee7\u7eed\u91cd\u8bd5\uff0c\u8be6\u7ec6\u539f\u56e0\u8bf7\u67e5\u770bt_job_log\u8868\u5806\u6808  \uff1a" + this.trigger.getJobDefID()));
            this.lastTriggeredTime = this.nextFireTime;
            this.nextFireTime = new Date(System.currentTimeMillis() + 300000L);
        } else {
            this.lastTriggeredTime = this.nextFireTime;
            this.nextFireTime = this.quartzTrigger.getFireTimeAfter(this.lastTriggeredTime);
        }
        boolean bl = b = this.nextFireTime != null;
        if (!b) {
            this.trigger.inValid();
            JobLog msg = new JobLog(JobLog.Type.Info, "inValid trigger {" + this.trigger.getJobDefID() + "} because has no fire time!", null, null, null);
            msg.save(this.trigger.getDatacenter(), this.trigger.getJobDefID());
        }
        return b;
    }

    boolean setLoaded() {
        return this.trigger.setLoaded();
    }

    public com.kingdee.bos.service.job.core.Trigger getTrigger() {
        return this.trigger;
    }
}

