/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.util;

import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;

public class Config {
    public static String getString(String config, String property) {
        ConfigurationItem item = Configuration.getInstance().getConfigItem(config);
        if (item == null) {
            return null;
        }
        String tmp = item.getProperty(property);
        if (tmp == null) {
            return null;
        }
        return tmp.trim();
    }

    public static int getInt(String config, String property) {
        ConfigurationItem item = Configuration.getInstance().getConfigItem(config);
        if (item == null) {
            return -1;
        }
        String tmp = item.getProperty(property);
        if (tmp == null) {
            return -1;
        }
        try {
            return Integer.parseInt(tmp.trim());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static String[] getLocalAddresses() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                Enumeration<InetAddress> en2 = ni.getInetAddresses();
                while (en2.hasMoreElements()) {
                    InetAddress ia = en2.nextElement();
                    if (!ia.isSiteLocalAddress()) continue;
                    list.add(ia.getHostAddress());
                }
            }
            Object[] addresses = list.toArray(new String[list.size()]);
            Arrays.sort(addresses);
            return addresses;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public static String getConfigPath(String fileName) {
        String tmp = System.getProperty("java.security.auth.login.config");
        if (tmp == null) {
            throw new RuntimeException("{java.security.auth.login.config} is not setted!");
        }
        int i = tmp.lastIndexOf("/");
        if (i < 0) {
            throw new RuntimeException("{java.security.auth.login.config}'s value '" + tmp + "' is invalid!");
        }
        String path = tmp.substring(0, i) + "/" + fileName;
        return path;
    }
}

