/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.util.DbConnector;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class SQL {
    public static int executeUpdate(Context ctx, String sql) throws BOSException {
        Connection cn = DbConnector.getConnection(ctx);
        try {
            int n = SQL.executeUpdate(sql, cn);
            return n;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQL.close(cn);
        }
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void close(Connection cn) {
        try {
            cn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(Statement smt) {
        try {
            if (smt != null) {
                smt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(ResultSet rs, Statement smt, Connection cn) {
        SQL.close(rs);
        SQL.close(smt);
        SQL.close(cn);
    }

    public static int executeUpdate(String datacenter, String sql) throws BOSException {
        Connection cn = DbConnector.getConnection(datacenter);
        try {
            int n = SQL.executeUpdate(sql, cn);
            return n;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQL.close(cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(String sql, Connection cn) throws SQLException {
        Statement smt = null;
        try {
            smt = cn.createStatement();
            int n = smt.executeUpdate(sql);
            return n;
        }
        finally {
            SQL.close(smt);
        }
    }

    public static int executeUpdate(Context ctx, String sql, int[] types, Object[] params) throws BOSException {
        int n;
        Connection cn = DbConnector.getConnection(ctx);
        PreparedStatement psm = null;
        try {
            psm = SQL.prepareStatement(cn, sql, types, params);
            n = psm.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQL.close(psm);
                SQL.close(cn);
                throw throwable;
            }
        }
        SQL.close(psm);
        SQL.close(cn);
        return n;
    }

    private static void close(PreparedStatement psm) {
        try {
            if (psm != null) {
                psm.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(String datacenter, String sql, int[] types, Object[] params) throws BOSException {
        Connection cn = DbConnector.getConnection(datacenter);
        try {
            int n = SQL.executeUpdate(cn, sql, types, params);
            return n;
        }
        finally {
            SQL.close(cn);
        }
    }

    public static int executeUpdate(Connection cn, String sql, int[] types, Object[] params) throws BOSException {
        int n;
        PreparedStatement psm = null;
        try {
            psm = SQL.prepareStatement(cn, sql, types, params);
            n = psm.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQL.close(psm);
                throw throwable;
            }
        }
        SQL.close(psm);
        return n;
    }

    public static PreparedStatement prepareStatement(Connection cn, String sql, int[] types, Object[] params) throws SQLException {
        PreparedStatement psm = cn.prepareStatement(sql);
        for (int i = 0; i < types.length; ++i) {
            if (params[i] != null) {
                psm.setObject(i + 1, params[i], types[i]);
                continue;
            }
            psm.setNull(i + 1, types[i]);
        }
        return psm;
    }

    public static ArrayList executeQuery(Context ctx, String sql, int[] types, Object[] params) throws BOSException {
        ArrayList arrayList;
        Connection cn = DbConnector.getConnection(ctx);
        PreparedStatement psm = null;
        try {
            psm = SQL.prepareStatement(cn, sql, types, params);
            ResultSet rs = psm.executeQuery();
            arrayList = SQL.toArray(rs);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQL.close(psm);
                SQL.close(cn);
                throw throwable;
            }
        }
        SQL.close(psm);
        SQL.close(cn);
        return arrayList;
    }

    public static ArrayList executeQuery(String datacenter, String sql, int[] types, Object[] params) throws BOSException {
        ArrayList arrayList;
        Connection cn = DbConnector.getConnection(datacenter);
        PreparedStatement psm = null;
        try {
            psm = SQL.prepareStatement(cn, sql, types, params);
            ResultSet rs = psm.executeQuery();
            arrayList = SQL.toArray(rs);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQL.close(psm);
                SQL.close(cn);
                throw throwable;
            }
        }
        SQL.close(psm);
        SQL.close(cn);
        return arrayList;
    }

    public static ArrayList executeQuery(Connection cn, String sql, int[] types, Object[] params) throws BOSException {
        ArrayList arrayList;
        PreparedStatement psm = null;
        try {
            psm = SQL.prepareStatement(cn, sql, types, params);
            ResultSet rs = psm.executeQuery();
            arrayList = SQL.toArray(rs);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQL.close(psm);
                throw throwable;
            }
        }
        SQL.close(psm);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList toArray(ResultSet rs) throws SQLException, IOException {
        ResultSetMetaData meta = rs.getMetaData();
        String[] names = new String[meta.getColumnCount() + 1];
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            names[i] = meta.getColumnName(i).toLowerCase();
        }
        ArrayList list = new ArrayList();
        try {
            SQL.resultSet2Array(rs, names, list);
        }
        finally {
            SQL.close(rs);
        }
        return list;
    }

    private static void resultSet2Array(ResultSet rs, String[] names, ArrayList list) throws SQLException, IOException {
        while (rs.next()) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            for (int i = 1; i < names.length; ++i) {
                Object v = rs.getObject(i);
                if ((v = SQL.convert(v)) == null) continue;
                item.put(names[i], v);
            }
            list.add(item);
        }
    }

    private static Object convert(Object o) throws SQLException, IOException {
        if (o instanceof Clob) {
            return SQL.clobToString((Clob)o);
        }
        if (o instanceof Blob) {
            return SQL.fromBlob((Blob)o);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object fromBlob(Blob blob) throws SQLException, IOException {
        if (blob == null) {
            return null;
        }
        int len = (int)blob.length();
        if (len == 0) {
            return null;
        }
        byte[] bytes = new byte[len];
        try (InputStream is = blob.getBinaryStream();){
            is.read(bytes);
        }
        return bytes;
    }

    private static String clobToString(Clob clob) throws SQLException, IOException {
        StringBuffer sb = new StringBuffer();
        try (Reader r = clob.getCharacterStream();){
            int ch22;
            while ((ch22 = r.read()) >= 0) {
                sb.append((char)ch22);
            }
            String ch22 = sb.toString();
            return ch22;
        }
    }

    public static ArrayList executeQuery(String datacenter, String sql) throws BOSException {
        Connection cn = DbConnector.getConnection(datacenter);
        Statement smt = null;
        try {
            smt = cn.createStatement();
            ResultSet rs = smt.executeQuery(sql);
            ArrayList arrayList = SQL.toArray(rs);
            return arrayList;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQL.close(smt);
            SQL.close(cn);
        }
    }

    public static Object getValue(String datacenter, String sql) throws BOSException {
        ArrayList list = SQL.executeQuery(datacenter, sql);
        if (list.size() == 0) {
            return null;
        }
        HashMap item = (HashMap)list.get(0);
        Collection c = item.values();
        if (c.size() == 0) {
            return null;
        }
        return c.iterator().next();
    }

    public static ArrayList executeQuery(Context ctx, String sql) throws BOSException {
        Connection cn = DbConnector.getConnection(ctx);
        Statement smt = null;
        try {
            smt = cn.createStatement();
            ResultSet rs = smt.executeQuery(sql);
            ArrayList arrayList = SQL.toArray(rs);
            return arrayList;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQL.close(smt);
            SQL.close(cn);
        }
    }
}

