/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.util;

import com.kingdee.bos.BOSException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import org.apache.log4j.Logger;

public class Serialization {
    protected static final Logger logger = Logger.getLogger(Serialization.class);

    public static String dump(Throwable t) {
        if (t == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.print("Error message:");
        pw.print(t.getMessage());
        pw.print("\r\nStack trace:\r\n");
        t.printStackTrace(pw);
        pw.flush();
        String s = "";
        try {
            s = new String(baos.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e);
        }
        return s.toString();
    }

    public static Object fromBytes(byte[] bytes) throws BOSException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            return ois.readObject();
        }
        catch (Exception e) {
            throw new BOSException("deserialize bytes to object failed!", (Throwable)e);
        }
    }

    public static Object fromBlob(Blob blob) throws BOSException {
        if (blob == null) {
            return null;
        }
        InputStream in = null;
        try {
            int len = (int)blob.length();
            if (len == 0) {
                Object var3_4 = null;
                return var3_4;
            }
            byte[] bytes = new byte[len];
            in = blob.getBinaryStream();
            in.read(bytes);
            Object object = Serialization.fromBytes(bytes);
            return object;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"InputStream close error!", (Throwable)e);
            }
        }
    }

    public static byte[] toBytes(Object o) throws BOSException {
        if (o == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.flush();
            oos.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new BOSException("serialize object {" + o.toString() + "} to bytes failed!", (Throwable)e);
        }
    }
}

