/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.wrapper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.util.IListener;
import com.kingdee.bos.service.job.util.Xml;
import com.kingdee.bos.util.rpc.ObjectFactory;
import java.lang.reflect.Method;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MethodWrapper
extends Wrapper
implements IJobHandler,
IListener {
    private static final int MODE_NONE = 0;
    private static final int MODE_CTX = 1;
    private static final int MODE_JOB = 2;
    private static final long serialVersionUID = 3892888617835703739L;
    private transient Method method;
    private Object o;
    private Object[] params;
    private int mode;

    public MethodWrapper(Class cls, String methodName, Object[] params) throws Exception {
        this.init(cls, methodName, params);
    }

    MethodWrapper(String config) throws BOSException {
        int i = config.indexOf(";");
        String params = i < 0 ? null : config.substring(i + 1);
        Object[] arr = null;
        if (params != null) {
            Document doc = Xml.parse(params);
            NodeList nodes = doc.getElementsByTagName("param");
            arr = new String[nodes.getLength()];
            for (int k = 0; k < nodes.getLength(); ++k) {
                arr[k] = nodes.item(k).getFirstChild().getNodeValue();
            }
        }
        String tmp = i < 0 ? config : config.substring(0, i);
        int j = tmp.indexOf("-");
        String className = tmp.substring(0, j);
        String methodName = tmp.substring(j + 1);
        try {
            Class<?> cls = Class.forName(className);
            this.init(cls, methodName, arr);
        }
        catch (Exception e) {
            throw new BOSException("restore method wrapper failed! config: " + config, (Throwable)e);
        }
    }

    private void init(Class cls, String methodName, Object[] params) throws Exception {
        Method m = ObjectFactory.getMethod((Class)cls, (String)methodName);
        if (m == null) {
            throw new BOSException("couldn't find method {" + methodName + "} in class {" + cls.getName() + "}.");
        }
        if (params == null) {
            params = new Object[]{};
        }
        this.method = m;
        this.o = cls.newInstance();
        Class<?>[] types = this.method.getParameterTypes();
        if (types.length != params.length + 1 && types.length != params.length) {
            throw new BOSException("the parameters count is{" + params.length + "}, and is not equals the parameters of method {" + cls.getName() + "-" + methodName + "}");
        }
        this.mode = 0;
        if (types.length == params.length + 1) {
            if (ObjectFactory.isSubClassOf(types[0], Context.class)) {
                this.mode = 1;
            } else if (ObjectFactory.isSubClassOf(types[0], Job.class)) {
                this.mode = 2;
            } else {
                throw new BOSException("the parameters count is{" + params.length + "}, and is not equals the parameters of method {" + cls.getName() + "-" + methodName + "}, and the first parameter is not job or ctx.");
            }
        }
        this.params = new Object[types.length];
        if (params != null) {
            Class[] p = new Class[]{String.class};
            int j = this.mode == 0 ? 0 : 1;
            for (int i = 0; i < params.length; ++i) {
                String s;
                if (params[i] == null || (s = params[i].toString()).length() <= 0) continue;
                this.params[j] = types[j].getConstructor(p).newInstance(s);
                ++j;
            }
        }
    }

    @Override
    public IJobHandler toHandler() {
        return this;
    }

    @Override
    public IListener toListener() {
        return this;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("method").append(":");
        sb.append(this.o.getClass().getName()).append("-").append(this.method.getName());
        if (this.params != null) {
            int i;
            sb.append(";");
            sb.append("\r\n<parameters>");
            int n = i = this.mode == 0 ? 0 : 1;
            while (i < this.params.length) {
                sb.append("\r\n\t<param>");
                if (this.params[i] != null) {
                    sb.append(Xml.escape(this.params[i].toString()));
                }
                sb.append("</param>");
                ++i;
            }
            sb.append("\r\n</parameters>");
        }
        return sb.toString();
    }

    @Override
    public Object execute(Job job) throws Exception {
        Object o = job.getParameters();
        Object[] array = null;
        if (o instanceof Object[]) {
            array = (Object[])o;
        } else if (o == null) {
            array = this.params;
        } else {
            throw new BOSException("job " + job + "'s parameters is not an Object[].");
        }
        return this.invoke(job, array);
    }

    @Override
    public void handle(Object o) throws Exception {
        Job job = (Job)o;
        this.invoke(job, this.params);
    }

    private Object invoke(Job job, Object[] params) throws Exception {
        Object[] array = params;
        if (this.mode != 0) {
            array = new Object[this.params.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = params[i];
            }
            switch (this.mode) {
                case 2: {
                    array[0] = job;
                    break;
                }
                case 1: {
                    array[0] = job.getContext();
                    break;
                }
                default: {
                    throw new BOSException("impossible invocation {" + this.toString() + "}.");
                }
            }
        }
        return this.method.invoke(this.o, array);
    }
}

