/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.scheduler;

import com.kingdee.bos.service.scheduler.util.SchedulerUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobStore;

public class BOSStdSchedulerFactory
extends StdSchedulerFactory {
    private static final Map jobStores = new HashMap();
    private String key;

    public BOSStdSchedulerFactory(Properties props) throws SchedulerException {
        super(props);
        this.key = props.getProperty("org.quartz.scheduler.instanceName");
    }

    public BOSStdSchedulerFactory(String fileName) throws SchedulerException {
        super(fileName);
    }

    protected Scheduler instantiate(QuartzSchedulerResources rsrcs, QuartzScheduler qs) {
        Scheduler scheduler = super.instantiate(rsrcs, qs);
        jobStores.put(this.key, rsrcs.getJobStore());
        return scheduler;
    }

    public static JobStore getJobStore(String aisName, String solution) {
        String key = SchedulerUtils.getSchedulerKey(aisName, solution);
        return (JobStore)jobStores.get(key);
    }
}

