/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.scheduler.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.scheduler.util.IWorkCalendarProvider;
import com.kingdee.bos.spi.SPManager;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class SchedulerUtils {
    private static String SCHEDULER_SEPARATOR = "\n";

    public static boolean isEnableScheduler() {
        Configuration config = Configuration.getInstance();
        ConfigurationItem workFlow = config.getConfigItem("Workflow");
        String isEnableSchedulerStr = workFlow.getProperty("isEnableScheduler", "false");
        boolean isEnableScheduler = Boolean.valueOf(isEnableSchedulerStr);
        return isEnableScheduler;
    }

    public static String getSchedulerKey(String ais, String solution) {
        if (StringUtils.isEmpty((String)ais)) {
            throw new IllegalArgumentException("Parameter \"ais\" is null!");
        }
        if (StringUtils.isEmpty((String)solution)) {
            throw new IllegalArgumentException("Parameter \"solution\" is null!");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("BOSScheduler");
        buffer.append(SCHEDULER_SEPARATOR);
        buffer.append(ais);
        buffer.append(SCHEDULER_SEPARATOR);
        buffer.append(solution);
        String key = buffer.toString();
        return key;
    }

    public static String getAIS(String key) {
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException();
        }
        String[] tokens = key.split(SCHEDULER_SEPARATOR);
        if (tokens.length != 3) {
            String msg = "Current key is \"" + key + "\"!";
            throw new IllegalArgumentException(msg);
        }
        if (!"BOSScheduler".equals(tokens[0])) {
            throw new IllegalArgumentException();
        }
        return tokens[1];
    }

    public static String getSolution(String key) {
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException();
        }
        String[] tokens = key.split(SCHEDULER_SEPARATOR);
        if (tokens.length != 3) {
            String msg = "Current key is \"" + key + "\"!";
            throw new IllegalArgumentException(msg);
        }
        if (!"BOSScheduler".equals(tokens[0])) {
            throw new IllegalArgumentException();
        }
        return tokens[2];
    }

    public static Context getContext(String key) {
        try {
            String wfEngineName = "com.kingdee.bos.workflow.enactment.WfEngine";
            Class<?> wfEngineClass = Class.forName(wfEngineName);
            Method getEngineMethod = wfEngineClass.getMethod("getEngine", String.class);
            Object engine = getEngineMethod.invoke(null, key);
            Method getContextMethod = wfEngineClass.getMethod("getContext", null);
            Object context = getContextMethod.invoke(engine, null);
            return (Context)context;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static boolean isWorkDay(Context ctx, String orgUnitID, Date d, boolean isCastBack) throws BOSException {
        Object o = SPManager.getInstance().getSeviceProviderInstance("WorkCalendarProvider");
        if (o instanceof IWorkCalendarProvider) {
            return ((IWorkCalendarProvider)o).isWorkDay(ctx, orgUnitID, d, isCastBack);
        }
        throw new BOSException("has no WorkCalendarProvider!");
    }

    public static boolean isWorkDay(Context ctx, String orgUnitID, Date d) throws BOSException {
        return SchedulerUtils.isWorkDay(ctx, orgUnitID, d, true);
    }

    private static List getDCInfos() {
        ArrayList<String> rtn = new ArrayList<String>();
        try {
            String classname = "com.kingdee.bos.workflow.util.DCServiceHelper";
            Class<?> c = Class.forName(classname);
            Method m = c.getMethod("getDCInfos", null);
            Object obj = m.invoke(c, null);
            if (obj instanceof String[][]) {
                String[][] dcs = (String[][])obj;
                for (int i = 0; i < dcs.length; ++i) {
                    rtn.add(dcs[i][0] + "/" + dcs[i][1]);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rtn;
    }

    public static String[][] getDataCenterInfos() {
        Configuration config = Configuration.getInstance();
        ConfigurationItem sln = config.getConfigItem("SolutionInfo");
        if (sln != null) {
            List dcs = SchedulerUtils.getDCInfos();
            List slns = sln.getAllChildren();
            for (int i = 0; i < slns.size(); ++i) {
                ConfigurationItem slnConfigItem = (ConfigurationItem)slns.get(i);
                String solutionName = slnConfigItem.getName();
                ConfigurationItem aisConfigItems = slnConfigItem.getChild("AISInfo");
                if (aisConfigItems == null) continue;
                List aisLI = aisConfigItems.getAllChildren();
                ArrayList<String[]> aisInfos = new ArrayList<String[]>();
                for (int j = 0; j < aisLI.size(); ++j) {
                    String[] aisInfo = new String[7];
                    ConfigurationItem aisConfigItem = (ConfigurationItem)aisLI.get(j);
                    String aisName = aisConfigItem.getName();
                    if (aisName.endsWith("_Query")) continue;
                    ConfigurationItem aisEJBConfigItem = aisConfigItem.getChild("EJBService");
                    aisInfo[0] = aisName;
                    aisInfo[1] = aisEJBConfigItem.getProperty("datasource");
                    aisInfo[2] = aisEJBConfigItem.getProperty("jndiURL");
                    aisInfo[3] = aisEJBConfigItem.getProperty("contextFactory");
                    aisInfo[4] = aisEJBConfigItem.getProperty("securityCredential");
                    aisInfo[5] = aisEJBConfigItem.getProperty("securityPrincipal");
                    aisInfo[6] = solutionName;
                    if (dcs != null && dcs.size() > 0) {
                        if (!dcs.contains(aisName + "/" + solutionName)) continue;
                        aisInfos.add(aisInfo);
                        continue;
                    }
                    aisInfos.add(aisInfo);
                }
                String[][] retVal = new String[aisInfos.size()][7];
                int index = 0;
                Iterator iterator = aisInfos.iterator();
                while (iterator.hasNext()) {
                    retVal[index] = (String[])iterator.next();
                    ++index;
                }
                return retVal;
            }
        }
        return new String[0][0];
    }
}

