/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.support.quartz.impl;

import com.kingdee.bos.support.quartz.impl.BatchUpdater;
import com.kingdee.bos.support.quartz.impl.JobWrapper;
import com.kingdee.bos.support.quartz.impl.QuartzObjectInputStream;
import com.kingdee.bos.support.quartz.impl.TriggerAndJobs;
import com.kingdee.bos.support.quartz.impl.TriggerWrapper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.Trigger;
import org.quartz.spi.ClassLoadHelper;

public class FileStoreHelper
extends BatchUpdater {
    public static final String LOCK_NAME = "lock";
    protected final File storePath;
    protected final File lockFile;
    protected final FileOutputStream lockStream;
    private ClassLoadHelper loadHelper = null;
    public static final String CALENDAR_DIR = "calendars";
    public static final String TRIGGER_DIR = "triggers";
    public static final String JOB_DIR = "jobs";
    private static final String JOBSTORE = "Quartz JobStore File";

    public FileStoreHelper(File _storePath) throws IOException {
        this.storePath = _storePath.getAbsoluteFile();
        this.storePath.mkdirs();
        if (!this.storePath.exists() || !this.storePath.isDirectory()) {
            throw new IOException("Can't create path '" + this.storePath.getAbsolutePath() + "'");
        }
        this.lockFile = new File(this.storePath, LOCK_NAME);
        try {
            this.lockStream = new FileOutputStream(this.lockFile);
        }
        catch (IOException e) {
            throw new IOException("'" + this.storePath.getAbsolutePath() + "' is used by another FileStoreHelper.");
        }
    }

    @Override
    public TriggerAndJobs initialize(ClassLoadHelper loadHelper) throws Exception {
        this.loadHelper = loadHelper;
        return this.loadAll();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        try {
            this.lockStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.lockFile.delete();
    }

    private static String readLine(InputStream in) throws IOException {
        int b;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while ((b = in.read()) != 10) {
            if (b == -1) {
                if (i != 0) break;
                return null;
            }
            if (b != 13) {
                out.write(b);
            }
            ++i;
        }
        return new String(out.toByteArray());
    }

    private static void writeLine(OutputStream out, String line) throws IOException {
        out.write((line + "\n").getBytes());
    }

    private ObjectInputStream openObjectFile(File f) throws IOException {
        InputStream in = FileStoreHelper.openFile(f);
        if (in != null) {
            return new QuartzObjectInputStream(in, this.loadHelper);
        }
        return null;
    }

    private static InputStream openFile(File f) throws IOException {
        InputStream in = null;
        if (!f.isFile()) {
            return null;
        }
        try {
            in = new BufferedInputStream(new FileInputStream(f));
            String line = FileStoreHelper.readLine(in);
            if (line == null || !line.equals(JOBSTORE)) {
                throw new IOException();
            }
            return in;
        }
        catch (IOException e) {
            if (in != null) {
                in.close();
            }
            return null;
        }
    }

    private static OutputStream createFile(File f) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
        FileStoreHelper.writeLine(out, JOBSTORE);
        return out;
    }

    private ObjectOutputStream createObjectFile(File f) throws IOException {
        return new ObjectOutputStream(FileStoreHelper.createFile(f));
    }

    private static String convertFileName(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ("!%/\\:*?\"<>|.".indexOf(c) >= 0) {
                sb.append("!" + Integer.toHexString(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void checkFile(File f, String name) throws Exception {
        if (!f.getName().equalsIgnoreCase(FileStoreHelper.convertFileName(name))) {
            throw new JobPersistenceException(f.getAbsoluteFile().getAbsolutePath() + " not a valid JobStore file.(should be '" + FileStoreHelper.convertFileName(name) + "')");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TriggerAndJobs loadAll() throws Exception {
        TriggerAndJobs store = new TriggerAndJobs();
        File calPath = new File(this.storePath, CALENDAR_DIR);
        calPath.mkdirs();
        File[] fs = calPath.listFiles();
        if (fs != null) {
            for (int i = 0; i < fs.length; ++i) {
                ObjectInputStream in = this.openObjectFile(fs[i]);
                if (in == null) continue;
                try {
                    String calName = (String)in.readObject();
                    this.checkFile(fs[i], calName);
                    Calendar cal = (Calendar)in.readObject();
                    store.calendars.put(calName, cal);
                    continue;
                }
                finally {
                    in.close();
                }
            }
        }
        File jobPath = new File(this.storePath, JOB_DIR);
        jobPath.mkdirs();
        File[] groups = jobPath.listFiles();
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                File[] jobs;
                if (!groups[i].isDirectory() || (jobs = groups[i].listFiles()) == null) continue;
                for (int j = 0; j < jobs.length; ++j) {
                    ObjectInputStream in = this.openObjectFile(jobs[j]);
                    if (in == null) continue;
                    try {
                        JobDetail job = (JobDetail)in.readObject();
                        this.checkFile(groups[i], job.getKey().getGroup());
                        this.checkFile(jobs[j], job.getKey().getName());
                        store.addJob(new JobWrapper(job));
                        continue;
                    }
                    finally {
                        in.close();
                    }
                }
            }
        }
        File triggerPath = new File(this.storePath, TRIGGER_DIR);
        triggerPath.mkdirs();
        groups = triggerPath.listFiles();
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                File[] triggers;
                if (!groups[i].isDirectory() || (triggers = groups[i].listFiles()) == null) continue;
                for (int j = 0; j < triggers.length; ++j) {
                    boolean no_job = false;
                    try (ObjectInputStream in = this.openObjectFile(triggers[j]);){
                        Trigger trigger = (Trigger)in.readObject();
                        int state = in.readInt();
                        this.checkFile(groups[i], trigger.getKey().getGroup());
                        this.checkFile(triggers[j], trigger.getKey().getName());
                        TriggerWrapper tw = new TriggerWrapper(trigger);
                        tw.state = state;
                        boolean bl = no_job = store.getTriggerJob(tw) == null;
                        if (!no_job) {
                            store.addTrigger(tw);
                        }
                    }
                    if (!no_job) continue;
                    triggers[j].delete();
                }
            }
        }
        return store;
    }

    private File getTriggerFile(String group, String name) {
        File path = new File(this.storePath, TRIGGER_DIR);
        if (!(path = new File(path, FileStoreHelper.convertFileName(group))).exists()) {
            path.mkdirs();
        }
        return new File(path, FileStoreHelper.convertFileName(name));
    }

    private File getJobFile(String group, String name) {
        File path = new File(this.storePath, JOB_DIR);
        if (!(path = new File(path, FileStoreHelper.convertFileName(group))).exists()) {
            path.mkdirs();
        }
        return new File(path, FileStoreHelper.convertFileName(name));
    }

    private File getCalendarFile(String name) {
        File path = new File(this.storePath, CALENDAR_DIR);
        if (!path.exists()) {
            path.mkdirs();
        }
        return new File(path, FileStoreHelper.convertFileName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalUpdateTriggerState(String group, String name, int state) throws Exception {
        File triggerFile = this.getTriggerFile(group, name);
        RandomAccessFile rf = new RandomAccessFile(triggerFile, "rw");
        boolean succeeded = false;
        try {
            rf.seek(rf.length() - 4L);
            rf.writeInt(state);
            succeeded = true;
        }
        finally {
            rf.close();
            if (!succeeded) {
                triggerFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalUpdateTrigger(Trigger trigger, int state) throws Exception {
        File triggerFile = this.getTriggerFile(trigger.getKey().getGroup(), trigger.getKey().getName());
        ObjectOutputStream out = this.createObjectFile(triggerFile);
        boolean succeeded = false;
        try {
            out.writeObject(trigger);
            out.writeInt(state);
            succeeded = true;
        }
        finally {
            out.close();
            if (!succeeded) {
                triggerFile.delete();
            }
        }
    }

    @Override
    protected void finalDeleteTrigger(String group, String name) throws Exception {
        File triggerFile = this.getTriggerFile(group, name);
        if (triggerFile.exists()) {
            if (!triggerFile.delete()) {
                throw new JobPersistenceException("can't delete Trigger file '" + triggerFile.getAbsolutePath());
            }
            triggerFile.getParentFile().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalUpdateJob(JobDetail job) throws Exception {
        File jobFile = this.getJobFile(job.getKey().getGroup(), job.getKey().getName());
        ObjectOutputStream out = this.createObjectFile(jobFile);
        boolean succeeded = false;
        try {
            out.writeObject(job);
            succeeded = true;
        }
        finally {
            out.close();
            if (!succeeded) {
                jobFile.delete();
            }
        }
    }

    @Override
    protected void finalDeleteJob(String group, String name) throws Exception {
        File jobFile = this.getJobFile(group, name);
        if (jobFile.exists()) {
            if (!jobFile.delete()) {
                throw new JobPersistenceException("can't delete Job file '" + jobFile.getAbsolutePath());
            }
            jobFile.getParentFile().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalUpdateCalendar(String name, Calendar cal) throws Exception {
        File calFile = this.getCalendarFile(name);
        ObjectOutputStream out = this.createObjectFile(calFile);
        boolean succeeded = false;
        try {
            out.writeObject(name);
            out.writeObject(cal);
            succeeded = true;
        }
        finally {
            out.close();
            if (!succeeded) {
                calFile.delete();
            }
        }
    }

    @Override
    protected void finalDeleteCalendar(String name) throws Exception {
        File calFile = this.getCalendarFile(name);
        if (calFile.exists() && !calFile.delete()) {
            throw new JobPersistenceException("can't delete Calendar file '" + calFile.getAbsolutePath());
        }
    }

    @Override
    protected void finalCheckTrigger(String group, String name) throws Exception {
    }
}

