/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.support.quartz.impl;

import com.kingdee.bos.support.quartz.impl.JobWrapper;
import com.kingdee.bos.support.quartz.impl.TriggerComparator;
import com.kingdee.bos.support.quartz.impl.TriggerWrapper;
import com.kingdee.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Calendar;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.StatefulJob;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.spi.TriggerFiredResult;

public class MemoryJobStore
implements JobStore {
    protected HashMap jobsByFQN = new HashMap();
    protected HashMap triggersByFQN = new HashMap();
    protected HashMap jobsByGroup = new HashMap();
    protected HashMap triggersByGroup = new HashMap();
    protected TreeSet timeTriggers = new TreeSet(new TriggerComparator());
    protected HashMap calendarsByName = new HashMap();
    protected ArrayList triggers = new ArrayList();
    protected HashSet pausedTriggerGroups = new HashSet();
    protected HashSet blockedJobs = new HashSet();
    protected long misfireThreshold = 5000L;
    protected SchedulerSignaler signaler;
    protected ClassLoadHelper loadHelper;
    private static long ftrCtr = System.currentTimeMillis();

    public void setTestProperty(String value) {
    }

    protected Log getLog() {
        return LogFactory.getLog(MemoryJobStore.class);
    }

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) {
        this.signaler = signaler;
        this.loadHelper = loadHelper;
        this.getLog().info((Object)"MemoryJobStore initialized.");
    }

    public synchronized long getMisfireThreshold() {
        return this.misfireThreshold;
    }

    public synchronized void setMisfireThreshold(long misfireThreshold) {
        if (misfireThreshold < 1L) {
            throw new IllegalArgumentException("Misfirethreashold must be larger than 0");
        }
        this.misfireThreshold = misfireThreshold;
    }

    public void shutdown() {
    }

    public boolean supportsPersistence() {
        return false;
    }

    public synchronized void storeJobAndTrigger(JobDetail newJob, Trigger newTrigger) throws JobPersistenceException {
        if (this.jobsByFQN.get(JobWrapper.getJobNameKey(newJob)) != null) {
            throw new ObjectAlreadyExistsException(newJob);
        }
        if (this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(newTrigger)) != null) {
            throw new ObjectAlreadyExistsException(newTrigger);
        }
        this.storeJob(newJob, false);
        this.storeTrigger(newTrigger, false);
    }

    public synchronized void storeJob(JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException {
        JobWrapper jw = new JobWrapper(newJob);
        boolean repl = false;
        if (this.jobsByFQN.get(jw.key) != null) {
            if (!replaceExisting) {
                throw new ObjectAlreadyExistsException(newJob);
            }
            repl = true;
        }
        if (!repl) {
            HashMap<String, JobWrapper> grpMap = (HashMap<String, JobWrapper>)this.jobsByGroup.get(newJob.getKey().getGroup());
            if (grpMap == null) {
                grpMap = new HashMap<String, JobWrapper>();
                this.jobsByGroup.put(newJob.getKey().getGroup(), grpMap);
            }
            grpMap.put(newJob.getKey().getName(), jw);
            this.jobsByFQN.put(jw.key, jw);
        } else {
            JobWrapper orig = (JobWrapper)this.jobsByFQN.get(jw.key);
            orig.jobDetail = newJob;
        }
    }

    public synchronized boolean removeJob(String jobName, String groupName) {
        HashMap grpMap;
        String key = JobWrapper.getJobNameKey(groupName, jobName);
        boolean found = false;
        Trigger[] trigger = this.getTriggersForJob(jobName, groupName);
        for (int i = 0; i < trigger.length; ++i) {
            Trigger trig = trigger[i];
            this.removeTrigger(trig.getKey().getName(), trig.getKey().getGroup());
            found = true;
        }
        found = this.jobsByFQN.remove(key) != null | found;
        if (found && (grpMap = (HashMap)this.jobsByGroup.get(groupName)) != null) {
            grpMap.remove(jobName);
            if (grpMap.size() == 0) {
                this.jobsByGroup.remove(groupName);
            }
        }
        return found;
    }

    public synchronized void storeTrigger(Trigger newTrigger, boolean replaceExisting) throws JobPersistenceException {
        TriggerWrapper tw = new TriggerWrapper(newTrigger);
        if (this.triggersByFQN.get(tw.key) != null) {
            if (!replaceExisting) {
                throw new ObjectAlreadyExistsException(newTrigger);
            }
            this.removeTrigger(newTrigger.getKey().getName(), newTrigger.getKey().getGroup());
        }
        if (this.retrieveJob(newTrigger.getJobKey().getName(), newTrigger.getJobKey().getGroup()) == null) {
            throw new JobPersistenceException("The job (" + newTrigger.getKey().getGroup() + "." + newTrigger.getKey().getName() + ") referenced by the trigger does not exist.");
        }
        this.triggers.add(tw);
        HashMap<String, TriggerWrapper> grpMap = (HashMap<String, TriggerWrapper>)this.triggersByGroup.get(newTrigger.getKey().getGroup());
        if (grpMap == null) {
            grpMap = new HashMap<String, TriggerWrapper>();
            this.triggersByGroup.put(newTrigger.getKey().getGroup(), grpMap);
        }
        grpMap.put(newTrigger.getKey().getName(), tw);
        this.triggersByFQN.put(tw.key, tw);
        if (this.pausedTriggerGroups.contains(newTrigger.getKey().getGroup())) {
            this.setTriggerState(tw, 4);
        } else if (this.blockedJobs.contains(tw.jobKey)) {
            this.setTriggerState(tw, 5);
        } else {
            this.timeTriggers.add(tw);
        }
    }

    public synchronized boolean removeTrigger(String triggerName, String groupName) {
        String key = TriggerWrapper.getTriggerNameKey(triggerName, groupName);
        boolean found = false;
        boolean bl = found = this.triggersByFQN.remove(key) != null;
        if (found) {
            TriggerWrapper tw = null;
            HashMap grpMap = (HashMap)this.triggersByGroup.get(groupName);
            if (grpMap != null) {
                grpMap.remove(triggerName);
                if (grpMap.size() == 0) {
                    this.triggersByGroup.remove(groupName);
                }
            }
            Iterator tgs = this.triggers.iterator();
            while (tgs.hasNext()) {
                tw = (TriggerWrapper)tgs.next();
                if (!key.equals(tw.key)) continue;
                tgs.remove();
                break;
            }
            if (tw == null) {
                return found;
            }
            this.timeTriggers.remove(tw);
            JobWrapper jw = (JobWrapper)this.jobsByFQN.get(JobWrapper.getJobNameKey(tw.trigger.getJobKey().getGroup(), tw.trigger.getJobKey().getName()));
            Trigger[] trigs = this.getTriggersForJob(tw.trigger.getJobKey().getName(), tw.trigger.getJobKey().getGroup());
            if (!(trigs != null && trigs.length != 0 || jw.jobDetail.isDurable())) {
                this.removeJob(tw.trigger.getJobKey().getName(), tw.trigger.getJobKey().getGroup());
            }
        }
        return found;
    }

    public synchronized boolean replaceTrigger(String triggerName, String groupName, Trigger newTrigger) throws JobPersistenceException {
        String key = TriggerWrapper.getTriggerNameKey(triggerName, groupName);
        boolean found = false;
        TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.remove(key);
        boolean bl = found = tw != null;
        if (found) {
            if (!tw.getTrigger().getJobKey().getName().equals(newTrigger.getJobKey().getName()) || !tw.getTrigger().getJobKey().getGroup().equals(newTrigger.getJobKey().getGroup())) {
                throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
            }
            tw = null;
            HashMap grpMap = (HashMap)this.triggersByGroup.get(groupName);
            if (grpMap != null) {
                grpMap.remove(triggerName);
                if (grpMap.size() == 0) {
                    this.triggersByGroup.remove(groupName);
                }
            }
            Iterator tgs = this.triggers.iterator();
            while (tgs.hasNext()) {
                tw = (TriggerWrapper)tgs.next();
                if (!key.equals(tw.key)) continue;
                tgs.remove();
                break;
            }
            this.timeTriggers.remove(tw);
            try {
                this.storeTrigger(newTrigger, false);
            }
            catch (JobPersistenceException jpe) {
                this.storeTrigger(tw.getTrigger(), false);
                throw jpe;
            }
        }
        return found;
    }

    public synchronized JobDetail retrieveJob(String jobName, String groupName) {
        JobWrapper jw = (JobWrapper)this.jobsByFQN.get(JobWrapper.getJobNameKey(groupName, jobName));
        if (jw != null) {
            return jw.jobDetail;
        }
        return null;
    }

    public synchronized Trigger retrieveTrigger(String triggerName, String groupName) {
        TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(triggerName, groupName));
        if (tw != null) {
            return tw.getTrigger();
        }
        return null;
    }

    public synchronized int getTriggerState(String triggerName, String groupName) throws JobPersistenceException {
        TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(triggerName, groupName));
        if (tw == null) {
            return Trigger.TriggerState.NONE.ordinal();
        }
        if (tw.state == 3) {
            return Trigger.TriggerState.COMPLETE.ordinal();
        }
        if (tw.state == 4) {
            return Trigger.TriggerState.PAUSED.ordinal();
        }
        return Trigger.TriggerState.NORMAL.ordinal();
    }

    public void storeCalendar(String name, Calendar calendar, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.storeCalendar(name, calendar, replaceExisting, false);
    }

    public synchronized void storeCalendar(String name, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws ObjectAlreadyExistsException {
        Object obj = this.calendarsByName.get(name);
        if (obj != null && !replaceExisting) {
            throw new ObjectAlreadyExistsException("Calendar with name '" + name + "' already exists.");
        }
        if (obj != null) {
            this.calendarsByName.remove(name);
        }
        this.calendarsByName.put(name, calendar);
        if (obj != null && updateTriggers) {
            for (TriggerWrapper tw : this.getTriggerWrappersForCalendar(name)) {
                boolean removed = this.timeTriggers.remove(tw);
                if (!removed) continue;
                this.timeTriggers.add(tw);
            }
        }
    }

    public synchronized boolean removeCalendar(String calName) throws JobPersistenceException {
        int numRefs = 0;
        Iterator itr = this.triggers.iterator();
        while (itr.hasNext()) {
            Trigger trigg = ((TriggerWrapper)itr.next()).trigger;
            if (trigg.getCalendarName() == null || !trigg.getCalendarName().equals(calName)) continue;
            ++numRefs;
        }
        if (numRefs > 0) {
            throw new JobPersistenceException("Calender cannot be removed if it referenced by a Trigger!");
        }
        return this.calendarsByName.remove(calName) != null;
    }

    public synchronized Calendar retrieveCalendar(String calName) {
        return (Calendar)this.calendarsByName.get(calName);
    }

    public synchronized int getNumberOfJobs() {
        return this.jobsByFQN.size();
    }

    public synchronized int getNumberOfTriggers() {
        return this.triggers.size();
    }

    public synchronized int getNumberOfCalendars() {
        return this.calendarsByName.size();
    }

    public synchronized String[] getJobNames(String groupName) {
        String[] outList = null;
        HashMap grpMap = (HashMap)this.jobsByGroup.get(groupName);
        if (grpMap != null) {
            outList = new String[grpMap.size()];
            int outListPos = 0;
            for (String key : grpMap.keySet()) {
                JobWrapper jw = (JobWrapper)grpMap.get(key);
                if (jw == null) continue;
                outList[outListPos++] = jw.jobDetail.getKey().getName();
            }
        } else {
            outList = new String[]{};
        }
        return outList;
    }

    public synchronized List<String> getCalendarNames() {
        Set names = this.calendarsByName.keySet();
        return new ArrayList<String>(this.calendarsByName.keySet());
    }

    public synchronized String[] getTriggerNames(String groupName) {
        String[] outList = null;
        HashMap grpMap = (HashMap)this.triggersByGroup.get(groupName);
        if (grpMap != null) {
            outList = new String[grpMap.size()];
            int outListPos = 0;
            for (String key : grpMap.keySet()) {
                TriggerWrapper tw = (TriggerWrapper)grpMap.get(key);
                if (tw == null) continue;
                outList[outListPos++] = tw.trigger.getKey().getName();
            }
        } else {
            outList = new String[]{};
        }
        return outList;
    }

    public synchronized List<String> getJobGroupNames() {
        return new ArrayList<String>(this.jobsByGroup.keySet());
    }

    public synchronized List<String> getTriggerGroupNames() {
        return new ArrayList<String>(this.triggersByGroup.keySet());
    }

    public synchronized Trigger[] getTriggersForJob(String jobName, String groupName) {
        ArrayList<Object> trigList = new ArrayList<Object>();
        String jobKey = JobWrapper.getJobNameKey(groupName, jobName);
        for (int i = 0; i < this.triggers.size(); ++i) {
            TriggerWrapper tw = (TriggerWrapper)this.triggers.get(i);
            if (!tw.jobKey.equals(jobKey)) continue;
            try {
                trigList.add(ObjectUtils.createCopy((Object)tw.trigger));
                continue;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return trigList.toArray(new Trigger[trigList.size()]);
    }

    protected synchronized ArrayList getTriggerWrappersForJob(String jobName, String groupName) {
        ArrayList<TriggerWrapper> trigList = new ArrayList<TriggerWrapper>();
        String jobKey = JobWrapper.getJobNameKey(groupName, jobName);
        for (int i = 0; i < this.triggers.size(); ++i) {
            TriggerWrapper tw = (TriggerWrapper)this.triggers.get(i);
            if (!tw.jobKey.equals(jobKey)) continue;
            trigList.add(tw);
        }
        return trigList;
    }

    protected synchronized ArrayList getTriggerWrappersForCalendar(String calName) {
        ArrayList<TriggerWrapper> trigList = new ArrayList<TriggerWrapper>();
        for (int i = 0; i < this.triggers.size(); ++i) {
            TriggerWrapper tw = (TriggerWrapper)this.triggers.get(i);
            String tcalName = tw.getTrigger().getCalendarName();
            if (tcalName == null || !tcalName.equals(calName)) continue;
            trigList.add(tw);
        }
        return trigList;
    }

    public synchronized void pauseTrigger(String triggerName, String groupName) {
        TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(triggerName, groupName));
        if (tw == null || tw.trigger == null) {
            return;
        }
        if (tw.state == 3) {
            return;
        }
        this.setTriggerState(tw, 4);
        this.timeTriggers.remove(tw);
    }

    public synchronized void pauseTriggerGroup(String groupName) {
        if (this.pausedTriggerGroups.contains(groupName)) {
            return;
        }
        this.pausedTriggerGroups.add(groupName);
        String[] names = this.getTriggerNames(groupName);
        for (int i = 0; i < names.length; ++i) {
            this.pauseTrigger(names[i], groupName);
        }
    }

    public synchronized void pauseJob(String jobName, String groupName) {
        Trigger[] triggers = this.getTriggersForJob(jobName, groupName);
        for (int j = 0; j < triggers.length; ++j) {
            this.pauseTrigger(triggers[j].getKey().getName(), triggers[j].getKey().getGroup());
        }
    }

    public synchronized void pauseJobGroup(String groupName) {
        String[] jobNames = this.getJobNames(groupName);
        for (int i = 0; i < jobNames.length; ++i) {
            Trigger[] triggers = this.getTriggersForJob(jobNames[i], groupName);
            for (int j = 0; j < triggers.length; ++j) {
                this.pauseTrigger(triggers[j].getKey().getName(), triggers[j].getKey().getGroup());
            }
        }
    }

    public synchronized void resumeTrigger(String triggerName, String groupName) {
        TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(triggerName, groupName));
        if (tw == null || tw.trigger == null) {
            return;
        }
        Trigger trig = tw.getTrigger();
        if (tw.state != 4) {
            return;
        }
        if (this.blockedJobs.contains(JobWrapper.getJobNameKey(trig.getJobKey().getGroup(), trig.getJobKey().getName()))) {
            this.setTriggerState(tw, 5);
        } else {
            this.setTriggerState(tw, 0);
        }
        this.applyMisfire(tw);
        if (tw.state == 0) {
            this.timeTriggers.add(tw);
        }
    }

    public synchronized void resumeTriggerGroup(String groupName) {
        String[] names = this.getTriggerNames(groupName);
        for (int i = 0; i < names.length; ++i) {
            this.resumeTrigger(names[i], groupName);
        }
    }

    public synchronized void resumeJob(String jobName, String groupName) {
        Trigger[] triggers = this.getTriggersForJob(jobName, groupName);
        for (int j = 0; j < triggers.length; ++j) {
            this.resumeTrigger(triggers[j].getKey().getName(), triggers[j].getKey().getGroup());
        }
    }

    public synchronized void resumeJobGroup(String groupName) {
        String[] jobNames = this.getJobNames(groupName);
        for (int i = 0; i < jobNames.length; ++i) {
            Trigger[] triggers = this.getTriggersForJob(jobNames[i], groupName);
            for (int j = 0; j < triggers.length; ++j) {
                this.resumeTrigger(triggers[j].getKey().getName(), triggers[j].getKey().getGroup());
            }
        }
    }

    public synchronized void pauseAll() {
        List<String> names = this.getTriggerGroupNames();
        for (int i = 0; i < names.size(); ++i) {
            this.pauseTriggerGroup(names.get(i));
        }
    }

    public synchronized void resumeAll() {
        List<String> names = this.getTriggerGroupNames();
        for (int i = 0; i < names.size(); ++i) {
            this.resumeTriggerGroup(names.get(i));
        }
    }

    protected synchronized boolean applyMisfire(TriggerWrapper tw) {
        Date tnft;
        long misfireTime = System.currentTimeMillis();
        if (this.getMisfireThreshold() > 0L) {
            misfireTime -= this.getMisfireThreshold();
        }
        if ((tnft = tw.trigger.getNextFireTime()).getTime() > misfireTime) {
            return false;
        }
        Calendar cal = null;
        if (tw.trigger.getCalendarName() != null) {
            cal = this.retrieveCalendar(tw.trigger.getCalendarName());
        }
        this.signaler.notifyTriggerListenersMisfired(tw.trigger);
        ((AbstractTrigger)tw.trigger).updateAfterMisfire(cal);
        if (tw.trigger.getNextFireTime() == null) {
            this.setTriggerState(tw, 3);
            this.timeTriggers.remove(tw);
        } else if (tnft.equals(tw.trigger.getNextFireTime())) {
            return false;
        }
        return true;
    }

    protected synchronized String getFiredTriggerRecordId() {
        return String.valueOf(ftrCtr++);
    }

    public synchronized Trigger acquireNextTrigger() {
        TriggerWrapper tw = null;
        while (tw == null) {
            try {
                tw = (TriggerWrapper)this.timeTriggers.first();
            }
            catch (NoSuchElementException nsee) {
                return null;
            }
            if (tw == null) {
                return null;
            }
            if (tw.trigger.getNextFireTime() == null) {
                this.timeTriggers.remove(tw);
                tw = null;
                continue;
            }
            this.timeTriggers.remove(tw);
            if (this.applyMisfire(tw)) {
                if (tw.trigger.getNextFireTime() != null) {
                    this.timeTriggers.add(tw);
                }
                tw = null;
                continue;
            }
            this.setTriggerState(tw, 1);
            ((AbstractTrigger)tw.trigger).setFireInstanceId(this.getFiredTriggerRecordId());
            Trigger trig = null;
            try {
                trig = (Trigger)ObjectUtils.createCopy((Object)tw.trigger);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return trig;
        }
        return null;
    }

    public synchronized void releaseAcquiredTrigger(Trigger trigger) {
        TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(trigger));
        if (tw != null && tw.state != 3 && tw.state != 4) {
            this.setTriggerState(tw, 0);
            this.timeTriggers.add(tw);
        }
    }

    public synchronized TriggerFiredBundle triggerFired(Trigger trigger) {
        TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(trigger));
        if (tw == null || tw.trigger == null) {
            return null;
        }
        if (tw.state == 3) {
            return null;
        }
        if (tw.state == 4) {
            return null;
        }
        if (tw.state == 5) {
            return null;
        }
        Calendar cal = null;
        if (tw.trigger.getCalendarName() != null) {
            cal = this.retrieveCalendar(tw.trigger.getCalendarName());
        }
        Date prevFireTime = trigger.getPreviousFireTime();
        if (trigger.getScheduleBuilder() instanceof SimpleScheduleBuilder) {
            ((SimpleTriggerImpl)tw.trigger).triggered(cal);
            ((SimpleTriggerImpl)trigger).triggered(cal);
        } else if (trigger.getScheduleBuilder() instanceof CronScheduleBuilder) {
            ((CronTriggerImpl)tw.trigger).triggered(cal);
            ((CronTriggerImpl)trigger).triggered(cal);
        }
        this.setTriggerState(tw, 0);
        TriggerFiredBundle bndle = new TriggerFiredBundle(this.retrieveJob(trigger.getJobKey().getName(), trigger.getJobKey().getGroup()), (OperableTrigger)trigger, cal, false, new Date(), trigger.getPreviousFireTime(), prevFireTime, trigger.getNextFireTime());
        JobDetail job = bndle.getJobDetail();
        if (StatefulJob.class.isAssignableFrom(job.getJobClass())) {
            ArrayList trigs = this.getTriggerWrappersForJob(job.getKey().getName(), job.getKey().getGroup());
            for (TriggerWrapper ttw : trigs) {
                if (ttw.state == 0) {
                    this.setTriggerState(ttw, 5);
                }
                this.timeTriggers.remove(ttw);
            }
            this.blockedJobs.add(JobWrapper.getJobNameKey(job));
        } else if (tw.trigger.getNextFireTime() != null) {
            this.timeTriggers.add(tw);
        }
        return bndle;
    }

    public synchronized void triggeredJobComplete(Trigger trigger, JobDetail jobDetail, int triggerInstCode) {
        String jobKey = JobWrapper.getJobNameKey(jobDetail.getKey().getGroup(), jobDetail.getKey().getName());
        JobWrapper jw = (JobWrapper)this.jobsByFQN.get(jobKey);
        TriggerWrapper tw2 = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(trigger));
        if (jw != null) {
            JobDetail jd = jw.jobDetail;
            if (StatefulJob.class.isAssignableFrom(jobDetail.getJobClass())) {
                JobDataMap newData = jobDetail.getJobDataMap();
                if (newData != null) {
                    newData.clearDirtyFlag();
                }
                JobDataMap jdm = jd.getJobDataMap();
                jdm.clear();
                jdm.putAll((Map)newData);
                this.blockedJobs.remove(JobWrapper.getJobNameKey(jd));
                ArrayList trigs = this.getTriggerWrappersForJob(jd.getKey().getName(), jd.getKey().getGroup());
                for (TriggerWrapper ttw : trigs) {
                    if (ttw.state != 5) continue;
                    this.setTriggerState(ttw, 0);
                    this.timeTriggers.add(ttw);
                }
            }
        } else {
            this.blockedJobs.remove(JobWrapper.getJobNameKey(jobDetail));
        }
        if (tw2 != null) {
            if (triggerInstCode == Trigger.CompletedExecutionInstruction.DELETE_TRIGGER.ordinal()) {
                if (trigger.getNextFireTime() == null) {
                    if (tw2.getTrigger().getNextFireTime() == null) {
                        this.removeTrigger(trigger.getKey().getName(), trigger.getKey().getGroup());
                    }
                } else {
                    this.removeTrigger(trigger.getKey().getName(), trigger.getKey().getGroup());
                }
            } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_TRIGGER_COMPLETE.ordinal()) {
                this.setTriggerState(tw2, 3);
                this.timeTriggers.remove(tw2);
            } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE.ordinal()) {
                ArrayList tws = this.getTriggerWrappersForJob(trigger.getJobKey().getName(), trigger.getJobKey().getGroup());
                for (TriggerWrapper tw2 : tws) {
                    this.setTriggerState(tw2, 3);
                    this.timeTriggers.remove(tw2);
                }
            }
        }
    }

    protected synchronized String peekTriggers() {
        StringBuffer str = new StringBuffer();
        TriggerWrapper tw2 = null;
        Iterator<Object> itr = this.triggersByFQN.keySet().iterator();
        while (itr.hasNext()) {
            tw2 = (TriggerWrapper)this.triggersByFQN.get(itr.next());
            str.append(tw2.trigger.getKey().getName());
            str.append("/");
        }
        str.append(" | ");
        for (TriggerWrapper tw2 : this.timeTriggers) {
            str.append(tw2.trigger.getKey().getName());
            str.append("->");
        }
        return str.toString();
    }

    public synchronized Set getPausedTriggerGroups() throws JobPersistenceException {
        HashSet set = new HashSet();
        set.addAll(this.pausedTriggerGroups);
        return set;
    }

    protected void setTriggerState(TriggerWrapper tw, int newState) {
        tw.state = newState;
    }

    public void schedulerStarted() throws SchedulerException {
    }

    public Trigger acquireNextTrigger(long noLaterThan) throws JobPersistenceException {
        return this.acquireNextTrigger();
    }

    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return 0L;
    }

    public boolean isClustered() {
        return false;
    }

    public void setInstanceId(String paramString) {
    }

    public void setInstanceName(String paramString) {
    }

    public List<OperableTrigger> acquireNextTriggers(long paramLong1, int paramInt, long paramLong2) throws JobPersistenceException {
        return null;
    }

    public boolean checkExists(JobKey paramJobKey) throws JobPersistenceException {
        return false;
    }

    public boolean checkExists(TriggerKey paramTriggerKey) throws JobPersistenceException {
        return false;
    }

    public void clearAllSchedulingData() throws JobPersistenceException {
    }

    public long getAcquireRetryDelay(int paramInt) {
        return 0L;
    }

    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> paramGroupMatcher) throws JobPersistenceException {
        return null;
    }

    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> paramGroupMatcher) throws JobPersistenceException {
        return null;
    }

    public Trigger.TriggerState getTriggerState(TriggerKey paramTriggerKey) throws JobPersistenceException {
        return null;
    }

    public List<OperableTrigger> getTriggersForJob(JobKey paramJobKey) throws JobPersistenceException {
        return null;
    }

    public void pauseJob(JobKey paramJobKey) throws JobPersistenceException {
    }

    public Collection<String> pauseJobs(GroupMatcher<JobKey> paramGroupMatcher) throws JobPersistenceException {
        return null;
    }

    public void pauseTrigger(TriggerKey paramTriggerKey) throws JobPersistenceException {
    }

    public Collection<String> pauseTriggers(GroupMatcher<TriggerKey> paramGroupMatcher) throws JobPersistenceException {
        return null;
    }

    public void releaseAcquiredTrigger(OperableTrigger paramOperableTrigger) {
    }

    public boolean removeJob(JobKey paramJobKey) throws JobPersistenceException {
        return false;
    }

    public boolean removeJobs(List<JobKey> paramList) throws JobPersistenceException {
        return false;
    }

    public boolean removeTrigger(TriggerKey paramTriggerKey) throws JobPersistenceException {
        return false;
    }

    public boolean removeTriggers(List<TriggerKey> paramList) throws JobPersistenceException {
        return false;
    }

    public boolean replaceTrigger(TriggerKey paramTriggerKey, OperableTrigger paramOperableTrigger) throws JobPersistenceException {
        return false;
    }

    public void resetTriggerFromErrorState(TriggerKey paramTriggerKey) throws JobPersistenceException {
    }

    public void resumeJob(JobKey paramJobKey) throws JobPersistenceException {
    }

    public Collection<String> resumeJobs(GroupMatcher<JobKey> paramGroupMatcher) throws JobPersistenceException {
        return null;
    }

    public void resumeTrigger(TriggerKey paramTriggerKey) throws JobPersistenceException {
    }

    public Collection<String> resumeTriggers(GroupMatcher<TriggerKey> paramGroupMatcher) throws JobPersistenceException {
        return null;
    }

    public JobDetail retrieveJob(JobKey paramJobKey) throws JobPersistenceException {
        return null;
    }

    public OperableTrigger retrieveTrigger(TriggerKey paramTriggerKey) throws JobPersistenceException {
        return null;
    }

    public void schedulerPaused() {
    }

    public void schedulerResumed() {
    }

    public void setThreadPoolSize(int paramInt) {
    }

    public void storeJobAndTrigger(JobDetail paramJobDetail, OperableTrigger paramOperableTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
    }

    public void storeJobsAndTriggers(Map<JobDetail, Set<? extends Trigger>> paramMap, boolean paramBoolean) throws ObjectAlreadyExistsException, JobPersistenceException {
    }

    public void storeTrigger(OperableTrigger paramOperableTrigger, boolean paramBoolean) throws ObjectAlreadyExistsException, JobPersistenceException {
    }

    public void triggeredJobComplete(OperableTrigger paramOperableTrigger, JobDetail paramJobDetail, Trigger.CompletedExecutionInstruction paramCompletedExecutionInstruction) {
    }

    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> paramList) throws JobPersistenceException {
        return null;
    }
}

