/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool;

import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.console.IUserStream;
import com.kingdee.bos.tool.console.UserStreamManager;
import com.kingdee.bos.tool.utils.ColorManager;
import com.kingdee.bos.tool.utils.FontManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ToolBasePlugin
extends AbstractUIPlugin {
    public static final int INTERNAL_ERROR = 120;
    private static ToolBasePlugin plugin;
    private ResourceBundle resourceBundle;

    public ToolBasePlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("com.kingdee.bos.tool.base.ToolBasePluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        PropertyConfigurator.configure((URL)ToolBasePlugin.getPlugInURL("log4j.properties"));
    }

    public void stop(BundleContext context) throws Exception {
        FontManager.dispose();
        ColorManager.dispose();
        super.stop(context);
    }

    public static ToolBasePlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = ToolBasePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public IUserStream getUserStream(String streamId) {
        UserStreamManager usm = UserStreamManager.getUserStreamManager();
        IUserStream userStream = usm.getUserStream(streamId);
        if (userStream == null) {
            userStream = usm.createUserStream(streamId);
        }
        return userStream;
    }

    public static URL getPlugInURL(String name) throws IDEException {
        try {
            URL installURL = ToolBasePlugin.getDefault().getBundle().getEntry("/");
            URL url = new URL(installURL, name);
            return url;
        }
        catch (MalformedURLException e) {
            throw new IDEException(e);
        }
    }

    public static void log(IStatus status) {
        ToolBasePlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        Status status = new Status(4, "com.kingdee.bos.tool.ToolBasePlugin", 120, "Error logged from Studio UI:", t);
        ToolBasePlugin.log((IStatus)status);
    }
}

