/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.inifile;

import com.kingdee.bos.tool.inifile.IniFileInvalidFormatException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class IniFileReader {
    HashMap sections;
    String fileName;
    boolean updateRightNow;
    private static String DEFAULT_CHARSET = "ISO8859-1";
    private String charset;
    private static final Logger logger = Logger.getLogger(IniFileReader.class);

    public static void main(String[] args) throws IOException, IniFileInvalidFormatException {
        IniFileReader ifile;
        try {
            ifile = new IniFileReader("bad.ini");
            logger.info((Object)ifile.toString());
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        catch (IniFileInvalidFormatException e) {
            logger.error((Object)e);
        }
        try {
            ifile = new IniFileReader("good.ini");
            logger.info((Object)ifile.toString());
            logger.info((Object)ifile.getProperty("Section1", "test1"));
            logger.info((Object)"bark: ");
            String[] bark = ifile.getPropertyValues("Section1", "test2");
            for (int i = 0; i < bark.length; ++i) {
                logger.info((Object)bark[i]);
            }
            ifile.setProperty("Section1", "fooo", "test0000");
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        catch (IniFileInvalidFormatException e) {
            logger.error((Object)e);
        }
    }

    public String toString() {
        return this.sections.toString();
    }

    public String getProperty(String sectionName, String property) {
        return (String)this.getSection(sectionName).get(property);
    }

    public String[] getPropertyValues(String sectionName, String property) {
        String tokens = this.getProperty(sectionName, property);
        if (tokens == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(tokens, ",");
        String[] result = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            result[i++] = st.nextToken();
        }
        return result;
    }

    public Set getProperties(String sectionName) {
        return this.getSection(sectionName).keySet();
    }

    public HashMap getSection(String sectionName) {
        HashMap section = (HashMap)this.sections.get(sectionName);
        return section;
    }

    public Set getSections() {
        return this.sections.keySet();
    }

    public IniFileReader(String pFileName) throws IOException, IniFileInvalidFormatException {
        this(pFileName, true);
    }

    public IniFileReader(String pFileName, String pCharset) throws IOException, IniFileInvalidFormatException {
        this(pFileName, true, pCharset);
    }

    public IniFileReader(String pFileName, boolean pUpdateRightNow) throws IOException, IniFileInvalidFormatException {
        this(pFileName, pUpdateRightNow, DEFAULT_CHARSET);
    }

    public IniFileReader(String pFileName, boolean pUpdateRightNow, String pCharset) throws IOException, IniFileInvalidFormatException {
        this.fileName = pFileName;
        this.updateRightNow = pUpdateRightNow;
        this.charset = pCharset;
        this.read();
    }

    public void setProperty(String sectionName, String property, String value) throws IOException {
        this.getSection(sectionName).put(property, value);
        if (this.updateRightNow) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        Iterator si = this.sections.keySet().iterator();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName), this.charset));
            while (si.hasNext()) {
                String sectionName = si.next().toString();
                pw.println("[" + sectionName + "]");
                Map section = (Map)this.sections.get(sectionName);
                Iterator pi = section.keySet().iterator();
                while (pi.hasNext()) {
                    String property = pi.next().toString();
                    pw.println(property + "=" + section.get(property));
                }
            }
            pw.flush();
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() throws IOException, IniFileInvalidFormatException {
        this.sections = new HashMap();
        BufferedReader lnr = null;
        String input = null;
        HashMap<String, String> currentSection = null;
        try {
            lnr = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), this.charset));
            while ((input = ((LineNumberReader)lnr).readLine()) != null) {
                String trimmedInput = input.trim();
                if ("".equals(trimmedInput) || trimmedInput.startsWith(";")) continue;
                if (trimmedInput.startsWith("[") && trimmedInput.endsWith("]")) {
                    String sectionName = trimmedInput.substring(1, trimmedInput.length() - 1);
                    currentSection = new HashMap<String, String>();
                    this.sections.put(sectionName, currentSection);
                    continue;
                }
                if (currentSection == null) {
                    throw new IniFileInvalidFormatException("Properties found before section at line " + ((LineNumberReader)lnr).getLineNumber());
                }
                int equalsAt = trimmedInput.indexOf("=");
                if (equalsAt == -1) {
                    throw new IniFileInvalidFormatException("Invalid property format at line " + ((LineNumberReader)lnr).getLineNumber());
                }
                String key = trimmedInput.substring(0, equalsAt);
                String value = trimmedInput.substring(equalsAt + 1);
                currentSection.put(key, value);
            }
        }
        finally {
            if (lnr != null) {
                try {
                    lnr.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

