/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.utils;

import com.kingdee.util.SAXBuilderFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XMLResourceManager {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.utils.XMLResourceManager");
    private static SAXBuilder builder = SAXBuilderFactory.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int saveToXML(Element root, String filename) {
        if (filename == null || root == null) {
            return -1;
        }
        File file = new File(filename);
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            Document myDocument = root.getDocument();
            if (myDocument == null) {
                myDocument = new Document(root);
            }
            Format format = Format.getRawFormat();
            format.setIndent("    ");
            format.setEncoding("UTF-8");
            format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
            XMLOutputter outputter = new XMLOutputter(format);
            outputter.output(myDocument, (Writer)writer);
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ioe) {
                logger.error((Object)ioe);
            }
        }
        return 0;
    }

    public static String printDocument(Element root) {
        Document myDocument = root.getDocument();
        Format format = Format.getRawFormat();
        format.setIndent("    ");
        format.setEncoding("UTF-8");
        XMLOutputter outputter = new XMLOutputter(format);
        String str = outputter.outputString(myDocument);
        str = str == null ? "" : str;
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element loadFromXML(String filename) {
        Element root;
        File file = new File(filename);
        if (!file.exists()) {
            return null;
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            Document doc = builder.build((Reader)fileReader);
            root = doc.getRootElement();
        }
        catch (Exception e) {
            logger.error((Object)e);
            Element element = null;
            return element;
        }
        finally {
            if (fileReader != null) {
                XMLResourceManager.safeClose(fileReader);
            }
        }
        return root;
    }

    public static void safeClose(FileReader fileReader) {
        if (fileReader != null) {
            try {
                fileReader.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    public static Element loadFromXML(byte[] str) {
        Element root;
        try {
            ByteArrayInputStream inb = new ByteArrayInputStream(str);
            Document doc = builder.build((Reader)new InputStreamReader(inb));
            root = doc.getRootElement();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
        return root;
    }
}

