/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md;

import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class MDFileSubsystem {
    private boolean isFile = false;
    private String path = "";

    public static MDFileSubsystem[] loadFromXMLFile(File file) throws JDOMException, IOException {
        ArrayList fss = new ArrayList();
        SAXBuilder builder = new SAXBuilder();
        Element root = builder.build(file).getRootElement();
        MDFileSubsystem.loadElements(fss, root, false);
        MDFileSubsystem.loadElements(fss, root, true);
        return fss.toArray(new MDFileSubsystem[fss.size()]);
    }

    public static MDFileSubsystem[] loadFromDir(File dir) {
        ArrayList<MDFileSubsystem> fss = new ArrayList<MDFileSubsystem>();
        ArrayList allFiles = new ArrayList();
        MDFileSubsystem.listFile(dir, allFiles);
        int len = dir.getAbsolutePath().length();
        int n = allFiles.size();
        for (int i = 0; i < n; ++i) {
            MDFileSubsystem fs;
            File f = (File)allFiles.get(i);
            String path = f.getAbsolutePath().substring(len);
            if ((path = StringUtils.replace((String)path, (String)"\\", (String)"/")).startsWith("/")) {
                path = path.substring(1);
            }
            if (f.isFile()) {
                fs = new MDFileSubsystem(path, true);
                fss.add(fs);
                continue;
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            fs = new MDFileSubsystem(path, false);
            fss.add(fs);
        }
        return fss.toArray(new MDFileSubsystem[fss.size()]);
    }

    private static void loadElements(List fss, Element root, boolean file) {
        String name = file ? "file" : "folder";
        List list = root.getChildren(name);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Element el = (Element)list.get(i);
            String path = el.getAttributeValue("path");
            MDFileSubsystem fs = new MDFileSubsystem(path, file);
            fss.add(fs);
        }
    }

    private static void listFile(File root, List list) {
        if (root.isFile()) {
            list.add(root);
            return;
        }
        File[] children = root.listFiles();
        for (int i = 0; i < children.length; ++i) {
            MDFileSubsystem.listFile(children[i], list);
        }
    }

    public MDFileSubsystem(String path, boolean isFile) {
        this.path = path;
        this.isFile = isFile;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        if (StringUtils.isEmpty((String)this.path)) {
            return this.path;
        }
        int index = this.path.lastIndexOf(47);
        if (index == -1) {
            return this.path;
        }
        return this.path.substring(index);
    }
}

