/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.cache;

import com.kingdee.bos.md.cache.CacheItem;
import com.kingdee.bos.md.cache.CacheMonitorThread;
import com.kingdee.bos.tool.LogTool;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public abstract class AbstractCacheInfoManager {
    protected int activeObjectSize = -1;
    protected int objectSize = -1;
    protected Map infoCache = new TreeMap();
    protected Set deactiveKeys = Collections.synchronizedSet(new HashSet());
    protected File cacheFile = null;
    protected Vector storeList = new Vector();
    protected CacheMonitorThread monitorThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractCacheInfoManager(File zipCacheFile) {
        if (!zipCacheFile.exists()) {
            zipCacheFile.getParentFile().mkdirs();
        } else {
            ZipFile zip = null;
            try {
                zip = new ZipFile(zipCacheFile);
                Enumeration<? extends ZipEntry> en = zip.entries();
                while (en.hasMoreElements()) {
                    ZipEntry entry = en.nextElement();
                    this.deactiveKeys.add(entry.getName());
                }
                zip.close();
            }
            catch (Exception ex) {
                LogTool.logError("\u4ece\u7f13\u5b58\u6587\u4ef6\u4e2d\u8f7d\u5165\u4fe1\u606f\u65f6\u51fa\u9519", ex);
            }
            finally {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.cacheFile = zipCacheFile;
        this.monitorThread = new CacheMonitorThread(this.storeList, this.cacheFile);
        this.monitorThread.start();
    }

    public boolean isUpdated(Object object) {
        String key = this.getPath(object);
        CacheItem info = (CacheItem)this.infoCache.get(key);
        if (info == null && this.deactiveKeys.remove(key) && (info = this.active(key)) != null) {
            this.addCacheItem(info);
        }
        return info == null || this.needReload(info.getLastLoadedTime(), object);
    }

    public CacheItem getCacheItem(Object object) {
        CacheItem info = null;
        if (this.isUpdated(object)) {
            try {
                Serializable uo = this.loadUserObject(object);
                info = new CacheItem(this.getPath(object), uo);
                info.setLastLoadedTime(System.currentTimeMillis());
                this.storeList.add(info);
                this.addCacheItem(info);
            }
            catch (Exception ex) {
                LogTool.logError("\u8f7d\u5165\u7528\u6237\u5bf9\u8c61\u65f6\u51fa\u9519", ex);
            }
        } else {
            info = (CacheItem)this.infoCache.get(this.getPath(object));
        }
        if (info == null) {
            return null;
        }
        info.setLastUsedTime(System.currentTimeMillis());
        return info;
    }

    private void addCacheItem(CacheItem item) {
        if (this.activeObjectSize > 0) {
            while (this.infoCache.size() >= this.activeObjectSize) {
                CacheItem r = (CacheItem)this.infoCache.values().iterator().next();
                this.deactiveKeys.add(r.getPath());
                this.infoCache.remove(r.getPath());
            }
        }
        this.infoCache.put(item.getPath(), item);
    }

    public Serializable getUserObject(Object object) {
        CacheItem item = this.getCacheItem(object);
        if (item == null) {
            return null;
        }
        return item.getUserObject();
    }

    protected boolean needReload(long loadedTime, Object object) {
        return false;
    }

    protected abstract Serializable loadUserObject(Object var1) throws Exception;

    protected abstract String getPath(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CacheItem active(String path) {
        ZipInputStream input = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.cacheFile);
            ZipEntry entry = zipFile.getEntry(path);
            if (entry == null) {
                CacheItem cacheItem = null;
                return cacheItem;
            }
            ObjectInputStream oin = new ObjectInputStream(zipFile.getInputStream(entry));
            CacheItem cacheItem = (CacheItem)oin.readObject();
            return cacheItem;
        }
        catch (Exception ex) {
            LogTool.logError("\u6fc0\u6d3b\u7f13\u5b58\u5bf9\u8c61\u65f6\u51fa\u9519", ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    LogTool.logError("close input stream error!", e);
                }
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception ex) {
                    LogTool.logError("close zip file error!", ex);
                }
            }
        }
        return null;
    }

    public int getActiveObjectSize() {
        return this.activeObjectSize;
    }

    public void setActiveObjectSize(int activeObjectSize) {
        this.activeObjectSize = activeObjectSize;
    }

    public int getObjectSize() {
        return this.objectSize;
    }

    public void setObjectSize(int objectSize) {
        this.objectSize = objectSize;
        this.monitorThread.setMaxSize(objectSize);
    }

    public File getCacheFile() {
        return this.cacheFile;
    }
}

