/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.cache;

import com.kingdee.bos.md.cache.CacheInfo;
import com.kingdee.bos.md.cache.MDSimpleObject;
import com.kingdee.bos.md.cache.SimleMDStoreThread;
import com.kingdee.bos.md.cache.SimpleObjectUtil;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.util.backport.Collections;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SimpleMDUtil {
    private static Map instances = new HashMap();
    Map caches = new HashMap();
    private SimleMDStoreThread storer;
    IMDProject project;
    Set changedSet = Collections.synchronizedSet(new HashSet());
    static final String INDEX_NAME = "cache/simpleMDUtil.index";

    public static MDSimpleObject getSimpleObject(IMDFile file) {
        SimpleMDUtil util = SimpleMDUtil.getInstance(file.getMDProject());
        try {
            return util.getSimpleObject(MDResourceUtil.getMDPath(file.getMDProject(), file.getPath()));
        }
        catch (Exception e) {
            LogTool.logError("\u8f7d\u5165\u7b80\u5355\u5bf9\u8c61\u65f6\u51fa\u9519", e);
            return null;
        }
    }

    public static void removeInstance(IMDProject project) {
        instances.remove(project);
    }

    private static SimpleMDUtil getInstance(IMDProject project) {
        SimpleMDUtil util = (SimpleMDUtil)instances.get(project);
        if (util == null) {
            util = new SimpleMDUtil(project);
            instances.put(project, util);
        }
        return util;
    }

    private SimpleMDUtil(IMDProject project) {
        this.project = project;
        this.load();
        this.storer = new SimleMDStoreThread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        block7: {
            File file = new File(this.project.toFile(), INDEX_NAME);
            if (!file.exists()) break block7;
            Properties prop = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                prop.load(fileInputStream);
            }
            catch (IOException e) {
                try {
                    LogTool.logError("\u8f7d\u5165\u7f13\u5b58\u65f6\u51fa\u9519", e);
                }
                catch (Throwable throwable) {
                    FileUtils.close(fileInputStream);
                    throw throwable;
                }
                FileUtils.close(fileInputStream);
            }
            FileUtils.close(fileInputStream);
            Iterator<Object> iter = prop.keySet().iterator();
            while (iter.hasNext()) {
                String key = ((String)iter.next()).trim();
                String value = prop.getProperty(key);
                CacheInfo info = new CacheInfo();
                info.setKey(key);
                try {
                    info.setLastActiveTime(Long.parseLong(value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.caches.put(key, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized MDSimpleObject getSimpleObject(String path) throws IOException, ClassNotFoundException {
        IMDFile file = this.project.getRoot().getChildFile(path);
        CacheInfo info = (CacheInfo)this.caches.get(path);
        if (info != null && file.lastModified() == info.getLastActiveTime()) {
            if (info.getObject() == null) {
                MDSimpleObject obj = this.storer.loadFromCache(path);
                if (obj != null) {
                    info.setObject(obj);
                    return obj;
                }
            } else {
                return info.getObject();
            }
        }
        if (info == null) {
            info = new CacheInfo();
            info.setKey(path);
        }
        MDSimpleObject so = new MDSimpleObject(path);
        InputStream content = file.getLibContent();
        if (content != null) {
            try {
                SimpleObjectUtil.parseXML(so, content);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((content = file.getLocalContent()) != null) {
            try {
                SimpleObjectUtil.parseXML(so, content);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        info.setLastActiveTime(file.lastModified());
        info.setObject(so);
        this.caches.put(path, info);
        Set set = this.changedSet;
        synchronized (set) {
            this.changedSet.add(info.getObject());
        }
        return so;
    }
}

