/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.mdfs;

import com.kingdee.bos.md.mdfs.BaseMetasFolder;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.IMDResource;
import com.kingdee.bos.md.mdfs.MDFile;
import com.kingdee.bos.md.mdfs.MDResource;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;

public class MDFolder
extends MDResource
implements IMDFolder {
    MDFolder(IMDProject project, String path) {
        super(project, MDFolder.ensureLastChar(path));
    }

    private static String ensureLastChar(String path) {
        if (!StringUtils.isEmpty((String)path) && !path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    MDFolder(IMDProject project, String path, Iterator iter) {
        super(project, path, iter);
    }

    @Override
    public String getPackageName() {
        if (this.path.length() == 0) {
            return "";
        }
        return StringUtils.replace((String)this.path.substring(0, this.path.length() - 1), (String)"/", (String)".");
    }

    @Override
    public IMDFile getChildFile(String path) {
        if (!(path = MDResourceUtil.getMDPath(this.project, path)).startsWith(this.path)) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            path = this.path + path;
        }
        return new MDFile(this.project, path);
    }

    @Override
    public IMDFolder getChildFolder(String path) {
        if (!(path = MDResourceUtil.getMDPath(this.project, path)).startsWith(this.path)) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            path = this.path + path;
        }
        return new MDFolder(this.project, path);
    }

    @Override
    public boolean isParentOf(String path, boolean direct) {
        if (path.equals(this.path)) {
            return false;
        }
        boolean flag = path.startsWith(this.path);
        if (!flag) {
            return false;
        }
        if (!direct) {
            return true;
        }
        String t = path.substring(this.path.length());
        if (t.endsWith("/")) {
            t = t.substring(0, t.length() - 1);
        }
        return t.indexOf(47) == -1;
    }

    private boolean includeSuffix(String path, String[] suffixs) {
        if (suffixs == null) {
            return true;
        }
        for (int j = 0; j < suffixs.length; ++j) {
            if (!path.endsWith(suffixs[j])) continue;
            return true;
        }
        return false;
    }

    @Override
    public IMDFile[] listAllFile(String exts) {
        IMDFile[] files = (IMDFile[])this.project.listChild(this.path, true, true, false);
        if (files.length > 0 && !StringUtils.isEmpty((String)exts)) {
            ArrayList<IMDFile> list = new ArrayList<IMDFile>();
            String[] suffixs = exts.split(";");
            for (int i = 0; i < files.length; ++i) {
                if (!this.includeSuffix(files[i].getPath(), suffixs)) continue;
                list.add(files[i]);
            }
            files = list.toArray(new IMDFile[list.size()]);
        }
        return files;
    }

    @Override
    public IMDResource[] listChildren() {
        return this.listChildren(null);
    }

    @Override
    public IMDResource[] listChildren(String exts) {
        IMDResource[] resources = this.project.listChild(this.path, false, true, true);
        if (resources.length > 0 && !StringUtils.isEmpty((String)exts)) {
            ArrayList<IMDResource> list = new ArrayList<IMDResource>();
            String[] suffixs = exts.split(";");
            for (int i = 0; i < resources.length; ++i) {
                if (!this.includeSuffix(resources[i].getPath(), suffixs)) continue;
                list.add(resources[i]);
            }
            resources = list.toArray(new IMDResource[list.size()]);
        }
        return resources;
    }

    @Override
    public boolean hasChildren() {
        return this.project.hasChild(this.path);
    }

    @Override
    public IMDFolder[] listAllFolder() {
        return (IMDFolder[])this.project.listChild(this.path, true, false, true);
    }

    public IMDFolder createBaseMetasFolder() {
        return new BaseMetasFolder(this.project, this.path);
    }
}

