/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.mdfs;

import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.RemoteFSInfo;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class RemoteFSInfoCollection {
    private static final Map ALL_COLLECTION = new HashMap();
    private Map map = new HashMap();
    private File storeFile = null;

    public static RemoteFSInfoCollection get(IMDProject project) {
        File file = new File(project.toFile(), "dynamic_metas.xml");
        return RemoteFSInfoCollection.get(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteFSInfoCollection get(File file) {
        RemoteFSInfoCollection coll = (RemoteFSInfoCollection)ALL_COLLECTION.get(file);
        Map map = ALL_COLLECTION;
        synchronized (map) {
            if (coll == null) {
                coll = new RemoteFSInfoCollection();
                coll.storeFile = file;
                coll.load();
            }
            ALL_COLLECTION.put(file, coll);
        }
        return coll;
    }

    public boolean exists(String path) {
        return this.map.containsKey(path.trim());
    }

    public void clear() {
        this.map.clear();
    }

    public void remove(String path) {
        this.map.remove(path);
    }

    private synchronized void load() {
        if (this.storeFile.exists()) {
            Element root;
            SAXBuilder builder = new SAXBuilder();
            try {
                root = builder.build(this.storeFile).getRootElement();
            }
            catch (Exception e) {
                LogTool.logError("", e);
                return;
            }
            List children = root.getChildren();
            int n = children.size();
            for (int i = 0; i < n; ++i) {
                Element el = (Element)children.get(i);
                String path = el.getAttributeValue("path");
                RemoteFSInfo info = this.addFile(path);
                if (info == null) continue;
                info.loadFromDOM(el);
            }
            HashMap<String, RemoteFSInfo> map = new HashMap<String, RemoteFSInfo>();
            Iterator iter = this.pathIterator();
            while (iter.hasNext()) {
                String path = (String)iter.next();
                int index = path.lastIndexOf(47);
                while (index != -1 && !map.containsKey(path = path.substring(0, index + 1))) {
                    map.put(path, RemoteFSInfo.newDir(path));
                    path = path.substring(0, path.length() - 1);
                    index = path.lastIndexOf(47);
                }
            }
            this.map.putAll(map);
        } else {
            this.storeFile.getParentFile().mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store2File() {
        Document doc = new Document();
        Element root = new Element("filesystem");
        doc.setRootElement(root);
        for (RemoteFSInfo info : this.map.values()) {
            if (info.isDirecotry()) continue;
            Element fEl = new Element("file");
            fEl.setAttribute("path", info.getPath());
            if (!StringUtils.isEmpty((String)info.getAlias())) {
                fEl.setAttribute("alias", info.getAlias());
            }
            if (!StringUtils.isEmpty((String)info.getMd5())) {
                fEl.setAttribute("md5", info.getMd5());
            }
            if (!StringUtils.isEmpty((String)info.getCheckOutUser())) {
                fEl.setAttribute("checkoutuser", info.getCheckOutUser());
            }
            if (!StringUtils.isEmpty((String)info.getCreator())) {
                fEl.setAttribute("creator", info.getCreator());
            }
            if (!StringUtils.isEmpty((String)info.getLastModifyUser())) {
                fEl.setAttribute("lastmodifyuser", info.getLastModifyUser());
            }
            fEl.setAttribute("createtime", String.valueOf(info.getCreateTime()));
            fEl.setAttribute("deploytime", String.valueOf(info.getDeployTime()));
            fEl.setAttribute("lastmodifytime", String.valueOf(info.getLastModifyTime()));
            root.addContent((Content)fEl);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.storeFile);
            XmlUtils.output((Document)doc, (OutputStream)fileOutputStream);
        }
        catch (Exception e) {
            try {
                LogTool.logError("\u4fdd\u5b58\u65f6\u51fa\u9519", e);
            }
            catch (Throwable throwable) {
                FileUtils.close(fileOutputStream);
                throw throwable;
            }
            FileUtils.close(fileOutputStream);
        }
        FileUtils.close(fileOutputStream);
    }

    public Iterator pathIterator() {
        return this.map.keySet().iterator();
    }

    public Iterator infoIterator() {
        HashSet set = new HashSet();
        set.addAll(this.map.values());
        return set.iterator();
    }

    public void replace(RemoteFSInfo info) {
        if (info == null) {
            return;
        }
        this.map.put(info.getPath(), info);
        String path = info.getPath();
        int index = path.lastIndexOf(47);
        while (index != -1 && !this.map.containsKey(path = path.substring(0, index + 1))) {
            this.map.put(path, RemoteFSInfo.newDir(path));
            path = path.substring(0, path.length() - 1);
            index = path.lastIndexOf(47);
        }
    }

    public RemoteFSInfo addFile(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        RemoteFSInfo info = (RemoteFSInfo)this.map.get(path = path.trim());
        if (info != null) {
            return info;
        }
        info = new RemoteFSInfo(path);
        this.map.put(path, info);
        int index = path.lastIndexOf(47);
        while (index != -1 && !this.map.containsKey(path = path.substring(0, index + 1))) {
            this.map.put(path, RemoteFSInfo.newDir(path));
            path = path.substring(0, path.length() - 1);
            index = path.lastIndexOf(47);
        }
        return info;
    }

    public RemoteFSInfo getRemoteFSInfo(String filePath) {
        if (StringUtils.isEmpty((String)filePath)) {
            return null;
        }
        filePath = filePath.trim();
        return (RemoteFSInfo)this.map.get(filePath);
    }
}

