/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.ui;

import com.kingdee.bos.md.cache.AliasUtil;
import com.kingdee.bos.md.cache.MDSimpleObject;
import com.kingdee.bos.md.dao.MDORMUtil;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.IMDResource;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.tool.views.ResourceContentProvider;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;

public class MDViewContentProvider
extends ResourceContentProvider {
    private String suffix;
    private boolean showFile = true;
    private IMDFile[] files;
    private Properties properties = new Properties();
    private boolean onlySrc = false;
    private boolean useAlias = false;
    private boolean showEmptyFolder = false;

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean isShowFile() {
        return this.showFile;
    }

    public void setShowFile(boolean showFile) {
        this.showFile = showFile;
    }

    public IMDFile[] listFileChildren(IMDFolder parent) {
        return (IMDFile[])this.listChildren(parent, true, false);
    }

    public IMDFolder[] listFolderChildren(IMDFolder parent) {
        return (IMDFolder[])this.listChildren(parent, false, true);
    }

    public IMDResource[] listChildren(IMDFolder parent) {
        return this.listChildren(parent, true, true);
    }

    public IMDProject getProject() {
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        return this.files[0].getMDProject();
    }

    private IMDResource[] listChildren(IMDFolder parent, boolean includeFiles, boolean includeFolders) {
        assert (includeFiles || includeFolders);
        if (!this.showEmptyFolder) {
            ArrayList<IMDFile> list = new ArrayList<IMDFile>();
            for (int i = 0; i < this.files.length; ++i) {
                IMDResource r = this.files[i];
                if (!parent.isParentOf(r.getPath(), false)) continue;
                while (r != null && !parent.equals(r.getParent())) {
                    r = r.getParent();
                }
                if (r == null || list.contains(r)) continue;
                if (r instanceof IMDFile) {
                    if (!includeFiles) continue;
                    list.add((IMDFile)r);
                    continue;
                }
                if (!includeFolders) continue;
                list.add((IMDFile)r);
            }
            Collections.sort(list);
            if (!includeFiles) {
                return list.toArray(new IMDFolder[list.size()]);
            }
            if (!includeFolders) {
                return list.toArray(new IMDFile[list.size()]);
            }
            return list.toArray(new IMDResource[list.size()]);
        }
        IMDResource[] children = parent.listChildren();
        if (!includeFiles) {
            ArrayList<IMDResource> list = new ArrayList<IMDResource>();
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof IMDFolder) || this.onlySrc && !children[i].toFile().exists()) continue;
                list.add(children[i]);
            }
            return list.toArray(new IMDFolder[list.size()]);
        }
        if (!includeFolders) {
            ArrayList<IMDResource> list = new ArrayList<IMDResource>();
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof IMDFile) || !this.inArray((IMDFile)children[i])) continue;
                list.add(children[i]);
            }
            return list.toArray(new IMDFile[list.size()]);
        }
        if (!this.onlySrc) {
            return children;
        }
        ArrayList<IMDResource> list = new ArrayList<IMDResource>();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].toFile().exists()) continue;
            list.add(children[i]);
        }
        return list.toArray(new IMDFile[list.size()]);
    }

    private boolean inArray(IMDFile file) {
        for (int i = 0; i < this.files.length; ++i) {
            if (!file.equals(this.files[i])) continue;
            return true;
        }
        return false;
    }

    public void setFilterProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void setOnlySrc(boolean flag) {
        if (this.onlySrc != flag) {
            this.onlySrc = flag;
            this.files = null;
        }
    }

    private void initFiles(IMDFolder folder) {
        IMDFile[] files = folder.listAllFile(this.suffix);
        ArrayList<IMDFile> list = new ArrayList<IMDFile>();
        if (!this.properties.isEmpty()) {
            for (int i = 0; i < files.length; ++i) {
                IMDFile file = files[i];
                if (this.onlySrc && !file.isModified()) continue;
                MDSimpleObject so = MDORMUtil.getSimpleObject(file);
                boolean flag = true;
                for (String string : this.properties.keySet()) {
                    String value = this.properties.getProperty(string);
                    if (value.equals(so.getProperty(string))) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                list.add(file);
            }
        } else {
            for (int i = 0; i < files.length; ++i) {
                IMDFile file = files[i];
                if (this.onlySrc && !file.isModified()) continue;
                list.add(file);
            }
        }
        this.files = list.toArray(new IMDFile[list.size()]);
    }

    private IMDResource[] getProjectChildren(IMDProject project) {
        this.initFiles(project.getRoot());
        return new IMDResource[]{project.getRoot()};
    }

    private IMDResource[] getFolderChildren(IMDFolder root) {
        if (this.files == null || this.files.length == 0) {
            this.initFiles(root);
        }
        return this.listChildren(root, this.showFile, true);
    }

    private IMDResource[] getArrayChildren(IMDFile[] files) {
        assert (files.length > 0);
        this.files = files;
        return new IMDResource[]{files[0].getMDProject().getRoot()};
    }

    @Override
    public Object getParent(Object element) {
        if (element instanceof IMDResource) {
            return ((IMDResource)element).getParent();
        }
        return null;
    }

    @Override
    public boolean hasChildren(Object element) {
        IMDFolder folder = null;
        if (element instanceof IMDProject) {
            folder = ((IMDProject)element).getRoot();
        } else if (element instanceof IMDFolder) {
            folder = (IMDFolder)element;
        }
        if (folder == null) {
            return false;
        }
        if (!this.showEmptyFolder) {
            for (int i = 0; i < this.files.length; ++i) {
                IMDResource r = this.files[i];
                if (!folder.isParentOf(r.getPath(), false)) continue;
                while (r != null && !folder.equals(r.getParent())) {
                    r = r.getParent();
                }
                if (r == null) continue;
                return true;
            }
        } else {
            IMDResource[] children = folder.listChildren();
            if (!this.onlySrc) {
                return true;
            }
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].toFile().exists()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IMDFile) {
            return new Object[]{inputElement};
        }
        if (inputElement instanceof IMDObject[]) {
            IMDObject[] objs = MDResourceUtil.getTopResources((IMDObject[])inputElement);
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < objs.length; ++i) {
                list.addAll(Arrays.asList(this.getElements(objs[i])));
            }
            return list.toArray(new Object[list.size()]);
        }
        return this.getChildren(inputElement);
    }

    @Override
    public void dispose() {
        if (this.files != null) {
            for (int i = 0; i < this.files.length; ++i) {
                this.files[i] = null;
            }
        }
        this.files = null;
        this.properties.clear();
        this.properties = null;
        super.dispose();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IMDProject) {
            return this.getProjectChildren((IMDProject)parentElement);
        }
        if (parentElement instanceof IMDFolder) {
            return this.getFolderChildren((IMDFolder)parentElement);
        }
        if (parentElement instanceof IMDFile[]) {
            return this.getArrayChildren((IMDFile[])parentElement);
        }
        return new Object[0];
    }

    public boolean isUseAlias() {
        return this.useAlias;
    }

    public void setUseAlias(boolean useAlias) {
        this.useAlias = useAlias;
    }

    public IMDFile[] searchFile(String reg) {
        if (StringUtils.isEmpty((String)reg)) {
            return this.files;
        }
        reg = reg.toLowerCase();
        if (this.files.length == 0) {
            return this.files;
        }
        ArrayList<IMDFile> list = new ArrayList<IMDFile>();
        for (int i = 0; i < this.files.length; ++i) {
            String alias;
            boolean suit = false;
            if (this.files[i].getName().toLowerCase().indexOf(reg) != -1) {
                suit = true;
            } else if (this.useAlias && (alias = AliasUtil.getAlias(this.files[i])).toLowerCase().indexOf(reg) != -1) {
                suit = true;
            }
            if (!suit) continue;
            list.add(this.files[i]);
        }
        return list.toArray(new IMDFile[list.size()]);
    }

    public boolean isShowEmptyFolder() {
        return this.showEmptyFolder;
    }

    public void setShowEmptyFolder(boolean showEmptyFolder) {
        this.showEmptyFolder = showEmptyFolder;
    }
}

