/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.server.module;

import com.kingdee.bos.server.module.IModuleFilter;
import com.kingdee.bos.server.module.IModuleInstaller;
import com.kingdee.bos.server.module.ServerModuleConfig;
import com.kingdee.bos.tool.function.Func1V;
import com.kingdee.bos.tool.function.Func2V;
import com.kingdee.bos.tool.function.Lists;
import com.kingdee.bos.tool.function.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class ServerModuleHelper {
    public static ServerModuleConfig[] module_configs = null;

    public static ServerModuleConfig[] getModuleConfig() {
        if (module_configs == null) {
            ArrayList<ServerModuleConfig> list = new ArrayList<ServerModuleConfig>();
            IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("com.kingdee.bos.tool.toolcommon.servermodule");
            if (extPoint != null) {
                IExtension[] exts = extPoint.getExtensions();
                for (int i = 0; i < exts.length; ++i) {
                    IConfigurationElement[] configs;
                    for (IConfigurationElement servermodule_ele : configs = exts[i].getConfigurationElements()) {
                        list.add(ServerModuleHelper.createServerModuleConfig(servermodule_ele));
                    }
                }
            }
            module_configs = ServerModuleHelper.sortByGroup(list.toArray(new ServerModuleConfig[0]));
        }
        return module_configs;
    }

    public static ServerModuleConfig[] sortByGroup(ServerModuleConfig[] configs) {
        if (configs == null) {
            return new ServerModuleConfig[0];
        }
        final TreeMap map = new TreeMap();
        Lists.foreach(configs, new Func1V<ServerModuleConfig>(){

            @Override
            public void invoke(ServerModuleConfig config) {
                ArrayList<ServerModuleConfig> list = (ArrayList<ServerModuleConfig>)map.get(config.getModuleGroup());
                if (list == null) {
                    list = new ArrayList<ServerModuleConfig>();
                    map.put(config.getModuleGroup(), list);
                }
                list.add(config);
            }
        });
        final ArrayList result = new ArrayList();
        if (map.containsKey("core")) {
            result.addAll((Collection)map.remove("core"));
        }
        List defaultGroup = (List)map.remove("default");
        Maps.foreach(map, new Func2V<String, List<ServerModuleConfig>>(){

            @Override
            public void invoke(String key, List<ServerModuleConfig> value) {
                result.addAll(value);
            }
        });
        if (defaultGroup != null) {
            result.addAll(defaultGroup);
        }
        return result.toArray(new ServerModuleConfig[0]);
    }

    public static ServerModuleConfig createServerModuleConfig(IConfigurationElement servermodule_ele) {
        IConfigurationElement[] installer_ele;
        ServerModuleConfig config = new ServerModuleConfig();
        config.put("id", servermodule_ele.getAttribute("id"));
        config.put("name", servermodule_ele.getAttribute("name"));
        config.put("desc", servermodule_ele.getAttribute("desc"));
        config.put("filter_rule", servermodule_ele.getAttribute("filter_rule"));
        config.put("group", servermodule_ele.getAttribute("group"));
        IConfigurationElement[] remote_path_entries = servermodule_ele.getChildren("remote_path_entries");
        if (remote_path_entries != null && remote_path_entries.length > 0) {
            IConfigurationElement[] path_eles = remote_path_entries[0].getChildren();
            String[] paths = new String[path_eles.length];
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = path_eles[i].getAttribute("path");
            }
            config.put("remote_path_entries", paths);
        }
        if ((installer_ele = servermodule_ele.getChildren("installer")).length == 1) {
            try {
                config.put("installer", (IModuleInstaller)WorkbenchPlugin.createExtension((IConfigurationElement)installer_ele[0], (String)"class"));
            }
            catch (CoreException e) {
                throw new RuntimeException("\u521b\u5efacom.kingdee.bos.server.module.IModuleInstaller\u5bf9\u8c61\u5931\u8d25 ", e);
            }
        } else {
            throw new RuntimeException(config.get("name") + "\u6a21\u5757\u6ca1\u6709\u5b9a\u4e49com.kingdee.bos.server.module.IModuleInstaller\u63a5\u53e3");
        }
        IConfigurationElement[] filter_ele = servermodule_ele.getChildren("filters");
        if (filter_ele.length > 0) {
            IConfigurationElement[] module_filters = filter_ele[0].getChildren();
            ArrayList<IModuleFilter> list = new ArrayList<IModuleFilter>();
            for (IConfigurationElement module_filter_ele : module_filters) {
                try {
                    list.add((IModuleFilter)WorkbenchPlugin.createExtension((IConfigurationElement)module_filter_ele, (String)"class"));
                }
                catch (CoreException e) {
                    throw new RuntimeException("\u521b\u5efacom.kingdee.bos.server.module.IModuleFilter\u5bf9\u8c61\u5931\u8d25 ", e);
                }
            }
            config.put("filters", list.toArray(new IModuleFilter[0]));
        }
        return config;
    }
}

