/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.server.module;

import com.kingdee.bos.server.module.IModuleInstaller;
import com.kingdee.bos.server.module.InstallerContext;
import com.kingdee.bos.server.module.ServerModuleConfig;
import com.kingdee.bos.server.module.ServerModuleHelper;
import com.kingdee.bos.server.module.UpdateTask;
import com.kingdee.bos.tool.function.Func;
import com.kingdee.bos.tool.function.Func1;
import com.kingdee.bos.tool.function.Func1V;
import com.kingdee.bos.tool.function.FuncV;
import com.kingdee.bos.tool.function.Functions;
import com.kingdee.bos.tool.function.Lists;
import com.kingdee.bos.tool.function.Predicate;
import com.kingdee.bos.tool.function.Strings;
import com.kingdee.bos.tool.function.event.EventDispatcher;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class UpdateManager {
    public static final String REQUIRE_CANCEL_TASK = "require_cancel_task";
    public static final String UPDATE_TASK_EVENT_PREFIX = "update_task_event_prefix:";
    public static final String INSTALL_MODULE = "install_module";
    public static final String FINISH_MODULE = "finish_module";
    public static final String CANCEL_MODULE = "cancel_module";
    public static final String INSTALL_MODULE_ERROR = "install_module_error";
    public static final String REMOVE_TASK = "remove_task";
    public static final String ADD_TASK = "add_task";
    public static final String FINISH_TASK = "finish_task";
    public static final String START_TASK = "start_task";
    private static final Logger log = Logger.getLogger(UpdateManager.class);
    private static List<UpdateTask> tasks = new ArrayList<UpdateTask>();

    public static UpdateTask[] getAllUpdateTask() {
        return tasks.toArray(new UpdateTask[0]);
    }

    public static synchronized void StartTask(UpdateTask task) {
        if (UpdateManager.hasRunTask()) {
            return;
        }
        if (task != null && !task.isRun()) {
            UpdateManager.wrapRunUpdateTask(task);
        }
    }

    public static void wrapRunUpdateTask(final UpdateTask task) {
        Functions.invokeWithTryCatchfinally(new Func<Void>(){

            @Override
            public Void invoke() {
                task.getInstallerContext().setCancel(false);
                task.setTaskState(UpdateTask.State.RUN);
                UpdateManager.fireEvent(UpdateManager.START_TASK, task.getTaskName());
                Lists.foreach(task.getSelectServerModuleNames(), new Func1V<String>(){

                    @Override
                    public void invoke(final String moduleName) {
                        if (task.getInstallerContext().isCancel()) {
                            task.setTaskState(UpdateTask.State.STOP);
                            UpdateManager.fireEvent("cancel install module:", moduleName);
                            return;
                        }
                        boolean success = UpdateManager.install(Lists.findFirst(ServerModuleHelper.getModuleConfig(), new Predicate<ServerModuleConfig>(){

                            @Override
                            public boolean apply(ServerModuleConfig input) {
                                return input.getModuleName().equals(moduleName);
                            }
                        }), task.getInstallerContext());
                        if (!success && task.getInstallerContext().isCancel()) {
                            task.setTaskState(UpdateTask.State.STOP);
                        }
                    }
                });
                if (task.getTaskState() != UpdateTask.State.STOP) {
                    task.setTaskState(UpdateTask.State.FINISH);
                    UpdateManager.fireEvent(UpdateManager.FINISH_TASK, task.getTaskName());
                }
                return null;
            }
        }, null, new FuncV(){

            @Override
            public void invoke() {
            }
        });
    }

    public static boolean hasRunTask() {
        return Lists.findFirst(tasks, new Predicate<UpdateTask>(){

            @Override
            public boolean apply(UpdateTask input) {
                return input.isRun();
            }
        }) != null;
    }

    public static boolean install(final ServerModuleConfig config, final InstallerContext context) {
        return Functions.invokeWithNoNull(config, new Func<Boolean>(){

            @Override
            public Boolean invoke() {
                try {
                    IModuleInstaller installer = config.getInstaller();
                    log.info((Object)("\u6a21\u5757\u5b89\u88c5[" + config.getModuleName() + "]"));
                    UpdateManager.fireEvent(UpdateManager.INSTALL_MODULE, config.getModuleName());
                    boolean sucess = false;
                    sucess = context.getUpdateTask().getTaskType().equals((Object)UpdateTask.Type.IMPORT) ? installer.install(config, context) : installer.update(config, context);
                    if (sucess) {
                        UpdateManager.fireEvent(UpdateManager.FINISH_MODULE, config.getModuleName());
                    } else {
                        UpdateManager.fireEvent(UpdateManager.CANCEL_MODULE, config.getModuleName());
                    }
                    return sucess;
                }
                catch (Exception e) {
                    log.error((Object)("\u6a21\u5757\u5b89\u88c5\u5931\u8d25[" + config.getModuleName() + "]" + e.getMessage()), (Throwable)e);
                    context.getUpdateTask().setTaskState(UpdateTask.State.ERROR);
                    UpdateManager.fireEvent(UpdateManager.INSTALL_MODULE_ERROR, Strings.format("%s[%s] ", config.getModuleName(), e.getMessage()));
                    try {
                        Throwable tempE = new Exception(e);
                        while (tempE.getCause() != null) {
                            tempE = tempE.getCause();
                        }
                        if (tempE instanceof FileNotFoundException) {
                            UpdateManager.fireEvent(UpdateManager.INSTALL_MODULE_ERROR, "\u6307\u5b9a\u4e0b\u8f7d\u76ee\u5f55\u4e0d\u5b58\u5728\uff1a" + tempE.getMessage());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return false;
                }
            }
        });
    }

    public static void stopTask(UpdateTask task) {
        if (task != null && !task.getTaskState().equals((Object)UpdateTask.State.FINISH)) {
            task.getInstallerContext().setCancel(true);
            UpdateManager.fireEvent(REQUIRE_CANCEL_TASK, task.getTaskName());
        }
    }

    public static boolean isRun(String taskName) {
        return false;
    }

    public static void fireEvent(String taskType, String taskName) {
        EventDispatcher.fireEvent(UPDATE_TASK_EVENT_PREFIX + taskType, taskType + ":" + taskName, null);
    }

    public static boolean removeUpdateTask(final String taskName) {
        if (tasks.remove(Lists.findFirst(tasks, new Predicate<UpdateTask>(){

            @Override
            public boolean apply(UpdateTask task) {
                return !task.isRun() && task.getTaskName().equals(taskName);
            }
        }))) {
            UpdateManager.fireEvent(REMOVE_TASK, taskName);
            return true;
        }
        return false;
    }

    public static boolean removeAllFinishTask() {
        Iterator<UpdateTask> it = tasks.iterator();
        while (it.hasNext()) {
            if (!it.next().isFinish()) continue;
            it.remove();
        }
        return true;
    }

    public static UpdateTask addUpdataTask(final UpdateTask task) {
        return Functions.invokeAsParam(Lists.findFirst(tasks, new Predicate<UpdateTask>(){

            @Override
            public boolean apply(UpdateTask input) {
                return input.getTaskName().equals(task.getTaskName()) && !input.isFinish();
            }
        }), new Func1<UpdateTask, UpdateTask>(){

            @Override
            public UpdateTask invoke(UpdateTask findTask) {
                if (findTask != null) {
                    return null;
                }
                tasks.add(task);
                UpdateManager.fireEvent(UpdateManager.ADD_TASK, task.getTaskName());
                return task;
            }
        });
    }
}

