/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool;

import com.kingdee.bos.tool.LogTool;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class FileUtils {
    private static final FileUtils PRIMARY_INSTANCE = new FileUtils();
    private static SecureRandom rand = new SecureRandom();
    private static final int BUF_SIZE = 8192;
    private static boolean[] isSpecial = new boolean[256];
    private static char[] escapedChar1 = new char[256];
    private static char[] escapedChar2 = new char[256];
    public static final long FAT_FILE_TIMESTAMP_GRANULARITY = 2000L;
    public static final long UNIX_FILE_TIMESTAMP_GRANULARITY = 1000L;

    public static FileUtils newFileUtils() {
        return new FileUtils();
    }

    public static FileUtils getFileUtils() {
        return PRIMARY_INSTANCE;
    }

    protected FileUtils() {
    }

    public void copyFile(String sourceFile, String destFile, boolean overwrite) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), overwrite, false);
    }

    public void copyFileByPath(File srcPath, File dstPath) throws IOException {
        if (srcPath == null || dstPath == null) {
            return;
        }
        ArrayList files = new ArrayList();
        this.getChildFiles(srcPath, files);
        for (int i = 0; i < files.size(); ++i) {
            File srcFile = (File)files.get(i);
            String dstFileName = StringUtils.replace((String)srcFile.getPath(), (String)srcPath.getPath(), (String)dstPath.getPath());
            File dstFile = new File(dstFileName);
            this.copyFile(srcFile, dstFile, true, true);
        }
    }

    public void copyFile(File sourceFile, File destFile) throws IOException {
        this.copyFile(sourceFile, destFile, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(File sourceFile, File destFile, boolean overwrite, boolean preserveLastModified) throws IOException {
        if (destFile.exists() && !overwrite) {
            return;
        }
        if (overwrite || !destFile.exists() || destFile.lastModified() < sourceFile.lastModified()) {
            File parent;
            if (destFile.exists() && destFile.isFile()) {
                destFile.delete();
            }
            if ((parent = destFile.getParentFile()) != null && !parent.exists()) {
                parent.mkdirs();
            }
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(sourceFile);
                out = new FileOutputStream(destFile);
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    out.write(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
            }
            catch (Throwable throwable) {
                FileUtils.close(out);
                FileUtils.close(in);
                throw throwable;
            }
            FileUtils.close(out);
            FileUtils.close(in);
        }
        if (preserveLastModified) {
            this.setFileLastModified(destFile, sourceFile.lastModified());
        }
    }

    public void setFileLastModified(File file, long time) {
        file.setLastModified(time < 0L ? System.currentTimeMillis() : time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createTempFile(String prefix, String suffix, File parentDir) {
        File result = null;
        String parent = parentDir == null ? System.getProperty("java.io.tmpdir") : parentDir.getPath();
        DecimalFormat fmt = new DecimalFormat("#####");
        rand.setSeed(System.currentTimeMillis() + Runtime.getRuntime().freeMemory());
        SecureRandom secureRandom = rand;
        synchronized (secureRandom) {
            int randNumber;
            do {
                int n = randNumber = (randNumber = rand.nextInt()) == Integer.MIN_VALUE ? randNumber + 1 : randNumber;
            } while ((result = new File(parent, prefix + fmt.format(Math.abs(randNumber)) + suffix)).exists());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean binaryEquals(File f1, File f2) throws IOException {
        boolean bl;
        FileInputStream fi2;
        FileInputStream fi1;
        BufferedInputStream in2;
        BufferedInputStream in1;
        block7: {
            block8: {
                boolean bl2;
                if (f1.length() != f2.length()) {
                    return false;
                }
                in1 = null;
                in2 = null;
                fi1 = null;
                fi2 = null;
                try {
                    fi1 = new FileInputStream(f1);
                    fi2 = new FileInputStream(f2);
                    in1 = new BufferedInputStream(fi1);
                    in2 = new BufferedInputStream(fi2);
                    int expectedByte = ((InputStream)in1).read();
                    while (expectedByte != -1) {
                        if (expectedByte != ((InputStream)in2).read()) {
                            bl = false;
                            break block7;
                        }
                        expectedByte = ((InputStream)in1).read();
                    }
                    if (((InputStream)in2).read() == -1) break block8;
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    FileUtils.close(in1);
                    FileUtils.close(in2);
                    FileUtils.close(fi1);
                    FileUtils.close(fi2);
                    throw throwable;
                }
                FileUtils.close(in1);
                FileUtils.close(in2);
                FileUtils.close(fi1);
                FileUtils.close(fi2);
                return bl2;
            }
            boolean bl3 = true;
            FileUtils.close(in1);
            FileUtils.close(in2);
            FileUtils.close(fi1);
            FileUtils.close(fi2);
            return bl3;
        }
        FileUtils.close(in1);
        FileUtils.close(in2);
        FileUtils.close(fi1);
        FileUtils.close(fi2);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean textEquals(File f1, File f2) throws IOException {
        boolean bl;
        FileReader fileReader2;
        FileReader fileReader;
        BufferedReader in2;
        BufferedReader in1;
        block6: {
            block7: {
                boolean bl2;
                in1 = null;
                in2 = null;
                fileReader = null;
                fileReader2 = null;
                try {
                    fileReader = new FileReader(f1);
                    fileReader2 = new FileReader(f2);
                    in1 = new BufferedReader(fileReader);
                    in2 = new BufferedReader(fileReader2);
                    String expected = in1.readLine();
                    while (expected != null) {
                        if (!expected.equals(in2.readLine())) {
                            bl = false;
                            break block6;
                        }
                        expected = in1.readLine();
                    }
                    if (in2.readLine() == null) break block7;
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    FileUtils.close(in1);
                    FileUtils.close(in2);
                    FileUtils.close(fileReader);
                    FileUtils.close(fileReader2);
                    throw throwable;
                }
                FileUtils.close(in1);
                FileUtils.close(in2);
                FileUtils.close(fileReader);
                FileUtils.close(fileReader2);
                return bl2;
            }
            boolean bl3 = true;
            FileUtils.close(in1);
            FileUtils.close(in2);
            FileUtils.close(fileReader);
            FileUtils.close(fileReader2);
            return bl3;
        }
        FileUtils.close(in1);
        FileUtils.close(in2);
        FileUtils.close(fileReader);
        FileUtils.close(fileReader2);
        return bl;
    }

    public File getParentFile(File f) {
        return f == null ? null : f.getParentFile();
    }

    public static final String readFully(Reader rdr) throws IOException {
        return FileUtils.readFully(rdr, 8192);
    }

    public static final String readFully(Reader rdr, int bufferSize) throws IOException {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        char[] buffer = new char[bufferSize];
        int bufferLength = 0;
        StringBuffer textBuffer = null;
        while (bufferLength != -1) {
            bufferLength = rdr.read(buffer);
            if (bufferLength <= 0) continue;
            textBuffer = textBuffer == null ? new StringBuffer() : textBuffer;
            textBuffer.append(new String(buffer, 0, bufferLength));
        }
        return textBuffer == null ? null : textBuffer.toString();
    }

    public boolean createNewFile(File f) throws IOException {
        return f.createNewFile();
    }

    public boolean createNewFile(File f, boolean mkdirs) throws IOException {
        File parent = f.getParentFile();
        if (mkdirs && !parent.exists()) {
            parent.mkdirs();
        }
        return f.createNewFile();
    }

    public boolean isSymbolicLink(File parent, String name) throws IOException {
        File toTest;
        if (parent == null) {
            File f = new File(name);
            parent = f.getParentFile();
            name = f.getName();
        }
        return !(toTest = new File(parent.getCanonicalPath(), name)).getAbsolutePath().equals(toTest.getCanonicalPath());
    }

    public void rename(File from, File to) throws IOException {
        if (to.exists() && !to.delete()) {
            throw new IOException("Failed to delete " + to + " while trying to rename " + from);
        }
        File parent = to.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to create directory " + parent + " while trying to rename " + from);
        }
        if (!from.renameTo(to)) {
            this.copyFile(from, to);
            if (!from.delete()) {
                throw new IOException("Failed to delete " + from + " while trying to rename it.");
            }
        }
    }

    public boolean isUpToDate(File source, File dest, long granularity) {
        if (!dest.exists()) {
            return false;
        }
        long sourceTime = source.lastModified();
        long destTime = dest.lastModified();
        return this.isUpToDate(sourceTime, destTime, granularity);
    }

    public boolean isUpToDate(long sourceTime, long destTime, long granularity) {
        if (destTime == -1L) {
            return false;
        }
        return destTime >= sourceTime + granularity;
    }

    public static void close(Writer device) {
        if (device != null) {
            try {
                device.close();
            }
            catch (IOException ioex) {
                LogTool.logError("", ioex);
            }
        }
    }

    public static void close(Reader device) {
        if (device != null) {
            try {
                device.close();
            }
            catch (IOException ioex) {
                LogTool.logError("", ioex);
            }
        }
    }

    public static void close(OutputStream device) {
        if (device != null) {
            try {
                device.close();
            }
            catch (IOException ioex) {
                LogTool.logError("", ioex);
            }
        }
    }

    public static void close(InputStream device) {
        if (device != null) {
            try {
                device.close();
            }
            catch (IOException ioex) {
                LogTool.logError("", ioex);
            }
        }
    }

    public void getChildFiles(File path, List files) {
        File[] filelist = path.listFiles();
        if (filelist == null) {
            return;
        }
        for (int i = 0; i < filelist.length; ++i) {
            if (filelist[i].isFile()) {
                files.add(filelist[i]);
                continue;
            }
            this.getChildFiles(filelist[i], files);
        }
    }

    public List getChildFiles(String path, String ext) {
        ArrayList<File> files = new ArrayList<File>();
        File[] filelist = new File(path).listFiles();
        if (filelist == null) {
            return files;
        }
        for (int i = 0; i < filelist.length; ++i) {
            if (!filelist[i].isFile() || !filelist[i].getName().trim().toUpperCase(Locale.ENGLISH).endsWith(ext.trim().toUpperCase(Locale.ENGLISH))) continue;
            files.add(filelist[i]);
        }
        return files;
    }

    public static void deleteFile(String filepath) throws IOException {
        File f = new File(filepath);
        if (f.exists()) {
            if (!f.isDirectory()) {
                f.delete();
            } else {
                if (f.listFiles().length > 0) {
                    File[] delFile = f.listFiles();
                    int i = f.listFiles().length;
                    for (int j = 0; j < i; ++j) {
                        FileUtils.deleteFile(delFile[j].getAbsolutePath());
                    }
                }
                f.delete();
            }
        }
    }

    public static void delete(File file) {
        if (file != null) {
            file.delete();
        }
    }

    static {
        for (int i = 0; i <= 32; ++i) {
            FileUtils.isSpecial[i] = true;
            FileUtils.escapedChar1[i] = Character.forDigit(i >> 4, 16);
            FileUtils.escapedChar2[i] = Character.forDigit(i & 0xF, 16);
        }
        FileUtils.isSpecial[127] = true;
        FileUtils.escapedChar1[127] = 55;
        FileUtils.escapedChar2[127] = 70;
        for (char ch : new char[]{'<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'}) {
            FileUtils.isSpecial[ch] = true;
            FileUtils.escapedChar1[ch] = Character.forDigit(ch >> 4, 16);
            FileUtils.escapedChar2[ch] = Character.forDigit(ch & 0xF, 16);
        }
    }
}

