/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool;

import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.utils.MD5;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.jdom2.Document;
import org.jdom2.Element;

public class PFileUtils {
    private static final String[] SUB_DIR = new String[]{"bim", "sp", "patch/mri", "patch_industry", "industry", "patch", "common/bos", "common/trd", "common/eas", "common/mri", "client/bos", "client/trd", "client/eas", "client/mri", "merged", "../web/webRoot/WEB-INF/lib"};
    private static final String EAS_RESOURCE_PREFIX = "eas_resource_";
    private static final String BOS_RESOURCE_PREFIX = "bos_resource_";
    private static FileComparator fileComparator = new FileComparator();
    private static final FilenameFilter SUB_SYSTEM_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return (name = name.toLowerCase(Locale.ENGLISH)).startsWith("subsystem_") && name.endsWith(".xml") && !name.equals("subsystem_industry.xml");
        }
    };
    public static final String[] METADATA_LOAD_PATH = new String[]{"sp", "patch_industry", "industry", "patch", "bos", "eas", "mri"};
    private static Map issMap = new HashMap(4);
    public static final String MERGE_PROPERTY_NAME = "merged.properties";
    private static final String MERGE_JAR_PERFIX = "merged_";
    private static final String ROOT_DIR = "orgRoot.key";

    public static File[] listLibFils(File libRoot) {
        ArrayList<File> oList = new ArrayList<File>();
        if (new File(libRoot, "industry_sp.jar").exists()) {
            oList.add(new File(libRoot, "industry_sp.jar"));
        }
        for (int i = 0; i < SUB_DIR.length; ++i) {
            File file = new File(libRoot, SUB_DIR[i]);
            if (!file.exists()) continue;
            PFileUtils.listLibFilesInDir(file, oList);
        }
        PFileUtils.listLibFiles(libRoot, oList);
        return oList.toArray(new File[oList.size()]);
    }

    private static boolean isLibJar(File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return false;
        }
        String name = file.getName();
        return !name.startsWith(EAS_RESOURCE_PREFIX) && !name.startsWith(BOS_RESOURCE_PREFIX);
    }

    public static IClasspathEntry[] cumputClasspath(File libRoot) {
        if (!libRoot.exists()) {
            return null;
        }
        File[] files = PFileUtils.listLibFils(libRoot);
        ArrayList<IClasspathEntry> classpaths = new ArrayList<IClasspathEntry>();
        for (int i = 0; i < files.length; ++i) {
            if (!PFileUtils.isLibJar(files[i])) continue;
            String name = files[i].getName();
            String path = files[i].getAbsolutePath();
            File dir = files[i].getParentFile();
            String srcPathString = "";
            Path srcPath = null;
            if (name.startsWith(MERGE_JAR_PERFIX)) {
                srcPathString = "src" + File.separator + MERGE_JAR_PERFIX + "0.jar";
            } else if (dir.getName().endsWith("eas")) {
                srcPathString = "src" + File.separator + "com-src.jar";
            } else if (name.startsWith("Ctrl-")) {
                srcPathString = "src" + File.separator + "ctrl-src.jar";
            } else if (name.lastIndexOf(46) > 0) {
                srcPathString = "src" + File.separator + name.substring(0, name.lastIndexOf(46));
                srcPathString = srcPathString + "-src.jar";
            }
            File srcFile = new File(libRoot, srcPathString);
            if (srcFile != null && srcFile.exists()) {
                srcPath = new Path(srcFile.getAbsolutePath());
            } else {
                int lpos = name.lastIndexOf("-client.jar");
                if (lpos == -1) {
                    lpos = name.lastIndexOf("-server.jar");
                }
                if (lpos != -1) {
                    String fileName = name.substring(0, lpos);
                    srcPathString = "src/" + fileName + "-src.jar";
                    srcFile = new File(libRoot, srcPathString);
                    if (srcFile.exists()) {
                        srcPath = new Path(srcFile.getAbsolutePath());
                    }
                }
            }
            IClasspathEntry newEntry = JavaCore.newLibraryEntry((IPath)new Path(path), (IPath)srcPath, null);
            classpaths.add(newEntry);
        }
        return classpaths.toArray(new IClasspathEntry[classpaths.size()]);
    }

    public static String getMD5(File file) throws IOException {
        return MD5.asHex(MD5.getHash(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) throws FileNotFoundException, IOException {
        block7: {
            block6: {
                if (!src.exists()) {
                    return;
                }
                if (!src.isFile()) break block6;
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(src);
                    PFileUtils.write2File(fileInputStream, dest);
                }
                catch (Throwable throwable) {
                    FileUtils.close(fileInputStream);
                    throw throwable;
                }
                FileUtils.close(fileInputStream);
                break block7;
            }
            if (!src.isDirectory()) break block7;
            File[] files = PFileUtils.listFile(src, true, true, false);
            int len = src.getAbsolutePath().length();
            for (int i = 0; i < files.length; ++i) {
                File s = files[i];
                File d = new File(dest, s.getAbsolutePath().substring(len));
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(s);
                    PFileUtils.write2File(fileInputStream, d);
                }
                catch (Throwable throwable) {
                    FileUtils.close(fileInputStream);
                    throw throwable;
                }
                FileUtils.close(fileInputStream);
            }
        }
    }

    private static void listLibFilesInDir(File libRoot, List list) {
        if (libRoot.isDirectory()) {
            File[] files = libRoot.listFiles();
            Arrays.sort(files, fileComparator);
            ArrayList<File> mergedList = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                String name;
                if (!files[i].isFile() || !(name = files[i].getName()).endsWith(".jar") && !name.endsWith(".zip")) continue;
                if (name.startsWith(MERGE_JAR_PERFIX)) {
                    mergedList.add(files[i]);
                    continue;
                }
                list.add(files[i]);
            }
            list.addAll(mergedList);
        }
    }

    private static void listLibFiles(File file, List list) {
        String name;
        if (file.isDirectory()) {
            if (!"src".equals(file.getName())) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    PFileUtils.listLibFiles(files[i], list);
                }
            }
        } else if (!list.contains(file) && ((name = file.getName()).endsWith(".jar") || name.endsWith(".zip"))) {
            list.add(file);
        }
    }

    public static File[] listSubSystemFile(File rootDir) {
        File[] files = rootDir.listFiles(SUB_SYSTEM_FILTER);
        if (files == null) {
            return new File[0];
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().indexOf("bos") == -1) continue;
            File t = files[0];
            files[0] = files[i];
            files[i] = t;
            break;
        }
        return files;
    }

    public static File[] filterFileName(File[] files, String[] reg) {
        if (files == null || files.length == 0) {
            return new File[0];
        }
        String[] fileNames = new String[files.length];
        for (int i = 0; i < fileNames.length; ++i) {
            fileNames[i] = files[i].getName();
        }
        List result = PFileUtils.innerFilter(files, fileNames, reg);
        return result.toArray(new File[0]);
    }

    public static String[] filterFileName(String[] files, String[] reg) {
        List result = PFileUtils.innerFilter(files, PFileUtils.getFileName(files), reg);
        return result.toArray(new String[0]);
    }

    private static List innerFilter(Object[] orgObject, String[] fileNames, String[] reg) {
        int i;
        ArrayList<Object> list = new ArrayList<Object>();
        if (fileNames == null || fileNames.length == 0) {
            return list;
        }
        assert (orgObject.length == fileNames.length);
        if (reg == null || reg.length == 0) {
            int[] result = new int[fileNames.length];
            for (int i2 = 0; i2 < result.length; ++i2) {
                result[i2] = i2;
            }
            return Arrays.asList(orgObject);
        }
        Pattern[] patterns = new Pattern[reg.length];
        for (i = 0; i < reg.length; ++i) {
            patterns[i] = Pattern.compile(reg[i]);
        }
        for (i = 0; i < fileNames.length; ++i) {
            String name = fileNames[i];
            boolean matches = false;
            for (int j = 0; j < patterns.length; ++j) {
                Pattern pattern = patterns[j];
                Matcher matcher = pattern.matcher(name);
                if (!matcher.matches()) continue;
                matches = true;
                break;
            }
            if (!matches) continue;
            list.add(orgObject[i]);
        }
        return list;
    }

    private static String[] getFileName(String[] files) {
        if (files == null || files.length == 0) {
            return files;
        }
        String[] result = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            int index = files[i].lastIndexOf("/");
            if (index == -1) {
                index = files[i].lastIndexOf(File.separatorChar);
            }
            result[i] = index == -1 ? files[i] : files[i].substring(index + 1);
        }
        return result;
    }

    public static String ensurePath(String projectDir, String dir) {
        File file;
        Path path = new Path(dir);
        if (!path.isAbsolute()) {
            dir = projectDir + File.separator + dir;
        }
        if (!(file = new File(dir)).exists()) {
            file.mkdirs();
        }
        return dir;
    }

    public static void deleteFile(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                PFileUtils.deleteFile(files[i]);
            }
        }
        file.delete();
    }

    public static String getMetadataPath(String path) {
        File root = new File(path);
        ArrayList<Object> list = new ArrayList<Object>();
        if (root.isDirectory()) {
            File[] files = root.listFiles();
            HashMap<String, File> dirMap = new HashMap<String, File>();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                dirMap.put(files[i].getName(), files[i]);
            }
            for (String metaPath : METADATA_LOAD_PATH) {
                PFileUtils.parserDir(dirMap, list, metaPath);
            }
            dirMap.remove("configure");
            for (File dir : dirMap.values()) {
                PFileUtils.parseMDPath(dir, list);
            }
            list.add(root.getAbsolutePath() + File.separator + "*.jar");
        } else if (root.getName().endsWith(".jar")) {
            list.add(root);
        }
        StringBuffer result = new StringBuffer();
        if (new File(root, "sp-industry-metas.jar").exists()) {
            result.append(new File(root, "sp-industry-metas.jar").getAbsolutePath());
        }
        for (int i = 0; i < list.size(); ++i) {
            if (result.length() > 0) {
                result.append(";");
            }
            result.append((String)list.get(i));
        }
        return result.toString();
    }

    private static void parserDir(Map dirMap, List list, String name) {
        File dir = (File)dirMap.remove(name);
        if (dir != null) {
            PFileUtils.parseMDPath(dir, list);
        }
    }

    private static void parseMDPath(File path, List list) {
        if (path.isDirectory()) {
            list.add(path.getAbsolutePath() + File.separator + "*.jar");
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                PFileUtils.parseMDPath(files[i], list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPackageExsitInIndustrySubSystem(File rootDir, String pkgName) {
        boolean exist = false;
        try {
            FileInputStream fileInputStream;
            block6: {
                boolean bl;
                HashSet<String> set = (HashSet<String>)issMap.get(rootDir.getCanonicalPath());
                if (set != null) {
                    return set.contains(pkgName);
                }
                File iss = new File(rootDir, "SubSystem_industry.xml");
                if (!iss.exists()) return exist;
                fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(iss);
                    Document industryDoc = XMLParser.parseXML((InputStream)fileInputStream);
                    Element root = industryDoc.getRootElement();
                    Element add = root.getChild("add");
                    if (add == null) break block6;
                    List rows = add.getChildren();
                    set = new HashSet<String>();
                    for (Element ele : rows) {
                        String fn = ele.getAttributeValue("fullname");
                        set.add(fn);
                    }
                    issMap.put(rootDir.getCanonicalPath(), set);
                    bl = set.contains(pkgName);
                }
                catch (Throwable throwable) {
                    FileUtils.close(fileInputStream);
                    throw throwable;
                }
                FileUtils.close(fileInputStream);
                return bl;
            }
            FileUtils.close(fileInputStream);
            return exist;
        }
        catch (Exception e) {
            LogTool.logError("", e);
        }
        return exist;
    }

    public static void emptyDir(File file) {
        if (file == null || !file.isDirectory()) {
            return;
        }
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            PFileUtils.deleteFile(files[i]);
        }
    }

    public static byte[] file2Bytes(File file) throws IOException {
        String content = PFileUtils.getFileContent(file);
        if (content == null) {
            return null;
        }
        return content.getBytes("UTF-8");
    }

    public static void write2File(byte[] contents, File file) throws IOException {
        if (contents == null || contents.length == 0) {
            return;
        }
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(contents);
            out.flush();
        }
        catch (Throwable throwable) {
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long write2File(InputStream input, File file) throws IOException {
        if (input == null) {
            return 0L;
        }
        byte[] bs = new byte[2048];
        long total = 0L;
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            int len = input.read(bs);
            while (len != -1) {
                total += (long)len;
                ((OutputStream)out).write(bs, 0, len);
                len = input.read(bs);
            }
            out.flush();
        }
        catch (Throwable throwable) {
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(out);
        input.close();
        return total;
    }

    public static long write2File(String string, File file) throws IOException {
        return PFileUtils.write2File(new ByteArrayInputStream(string.getBytes("UTF-8")), file);
    }

    public static boolean mergeLib(File libRoot, IProgressMonitor monitor) throws IOException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        File propertyFile = new File(libRoot, MERGE_PROPERTY_NAME);
        File[] files = null;
        if (!propertyFile.exists()) {
            monitor.beginTask("\u5408\u5e76LIB\u5305", 100);
            files = PFileUtils.mergeJars(libRoot, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        } else {
            monitor.beginTask("\u91cd\u65b0\u5408\u5e76LIB\u5305", 100);
            files = PFileUtils.remergeJars(propertyFile, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 50);
        subMonitor.beginTask("\u5907\u4efdJAR\u5305", files.length);
        int prefixLen = libRoot.getAbsolutePath().length();
        File bakRoot = new File(libRoot + "_bak");
        boolean flag = true;
        for (int i = 0; i < files.length; ++i) {
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            File from = files[i];
            File to = new File(bakRoot, from.getAbsolutePath().substring(prefixLen));
            monitor.setTaskName("\u5f00\u59cb\u5907\u4efd\uff1a" + from);
            if (!PFileUtils.rename(from, to, 10)) {
                flag = false;
            }
            monitor.worked(1);
        }
        monitor.done();
        return flag;
    }

    private static boolean rename(File from, File to, int maxTry) {
        for (int i = 0; i < maxTry; ++i) {
            if (!PFileUtils.rename(from, to)) continue;
            return true;
        }
        try {
            FileUtils.getFileUtils().rename(from, to);
            return true;
        }
        catch (Throwable t) {
            LogTool.logError("\u91cd\u547d\u540d\u51fa\u9519", t);
            LogTool.logWarn("\u65e0\u6cd5\u5907\u4efd\u6587\u4ef6\uff1a" + from + " \u5230" + to + ",\u6587\u4ef6\u53ef\u80fd\u5904\u4e8e\u6253\u5f00\u72b6\u6001\u6216\u88ab\u5176\u5b83\u8fdb\u7a0b\u5360\u7528\uff0c\u8bf7\u624b\u5de5\u5904\u7406\u8be5\u95ee\u9898", new Exception());
            return false;
        }
    }

    private static boolean rename(File from, File to) {
        try {
            FileUtils.getFileUtils().rename(from, to);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File[] remergeJars(File propertyFile, IProgressMonitor monitor) throws InterruptedException, IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        Properties prop = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(propertyFile);
            prop.load(fileInputStream);
        }
        catch (Throwable throwable) {
            FileUtils.close(fileInputStream);
            throw throwable;
        }
        FileUtils.close(fileInputStream);
        String rootName = prop.getProperty(ROOT_DIR);
        File root = new File(rootName);
        monitor.beginTask("\u91cd\u65b0\u5408\u5e76JAR", -1);
        HashMap<String, ArrayList<File>> allFiles = new HashMap<String, ArrayList<File>>();
        for (String string : prop.keySet()) {
            File file = new File(root, string);
            if (!file.exists()) continue;
            String jarName = prop.getProperty(string);
            ArrayList<File> list = (ArrayList<File>)allFiles.get(jarName);
            if (list == null) {
                list = new ArrayList<File>();
                allFiles.put(jarName, list);
            }
            list.add(file);
        }
        monitor.worked(1);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        monitor.setTaskName("\u5f00\u59cb\u5408\u5e76");
        ArrayList<File> list = new ArrayList<File>();
        Iterator iterator = allFiles.keySet().iterator();
        while (iterator.hasNext()) {
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            String jarName = (String)iterator.next();
            List fileList = (List)allFiles.get(jarName);
            File tempJar = new File(root, jarName + "_temp");
            FileOutputStream fileOutputStream = null;
            JarOutputStream jos = null;
            File oldJar = null;
            try {
                fileOutputStream = new FileOutputStream(tempJar);
                jos = new JarOutputStream((OutputStream)fileOutputStream, new Manifest());
                HashSet set = new HashSet();
                for (int i = 0; i < fileList.size(); ++i) {
                    if (monitor.isCanceled()) {
                        PFileUtils.deleteFile(tempJar);
                        throw new InterruptedException();
                    }
                    File jar = (File)fileList.get(i);
                    monitor.setTaskName("\u5904\u7406\u65b0\u5305\uff1a" + jar.getName() + "=>" + tempJar);
                    PFileUtils.writeJar2Stream(jos, jar, set);
                    monitor.worked(1);
                    list.add(jar);
                }
                oldJar = new File(root, jarName);
                monitor.setTaskName("\u5904\u7406\u65e7\u5305:" + oldJar);
                PFileUtils.writeJar2Stream(jos, oldJar, set);
                monitor.worked(1);
                jos.flush();
            }
            catch (Throwable throwable) {
                FileUtils.close(fileOutputStream);
                FileUtils.close(jos);
                throw throwable;
            }
            FileUtils.close(fileOutputStream);
            FileUtils.close(jos);
            monitor.setTaskName("\u6539\u540d...");
            if (oldJar != null) {
                oldJar.delete();
            }
            PFileUtils.rename(tempJar, oldJar, 10);
        }
        return list.toArray(new File[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long writeJar2Stream(JarOutputStream out, File jarFile, Set existsEntrySet) throws InterruptedException, ZipException, IOException {
        if (!jarFile.exists()) {
            return 0L;
        }
        long total = 0L;
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                if (entry.isDirectory() || entry.getName().startsWith("META-INF/") || existsEntrySet.contains(entry.getName())) continue;
                existsEntrySet.add(entry.getName());
                JarEntry jarEntry = new JarEntry(entry.getName());
                out.putNextEntry(jarEntry);
                InputStream in = zipFile.getInputStream(entry);
                byte[] bs = new byte[2048];
                int len = in.read(bs);
                while (len != -1) {
                    total += (long)len;
                    out.write(bs, 0, len);
                    len = in.read(bs);
                }
                in.close();
                out.closeEntry();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File[] mergeJars(File root, IProgressMonitor monitor) throws IOException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        Properties prop = new Properties();
        int prefixLen = root.getAbsolutePath().length();
        prop.put(ROOT_DIR, root.getAbsolutePath());
        File[] dirs = PFileUtils.listFile(root, true, false, true);
        monitor.beginTask("\u5f00\u59cb\u5408\u5e76\u6587\u4ef6...", dirs.length * 10);
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < dirs.length; ++i) {
            File[] jars;
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.setTaskName("\u5408\u5e76\u76ee\u5f55:" + dirs[i]);
            String path = dirs[i].getAbsolutePath().toLowerCase(Locale.ENGLISH);
            path = StringUtils.replace((String)path, (String)"\\", (String)"/");
            if (path.indexOf("/web/") != -1 || path.endsWith("/web") || (jars = PFileUtils.listJars4Merge(dirs[i])).length == 0) continue;
            HashSet set = new HashSet();
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 9);
            subMonitor.beginTask("\u5f00\u59cb\u5408\u5e76\u6587\u4ef6", jars.length);
            int count = 0;
            long total = 0L;
            long TOTAL = 0x6400000L;
            File mergeFile = new File(dirs[i], MERGE_JAR_PERFIX + count + ".jar");
            String mergeFileName = mergeFile.getAbsolutePath().substring(prefixLen);
            FileOutputStream fileOutputStream = null;
            JarOutputStream jos = null;
            try {
                fileOutputStream = new FileOutputStream(mergeFile);
                jos = new JarOutputStream((OutputStream)fileOutputStream, new Manifest());
                for (int j = 0; j < jars.length; ++j) {
                    if (subMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    File file = jars[j];
                    subMonitor.subTask("\u5408\u5e76\u6587\u4ef6:" + file.getName());
                    total += PFileUtils.writeJar2Stream(jos, file, set);
                    String jarName = file.getAbsolutePath().substring(prefixLen);
                    jarName = StringUtils.replace((String)jarName, (String)"\\", (String)"/");
                    prop.put(jarName, mergeFileName);
                    list.add(file);
                    subMonitor.worked(1);
                    if (total < 0x6400000L || dirs[i].getName().equals("src")) continue;
                    jos.flush();
                    jos.close();
                    mergeFile = new File(dirs[i], MERGE_JAR_PERFIX + ++count + ".jar");
                    mergeFileName = mergeFile.getAbsolutePath().substring(prefixLen);
                    jos = new JarOutputStream((OutputStream)new FileOutputStream(mergeFile), new Manifest());
                    total = 0L;
                }
                jos.flush();
            }
            catch (Throwable throwable) {
                FileUtils.close(jos);
                FileUtils.close(fileOutputStream);
                throw throwable;
            }
            FileUtils.close(jos);
            FileUtils.close(fileOutputStream);
            subMonitor.done();
            monitor.worked(1);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(new File(root, MERGE_PROPERTY_NAME));
            prop.store(fileOutputStream, "michael");
        }
        catch (Throwable throwable) {
            FileUtils.close(fileOutputStream);
            throw throwable;
        }
        FileUtils.close(fileOutputStream);
        monitor.done();
        return list.toArray(new File[list.size()]);
    }

    public static File[] listFile(File root, boolean recursion, boolean includeFile, boolean includeDir) {
        return PFileUtils.listFile(root, recursion, includeFile, includeDir, null);
    }

    public static File[] listFile(File root, boolean recursion, boolean includeFile, boolean includeDir, String[] excludeNames) {
        ArrayList list = new ArrayList();
        File[] children = root.listFiles();
        if (children == null) {
            return new File[0];
        }
        for (int i = 0; i < children.length; ++i) {
            PFileUtils.listFile(list, children[i], recursion, includeFile, includeDir, excludeNames);
        }
        return list.toArray(new File[list.size()]);
    }

    private static void listFile(List list, File root, boolean recursion, boolean includeFile, boolean includeDir, String[] excludeNames) {
        int i;
        if (!includeFile && !includeDir) {
            return;
        }
        if (excludeNames != null) {
            String name = root.getName();
            for (i = 0; i < excludeNames.length; ++i) {
                if (!name.equalsIgnoreCase(excludeNames[i])) continue;
                return;
            }
        }
        if (root.isFile()) {
            if (includeFile) {
                list.add(root);
            }
        } else {
            if (includeDir) {
                list.add(root);
            }
            if (!recursion) {
                return;
            }
            File[] children = root.listFiles();
            for (i = 0; i < children.length; ++i) {
                PFileUtils.listFile(list, children[i], recursion, includeFile, includeDir, excludeNames);
            }
        }
    }

    private static File[] listJars4Merge(File dir) {
        ArrayList<File> list = new ArrayList<File>();
        File[] fs = dir.listFiles();
        for (int i = 0; i < fs.length; ++i) {
            File file = fs[i];
            String name = file.getName().toLowerCase(Locale.ENGLISH);
            if (file.isDirectory() || !name.endsWith(".zip") && !name.endsWith(".jar") || name.startsWith(MERGE_JAR_PERFIX) || name.startsWith(EAS_RESOURCE_PREFIX) || name.startsWith(BOS_RESOURCE_PREFIX) || name.equals("xercesImpl.jar")) continue;
            list.add(file);
        }
        return list.toArray(new File[list.size()]);
    }

    public static String getContent(InputStream input) {
        byte[] contents = PFileUtils.getContents(input);
        if (contents == null) {
            return null;
        }
        try {
            return new String(contents, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LogTool.logError("\u5b57\u7b26\u4e32\u8f6c \u6362\u65f6\u51fa\u9519", e);
            return null;
        }
    }

    public static byte[] getContents(InputStream input) {
        if (input == null) {
            return null;
        }
        byte[] bs = new byte[1024];
        byte[] result = new byte[]{};
        try {
            int len = input.read(bs);
            while (len != -1) {
                byte[] temp = new byte[len + result.length];
                System.arraycopy(result, 0, temp, 0, result.length);
                System.arraycopy(bs, 0, temp, result.length, len);
                result = temp;
                len = input.read(bs);
            }
            input.close();
        }
        catch (Exception ex) {
            LogTool.logError("\u8bfb\u53d6\u6587\u4ef6\u65f6\u51fa\u9519", ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(File file) {
        String string;
        if (!file.isFile() || !file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            string = PFileUtils.getContent(fileInputStream);
        }
        catch (FileNotFoundException ex) {
            String string2;
            try {
                LogTool.logError("\u8bfb\u53d6\u6587\u4ef6\u65f6\u51fa\u9519", ex);
                string2 = null;
            }
            catch (Throwable throwable) {
                FileUtils.close(fileInputStream);
                throw throwable;
            }
            FileUtils.close(fileInputStream);
            return string2;
        }
        FileUtils.close(fileInputStream);
        return string;
    }

    private static class FileComparator
    implements Comparator {
        private FileComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof File && arg1 instanceof File) {
                return ((File)arg0).getAbsolutePath().compareTo(((File)arg1).getAbsolutePath());
            }
            return 0;
        }
    }
}

