/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool;

import com.kingdee.bos.cloud.CloudServerInfo;
import com.kingdee.bos.tool.FileMD5Cache;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.PFileUtils;
import com.kingdee.bos.tool.ToolSetting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class UpdateHelper {
    public static void update(final Shell shell, final IWorkbenchPage page, final boolean silence, final boolean showError) {
        try {
            String toolInstall = FileLocator.resolve((URL)Platform.getInstallLocation().getURL()).getFile();
            final File localRoot = new File(toolInstall).getParentFile().getParentFile().getParentFile();
            Job job = new Job("\u68c0\u67e5\u66f4\u65b0"){

                protected IStatus run(IProgressMonitor monitor) {
                    String[] filePaths;
                    CloudServerInfo info = CloudServerInfo.getInstance();
                    String url = null;
                    try {
                        url = info.getToolUpdateUrl();
                        filePaths = UpdateHelper.getUpdatedFiles(url, localRoot);
                    }
                    catch (Exception e) {
                        LogTool.logError("\u66f4\u65b0\u51fa\u9519", e);
                        if (!showError) {
                            return Status.CANCEL_STATUS;
                        }
                        return new Status(4, "BIM", "\u68c0\u67e5\u5de5\u5177\u66f4\u65b0\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u53ef\u80fd\u662f\u670d\u52a1\u5668\u6ca1\u6709\u542f\u52a8", (Throwable)e);
                    }
                    if (filePaths.length > 0) {
                        if (!silence) {
                            final boolean[] flag = new boolean[]{false};
                            shell.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    flag[0] = MessageDialog.openConfirm((Shell)shell, (String)"\u66f4\u65b0", (String)"\u68c0\u6d4b\u5230\u5de5\u5177\u6709\u66f4\u65b0\uff0c\u662f\u5426\u4e0b\u8f7d\u66f4\u65b0?");
                                }
                            });
                            if (!flag[0]) {
                                return Status.CANCEL_STATUS;
                            }
                        }
                    } else {
                        return Status.OK_STATUS;
                    }
                    final File temp = new File(ToolSetting.getToolUpdateTempDir());
                    try {
                        UpdateHelper.downloadFiles(temp, url, filePaths, monitor);
                        if (shell.isDisposed()) {
                            return Status.CANCEL_STATUS;
                        }
                        shell.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!MessageDialog.openConfirm((Shell)shell, (String)"\u63d0\u793a", (String)"\u5347\u7ea7\u524d\u9700\u8981\u5148\u5173\u95ed\u6240\u6709\u4e0eBOSIDE\u6709\u5173\u7684\u900f\u89c6\u56fe\uff0c\u662f\u5426\u7ee7\u7eed\uff1f")) {
                                    return;
                                }
                                UpdateHelper.closeAll(page);
                                UpdateHelper.copyTempFile(temp, localRoot, filePaths);
                                UpdateHelper.restart();
                            }
                        });
                        return Status.OK_STATUS;
                    }
                    catch (Throwable e) {
                        LogTool.logError("", e);
                        return new Status(4, "BIM", "\u9519\u8bef", e);
                    }
                }
            };
            job.schedule(1000L);
        }
        catch (Throwable t) {
            LogTool.logError("\u66f4\u65b0\u5de5\u5177\u53d1\u751f\u9519\u8bef", t);
        }
    }

    private static void closeAll(IWorkbenchPage page) {
        try {
            IWorkbenchPage[] pages = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
            for (int i = 0; i < pages.length; ++i) {
                IViewReference[] refs = pages[i].getViewReferences();
                for (int j = 0; j < refs.length; ++j) {
                    try {
                        IWorkbenchPart part = refs[j].getPart(false);
                        Method method = part.getClass().getMethod("innerDispose", null);
                        if (method == null) continue;
                        method.invoke((Object)part, null);
                        continue;
                    }
                    catch (NoSuchMethodException part) {
                        continue;
                    }
                    catch (Throwable ex) {
                        LogTool.debug("\u5173\u95ed\u89c6\u56fe\u65f6\u51fa\u9519", ex);
                    }
                }
            }
        }
        catch (Throwable ex) {
            LogTool.debug("\u5173\u95ed\u89c6\u56fe\u65f6\u51fa\u9519", ex);
        }
        try {
            page.closeAllEditors(true);
            page.closeAllPerspectives(true, true);
        }
        catch (Throwable t) {
            LogTool.logError("", t);
        }
    }

    private static void copyTempFile(File temp, File localRoot, String[] filePaths) {
        File srcFile = new File(temp, "BOSModular");
        File destFile = new File(localRoot, "BOSModular");
        try {
            FileUtils.getFileUtils().copyFileByPath(srcFile, destFile);
            if (!ToolSetting.isKeepUpdateToolTemp()) {
                PFileUtils.deleteFile(temp);
            }
            FileMD5Cache cache = ToolSetting.getFileMD5Cache();
            int n = filePaths.length;
            for (int i = 0; i < n; ++i) {
                cache.update(new File(localRoot, filePaths[i]));
            }
            cache.store();
        }
        catch (IOException e) {
            LogTool.logError("\u62f7\u8d1d\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restart() {
        try {
            String root = FileLocator.resolve((URL)Platform.getInstallLocation().getURL()).getFile();
            File bosRoot = new File(root).getParentFile().getParentFile();
            File configFile = new File(root, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
            File[] pluginRoots = new File[]{new File(bosRoot, "bim"), new File(bosRoot, "boscommon"), new File(bosRoot, "bosideupdate"), new File(bosRoot, "bosruntime"), new File(bosRoot, "bosstudio"), new File(bosRoot, "commonthirdlib"), new File(bosRoot, "kbs"), new File(bosRoot, "ksqltool"), new File(bosRoot, "license"), new File(bosRoot, "nlpack"), new File(bosRoot, "rcs"), new File(bosRoot, "svn"), new File(bosRoot, "wfdesigner")};
            File p2Dir = new File(root, "p2");
            PFileUtils.emptyDir(p2Dir);
            String[] deletedDir = new String[]{"configuration/org.eclipse.core.runtime", "configuration/org.eclipse.equinox.source", "configuration/org.eclipse.equinox.app", "configuration/.settings/org.eclipse.equinox.p2.metadata.repository.prefs", "configuration/.settings/org.eclipse.equinox.p2.artifact.repository.prefs"};
            for (int i = 0; i < deletedDir.length; ++i) {
                File file = new File(root, deletedDir[i]);
                if (!file.exists()) continue;
                try {
                    PFileUtils.deleteFile(file);
                    continue;
                }
                catch (Throwable t) {
                    LogTool.logError("\u5220\u9664\u6587\u4ef6\u65f6\u51fa\u9519", t);
                }
            }
            PlatformUI.getWorkbench().showPerspective("com.kingdee.bos.bim.perspective.BIMPerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            Class<?> cls = Class.forName("com.kingdee.bos.bundle.BundleUtil");
            Method method = cls.getMethod("adjustBunleConfigFile", File.class, File[].class);
            method.invoke(null, configFile, pluginRoots);
        }
        catch (Throwable t) {
            LogTool.debug("", t);
        }
        finally {
            PlatformUI.getWorkbench().restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getUpdatedFiles(String url, File localRoot) throws Exception {
        int sIndex;
        URL remoteUrl = new URL(url);
        URLConnection conn = remoteUrl.openConnection();
        InputStream in = null;
        StringBuffer sb = null;
        try {
            try {
                in = conn.getInputStream();
            }
            catch (ConnectException ex) {
                throw new Exception("\u670d\u52a1\u5668\u53ef\u80fd\u672a\u542f\u52a8", ex);
            }
            sb = new StringBuffer();
            sb.append(PFileUtils.getContent(in));
        }
        finally {
            FileUtils.close(in);
        }
        ArrayList<String> updateList = new ArrayList<String>();
        String PREFIX = "<file ";
        String SUFFIX = "/>";
        FileMD5Cache cache = ToolSetting.getFileMD5Cache();
        int index = sb.indexOf("<file ");
        while (index != -1 && (sIndex = sb.indexOf("/>", index += "<file ".length())) != -1) {
            String md5;
            String str = sb.substring(index, sIndex);
            String href = UpdateHelper.getSegment(str, "href=\"");
            File file = new File(localRoot, href);
            if (cache.isUpdate(file, md5 = UpdateHelper.getSegment(str, "md5=\""))) {
                updateList.add(href);
            }
            index = sb.indexOf("<file ", sIndex);
        }
        cache.store();
        return updateList.toArray(new String[updateList.size()]);
    }

    private static String getSegment(String s, String prefix) {
        int index = s.indexOf(prefix) + prefix.length();
        int sIndex = s.indexOf(34, index);
        return s.substring(index, sIndex);
    }

    public static void downloadFiles(File toDir, String serverUrl, String[] filePaths, IProgressMonitor monitor) throws Exception {
        if (filePaths == null || filePaths.length == 0) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("\u4ece\u8fdc\u7a0b\u670d\u52a1\u5668\u4e0b\u8f7d\u6587\u4ef6", filePaths.length);
        serverUrl = UpdateHelper.trimServerUrl(serverUrl);
        ArrayList faildList = new ArrayList();
        UpdateHelper.downloadFiles(toDir, serverUrl, filePaths, monitor, faildList);
        for (int retryCount = 3; retryCount > 0 && !faildList.isEmpty(); --retryCount) {
            filePaths = faildList.toArray(new String[faildList.size()]);
            faildList.clear();
            UpdateHelper.downloadFiles(toDir, serverUrl, filePaths, monitor, faildList);
        }
        if (!faildList.isEmpty()) {
            filePaths = faildList.toArray(new String[faildList.size()]);
            UpdateHelper.downloadFiles(toDir, serverUrl, filePaths, monitor, null);
        }
        monitor.done();
    }

    private static String trimServerUrl(String url) {
        int index = url.indexOf("BOSModular.jsp");
        if (index != -1) {
            url = url.substring(0, index);
        }
        if ((index = url.indexOf("BOSModular.xml")) != -1) {
            url = url.substring(0, index);
        }
        return url;
    }

    private static void downloadFiles(File toDir, String serverUrl, String[] paths, IProgressMonitor monitor, List faildList) throws Exception {
        for (int i = 0; i < paths.length; ++i) {
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            String path = paths[i];
            monitor.setTaskName("\u4e0b\u8f7d\u6587\u4ef6:" + path);
            try {
                UpdateHelper.downloadFile(new File(toDir, path), serverUrl + path);
            }
            catch (Exception ex) {
                if (faildList == null) {
                    throw ex;
                }
                faildList.add(path);
            }
            monitor.worked(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(File toFile, String path) throws Exception {
        URL remoteUrl = new URL(path);
        URLConnection conn = remoteUrl.openConnection();
        InputStream in = null;
        try {
            try {
                in = conn.getInputStream();
            }
            catch (ConnectException ex) {
                throw new Exception("\u670d\u52a1\u5668\u53ef\u80fd\u672a\u542f\u52a8", ex);
            }
            if (in != null) {
                PFileUtils.write2File(in, toFile);
            }
        }
        finally {
            FileUtils.close(in);
        }
    }
}

